/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <X11/Xlib.h>
#include <Xm/Xm.h>
#include "dskutil_glob.h"

Boolean bld_cmd_line(command,command_size,addition)
char **command;
int *command_size;
char *addition;
{
	int needed_space;
	void malloc_failure();

  if (debug_mode >= 2) fprintf(stderr,"-> bld_cmd_line <-\n");
	needed_space = strlen(addition) + 2;
	if ((*command == NULL) ||
	  ((int)(strlen(*command) + needed_space) > *command_size)) {

/* if we have exceeded space, allocate memory by chunks of BUFSIZ bytes */

	  if (*command_size < BUFSIZ) 
	    *command_size = BUFSIZ;
	  else
	    *command_size = ((int)
		((*command_size + needed_space) /BUFSIZ) + 1) * BUFSIZ;
		
	  if (*command == NULL) {
	    *command = (char *) calloc(*command_size,sizeof(char));
	    }
	  else
	    *command = (char *) realloc(*command,*command_size*sizeof(char));

	  if (*command == 0) {
	    malloc_failure((unsigned int)(*command_size*sizeof(char)));
	    return(FALSE);
	    }
	  }
	strcat(*command,addition);
	strcat(*command," ");
	return(TRUE);
}
void free_cmd_line(command,command_size)
char **command;
int *command_size;
{
	    free(*command);
	    *command = NULL;
	    *command_size = 0;
}
