/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <localsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
#include <Xm/RowColumn.h>

#include "HelpObject.h"
#include "display_menu.h"
#include "dskutil_glob.h"

Widget *show_button;
Widget *sort_button;
Widget *time_button;
Widget reverse;

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void pop_the_dialog(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  void tree();
  if (debug_mode >= 2) {
   fprintf(stderr,"-> pop_the_dialog <-\n");
   tree( (Widget) client_data,0);
   }
  XtManageChild((Widget) client_data);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void dismiss_dialog(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  if (debug_mode >= 2) {
   fprintf(stderr,"-> dismiss_dialog <-\n");
   }
  XtUnmanageChild((Widget) client_data);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void rev_button_label(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  XmString *labels = (XmString *)client_data;
  XmToggleButtonCallbackStruct *toggle_struct =
		(XmToggleButtonCallbackStruct *) call_data;

  if (debug_mode >= 2) fprintf(stderr,"-> rev_button_label <-\n");

  if (toggle_struct->set) {
    if (debug_mode >= 2) fprintf(stderr," reverse order \n");
/*
    XtVaSetValues(reverse,XmNlabelString,reverse_label,NULL);
*/
    XtVaSetValues(widget,XmNlabelString,labels[0],NULL);
    }
  else {
    if (debug_mode >= 2) fprintf(stderr," forward order \n");
/*
    XtVaSetValues(reverse,XmNlabelString,forward_label,NULL);
*/
    XtVaSetValues(widget,XmNlabelString,labels[1],NULL);
    }
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void set_the_options(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  int i,num_show_items,num_sort_items,num_time_items;
  void sort_list();

  if (debug_mode >= 2) fprintf(stderr,"-> set_the_options <-\n");
  num_show_items = sizeof(show_item) / sizeof(option_list_item);
  num_sort_items = sizeof(sort_item) / sizeof(option_list_item);
  num_time_items = sizeof(time_item) / sizeof(option_list_item);

#ifdef CRAYSYSTEM
  strcpy(ls_options,"-ld");
#else
  strcpy(ls_options,"-lgd");
#endif

  strcpy(sort_command,"");
 
  reverse_flag = XmToggleButtonGetState(reverse);

  for (i=0; i<num_show_items; i++) {
    if (show_item[i].state = XmToggleButtonGetState(show_button[i])) {
      switch (show_item[i].value) {
	case 1:
		hidden_files = TRUE;
		strcat(ls_options,"a");
		break;
	case 4:
		strcat(ls_options,"R");
		break;
	}
      }
    else {
      switch (show_item[i].value) {
	case 1:
		hidden_files = FALSE;
		break;
	}
      }
    }

  for (i=0; i<num_time_items; i++) {
    if (time_item[i].state = XmToggleButtonGetState(time_button[i])) {
      switch (time_item[i].value) {
	case 1:			/* time of last edit */
		strcat(ls_options,"c");
		break;
	case 3:			/* time of last access */
		strcat(ls_options,"u");
		break;
        }
      break;
      }
    }

  for (i=0; i<num_sort_items; i++) {
    if (sort_item[i].state = XmToggleButtonGetState(sort_button[i])) {
      switch (sort_item[i].value) {
	case 0:
		if (reverse_flag)
		  strcpy(sort_command,"| sort -r -n +4");
		else
		  strcpy(sort_command,"| sort -n +4");
		break;
	case 1:
		strcat(ls_options,"t");
		break;
	case 2:
		break;
        }
      if ((sort_item[i].value != 0) && (reverse_flag)) strcat(ls_options,"r");
      break;
      }
    }

  sort_list((Widget) client_data,NULL,NULL);
/*
  XtUnmanageChild((Widget) client_data);
*/
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void cancel_all_options(widget,client_data,call_data)
  Widget widget;
  XtPointer client_data,call_data;
{
  int i,num_show_items,num_sort_items,num_time_items;

  if (debug_mode >= 2) fprintf(stderr,"-> cancel_all_options <-\n");

  num_show_items = sizeof(show_item) / sizeof(option_list_item);
  num_sort_items = sizeof(sort_item) / sizeof(option_list_item);
  num_time_items = sizeof(time_item) / sizeof(option_list_item);


  for (i=0; i<num_show_items; i++)
    XmToggleButtonSetState(show_button[i], show_item[i].state, FALSE);

  for (i=0; i<num_time_items; i++)
    XmToggleButtonSetState(time_button[i], time_item[i].state, FALSE);

  for (i=0; i<num_sort_items; i++)
    XmToggleButtonSetState(sort_button[i], sort_item[i].state, FALSE);

  XmToggleButtonSetState(reverse, reverse_flag, TRUE);
  XtUnmanageChild((Widget) client_data);
  return;
}

Widget display_menu(popup)
     Widget popup;
{
	Widget dialog,option_form,show_form,sort_form,button_form;
	Widget time_rc,show_rc,sort_rc;
	Widget dialog_heading,show_heading,sort_heading,order_heading;
	Widget separator;
	Widget action_rc,ok,apply,cancel,help;
	int i;
	XmString item_label;
	XmString *labels;
	int num_show_items,num_sort_items,num_time_items;
	void sort_list();
	void tree();

  if (debug_mode >= 2) fprintf(stderr,"-> display_menu <-\n");
	dialog = XmCreateFormDialog(popup,"Display_Shell",NULL,0);
	item_label = XmStringCreateLtoR("Display Options",
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog,
/*
			XmNverticalSpacing,	10,
*/
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		popup,
			XmNautoUnmanage,	FALSE,
			XmNdefaultPosition,	TRUE,
			XmNhorizontalSpacing,	10,
			XmNdialogTitle,		item_label,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("Display Options",
		XmSTRING_DEFAULT_CHARSET);
	dialog_heading = XtVaCreateManagedWidget("display_heading",
		xmLabelWidgetClass,dialog,
			XmNlabelString,item_label,
			XmNrightAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	option_form = XtVaCreateManagedWidget("option_form",
		xmFormWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,dialog_heading,
			NULL);

	sort_form = XtVaCreateManagedWidget("sort_form",
		xmFormWidgetClass,option_form,
			NULL);

	item_label = XmStringCreateLtoR("Sort by:",XmSTRING_DEFAULT_CHARSET);
	sort_heading = XtVaCreateManagedWidget("sort_heading",
		xmLabelWidgetClass,sort_form,
			XmNlabelString,item_label,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	sort_rc = XtVaCreateManagedWidget("sortrc",
		xmRowColumnWidgetClass,sort_form,
			XmNpacking,XmPACK_TIGHT,
			XmNorientation,XmVERTICAL,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,sort_heading,
			XmNleftAttachment,XmATTACH_FORM,
/*
			XmNleftOffset, 10,
*/
			XmNrightAttachment,XmATTACH_FORM,
			XmNmarginWidth,0,
			XmNradioBehavior,TRUE,
			NULL);

	show_form = XtVaCreateManagedWidget("show_form",
		xmFormWidgetClass,option_form,
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,sort_form,
/*
			XmNleftOffset,20,
*/
			NULL);

	item_label = XmStringCreateLtoR("Show:",XmSTRING_DEFAULT_CHARSET);
	show_heading = XtVaCreateManagedWidget("show_heading",
		xmLabelWidgetClass,show_form,
			XmNleftAttachment,XmATTACH_FORM,
			XmNlabelString,item_label,
			XmNleftAttachment,XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	time_rc = XtVaCreateManagedWidget("timerc",
		xmRowColumnWidgetClass,show_form,
			XmNpacking,XmPACK_TIGHT,
			XmNorientation,XmVERTICAL,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,show_heading,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
/*
			XmNmarginWidth,0,
*/
			XmNradioBehavior,TRUE,
			NULL);

	show_rc = XtVaCreateManagedWidget("showrc",
		xmRowColumnWidgetClass,show_form,
			XmNpacking,XmPACK_TIGHT,
			XmNorientation,XmVERTICAL,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,time_rc,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			XmNmarginWidth,0,
			NULL);

/*
	XtManageChild(sort_rc);
	XtManageChild(time_rc);
	XtManageChild(show_rc);
*/

	num_show_items = sizeof(show_item) / sizeof(option_list_item);
	show_button = (Widget *) malloc(num_show_items * sizeof(Widget));
	for (i=0; i<num_show_items; i++) {
	  item_label = XmStringCreateLtoR(show_item[i].label,
		XmSTRING_DEFAULT_CHARSET);
	  show_button[i] = XtVaCreateManagedWidget(show_item[i].name,
		xmToggleButtonWidgetClass,show_rc,
	  		XmNlabelString,item_label,
/*
	  		XmNset,show_item[i].state,
*/
			NULL);
	  XmStringFree(item_label);
	  }
/*
	XtManageChild(show_rc);
*/

	num_time_items = sizeof(time_item) / sizeof(option_list_item);
	time_button = (Widget *) malloc(num_time_items * sizeof(Widget));
	for (i=0; i<num_time_items; i++) {
	  item_label = XmStringCreateLtoR(time_item[i].label,
		XmSTRING_DEFAULT_CHARSET);
	  time_button[i] = XtVaCreateManagedWidget(time_item[i].name,
		xmToggleButtonWidgetClass,time_rc,
	  		XmNlabelString,item_label,
/*
	  		XmNset,time_item[i].state,
*/
			NULL);
	  XmStringFree(item_label);
	  }
/*
	XtManageChild(time_rc);
*/

	num_sort_items = sizeof(sort_item) / sizeof(option_list_item);
	sort_button = (Widget *) malloc(num_sort_items * sizeof(Widget));
	for (i=0; i<num_sort_items; i++) {
	  item_label = XmStringCreateLtoR(sort_item[i].label,
		XmSTRING_DEFAULT_CHARSET);
	  sort_button[i] = XtVaCreateManagedWidget(sort_item[i].name,
		xmToggleButtonWidgetClass,sort_rc,
	  		XmNlabelString,item_label,
/*
	  		XmNset,sort_item[i].state,
*/
			NULL);
	  XmStringFree(item_label);
	  }
/*
	XtManageChild(sort_rc);
	XtManageChild(option_form);
*/

	item_label = XmStringCreateLtoR("Sort order:",XmSTRING_DEFAULT_CHARSET);
	order_heading = XtVaCreateManagedWidget("order_heading",
		xmLabelWidgetClass,sort_form,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,sort_rc,
			XmNleftAttachment,XmATTACH_FORM,
/*
			XmNleftOffset, 10,
*/
			XmNlabelString,item_label,
			NULL);
	XmStringFree(item_label);

/*
	forward_label = XmStringCreateLtoR("forward",XmSTRING_DEFAULT_CHARSET);
	reverse_label = XmStringCreateLtoR("reverse",XmSTRING_DEFAULT_CHARSET);
*/
	labels = (XmString *) XtMalloc(2*sizeof(XmString));
	labels[0] = XmStringCreateLtoR("reverse",XmSTRING_DEFAULT_CHARSET);
	labels[1] = XmStringCreateLtoR("forward",XmSTRING_DEFAULT_CHARSET);

	reverse = XtVaCreateManagedWidget("reverse",
		xmToggleButtonWidgetClass,sort_form,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,order_heading,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
/*
			XmNleftAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNleftWidget,sort_rc,
			XmNbottomAttachment,XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,show_rc,
*/
			NULL);
	XtAddCallback(reverse, XmNvalueChangedCallback, rev_button_label,
		 labels);

	if (XmToggleButtonGetState(reverse)) {
	  XtVaSetValues(reverse,XmNlabelString,labels[0],NULL);
	  }
	else {
	  XtVaSetValues(reverse,XmNlabelString,labels[1],NULL);
	  }
/*
	rc3 = XtVaCreateManagedWidget("rc3",
		xmRowColumnWidgetClass,dialog,
			XmNorientation,XmHORIZONTAL,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);
*/
	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,option_form,
			XmNtopOffset,5,
			XmNleftAttachment,XmATTACH_FORM,
			XmNrightAttachment,XmATTACH_FORM,
			NULL);

	button_form = XtVaCreateManagedWidget("option_form",
		xmFormWidgetClass,dialog,
			XmNtopAttachment,XmATTACH_WIDGET,
			XmNtopWidget,separator,
			XmNtopOffset,5,
			NULL);

	ok = XtVaCreateManagedWidget("OK",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,5,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,24,
			NULL);
	XtAddCallback(ok, XmNactivateCallback, set_the_options,
		(XtPointer) dialog);
	XtAddCallback(ok, XmNactivateCallback, dismiss_dialog,
		(XtPointer) dialog);
/*
	XtAddCallback(ok, XmNactivateCallback, sort_list,
		(XtPointer) NULL);
*/

	apply = XtVaCreateManagedWidget("Apply",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,29,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,48,
			NULL);

	XtAddCallback(apply, XmNactivateCallback, set_the_options,
		(XtPointer) dialog);

	cancel = XtVaCreateManagedWidget("Cancel",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,53,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,72,
			NULL);

	XtAddCallback(cancel, XmNactivateCallback, cancel_all_options,
		(XtPointer) dialog);

	help = XtVaCreateManagedWidget("Help",
		xmPushButtonWidgetClass,button_form,
			XmNtopAttachment,XmATTACH_FORM,
			XmNleftAttachment,XmATTACH_POSITION,
			XmNleftPosition,77,
			XmNrightAttachment,XmATTACH_POSITION,
			XmNrightPosition,96,
			NULL);

	XtAddCallback(help, XmNactivateCallback, XuHelper,
		(XtPointer) "Dsply_Dsc.help");

	XtAddCallback(popup, XmNactivateCallback, pop_the_dialog,
		(XtPointer) dialog);

	XtAddCallback(popup, XmNhelpCallback, XuHelper,
		(XtPointer) "Dsply_Dsc.help");

	if (debug_mode >= 1) tree(dialog,0);
	return(dialog);
}
