/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "HelpObject.h"
#include "dskutil_defs.h"
#include "dskutil_glob.h"

/*ARGSUSED*/			/* this is to satisfy Saber-C */
void get_files(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	file_list_item *list_entry;
	FILE *export_fd;
	String export_file;
	int indx,num_selected_items;
	if (debug_mode >= 2) fprintf(stderr,"-> get_files <-\n");

	if (!XmStringGetLtoR(
		((XmFileSelectionBoxCallbackStruct *)call_data)->value,
		XmSTRING_DEFAULT_CHARSET,&export_file)) {
	  fprintf(stderr,"Unable to retrieve file_name\n");
/*
	  XtRemoveCallback(widget,XmNokCallback,get_files,client_data);
	  XtUnmanageChild(widget);
*/
	  XtManageChild(widget);
	  return;
	  }
	if (( export_fd = fopen(export_file,"w+")) == NULL) {
	  char *error_msg = (char *) malloc(256*sizeof(char));
	  sprintf(error_msg,"Unable to open %s for saving list\n",export_file);
	  strcat(error_msg,"please check file name and permissions");
	  post_message(TRUE,widget,error_msg,
		XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "BadSvList.help");
	  free(error_msg);
	  return;
	  }

/*
	fprintf(stderr,"Saved List:\n");
*/
	fprintf(export_fd,"%%dskutil\n");
        XtVaGetValues(lists[1],XmNitemCount,&num_selected_items, NULL);
	for (indx=0; indx<num_selected_items; indx++) {
	  list_entry = *(selected_list+indx);
	  fprintf(export_fd,"%s\n",list_entry->name);
/*
 	  fprintf(stderr,"%s\n",list_entry->name);
*/
	  }
	fclose(export_fd);
	XtRemoveCallback(widget,XmNokCallback,get_files,client_data);
	XtUnmanageChild(widget);
}

/*ARGSUSED*/			/* this is to satisfy Saber-C */
void save_processed_files(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	file_list_item *list_entry;
	FILE *export_fd;
	String tempfile;
	int indx;
	if (debug_mode >= 2) fprintf(stderr,"-> save_processed_files <-\n");
	tempfile = tmpnam(NULL);
	export_fd = fopen(tempfile,"w+");
	if (export_fd == NULL) {
	  post_message(TRUE,widget,"Unable to save list of processed files",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "Tmp_Fail.help");
	  return;
	  }
	fprintf(export_fd,"%%dskutil\n");
	for (indx=0; indx<num_selected_items; indx++) {
	  list_entry = *(selected_list+indx);
	  fprintf(export_fd,"%s\n",list_entry->name);
	  }
	fclose(export_fd);
/*
	fflush(export_fd);
	unlink(tempfile);
*/
/*
	XmTextSetString(XmFileSelectionBoxGetChild((Widget)client_data,
		XmDIALOG_TEXT),tempfile);
	process_files((Widget) client_data,NULL,NULL);
*/
}

/*ARGSUSED*/			/* this is to satisfy Saber-C */
void recover_list(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	file_list_item *list_entry;
	XmFileSelectionBoxCallbackStruct fake_cb_data;
	int i,indx,indx2,j;
	Boolean in_sorted_list;
	void select_filelist();
	String export_file;
	if (debug_mode >= 2) fprintf(stderr,"-> recover_list <-\n");

	if (*(Widget *) client_data == NULL)
          *(Widget *)client_data = XmCreateFileSelectionDialog(
		XtParent(widget),"SaveDialog",NULL,0);

	if (num_processed_items == 0) {
	  post_message(TRUE,widget,"Processed file list is empty",
		XmDIALOG_INFORMATION,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  return;
	  }
/*
 * there is still space in these for the processed items
 */
	sorted_list = (file_list_item *) realloc (sorted_list,
	  (num_list_items+num_processed_items) * sizeof(file_list_item));
	selected_list = (file_list_item **) realloc (selected_list,
	  (num_list_items+num_processed_items) * sizeof(file_list_item *));

	for (i=0, indx=0, indx2=0; i<num_list_items; i++) {
	  if ((sorted_list+i)->selected > 0) {
	    *(selected_list+indx) = sorted_list+i;
	    indx++;
	    }
/*
 * pointers in processed list must point to new area, even though
 * the processed list isn't changing
	  if ((sorted_list+i)->selected < 0) {
	    *(processed_list+indx2) = sorted_list+i;
	    indx2++;
	    }
 */
	  }

	for (i=0,indx=num_list_items; i<num_processed_items; i++ ) {
	  for (j=0; j<num_list_items; j++) {
	    in_sorted_list = FALSE;
	    if (strcmp(processed_files[i],(sorted_list+j)->name) == 0) {
	      in_sorted_list = TRUE;
	      if (!(sorted_list+j)->selected) {
		XmListSelectPos(lists[0],(sorted_list+j)->current_pos,TRUE);
		XtCallCallbacks(select_but,XmNactivateCallback,NULL);
		}
	      else if ((sorted_list+j)->selected < 0) {
		(sorted_list+j)->selected = TRUE;
	        *(selected_list+num_selected_items) = sorted_list+j;
		num_selected_items++;
		}
	      break;
	      }
	    }
	    if ( ! in_sorted_list ) {
	      list_entry = (sorted_list+num_list_items);
	      *(selected_list+num_selected_items) = list_entry;
	      indx++;
	      num_list_items++;
	      num_selected_items++;
	      list_entry->current_pos = num_list_items;
	      list_entry->orig_pos = num_list_items;
	      list_entry->selected = TRUE;
	      list_entry->name = (char *)
		malloc((strlen(processed_files[i])+1)*sizeof(char));
	      strcpy(list_entry->name,processed_files[i]);
	      }
	  }

/*
	since these are decreasing in size, they shouldn't move.
	if they do, we've got a problem...
*/
/*
	sorted_list = (file_list_item *) realloc
	  (sorted_list,num_list_items * sizeof(file_list_item));
	selected_list = (file_list_item **) realloc
	  (selected_list,num_list_items * sizeof(file_list_item *));
*/
	sort_list(widget,NULL,NULL);
}

void select_filelist(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	file_list_item *list_entry;
	XmString new_item;
	FILE *import_fd,*wc_command;
	String import_file;
	char *command;
	char *filename;
	int i,j,indx,indx2,num_newlist_items;
	Boolean in_sorted_list= FALSE;
	if (debug_mode >= 2) fprintf(stderr,"-> select_filelist <-\n");

	if (!XmStringGetLtoR(
		((XmFileSelectionBoxCallbackStruct *)call_data)->value,
		XmSTRING_DEFAULT_CHARSET,&import_file)) {
	  fprintf(stderr,"Unable to retrieve file_name\n");
	  XtUnmanageChild(widget);
	  free(import_file);
	  return;
	  }

	import_fd = fopen(import_file,"r");
	if (import_fd == NULL) {
	  command = (char *) malloc(256*sizeof(char));
	  strcpy(command,"Unable to open list file (");
	  strcat(command,import_file);
	  strcat(command,")");
	  post_message(TRUE,widget,command,
		XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "Bad_List.help");
	  free(command);
	  free(import_file);
	  return;
	  }

	filename = (char *)malloc(MAXNAMLEN*sizeof(char));
	fscanf(import_fd,"%s",filename);
	if (strcmp(filename,"%dskutil") != 0) {
	  post_message(TRUE,widget,"Selected file is not a valid list",
		XmDIALOG_ERROR,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "Bad_List.help");
	  free(filename);
	  free(import_file);
	  XtManageChild(widget);
	  return;
	  }
	free(filename);

	command = (char *) malloc((7+strlen(import_file))*sizeof(char));
	strcpy(command,"wc -l ");
	strcat(command,import_file);
	wc_command = popen(command,"r");
	fscanf(wc_command,"%d",&num_newlist_items);
	num_newlist_items--;
	free(command);
	free(import_file);
	pclose(wc_command);

/*
	fprintf(stderr,"Retrieved List:\n");
        XtVaGetValues(lists[1],XmNitemCount,&num_selected_items, NULL);
*/
	sorted_list = (file_list_item *) realloc (sorted_list,
	  (num_list_items+num_newlist_items) * sizeof(file_list_item));
	selected_list = (file_list_item **) realloc (selected_list,
	  (num_list_items+num_newlist_items) * sizeof(file_list_item *));
	for (i=0, indx=0, indx2=0; i<num_list_items; i++) {
	  if ((sorted_list+i)->selected > 0) {
	    *(selected_list+indx) = sorted_list+i;
	    indx++;
	    }
/*
 * pointers in processed list must point to new area, even though
 * the processed list isn't changing
	  if ((sorted_list+i)->selected < 0) {
	    *(processed_list+indx2) = sorted_list+i;
	    indx2++;
	    }
 */
	  }

	for (i=0,indx=num_list_items; i<num_newlist_items; i++ ) {
	  filename = (char *)malloc(MAXNAMLEN*sizeof(char));
	  fscanf(import_fd,"%s",filename);
	  filename = (char *)realloc(filename, strlen(filename)+1);
/*
	  fprintf(stderr,"select_filelist: allocated string ->%s<- address = %08x\n",filename,filename);
 	  fprintf(stderr,"%s\n",filename);
*/
	  for (j=0; j<num_list_items; j++) {
	    in_sorted_list = FALSE;
	    if (strcmp(filename,(sorted_list+j)->name) == 0) {
	      in_sorted_list = TRUE;
	      if (!(sorted_list+j)->selected) {
		XmListSelectPos(lists[0],(sorted_list+j)->current_pos,TRUE);
		XtCallCallbacks(select_but,XmNactivateCallback,NULL);
		XtFree(filename);
		}
	      else if ((sorted_list+j)->selected < 0) {
		(sorted_list+j)->selected = TRUE;
	        *(selected_list+num_selected_items) = sorted_list+j;
		num_selected_items++;
		}
	      break;
	      }
	    }
	    if ( ! in_sorted_list ) {
	      list_entry = (sorted_list+num_list_items);
	      *(selected_list+num_selected_items) = list_entry;
	      indx++;
	      num_list_items++;
	      num_selected_items++;
	      list_entry->current_pos = num_list_items;
	      list_entry->orig_pos = num_list_items;
	      list_entry->selected = TRUE;
	      list_entry->name = filename;
/* see if we can do it without putting it in the widget
	      new_item = XmStringCreateLtoR(list_entry->name,
		XmSTRING_DEFAULT_CHARSET);
	      XmListAddItemUnselected(lists[1],new_item,0);
	      XmStringFree(new_item);
	      list_entry->string = &new_item;
*/
	      }
	  }

/*
	since these are decreasing in size, they shouldn't move.
	if they do, we've got a problem...
*/
/*
	sorted_list = (file_list_item *) realloc
	  (sorted_list,num_list_items * sizeof(file_list_item));
	selected_list = (file_list_item **) realloc
	  (selected_list,num_list_items * sizeof(file_list_item *));
*/
	sort_list(widget,NULL,NULL);
	fclose(import_fd);
	XtUnmanageChild(widget);
	XtRemoveCallback(widget,XmNokCallback,
		(XtCallbackProc) select_filelist,client_data);
}
/*ARGSUSED*/			/* this is to satisfy Saber-C */
void save_list(widget,client_data,call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;	/* unused */
{
	int num_selected_items;
	if (debug_mode >= 2) fprintf(stderr,"-> save_list <-\n");

	if (*(Widget *) client_data == NULL)
          *(Widget *)client_data = XmCreateFileSelectionDialog(
		XtParent(widget),"SaveDialog",NULL,0);

        XtVaGetValues(lists[1],XmNitemCount,&num_selected_items, NULL);
	if (num_selected_items == 0) {
	  post_message(FALSE,widget,"Selected file list is empty",
		XmDIALOG_INFORMATION,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
	  return;
	  }

	XtAddCallback(*(Widget *)client_data,XmNokCallback,get_files,
			(XtPointer)lists[1]);
	XtAddCallback(*(Widget *)client_data,XmNcancelCallback,
		(XtCallbackProc) XtUnmanageChild,NULL);
	XtUnmanageChild(XmFileSelectionBoxGetChild(*(Widget *)client_data,
		XmDIALOG_HELP_BUTTON));
	XtManageChild(*(Widget *)client_data);
}
/*ARGSUSED*/			/* this is to satisfy Saber-C */
void retrieve_list(widget,client_data,call_data)
Widget widget;	
XtPointer client_data;
XtPointer call_data;	/* unused */
{
	if (debug_mode >= 2) fprintf(stderr,"-> retrieve_list <-\n");

	if (*(Widget *) client_data == NULL)
          *(Widget *)client_data = XmCreateFileSelectionDialog(
		XtParent(widget),"SaveDialog",NULL,0);

	XtAddCallback(*(Widget *)client_data,XmNokCallback,
			(XtCallbackProc) select_filelist, (XtPointer)lists[1]);
	XtAddCallback(*(Widget *)client_data,XmNcancelCallback,
		(XtCallbackProc)XtUnmanageChild,NULL);
	XtUnmanageChild(XmFileSelectionBoxGetChild(*(Widget *)client_data,
		XmDIALOG_HELP_BUTTON));
	XtManageChild(*(Widget *)client_data);
}
void save_processed_list(widget,client_data,call_data)
Widget widget;	
XtPointer client_data;
XtPointer call_data;	/* unused */
{
	XmString dialog_text;
	String tempfile;
	void processed_filelist();
	int indx;

	if (debug_mode >= 2) {
	  fprintf(stderr,"-> save_processed_list <-\n");

	  fprintf(stderr,"previously processed files:\n");
	  for (indx = 0; indx < num_processed_items; indx++)
 	    fprintf(stderr," %s\n", processed_files[indx]);
	  }

	if (*(Widget *) client_data == NULL)
          *(Widget *)client_data = XmCreateFileSelectionDialog(
		XtParent(widget),"SaveDialog",NULL,0);

	if (num_processed_items == 0) {
	  post_message(TRUE,widget,"Processed file list is empty",
		XmDIALOG_INFORMATION,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "NoPrcList.help");
	  return;
	  }

	XtAddCallback(*(Widget *)client_data,XmNokCallback,
		processed_filelist,NULL);
	XtAddCallback(*(Widget *)client_data,XmNcancelCallback,
		(XtCallbackProc) XtUnmanageChild,NULL);
	XtManageChild(*(Widget *)client_data);
}
void processed_filelist(widget,client_data,call_data)
Widget widget;	
XtPointer client_data;
XtPointer call_data;
{
	FILE *export_fd;
	String newfile;
	int indx;

	if (debug_mode >= 2) {
	  fprintf(stderr,"-> processed_filelist <-\n");
	  for (indx = 0; indx < num_processed_items; indx++)
 	    fprintf(stderr," %s\n", processed_files[indx]);
	  }

	if (!XmStringGetLtoR(
		((XmFileSelectionBoxCallbackStruct *)call_data)->value,
		XmSTRING_DEFAULT_CHARSET,&newfile)) {
	  fprintf(stderr,"Unable to retrieve file_name\n");
	  XtManageChild(widget);
	  return;
	  }
	export_fd = fopen(newfile,"w+");
	if (export_fd == NULL) {
	  post_message(TRUE,widget,"Unable to save list of processed files",
		XmDIALOG_WARNING,
		TRUE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		TRUE,NULL,(XtCallbackProc) XuHelper,
			(XtPointer) "Tmp_Fail.help");
	  return;
	  }
	fprintf(export_fd,"%%dskutil\n");
	for (indx=0; indx<num_processed_items; indx++) {
	  fprintf(export_fd,"%s\n",processed_files[indx]);
	  }
	fclose(export_fd);
	XtUnmanageChild((Widget)widget);
	XtRemoveCallback(widget,XmNokCallback,processed_filelist,client_data);
	XtRemoveCallback(widget, XmNcancelCallback,
		(XtCallbackProc) XtUnmanageChild, NULL);
}

