/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*SUPPRESS 594*/		/* get rid of Saber-C's "set but not used warning */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <localsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xresource.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Separator.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Text.h>

#include "HelpObject.h"
#include "dskutil_defs.h"
#include "dskutil_glob.h"
#include "tape_menu.h"

char *bld_err_msg(prefix,body,suffix)
char *prefix,*body,*suffix;
{
	char *command;
	command = (char *) XtMalloc (
		(strlen(prefix) + strlen(body) + strlen(suffix) + 1)
		* sizeof(char));
	strcpy(command,prefix);
	strcat(command,body);
	strcat(command,suffix);
	return(command);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void set_archival_opts(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
  int indx;
  Widget history_widget;
  void pop_the_dialog();

  tape_parameters *archive_info = (tape_parameters *) client_data;
  callback_info *menu_info = (callback_info *) archive_info->menu_info;
  if (debug_mode >= 2) {
    fprintf(stderr,"-> set_archival_opts <-\n");
    fprintf(stderr," menu_format = %d\n",menu_info->menu_format);
    fprintf(stderr,"widgets = ");
    for (indx=0; indx<MENU_WIDGET_MAX; indx++)
      fprintf(stderr," %08x",*(menu_info->widgets+indx));
    fprintf(stderr,"\n");
    }

  XtFree(archive_info->dataset_name);
  archive_info->dataset_name =
		XmTextGetString(*(menu_info->widgets+DATASET_TEXT));

  switch (menu_info->menu_format) {
    case TAR_ARCHIVAL_TAPE:
	XtFree(archive_info->device_blocksize);
        archive_info->device_blocksize =
		XmTextGetString(*(menu_info->widgets+DEVICE_BLOCKSIZE));
	XtVaGetValues(*(menu_info->widgets+DEVICE_BLOCKSIZE_OPTION),
		XmNmenuHistory,	&history_widget,
		NULL);
	XtVaGetValues(history_widget,
		XmNuserData,	&archive_info->device_blocksize_option,
		NULL);
    case TAR_ARCHIVAL_FILE:
	archive_info->full_path_names = 
	  XmToggleButtonGetState(*(menu_info->widgets+FULL_PATH_TOGGLE));
	archive_info->remove_archive_files = 
	  XmToggleButtonGetState(*(menu_info->widgets+REMOVAL_TOGGLE));
	break;
    case CRAY_ARCHIVAL_TAPE:
    case IBM_ARCHIVAL_TAPE:
	XtFree(archive_info->expiration_date);
	archive_info->expiration_date =
		XmTextGetString(*(menu_info->widgets+EXPDT_TEXT));
	XtFree(archive_info->max_no_of_tapes);
	archive_info->max_no_of_tapes =
	  XmTextGetString(*(menu_info->widgets+TAPE_LIM_TEXT));
	if (menu_info->menu_format == IBM_ARCHIVAL_TAPE) {
	  XtFree(archive_info->record_format);
	  archive_info->record_format =
	    XmTextGetString(*(menu_info->widgets+RECFM_TEXT));
	  }
	archive_info->full_path_names = 
	  XmToggleButtonGetState(*(menu_info->widgets+FULL_PATH_TOGGLE));
	archive_info->remove_archive_files = 
	  XmToggleButtonGetState(*(menu_info->widgets+REMOVAL_TOGGLE));
	break;
    case TAR_REMOTE_DEVICE:
	XtFree(archive_info->machine_name);
        archive_info->machine_name =
		XmTextGetString(*(menu_info->widgets+MACHINE_NAME));
	XtFree(archive_info->transfer_blocksize);
        archive_info->transfer_blocksize =
		XmTextGetString(*(menu_info->widgets+TRANSFER_BLOCKSIZE));
	XtVaGetValues(*(menu_info->widgets+TRANSFER_BLOCKSIZE_OPTION),
		XmNmenuHistory,	menu_info->widgets+TRANSFER_BLOCKSIZE_HISTORY,
		NULL);
	XtVaGetValues(*(menu_info->widgets+TRANSFER_BLOCKSIZE_HISTORY),
		XmNuserData,	&archive_info->transfer_blocksize_option,
		NULL);
	XtFree(archive_info->device_blocksize);
        archive_info->device_blocksize =
		XmTextGetString(*(menu_info->widgets+DEVICE_BLOCKSIZE));
	XtVaGetValues(*(menu_info->widgets+DEVICE_BLOCKSIZE_OPTION),
		XmNmenuHistory,	menu_info->widgets+DEVICE_BLOCKSIZE_HISTORY,
		NULL);
	XtVaGetValues(*(menu_info->widgets+DEVICE_BLOCKSIZE_HISTORY),
		XmNuserData,	&archive_info->device_blocksize_option,
		NULL);
	archive_info->full_path_names = 
	  XmToggleButtonGetState(*(menu_info->widgets+FULL_PATH_TOGGLE));
	archive_info->remove_archive_files = 
	  XmToggleButtonGetState(*(menu_info->widgets+REMOVAL_TOGGLE));

	break;
    }
  XtUnmanageChild(*(menu_info->widgets+DIALOG_WIDGET));
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void chg_toggle_label(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	XmToggleButtonCallbackStruct *toggle_struct =
		(XmToggleButtonCallbackStruct *) call_data;

	XtVaSetValues(widget,XmNlabelString,
		*((XmString *)client_data+toggle_struct->set),NULL);	
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void cancel_archival_changes(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
  int indx;
  tape_parameters *archive_info = (tape_parameters *) client_data;
  callback_info *menu_info = (callback_info *) archive_info->menu_info;
  if (debug_mode >= 2) {
    fprintf(stderr,"-> cancel_archival_changes <-\n");
    fprintf(stderr," menu_format = %d\n",menu_info->menu_format);
    fprintf(stderr,"widgets = ");
    for (indx=0; indx<MENU_WIDGET_MAX; indx++)
      fprintf(stderr," %08x",*(menu_info->widgets+indx));
    fprintf(stderr,"\n");
    }

  XmTextSetString(*(menu_info->widgets+DATASET_TEXT),
    archive_info->dataset_name);

  switch (menu_info->menu_format) {
    case TAR_ARCHIVAL_TAPE:
	XmTextSetString(*(menu_info->widgets+DEVICE_BLOCKSIZE),
          archive_info->device_blocksize);
	XtVaSetValues(*(menu_info->widgets+DEVICE_BLOCKSIZE_OPTION),
		XmNmenuHistory,*(menu_info->widgets+DEVICE_BLOCKSIZE_HISTORY),
		NULL);
    case TAR_ARCHIVAL_FILE:
	XmToggleButtonSetState(*(menu_info->widgets+FULL_PATH_TOGGLE),
	  archive_info->full_path_names,False);
	XmToggleButtonSetState(*(menu_info->widgets+REMOVAL_TOGGLE),
	  archive_info->remove_archive_files,False);
	break;
    case CRAY_ARCHIVAL_TAPE:
    case IBM_ARCHIVAL_TAPE:
	XmTextSetString(*(menu_info->widgets+EXPDT_TEXT),
	  archive_info->expiration_date);
	XmTextSetString(*(menu_info->widgets+TAPE_LIM_TEXT),
	  archive_info->max_no_of_tapes);
	if (menu_info->menu_format == IBM_ARCHIVAL_TAPE) 
	  archive_info->record_format =
	    XmTextGetString(*(menu_info->widgets+RECFM_TEXT));
	XmToggleButtonSetState(*(menu_info->widgets+FULL_PATH_TOGGLE),
	  archive_info->full_path_names,False);
	XmToggleButtonSetState(*(menu_info->widgets+REMOVAL_TOGGLE),
	  archive_info->remove_archive_files,False);

	break;
    case TAR_REMOTE_DEVICE:
	XmTextSetString(*(menu_info->widgets+MACHINE_NAME),
          archive_info->machine_name);
	XmTextSetString(*(menu_info->widgets+TRANSFER_BLOCKSIZE),
          archive_info->transfer_blocksize);
	XtVaSetValues(*(menu_info->widgets+TRANSFER_BLOCKSIZE_OPTION),
		XmNmenuHistory,*(menu_info->widgets+TRANSFER_BLOCKSIZE_HISTORY),
		NULL);
	XmTextSetString(*(menu_info->widgets+DEVICE_BLOCKSIZE),
          archive_info->device_blocksize);
	XtVaSetValues(*(menu_info->widgets+DEVICE_BLOCKSIZE_OPTION),
		XmNmenuHistory,*(menu_info->widgets+DEVICE_BLOCKSIZE_HISTORY),
		NULL);
	XmToggleButtonSetState(*(menu_info->widgets+FULL_PATH_TOGGLE),
	  archive_info->full_path_names,False);
	XmToggleButtonSetState(*(menu_info->widgets+REMOVAL_TOGGLE),
	  archive_info->remove_archive_files,False);

	break;
    }
  XtUnmanageChild(*(menu_info->widgets+DIALOG_WIDGET));
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void dsn_msg(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	void check_dsn();
/*	XEvent event; */
  if (debug_mode >= 2) fprintf(stderr,"-> dsn_msg <-\n");
/*
	XtAddEventHandler(info_dialog, ExposureMask, FALSE,
		check_dsn, (XtPointer) client_data);
	XtAddCallback(info_dialog, XmNmapCallback, check_dsn,
		(XtPointer) client_data);
	XSynchronize(XtDisplay(info_dialog),TRUE);
*/

	post_message(FALSE,widget,
		"Checking dsn; please be patient",
		XmDIALOG_WORKING,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);

/*
	XSync(XtDisplay(widget),FALSE);
	XFlush(XtDisplay(widget));

	while (XtPending()) {
	  XtNextEvent(&event);
	  XtDispatchEvent(&event);
          }
*/
}
/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void overwrite_verify(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	void write_tape();
  if (debug_mode >= 2) 
    fprintf(stderr,"-> overwrite_verify <-\n");
	dsn_verified = TRUE;
	write_tape((callback_info *)client_data);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void dsn_verify(client_data,source,id)
XtPointer client_data;
int *source;
XtInputId *id;
{
	void pop_archival_menu();
	void write_tape();
	int err_stat;
	verify_info *verify_struct = (verify_info *)client_data;
  if (debug_mode >= 2) fprintf(stderr,"-> dsn_verify <-\n");
	fscanf(verify_struct->verify_cmd,"%d",&dsn_exists);
	if ((err_stat = ferror(verify_struct->verify_cmd)) != 0) {
	  fprintf(stderr,"error executing dsn_verify - %d\n",err_stat);
	  exit(0);
	  }
	XtRemoveInput(*id);
	pclose(verify_struct->verify_cmd);

	if (dsn_exists != 0) {
	  char *command;
	  char *prefix = "dataset ";
	  char *suffix = " already exists";
/*
	  fprintf(stderr,"dsn %s exists\n",
	    verify_struct->archive_info->dataset_name);
*/
	  command = (char *) bld_err_msg(prefix,
		verify_struct->archive_info->dataset_name,suffix);
/*
	    (strlen(prefix) +
	    strlen(verify_struct->archive_info->dataset_name) +
	    strlen(suffix) + 1) * sizeof(char));
	  strcpy(command,prefix);
	  strcat(command,verify_struct->archive_info->dataset_name);
	  strcat(command,suffix);
*/
          post_message(TRUE,shell,
	    command,
	    XmDIALOG_WARNING,
	    TRUE,"New Revision", (XtPointer) overwrite_verify,
		(XtPointer) verify_struct->archive_info,
	    TRUE,"Enter New Name", (XtPointer) pop_archival_menu,
		(XtPointer) verify_struct->archive_info->menu_info,
	    TRUE,NULL,(XtPointer) XuHelper, (XtPointer) "DsnExists.help");
	  XtFree(command);
	  XtFree((char *)verify_struct);
	  return;
	  }
	dsn_verified = TRUE;
	write_tape(verify_struct->archive_info);
	XtFree((char *)verify_struct);
}

/*ARGSUSED*/			/* this is a pacifier for Saber-C */
void check_dsn(widget,client_data,call_data)
Widget widget;
XtPointer client_data,call_data;
{
	tape_parameters *archive_info = (tape_parameters *) client_data;
	callback_info *menu_info = (callback_info *) archive_info->menu_info;
	struct stat file_stat;
	void pop_archival_menu();
	void write_tape();
	char prefix[32],suffix[32];
	char *command;
	Boolean error = FALSE;

  if (debug_mode >= 2) fprintf(stderr,"-> check_dsn <-\n");
	mode = ARCHIVAL;
	dsn_verified = FALSE;

	if (debug_mode) 
	  fprintf(stderr,"checking dsn %s\n",
		archive_info->dataset_name);

	switch(menu_info->menu_format) {
	  case TAR_ARCHIVAL_TAPE:
	    if (strlen(archive_info->dataset_name) != 0) {
	      if (stat(archive_info->dataset_name,&file_stat) == 0) {
/*
		fprintf(stderr,"mode of %s = %08x\n",archive_info->dataset_name,file_stat.st_mode);
*/
/*	        if ((file_stat.st_mode & S_IFCHR) == 0) {} */
/*		if ((file_stat.st_mode & S_IFMT) != S_IFCHR) {} */
		if (!S_ISCHR(file_stat.st_mode)) {
		  strcpy(prefix,"device ");
		  strcpy(suffix," is not a tape device");
		  error = TRUE;
		  }
		}
	      else {
		strcpy(prefix,"device ");
		strcpy(suffix," not found");
		error = TRUE;
		}

	      if (error) {
	        command = (char *) bld_err_msg(prefix,
		  archive_info->dataset_name,suffix);
/*
		  command = XtMalloc((strlen(prefix) +
			strlen(archive_info->dataset_name) +
			strlen(suffix)) * sizeof(char));

		  strcpy(command,prefix);
		  strcat(command,archive_info->dataset_name);
		  strcat(command,suffix);
*/

		  post_message(TRUE,widget,
			command,
			XmDIALOG_ERROR,
			TRUE,"Enter New Name",
			  (XtPointer) pop_archival_menu,(XtPointer) menu_info,
			FALSE,NULL,NULL,NULL,
			TRUE,NULL,(XtPointer) XuHelper,
				(XtPointer) "BadDevice.help");
		  XtFree(command);
		  return;
		  }
		}
	    dsn_verified = TRUE;
	    break;
	  case TAR_ARCHIVAL_FILE:
	    if (strlen(archive_info->dataset_name) == 0) {
	      post_message(TRUE,widget,
		"No dataset name entered",
		XmDIALOG_ERROR,
		TRUE,"Enter New Name",
		  (XtPointer) pop_archival_menu,(XtPointer) menu_info,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
		return;
		}

	    if (stat(archive_info->dataset_name,&file_stat) == 0) {
/*	      if ((file_stat.st_mode & S_IFREG) != 0) {} */
/*	      if ((file_stat.st_mode & S_IFMT) == S_IFREG) {} */
	      if (S_ISREG(file_stat.st_mode)) {
	        error = TRUE;
	        command = (char *) bld_err_msg("dataset ",
		  archive_info->dataset_name," already exists");
		post_message(TRUE,widget,
		  command,
		  XmDIALOG_WARNING,
		  TRUE,"Overwrite",(XtPointer) overwrite_verify,
			(XtPointer) archive_info,
		  TRUE,"Enter New Name",(XtPointer) pop_archival_menu,
			(XtPointer) menu_info,
		  TRUE,NULL,(XtPointer) XuHelper,
			(XtPointer) "DsnExists.help");
		}
	      else {
	        error = TRUE;
	        command = (char *) bld_err_msg("dataset ",
		  archive_info->dataset_name,
		  " already exists,\nbut is not a regular file");
		post_message(TRUE,widget,
		  command,
		  XmDIALOG_WARNING,
		  TRUE,"Enter New Name",(XtPointer) pop_archival_menu,
			(XtPointer) menu_info,
		  FALSE,NULL,NULL,NULL,
		  TRUE,NULL,(XtPointer) XuHelper,
			(XtPointer) "DsnExists.help");
		}
	      }

/*
		fprintf(stderr,"dsn %s exists\n",
			archive_info->parmfile->dataset_name);
*/
	      if (error) {
		XtFree(command);
		return;
		}
/*
	      else {
	        strcpy(prefix,"file ");
	        strcpy(suffix," already exists,\nbut is not a simple file");

	        command = (char *) bld_err_msg(prefix,
		  archive_info->dataset_name,suffix);
	        post_message(TRUE,widget,command,
		  XmDIALOG_ERROR,
		  TRUE,"Enter New Name",
		    (XtPointer) pop_archival_menu, (XtPointer) menu_info,
		  FALSE,NULL,NULL,NULL,
		  TRUE,NULL,(XtPointer) XuHelper, (XtPointer) "Simple.help");
		XtFree(command);
		return;
	     	}
*/
	    dsn_verified = TRUE;
	    break;
	  case CRAY_ARCHIVAL_TAPE:
	  case IBM_ARCHIVAL_TAPE:
	    if (strlen(archive_info->dataset_name) == 0) {
	       post_message(TRUE,widget,
		"No dataset name entered",
		XmDIALOG_ERROR,
		TRUE,"Enter New Name",
		  (XtPointer) pop_archival_menu,(XtPointer) menu_info,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
		return;
		}
	    {
	    verify_info *ver_struct;
	    char *command;
	    char *list_cmd = "listtape -raw -d ";
	    char *wc_cmd = "| wc -l";

	    command = XtMalloc((strlen(list_cmd) +
		strlen(archive_info->dataset_name) +
		strlen(wc_cmd) + 1) * sizeof(char));

	    strcpy(command,list_cmd);
	    strcat(command,archive_info->dataset_name);
	    strcat(command,wc_cmd);

	    if (debug_mode >= 2)
	      fprintf(stderr,"%s\n",command);

	    ver_struct = (verify_info *) XtMalloc(sizeof(verify_info));
	    ver_struct->verify_cmd = popen(command,"r");
	    ver_struct->archive_info = archive_info;
	    XtAppAddInput(app_con,fileno(ver_struct->verify_cmd),
		(XtPointer)XtInputReadMask,dsn_verify,(XtPointer) ver_struct);
	    XtFree(command);
	    break;
	  case TAR_REMOTE_DEVICE:
	    if (strlen(archive_info->dataset_name) == 0) {
	      post_message(TRUE,widget,
		"No dataset name entered",
		XmDIALOG_ERROR,
		TRUE,"Enter New Name",
		  (XtPointer) pop_archival_menu,(XtPointer) menu_info,
		FALSE,NULL,NULL,NULL,
		FALSE,NULL,NULL,NULL);
		return;
		}
	    dsn_verified = TRUE;
	    }
	    break;
	  }
	write_tape(archive_info);
}

void tape_menu(trigger,parmfile,menu_format)
Widget trigger;
tape_parameters *parmfile;
int menu_format;
{
	Widget dialog,option_form,reference_widget;
	Widget dsn_label,dsn_input;
	Widget tape_lim_label,tape_lim_input;
	Widget expdt_label,expdt_input;
	Widget recfm_label,recfm_input;
	Widget rm_query,rm_toggle,full_path_query,full_path_toggle;
	Widget separator;
	Widget apply,cancel,help;
	XmString item_label;
	String dsn_name;
	callback_info *info;
	void write_tape(),pop_the_dialog(),set_dialog_focus();
	void tree();

  if (debug_mode >= 2) fprintf(stderr,"-> tape_menu <-\n");
	info = (callback_info *) XtMalloc(sizeof(callback_info));
	(parmfile+menu_format)->menu_info = info;

	info->menu_format = menu_format;
	info->widgets = (Widget *) calloc(MENU_WIDGET_MAX,sizeof(Widget));

	nargs = 0;
	XtSetArg(Xarg[nargs], XmNallowShellResize, FALSE); nargs++;
	dialog = XmCreateFormDialog(
		trigger,menu_dialog_name[menu_format],Xarg,nargs);
	item_label = XmStringCreateLtoR(tape_dialog_label[menu_format],
		XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog,	XmNverticalSpacing,	(Dimension)10,
				XmNdialogTitle,		item_label,
				XmNmappedWhenManaged,	TRUE,
				XmNautoUnmanage,	FALSE,
				NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("OK",
		XmSTRING_DEFAULT_CHARSET);
	apply = XtVaCreateManagedWidget("apply",
		xmPushButtonWidgetClass, dialog,
			XmNlabelString,		item_label,
/*
			XmNresizable,		FALSE,
*/
			XmNtopAttachment,	XmATTACH_NONE,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	30,
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL);
	XmStringFree(item_label);

	cancel = XtVaCreateManagedWidget("Cancel",
		xmPushButtonWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		apply,
			XmNtopOffset,		0,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	apply,
			XmNbottomOffset,	0,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	40,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	60,
			NULL);

	help = XtVaCreateManagedWidget("Help",
		xmPushButtonWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNtopWidget,		apply,
			XmNtopOffset,		0,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	apply,
			XmNbottomOffset,	0,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	70,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	90,
			NULL);

	separator = XtVaCreateManagedWidget("separator",
		xmSeparatorWidgetClass, dialog,
			XmNtopAttachment,	XmATTACH_NONE,
			XmNtopOffset,		0,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	apply,
			XmNbottomOffset,	0,
			XmNresizable,		FALSE,
/*
			XmNheight,	40,
*/
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	option_form = XmCreateForm(dialog,"tape_options",NULL,0);
	XtVaSetValues(option_form,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_WIDGET,
			XmNbottomWidget,	separator,
			NULL);

	dsn_input = XtVaCreateManagedWidget("dsn",
		xmTextWidgetClass,option_form,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL);

	item_label = XmStringCreateLtoR("dataset name",
		XmSTRING_DEFAULT_CHARSET);

	dsn_label = XtVaCreateManagedWidget("dsn_label",
		xmLabelWidgetClass, option_form, 
			XmNtopAttachment,	XmATTACH_FORM,
			XmNlabelString,		item_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment, 	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	dsn_input,
			NULL);
	XmStringFree(item_label);

	dsn_name = XmTextGetString(dsn_input);

	if (strlen(dsn_name) != 0) {
	  (parmfile+menu_format)->dataset_name = dsn_name;
	  XtVaSetValues(dsn_input,
	  		XmNcolumns,		(short)strlen(dsn_name)+25,
	  		XmNcursorPosition,	(short)strlen(dsn_name),
			NULL);
	  }
	XtFree(dsn_name);

	expdt_input = XtVaCreateManagedWidget("expdt",
		xmTextWidgetClass, option_form,
			XmNeditable,		TRUE,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		dsn_input,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			NULL);

	(parmfile+menu_format)->expiration_date = XmTextGetString(expdt_input);

	item_label = XmStringCreateLtoR("expiration date",
		XmSTRING_DEFAULT_CHARSET);
	expdt_label = XtVaCreateManagedWidget("expdt_label", 
		xmLabelWidgetClass,		option_form,
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		dsn_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	expdt_input,
			NULL);
	XmStringFree(item_label);

	tape_lim_input = XtVaCreateManagedWidget("tape_count",
		xmTextWidgetClass, option_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		expdt_input,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			NULL);

	(parmfile+menu_format)->max_no_of_tapes =
					XmTextGetString(tape_lim_input);

	item_label = XmStringCreateLtoR("max # of tapes",
		XmSTRING_DEFAULT_CHARSET);
	tape_lim_label = XtVaCreateManagedWidget("tape_lim_label",
		xmLabelWidgetClass, 		option_form,
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		expdt_label,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	tape_lim_input,
			NULL);
	XmStringFree(item_label);
	reference_widget = tape_lim_label;

/*
	if (menu_format == IBM_ARCHIVAL_TAPE) {
*/
	  recfm_input = XtVaCreateManagedWidget("recfm",
		xmTextWidgetClass, option_form,
	  		XmNtopAttachment,	XmATTACH_WIDGET,
	  		XmNtopWidget,		reference_widget,
	  		XmNrightAttachment,	XmATTACH_FORM,
	  		XmNleftAttachment,	XmATTACH_POSITION,
	  		XmNleftPosition,	(Position) 50,
			NULL);

	  (parmfile+menu_format)->record_format = XmTextGetString(recfm_input);

	  item_label = XmStringCreateLtoR("recfm",
		XmSTRING_DEFAULT_CHARSET);
	  recfm_label = XtVaCreateManagedWidget("recfm_label",
		xmLabelWidgetClass, option_form,
	  		XmNlabelString,item_label,
	  		XmNtopAttachment,XmATTACH_WIDGET,
	  		XmNtopWidget,reference_widget,
	  		XmNleftAttachment,XmATTACH_FORM,
	  		XmNrightAttachment,XmATTACH_POSITION,
	  		XmNrightPosition,(Position) 50,
	  		XmNbottomAttachment,
			XmATTACH_OPPOSITE_WIDGET,
	  		XmNbottomWidget,recfm_input,
			NULL);
	  XmStringFree(item_label);
	  reference_widget = recfm_label;
/*
	  }
*/
	if (menu_format != IBM_ARCHIVAL_TAPE) {
		XtVaSetValues(recfm_label,
			XmNsensitive,	FALSE,
			NULL);
		XtVaSetValues(recfm_input,
	  		XmNeditable,	FALSE,
			XmNsensitive,	FALSE,
			NULL);
		}

	full_path_toggle = XtVaCreateManagedWidget("full_path_toggle",
		xmToggleButtonWidgetClass, option_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		reference_widget,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL);

	XtAddCallback(full_path_toggle, XmNvalueChangedCallback,
		chg_toggle_label, path_labels);

	(parmfile+menu_format)->full_path_names =
		XmToggleButtonGetState(full_path_toggle);

	XtVaSetValues(full_path_toggle,
	  XmNlabelString, path_labels[(parmfile+menu_format)->full_path_names],
	  NULL);

	nargs = 0;
	item_label = XmStringCreateLtoR("Path names for archival",
		XmSTRING_DEFAULT_CHARSET);
	full_path_query = XtVaCreateManagedWidget("full_path_query",
		xmLabelWidgetClass, option_form,
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		reference_widget,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	full_path_toggle,
			NULL);
	XmStringFree(item_label);

	item_label = XmStringCreateLtoR("Yes",XmSTRING_DEFAULT_CHARSET);
	rm_toggle = XtVaCreateManagedWidget("rm_toggle",
		xmToggleButtonWidgetClass, option_form,
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		full_path_query,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	(Position) 50,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL);
	XmStringFree(item_label);
	XtAddCallback(rm_toggle, XmNvalueChangedCallback,
		chg_toggle_label, bool_label);

	(parmfile+menu_format)->remove_archive_files =
		XmToggleButtonGetState(rm_toggle);

	XtVaSetValues(rm_toggle, XmNlabelString,
	  bool_label[(parmfile+menu_format)->remove_archive_files],
	  NULL);

	item_label = XmStringCreateLtoR("Remove files after archive?",
		XmSTRING_DEFAULT_CHARSET);
	rm_query = XtVaCreateManagedWidget("rm_query",
		xmLabelWidgetClass, option_form,
			XmNlabelString,		item_label,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		full_path_query,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	(Position) 50,
			XmNbottomAttachment,	XmATTACH_OPPOSITE_WIDGET,
			XmNbottomWidget,	rm_toggle,
			NULL);
	XmStringFree(item_label);

	XtManageChild(option_form);

	*(info->widgets+TRIGGER_WIDGET)   = trigger;
	*(info->widgets+DIALOG_WIDGET) = dialog;
	*(info->widgets+DATASET_TEXT) = dsn_input;
	*(info->widgets+EXPDT_TEXT) = expdt_input;
	*(info->widgets+TAPE_LIM_TEXT) = tape_lim_input;
	*(info->widgets+RECFM_TEXT) = recfm_input;
	*(info->widgets+FULL_PATH_TOGGLE) = full_path_toggle;
	*(info->widgets+REMOVAL_TOGGLE) = rm_toggle;
	XtAddCallback(apply, XmNactivateCallback, set_archival_opts,
		(XtPointer) (parmfile+menu_format));
/*
	XtAddCallback(apply, XmNactivateCallback, dsn_msg, (XtPointer) info);
	XtAddCallback(apply, XmNactivateCallback,
				write_tape, (XtPointer) info);
*/
	XtAddCallback(apply, XmNactivateCallback, check_dsn,
		(XtPointer) (parmfile+menu_format));
	XtAddCallback(cancel, XmNactivateCallback, cancel_archival_changes,
		(XtPointer) (parmfile+menu_format));
	XtAddCallback(help, XmNactivateCallback, XuHelper,
		(XtPointer) (parmfile+menu_format)->help_file);

	XtAddCallback(trigger, XmNactivateCallback, pop_the_dialog,
		(XtPointer) dialog);
	XtAddCallback(trigger, XmNhelpCallback, XuHelper,
		(XtPointer) (parmfile+menu_format)->help_file);
	XtAddCallback(dialog, XmNmapCallback, set_dialog_focus,
		(XtPointer) dsn_input);

	if (debug_mode >= 1) tree(dialog,(int) 0);
}
