/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <localsys.h>
#include <size_defs.h>
#include <sisio_c.h>
#include <slice.h>

main(argc,argv)
int argc;
char **argv;
{
	FILE *fdin,*fdout;
	int i,j;
	int verbos,is_a_pipe();
	int first_slice,last_slice,increment,slice;
	long int skip_size,initial_skip_size,normal_skip_size,trace_size;
	char *green_trace,*trace,*header;
	char *sample;
	long hdr_byte_count;
	char ntap[64],otap[64];
	line_header old,new;
	trace_header trace_hdr;
	void read_err(),write_err();
	long get_full_word(),get_half_word();
	void put_full_word(),put_half_word();
	void help();

	fprintf(stderr,"DSLICE:\n");

	if (argis_c("-?",&argc,argv) != 0) help();
	verbos = argis_c("-V",&argc,argv);
	argstr_c("-N",ntap,"","",&argc,argv);
	argstr_c("-O",otap,"","",&argc,argv);

	if (strlen(ntap) != 0) {
	  if (verbos) fprintf(stderr,"input data set -  %s\n",ntap);
	  fdin = fopen(ntap,"r");
	  if (fdin == NULL) {
	    fprintf(stderr,"ERROR: unable to open input data set - ");
	    fprintf(stderr,"please check data set\n");
	    exit(100);
	    }
	  }
	else {
	  if (is_a_pipe(stdin)) {
	    fprintf(stderr,"ERROR: piped input not allowed\n");
	    exit(100);
	    }
	  else {
	    if (verbos) fprintf(stderr,"input data set -  stdin\n");
	    fdin = stdin;
	    }
	  }

	if (strlen(otap) != 0) {
	  if (verbos) fprintf(stderr,"output data set -  %s\n",otap);
	  fdout = fopen(otap,"w");
	  if (fdout == NULL) {
	    fprintf(stderr,"ERROR: unable to open output data set - ");
	    fprintf(stderr,"please verify permissions\n");
	    exit(100);
	    }
	  }
	else {
/*
   Earlier versions disallowed pipes; qdslice is quicker, but will not
   handle piped data. No reason for this one not too. Data is handled in
   order.					- j.m.wade 9/28/94
*/
	    fdout = stdout;
	  }

	buffer.value = 0;
	if (fread(&buffer.fullword.value[0],SZGRWD,1,fdin) == 0) read_err();
	if (fwrite(buffer.fullword.value,SZGRWD,1,fdout) == 0) write_err();
	hdr_byte_count = buffer.value;

	header = (char *) malloc(hdr_byte_count);
	if (fread(header,hdr_byte_count,1,fdin) == 0) read_err();

	old.Number_of_Traces  = get_full_word(header+NUMBER_OF_TRACES_OFFSET);
	old.Number_of_Records = get_full_word(header+NUMBER_OF_RECORDS_OFFSET);
	old.Sample_Interval   = get_full_word(header+SAMPLE_INTERVAL_OFFSET);
	old.Number_of_Samples = get_full_word(header+NUMBER_OF_SAMPLES_OFFSET);
	old.Format 	      = get_half_word(header+FORMAT_OFFSET);

	if (verbos) {
	  fprintf(stderr,"\ninput:\n");
	  fprintf(stderr,"\t\tformat = %d\n",		old.Format);
	  fprintf(stderr,"\t\tno. of records = %d\n",	old.Number_of_Records);
	  fprintf(stderr,"\t\tno. of traces/record = %d\n", old.Number_of_Traces);
	  fprintf(stderr,"\t\tno. of samples = %d\n",	old.Number_of_Samples);
	  fprintf(stderr,"\t\tsample interval = %d\n",	old.Sample_Interval);
	  }

	new.Format		= old.Format;
	new.Number_of_Samples	= old.Number_of_Traces;
	new.Number_of_Traces	= old.Number_of_Records;
	new.Sample_Interval	= 1;

/*  look for sample parms first, then by time; if neither, use default */

	argi4_c("-ss",&first_slice,0,-1,&argc,argv);
	if (first_slice == -1) {
	  argi4_c("-s",&first_slice,0,0,&argc,argv);
	  first_slice = (first_slice / old.Sample_Interval) + 1;
	  }
	if (first_slice < 0) first_slice = 0;
	if (first_slice > old.Number_of_Samples)
		first_slice = old.Number_of_Samples;

	argi4_c("-es",&last_slice,old.Number_of_Samples,-1,&argc,argv);
	if (last_slice == -1) {
	  argi4_c("-e",&last_slice,0,old.Number_of_Samples,&argc,argv);
	  last_slice = (last_slice / old.Sample_Interval) + 1;
	  }
	if (last_slice < 0) last_slice = 0;
	if (last_slice > old.Number_of_Samples)
		last_slice = old.Number_of_Samples;

	argi4_c("-is",&increment,1,-1,&argc,argv);
	if (increment == -1) {
	  argi4_c("-i",&increment,old.Sample_Interval,old.Sample_Interval,
		&argc,argv);
	  increment = (int) (increment / old.Sample_Interval);
	  }
	if (increment < 0) increment = 1;

	fprintf(stderr,"\nsampling:\n");
	fprintf(stderr,"\t\tfirst slice at sample # %d\n",first_slice);
	fprintf(stderr,"\t\tlast slice at sample # %d\n",last_slice);
	fprintf(stderr,"\t\tincrement = %d\n",	increment);

	if (increment != 0.)
	  new.Number_of_Records =
		(long) ((last_slice - first_slice) / increment) + 1;
	else {
	  if (first_slice != last_slice) {
	    fprintf(stderr,"ERROR: An increment of zero has been ");
	    fprintf(stderr,"specified although start\nand end slices differ;");
	    fprintf(stderr,"please correct and resubmit.\n");
	    exit(100);
	    }
	  new.Number_of_Records = 1;
	  increment = 1; /* this will ensure that we get out our loop! */
	  }

	if (verbos) {
	  fprintf(stderr,"\noutput:\n");
	  fprintf(stderr,"\t\tformat = %d\n",		new.Format);
	  fprintf(stderr,"\t\tno. of records = %d\n",	new.Number_of_Records);
	  fprintf(stderr,"\t\tno. of traces/record = %d\n",
		new.Number_of_Traces);
	  fprintf(stderr,"\t\tno. of samples = %d\n",	new.Number_of_Samples);
	  fprintf(stderr,"\t\tsample interval = %d\n",	new.Sample_Interval);
	  }

	put_full_word(header+NUMBER_OF_TRACES_OFFSET,new.Number_of_Traces);
	put_full_word(header+NUMBER_OF_RECORDS_OFFSET,new.Number_of_Records);
	put_full_word(header+SAMPLE_INTERVAL_OFFSET,new.Sample_Interval);
	put_full_word(header+NUMBER_OF_SAMPLES_OFFSET,new.Number_of_Samples);
	put_half_word(header+FORMAT_OFFSET,new.Format);

	if (fwrite(header,hdr_byte_count,1,fdout) == 0) write_err();

	buffer.value = 0;
	if (fread(buffer.fullword.value,sizeof(char),SZGRWD,fdin) == 0)
		read_err();

	header = (char *) malloc(TRACE_HDR_SIZE);
	if (fread(header,TRACE_HDR_SIZE,1,fdin) == 0) read_err();

	trace_hdr.Record_Number = 1;
	trace_hdr.Trace_Number  = 1;

	trace_size = TRACE_HDR_SIZE + (new.Number_of_Samples * SZSAMP);

	green_trace = (char *) malloc( trace_size + SZGRWD);
	trace = green_trace + SZGRWD;
	memcpy(trace,header,TRACE_HDR_SIZE);

	put_full_word(green_trace,trace_size);
	put_half_word(trace+RECORD_NUMBER_OFFSET,trace_hdr.Record_Number);
	put_half_word(trace+TRACE_NUMBER_OFFSET,trace_hdr.Trace_Number);

	normal_skip_size = (long int)
		((old.Number_of_Samples -1) * SZSAMP) + SZGRWD + SZDTHD;

	for (slice=first_slice; slice<=last_slice; slice+=increment) {
	 initial_skip_size = (slice -1) * SZSAMP;
	 for (i=0,skip_size=initial_skip_size;
		i< new.Number_of_Traces;
		  i++) {
	  for (j=0,sample=(trace+TRACE_HDR_SIZE);
		j < new.Number_of_Samples;
		  j++,skip_size=normal_skip_size,sample+=SZSAMP) {
	    if ( fseek(fdin,skip_size,SEEK_CUR) != 0) read_err();
	    if (fread(sample,SZSAMP,1,fdin) == 0) read_err();
	    }
	  put_half_word(trace+TRACE_NUMBER_OFFSET,trace_hdr.Trace_Number);
	  if (fwrite(green_trace,trace_size+SZGRWD,1,fdout) == 0)
		write_err();
	  trace_hdr.Trace_Number++;
	  }
	 trace_hdr.Trace_Number = 1;
	 trace_hdr.Record_Number++;
	 put_half_word(trace+RECORD_NUMBER_OFFSET,trace_hdr.Record_Number);
	 put_half_word(trace+TRACE_NUMBER_OFFSET,trace_hdr.Trace_Number);
	 rewind(fdin);
	 if (fseek(fdin,
	   hdr_byte_count+TRACE_HDR_SIZE+(2*SZGRWD),SEEK_CUR) != 0)
		read_err();
	 }
	fclose(fdin);
	fclose(fdout);
	exit(0);
}
void read_err()
{
 	fprintf(stderr,
	  "ERROR: dslice - error reading input data\n");
	exit(1);
}

void write_err()
{
 	fprintf(stderr,
	  "ERROR: dslice - error writing output data\n");
	exit(1);
}
long get_full_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.fullword.value,source,SZDFWD);
	return(buffer.value);
}
long get_half_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.halfword.value,source,SZDHWD);
	return(buffer.value);
}
void put_full_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.fullword.value,SZDFWD);
	return;
}
void put_half_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.halfword.value,SZDHWD);
	return;
}
void help()
{
	fprintf(stderr,"Purpose: generate data slice(s) from USP data set\n");
	fprintf(stderr,"Usage: dslice -N[ntap] -O[otap] -s[start_time]");
	fprintf(stderr,"\n\t\t -e[end_time] -i[time_increment]\n");
	fprintf(stderr,"       dslice -N[ntap] -O[otap] -ss[begin_sample]");
	fprintf(stderr,"\n\t\t -es[end_sample] -is[increment_sample]\n\n");
	fprintf(stderr,"Options:\n");
	fprintf(stderr,"  -s  starting time for slicing (default=0)\n");
	fprintf(stderr,"  -e  ending time for slicing ");
	fprintf(stderr,"(default=trace length)\n");
	fprintf(stderr,"  -i  time increment between slices ");
	fprintf(stderr,"(default=input sample interval)\n");
	fprintf(stderr,"  -ss  starting sample for slicing (default=0)\n");
	fprintf(stderr,"  -es  ending sample for slicing ");
	fprintf(stderr,"(default=trace length)\n");
	fprintf(stderr,"  -is  increment in samples between slices ");
	fprintf(stderr,"(default=1)\n");
	exit(0);
}
