C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wtn ( data, nn, ndim, isign, cc, cr, ncof, ioff, 
     :     joff, itotal, level_req )

c routine to perform n dimensional discrete wavelet transform
c After Numerical Recipes, Press Et. Al. pp. 595, 596

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from main

      integer ndim, nn(ndim), isign, ncof, ioff, joff, itotal, level_req

      real cc(SZLNHD), cr(SZLNHD), data(itotal)

c ndim : number of dimensions
c nn[] : an array containing the number of samples in each dimension
c isign : 1 = forward transform  ,  -1 = reverse transform
c cc[], cr[] : wavelet coefficients
c ncof = number of coefficients
c ioff,joff : center of wavelet
c level_req : the level to decompose/recompose to/from
c itotal : nn(1) * nn(2) * ... * nn(ndim): I use this so I can see data[]
c                                          in the debugger.  May be removed
c                                          when code goes on line.

c local variables

      integer i1, i2, i3, idim, k, n, nnew, nprev, nt, ntot
      integer levelx

      real  work(SZLNHD)

c levelx: the level of the transform being considered
  
c initialize variables

      call vclr(work,1,SZLNHD)
      ntot = 1

      do idim = 1, ndim

c POLICEMAN: make sure won't walk on memory

         if ( nn(idim) .gt. SZLNHD ) then
            write(LERR,*)' '
            write(LERR,*)'DWT2D: Too much memory requested.  Contact'
            write(LERR,*)'       Garossino and ask for dynamic memory'
            write(LERR,*)'       allocation in the N-dimensional  '
            write(LERR,*)'       wavelet transform subroutine wtn[]'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'DWT2D: Too much memory requested.  Contact'
            write(LER,*)'       Garossino and ask for dynamic memory'
            write(LER,*)'       allocation in the N-dimensional  '
            write(LER,*)'       wavelet transform subroutine wtn[]'
            write(LER,*)'FATAL '
            stop
         endif

         ntot = ntot * nn(idim)
      enddo

      nprev = 1

c main loop over dimensions

      DO idim = 1, ndim
         n = nn(idim)
         nnew = n * nprev

         if ( n .gt. 4 ) then

            do i2 = 0, ntot - 1, nnew

               do i1 = 1, nprev
                  i3 = i1 + i2

                  do k = 1, n

c watch out if n > SZLNHD then segmentation fault will surely follow
c must put work into main and allocate memory dynamically before release

                     work(k) = data(i3)
                     i3 = i3 + nprev
                  enddo

                  if ( isign .ge. 0 ) then

c do 1D forward transform

                     levelx = 0
                     nt = n

 1                   if ( nt .ge. 4 .and. levelx .lt. level_req) then
                        call pwt ( work, nt, isign, cc, cr, ioff, joff, 
     :                       ncof )
                        nt = nt / 2
                        levelx = levelx + 1
                        goto 1
                     endif

                  else

c do 1D inverse transform

c                     nt = 4

c debug
                     nt = n

C WARNING:::::::::::::
c hard-wiring this for the first level inverse transform. Must put some
c logic in to handle this, probably put into the line header of the forward 
c dwt dataset which level of data decomposition is contained

                     levelx = 0

 2                   if ( nt .le. n .and. levelx .lt. level_req ) then
                        call pwt ( work, nt, isign, cc, cr, ioff, joff, 
     :                       ncof )
                        nt = nt*2
                        levelx = levelx + 1
                        goto 2
                     endif
                        
                  endif

                  i3 = i1 + i2

c load output array

                  do k = 1, n
                     data(i3) = work(k)
                     i3 = i3 + nprev
                  enddo
               enddo
            enddo
         endif
         nprev = nnew

      ENDDO
      
      return
      end

                     
                     

         

