C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c edge3d reads in a 3D data set and outputs an edge enhanced data set 
c using a simple spectral wavenumber powering scheme.
c**********************************************************************c
c______________________________________________________________________
c          Kurt J. Marfurt (Amoco EPTG, Tulsa, OK, USA)
c______________________________________________________________________
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
c______________________________________________________________________
      parameter (maxangs=1000,maxannuli=12)         
      parameter (maxmy=51,maxrec=3001)
c
      parameter   (pi=3.1415926,twopi=2.*pi)
      integer     iypointer(-maxmy:maxrec+maxmy)     
      integer*2   sheader(SZLNHD)
      real        cputim(20),waltim(20)
#include <f77/pid.h>
#include <save_defs.h>
c
      character*120  file_in,file_out
      character*6    name
      logical        verbose,query,depth_section,IKP,padded
      integer        argis,pipcnt
      logical        wrint
      integer        stdin,stdout,stderr
      character*9    host,blank9
      integer        pipe(5)
      data           name/'EDGE3D'/
      data           host/'         '/
      data           blank9/'         '/
      data           pipe/3,4,5,6,7/
      data           luhls/88/
      logical        notchx,notchy,notchz
c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     read program parameters from command line card image file
c_______________________________________________________________
      query=(argis( '-?' ) .gt. 0 )
      if(query) then
         call help(ler)
         call exitfu(0)
      endif
      notchx=(argis( '-notchx' ) .gt. 0 )
      notchy=(argis( '-notchy' ) .gt. 0 )
      notchz=(argis( '-notchz' ) .gt. 0 )
      if(.not. notchz) notchz=(argis( '-notcht' ) .gt. 0 )
c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O',file_out,' ', ' ')
c
      call argr4('-tstart',tstart_cmd,0.,0.)
      call argr4('-tend',tend_cmd,0.,0.)
      call argr4('-tskip',tskip,0.,0.)
      call argi4('-ilhap',mx,2,2)   
      call argi4('-clhap',my,2,2)   
      call argi4('-vhap',mz,0,0)   
      call argr4('-ildm',dx,0.,0.)                     
      call argr4('-cldm',dy,0.,0.)                     
      call argr4('-dz',dz,0.,0.)                     
      call argr4('-p',power,2.,2.)
      verbose=(argis('-V') .gt. 0)
      wrint=(argis('-int') .gt. 0)

      ierror=0
      if(dx .le. 0.) then 
         write(lerr,*) 'error! ',
     1                 'positive non-zero dx must be entered '
     2                 //'after  -ildm on command line!'
         write(lerr,*) 'dx = ',dx
         write(ler,*) 'dx = ',dx
         ierror=ierror+1
      endif
      if(dy .le. 0.) then 
         write(lerr,*) 'error! ',
     1                 ' positive non-zero dy must be entered '
     3                 //'after -cldm on command line!'
         write(lerr,*) 'dy = ',dy
         ierror=ierror+1
      endif
      if(dz .lt. 0.) then 
         write(lerr,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(lerr,*) 'dz = ',dz
         ierror=ierror+1
      endif
      if(ierror .gt. 0) then
         call exitfu(666)
         close(lerr)
      endif
c______________________________________________________________________
c     set up a default analysis window.
c______________________________________________________________________
      if(mx .lt. 0) then
         mx=1
      endif
      if(my .lt. 0) then
         my=1
      endif
      if(dz .gt. 0.) then
         depth_section=.true.
      else
         depth_section=.false.
      endif
      if(my .gt. maxmy) then
         write(lerr,*) 'my = ',my,' exceeds maxmy = ',maxmy
         write(lerr,*) 'check command line arguments!'
         call exitfu(1666)
      endif
c_______________________________________________________________
c     get logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout, file_out,'w', 1)
c_______________________________________________________________
c     read line header of input
c     save certain parameters
c_______________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'EDGE3D: no header read from unit ',luin
         write(ler,*)'EDGE3D: no header read from unit ',luin
         call exitfu(4666)
      endif
C_______________________________________________________________________
c     pull relevent values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'TmMsSl',jtstart_orig,LINEHEADER)
      call saver(sheader,'TmSlIn',jtslice_orig,LINEHEADER)
      call saver(sheader,'Dz1000',dzh,LINEHEADER)
      call saver(sheader,'Nx_Pad',nxpad,LINEHEADER)
      nt=nsamp_in-1  
      if(nxpad .gt. 0) then
         padded=.true.
         if(mx .gt. nxpad) then
            write(lerr,*) 'error in edge3d!'
            write(lerr,*) 'mx = ',mx,' exceeds nxpad = ',nxpad,
     1                 ' read from line header!'
            write(lerr,*) 'examine command lines to edge3d and splitr!'
         endif
      else
         padded=.false.
         nxpad=0
      endif
      if(nsi .gt. 16) then
         dtmsec=.001*nsi
      else
         dtmsec=nsi
      endif
      if(depth_section) then
         dtmsec=dz
         dt=.001*dz
      else
         dz=dtmsec
      endif
      ierror=0
      if(tend_cmd .eq. 0.) tend_cmd=tstart_orig+(nsamp_in-1)*dtmsec
      if(semb_window .lt. 0.) semb_window=5.*dtmsec
      dt=.001*dtmsec
      tstart=max(tstart_orig,tstart_cmd)
      tend_orig=tstart_orig+(nsamp_in-1)*dtmsec
      tend=min(tend_orig,tend_cmd)
      tskip=max(tskip,dtmsec)
      istart=nint((tstart-tstart_orig)/dtmsec)
      iend=nint((tend-tstart_orig)/dtmsec)
      istart=max(0,istart)
      iend=min(nsamp_in-1,iend)
      iskip=nint(tskip/dtmsec)
      iskip=max(iskip,1)
      nsamp_out=(iend-istart+1)/iskip
      if(nrec .gt. maxrec) then
         write(lerr,*) 'error in EDGE3D!'
         write(lerr,*) 'too many seismic records!'                 
         write(lerr,*) 'nrec = ',nrec,' exceeds maxrec = ',maxrec 
         write(lerr,*) 'call Marfurt at APR and have him do some'
     1                 //' memory management voodoo!'
         close(lerr)
         write(ler,*) 'error in EDGE3D!'
         write(ler,*) 'too many seismic records!'                 
         write(ler,*) 'nrec = ',nrec,' exceeds maxrec = ',maxrec 
         write(ler,*) 'call Marfurt at APR and have him do some'
         call exit(5666)
      endif
      nbytes_out=(nsamp_out+ITRWRD)*szsmpd
      ny=nrec-1
      if(padded) then
c______________________________________________________________________
c        input data have been padded each with nx_pad extra traces by
c        routine 'splitr' or equivalent.
c        it is the user's responsibility to make sure that the 
c        nxpad following -nxpad in routine 'splitr' is identical to 
c        the mx used in this application.
c______________________________________________________________________
         nx=ntr-1-(2*nxpad)           
      else
         nx=ntr-1
      endif
c
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(a,t40,i5,t50,a)') 'input seismic file name',
     1                         luin,file_in
      write(lerr,'(a,t40,i5,t50,a)') 'output multi-attribute file name',
     1                         luout,file_out
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,i5)') 'number of output samples',nsamp_out
      write(lerr,'(a,t40,i5)') 'number of traces',ntr  
      write(lerr,'(a,t40,i5)') 'number of records',nrec 
      write(lerr,'(a,t40,f12.6)') 'original start time (msec)',
     1                             tstart_orig
      write(lerr,'(a,t40,f12.6)') 'original end time (msec)',
     1                             tend_orig
      write(lerr,'(a,t40,f12.6)') 'output start time (msec)',
     1                             tstart
      write(lerr,'(a,t40,f12.6)') 'output end time (msec)',
     1                             tend
      write(lerr,'(a,t40,f12.6)') 'output skip time (msec)',tskip
      write(lerr,'(a,t40,i5)') 'output start time (samples)',istart
      write(lerr,'(a,t40,i5)') 'output end time (samples)',iend  
      write(lerr,'(a,t40,i5)') 'output skip time (samples)',iskip
      write(lerr,'(a,t40,f12.6)') 'input data sample interval (msec)', 
     1                         dtmsec
      write(lerr,'(a,t40,f12.6)') 'inline trace spacing dx (m)',dx   
      write(lerr,'(a,t40,f12.6)') 'crossline trace spacing dy (m)',
     1                          dy   
      if(depth_section) then
         write(lerr,'(a,t40,f12.6)') 'depth interval dz (m)',dz   
      else
         write(lerr,'(a,t40,f12.6)') 'time  interval dt (sec)',dt   
      endif
      write(lerr,'(a,t40,f12.6)') 'analysis window mx*dx (m) ',mx*dx
      write(lerr,'(a,t40,f12.6)') 'analysis window my*dy (m) ',my*dy
      if(depth_section) then
         write(lerr,'(a,t40,f12.6)') 'analysis window mz*dz (m) ',
     1               mz*dz
      else
         write(lerr,'(a,t40,f12.6)') 'analysis window mz*dtmsec (ms)',
     1               mz*dtmsec
      endif
      
      write(lerr,'(a,t40,i5)') 'nt',nt,'ntr',ntr,'nx',nx,'ny',ny  
      write(lerr,'(a,t40,i5)') 'nxpad',nxpad,'mx',mx,'my',my,'mz',mz
      write(lerr,'(a,t40,i5)') 'nbytes_out',nbytes_out           
      write(lerr,'(a,t40,f12.6)') 'wavenumber power',power
c
      write(lerr,'(a,t40,l5)') 'input depth section?',depth_section
      write(lerr,'(a,t40,l5)') 'running under IKP?',IKP
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
c____________________________________________________________________
      length=(2*mz+1)*(2*mx+1)*(2*my+1)
      length2=length*length
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,
     1                (nt+2*mz+1)*(nx+2*mx+1)*(2*my+1),lerr)
      call mapmem('uout',l_uout,l_free,(nx+1)*(nt+1),lerr)
      call mapmem('live',l_live,l_free,(2*my+1)*(nx+1+2*mx),lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,(nt+1+ITRWRD),lerr)
      call mapmem('trheader',l_trheader,l_free,
     1                             ITRWRD*(nx+1)*(2*my+1),lerr)
      call mapmem('f',l_f,l_free,2*length2,lerr)                     
      call mapmem('fc',l_fc,l_free,2*length2,lerr)                     
      call mapmem('rf',l_rf,l_free,2*length2,lerr)                     
      call mapmem('r',l_r,l_free,length,lerr)                     
      call mapmem('fcrf',l_fcrf,l_free,length,lerr)                     
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for EDGE3D: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program EDGE3D aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)
         write(ler,*)'program EDGE3D aborted'
         call exit(101)
      endif
C_______________________________________________________________________
c     modify line header to reflect actual number of traces output
c     determine if the attributes will go to separate files or
c     one large files with attribute lines written back to back.
C_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)
      jtstart=nint(tstart)
      jtend=nint(tend)
      jtslice=nint(iskip*dtmsec)
      call savew(sheader,'TmMsFS',tstart,LINEHEADER)
      call savew(sheader,'TmMsSl',jtstart,LINEHEADER)
      call savew(sheader,'TmSlIn',jtslice,LINEHEADER)
      call savew(sheader,'NumSmp',nsamp_out,LINEHEADER)
      call savew(sheader,'NumTrc',nx+1,LINEHEADER)
      nrec_out=ny+1
      call savew(sheader,'NumRec',nrec_out,LINEHEADER)
      call wrtape(luout,sheader,lbyout)
c
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
c_____________________________________________________________   
c     go calculate the edge enhancement matrix.
c_____________________________________________________________   
      call getmx(s(l_f),s(l_fc),s(l_r),s(l_rf),s(l_fcrf),
     1           mx,my,mz,dx,dy,dz,power,lerr,
     2           notchx,notchy,notchz)
c_____________________________________________________________   
c     process the data.
c_____________________________________________________________   
      call process(s(l_uin),s(l_uout),s(l_live),s(l_fcrf),
     1             s(l_tracebuf),s(l_trheader),
     2             mx,my,mz,nx,ny,nt,
     3             iypointer,nxpad,ler,
     4             luin,luout,lerr,ITRWRD,
     5             istart,iend,iskip,nsamp_out,nbytes_out,
     6             wrint,cputim,waltim,
     7             l_StaCor,ifmt_StaCor,ln_StaCor)
c_____________________________________________________________   
c     write out timing statistics.
c_____________________________________________________________   
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     6         'write output',cputim(10),waltim(10),
     7         'total',cputim(20),waltim(20)
c_____________________________________________________________   
c     close data files
c_____________________________________________________________   
      if(luout .ne. stdout) call lbclos(luout)

      write(ler,*)'normal completetion. routine EDGE3D'           
      write(lerr,*)'normal completetion. routine EDGE3D'           
      close(lerr)
      call exitfu(0)
c
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3D seismic attributes using a semblance algorithm'
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute edge3d by typing edge3d and list of'
     1                   //' program parameters.'
      write(ler,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(ler,*)
     1'a character(s) correlation to some parameter.'
      write(ler,*)
     1'users enter the following parameters, or use the default values'
      write(ler,*)' '
        write(ler,*)
     1' -N [file_in]  (stdin)      : input seismic file name'          
        write(ler,*)
     1' -O [file_out]  (stdout)    : output multi-attribute file name'        
        write(ler,*)
     1' -p          (2.0)           : multiply spectrum by k**p'
        write(ler,*)
     1' -ildm       (none)          : in line trace spacing '
     2                                 //'in m (ft)'        
        write(ler,*)
     1' -cldm       (none)          : cross line trace spacing '
     2                                 //'in m (ft)'        
        write(ler,*)
     1' -dz         (0.)            : depth sample unit (dz > 0 '
     2                     //'indicates depth section)'
        write(ler,*)
     1' -ilhap      (2)             : half operator length '
     2                    //'for filter in inline direction'
        write(ler,*)
     1' -clhap      (2)             : half operator length '
     2                    //'for filter in crossline direction'
        write(ler,*)
     1' -vhap       (0)             : half operator length '
     2                    //'for filter in vertical direction'
        write(ler,*)
     1' -tstart[tstart] (first sample) : start time (depth)'
     2                           //'  in msec (m)'         
        write(ler,*)
     1' -tend[tend]   (last  sample) : end time in msec'         
     2                           //'  in msec (m)'         
        write(ler,*)
     1' -tskip[tskip]   (1 sample) : output time interval'
     2                           //'  in msec (m)'         
        write(ler,*)
     1' -notchx               : if present, notch out the kx=0. '
     2                        //' spectral component' 
        write(ler,*)
     1' -notchy               : if present, notch out the ky=0. '
     2                        //' spectral component' 
        write(ler,*)
     1' -notchz               : if present, notch out the kz=0. '
     2                        //' spectral component' 
        write(ler,*)
     1' -V                    : if present, verbose printout'
       write(ler,*)' '
       write(ler,*)'usage:'
       write(ler,*)
       write(ler,*)'edge3d -N[file_in] -O[file_out]'
       write(ler,*)'       -p[] -ildm[] -cldm[] -dz[]'
       write(ler,*)'       -ilhap[] -clhap[] -vhap[] '    
       write(ler,*)'       -tstart[] -tend[] -tskip[]'
       write(ler,*)'       -[int,notchx,notchy,notchz,V]'
       write(ler,*)' '
       write(ler,*)

      return
      end
