C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine process(uin,uout,live,afilt,
     1                   tracebuf,trheader,
     2                   mx,my,mt,nx,ny,nt,
     3                   iypointer,nxpad,ler,
     4                   luin,luout,lerr,ITRWRD,
     5                   istart,iend,iskip,nsamp_out,nbytes_out,
     6                   wrint,cputim,waltim,
     7                   l_StaCor,ifmt_StaCor,ln_StaCor)
c__________________________________________________________________________
c     input seismic records.                  
c___________________________________________________________________
      real      uin(-mt:nt+mt,-mx:nx+mx,-my:my)
      integer   iypointer(-my:ny+my)
      logical   live(-mx:nx+mx,-my:+my)
c___________________________________________________________________
c     output vectors.
c___________________________________________________________________
      real      uout(0:nsamp_out-1,0:nx)
      real      tracebuf(-ITRWRD:nt)
      integer*2 trheader(ITRWRD,0:nx,-my:my)
c___________________________________________________________________
c     filter matrix.
c___________________________________________________________________
      real      afilt(-mt:+mt,-mx:+mx,-my:+my)
c___________________________________________________________________
c     timing arrays.
c___________________________________________________________________
      real     cputim(*),waltim(*)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      logical  eof,wrint
c
      jrec=0
c_____________________________________________________________
c     fill in the data swath uin needed for processing.
c_____________________________________________________________
      call timstr(va,wa)
      do 10000 iy=-my,+my
       iypointer(iy)=iy
       if(iy .lt. 0 .or. iy .gt. ny) then
c_____________________________________________________________
c         no records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(iy),my,mx,nx)
       else
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          call rdgather(tracebuf,tracebuf,trheader(1,0,iy),
     1                  uin(-mt,-mx,iy),live(-mx,iy),luin,nx,eof,
     2                  mx,ITRWRD,mt,nt,lerr,
     3                  istart,iend,cputim,waltim,nxpad,
     4                  l_StaCor,ifmt_StaCor,ln_StaCor)
          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return
       endif
10000 continue
c_____________________________________________________________
c     data swath is now full. roll through in the y direction,
c     each time adding the next seismic line and dropping the
c     oldest.
c_____________________________________________________________
      do 90000 jy=0,ny
       if(jy .lt. my) then
          write(ler,*) 'process line ',jy,' of ',ny
       elseif(jy .eq. my) then
          call timstr(v0,w0)
          write(ler,*) 'process line ',jy,' of ',ny
       else
          write(ler,'(a,i5,a,i5,a,i5,a,i5,a,i5,a)')
     1    'process line ',jy,' of ',ny,
     2    ' time to completion: ',nhour,' hr',
     3      nmin,' min',nsec,' sec'
       endif
c___________________________________________________________________
c      loop over the inline (x) direction, taking the radon transform.
c      points lieing outside the computational window are 'dead' 
c      (i.e. live(jx,jy)=.false.)
c___________________________________________________________________
       do 40000 jx=0,nx             
        call timstr(v1,w1)
        jrec=jrec+1
c___________________________________________________________________
c       initialize.
c___________________________________________________________________
        do 15000 jt=0,nsamp_out-1
         uout(jt,jx)=0.
15000   continue
c___________________________________________________________________
c       calculate {uout}=[afilt]{uin}.
c___________________________________________________________________
        do 30000 ky=-my,+my         
         iy=iypointer(jy+ky)                     
         do 28000 kx=-mx,+mx
          ix=jx+kx
          if(live(ix,iy)) then
             it=0
             do 20000 jt=istart,iend,iskip 
              do 19000 kt=-mt,+mt
               uout(it,jx)=uout(it,jx)+
     1               afilt(kt,kx,ky)*uin(jt+kt,ix,iy)
19000         continue
              it=it+1
20000        continue
          endif
28000    continue
30000   continue
        call timend(cputim(3),v1,v2,waltim(3),w1,w2)
40000  continue
c_____________________________________________________________
c      write out the results.
c_____________________________________________________________
       call timstr(va,wa)
       iy=iypointer(jy)
       call wrgather(uout,trheader(1,-mx,iy),tracebuf,tracebuf,
     1               luout,nx,
     2               my,nsamp_out,ITRWRD,nbytes_out,
     3               wrint,umin,umax)
       call timend(cputim(10),va,vb,waltim(10),wa,wb)
c_____________________________________________________________
c      roll the swath buffer in y.
c_____________________________________________________________
       iypointer(jy+my+1)=iypointer(jy-my)
       if(jy+my+1 .gt. ny .and. jy .lt. ny) then
c_____________________________________________________________
c         no more records exist. set all traces to be dead.
c_____________________________________________________________
          call deadrec(live,iypointer(jy+my+1),my,mx,nx)
       elseif(jy+my+1 .le. ny) then
c_____________________________________________________________
c         read in the next record.
c_____________________________________________________________
          call timstr(va,wa)
          iy=iypointer(jy+my+1)
          call rdgather(tracebuf,tracebuf,trheader(1,0,iy),
     1                  uin(0,-mx,iy),live(-mx,iy),luin,nx,eof,
     2                  mx,ITRWRD,mt,nt,lerr,
     3                  istart,iend,cputim,waltim,nxpad,
     4                  l_StaCor,ifmt_StaCor,ln_StaCor)
          call timend(cputim(1),va,vb,waltim(1),wa,wb)
          if(eof) return        
       endif
       if(jy .ge .my) then
c_____________________________________________________________
c         calculate average wall time for completely
c         filled lines.
c_____________________________________________________________
          call timstr(vcurr,wcurr)
          time_per_line=(wcurr-w0)/(jy-my+1)
c_____________________________________________________________
c         predict wall time to completion.
c_____________________________________________________________
          time_left=(ny-jy)*time_per_line
          nhour=time_left/3600.
          nmin=(time_left-3600.*nhour)/60.
          nsec=time_left-3600.*nhour-60.*nmin
       endif
90000 continue
c
      return
      end
