C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     program module embed
c
c**********************************************************************c
c
c embed reads seismic data record by record,
c pads user specified number of zero traces on either side of the spread,
c and writes the results to an output file
c
c     this code works as is on both the cray2 & then sun
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer     itr  ( SZLNHD )
      integer     itr0 ( SZLNHD )
      integer     lhed ( SZLNHD )
      integer     lhed0( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne, lpad, rpad, idist,recnum,trcnum
      character*4 chgrp

#include <f77/pid.h>

      real        tri  ( SZLNHD )
      real        grp, distl, distr, dir, group
      character   ntap * 256, otap * 256, name*5
      logical verbos, query, dead ,copy, up
      integer argis

      equivalence ( itr (  1), lhed (1) )
      equivalence ( itr0(  1), lhed0(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'EMBED'/
      data itr0 / SZLNHD*0 /

c-----
c     get online help if necessary
c-----
      query = (argis ('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout files
c-----
#include <f77/open.h>

c-----
c     read program parameters from command line card image file
c-----
      call gcmdln(ntap,otap,ns,ne,irs,ire,lpad,rpad,
     1            ipad,is,group,verbos, dead,copy,up)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'EMBED: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)


      call hlhprt (itr, lbytes, name, 5, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c-----
c     modify line header to reflect actual number of traces output
c-----
c     if (is .eq. 0) is = (ne+ns)/2
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr = lpad + ne-ns+1 + rpad + ipad
      obytes = SZTRHD * nsamp * SZSMPD
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     get group interval
c-----
      if ( group .eq. 0.0 ) then
            call saver(itr, 'GrpInt' , chgrp , LINHED)
            write(LERR,*)'Getting group interval from line header'
            write(LERR,*)'chgrp= ',chgrp,ichar(chgrp(1:1)),
     1      ichar(chgrp(2:2)),ichar(chgrp(3:3)),ichar(chgrp(4:4))
            if (ichar(chgrp(4:4)) .eq. 0) then
               write(LERR,*)'WARNING:'
               write(LERR,*)'Group interval entry blank'
               write(LERR,*)'Setting grp interval to zero'
               grp = 0.
            else
               read(chgrp,'(f4.0)') grp 
            endif
            write(LERR,*)'grp= ',grp
      else
            grp = group
      endif

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform, grp,
     1                  copy,lpad,rpad,ipad,is,ntap,otap)
c     end if

c-----
c     BEGIN PROCESSING
c     read trace, pad traces, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)

c-----
c     process desired trace records
c-----
      do  301  ii = 1, SZLNHD
               itr0(ii) = 0
301   continue

      iflag = 0
      do 1000 jj = irs, ire

c--------------
c  skip to
c  start of rec
            call trcskp(jj,1,ns-1,luin,ntrc,itr)

            ic = 0
            do 1001 kk=ns,ne
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)

                  if(verbos) 
     :                 write(LERR,*)'Reading from input rec=  ',recnum,
     1                 '  trc=  ',trcnum

c-----------------
c  pad left
c  but also output
c  first input trace
c  regardless
c-----------------
                  IF(kk .eq. ns .AND. kk .ne. ne) then
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist  , TRACEHEADER)
                     distl = idist
                     if( up ) then
                         sn = +1.0
                     else
                         sn = -1.0
                     endif
                     call vmov (lhed, 1, lhed0, 1, SZLNHD)
                     if(.not. copy) then
                        call vclr (lhed0(ITHWP1),1,nsamp)
                     endif
                     do 500  k = 1, lpad
                         ic = ic + 1
                         xoff = (grp*float(lpad-k+1))
                         idist = distl + sn * xoff
                         idista    = iabs(idist)
                         call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,   ic   , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstUsg,l_DstUsg,
     1                               ln_DstUsg, idista , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                               ln_DstSgn, idist  , TRACEHEADER)
                         if (dead)
     1                   call savew2(lhed0,ifmt_StaCor,l_StaCor,
     2                               ln_StaCor, 30000  , TRACEHEADER)
                         if (verbos)
     1                   write(LERR,*)'Left padding trc= ',ic,' dist= ',
     2                               idist
                         call wrtape(luout, itr0, nbytes)
  500                continue
                     ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           ic     , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)

c-----------------
c  leave middle alone
c  if we have no inside
c  pad
c-----------------
                  ELSEIF ( (kk .gt. ns .and. kk .lt. ne) 
     1                                 .AND. is .eq. 0) then
                     ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)

c-----------------
c  leave middle alone
c  up to inside trace pad
c  figure out direction of spread: increasing dists L to R (dir +1)
c                                  decreasing dists L to R (dir -1)
c-----------------
                  ELSEIF ( (kk .gt. ns .and. kk .lt. is)
     1                                 .AND. is .ne. 0) then
                        if( up ) then
                           dir = -1.0
                        else
                           dir = +1.0
                        endif
                     ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)

c---------------------
c  insert inside pad
c  if nonzero
c---------------------
                  ELSEIF (kk .eq. is) then
                     ic = ic + 1
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn,
     1                           ln_DstSgn, idist  , TRACEHEADER)
                     distr = idist
                     call vmov (lhed, 1, lhed0, 1, SZLNHD)
                     if(.not. copy) then
                        call vclr (lhed0(ITHWP1),1,nsamp)
                     endif
                     do 502  k = 1, ipad
                         xoff = (grp*float(k))
                         idist = distr + dir * xoff
                         ic = ic + 1
                         idista    = iabs(idist)
                         call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,   ic   , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstUsg,l_DstUsg,
     1                               ln_DstUsg, idista , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                               ln_DstSgn, idist  , TRACEHEADER)
                         if (dead)
     1                   call savew2(lhed0,ifmt_StaCor,l_StaCor,
     2                               ln_StaCor, 30000  , TRACEHEADER)
                         if (verbos)
     1                   write(LERR,*)'Inside padding trc= ',ic
                         call wrtape(luout, itr0, nbytes)
  502                continue
               

c-----------------
c  leave middle alone
c  beyond inside trace pad
c-----------------
                  ELSEIF ( (kk .gt. is .and. kk .lt. ne)
     1                                 .AND. is .ne. 0) then
                     ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)

c-----------------
c  pad right
c  but also output last
c  input trace regardless
c-----------------
                  ELSEIF (kk .ne. ns .AND. kk .eq. ne) then
                     ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn,
     1                           ln_DstSgn, idist  , TRACEHEADER)
                     distr = idist
                     call wrtape(luout, itr, nbytes)
                     if( up ) then
                         sn = -1.0
                     else
                         sn = +1.0
                     endif
                     call vmov (lhed, 1, lhed0, 1, SZLNHD)

                     if(.not. copy) then
                        call vclr (lhed0(ITHWP1),1,nsamp)
                     endif
                     do 501  k = 1, rpad
                         xoff = (grp*float(k))
                         idist = distr + sn * xoff
                         ic = ic + 1
                         dista     = iabs(idist)
                         call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,   ic   , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstUsg,l_DstUsg,
     1                               ln_DstUsg, idista , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                               ln_DstSgn, idist  , TRACEHEADER)
                         if (dead)
     1                   call savew2(lhed0,ifmt_StaCor,l_StaCor,
     2                               ln_StaCor, 30000  , TRACEHEADER)
                         if (verbos)
     1                   write(LERR,*)'Right padding trc= ',ic,' dist= '
     2                                 ,idist
                         call wrtape(luout, itr0, nbytes)
  501                continue

c-----------------
c  special case:
c  single input trc
c  ns = ne
                  ELSEIF (kk .eq. ns .AND. kk .eq. ne) then
cmam              ELSEIF (kk .eq. ne .AND. kk .eq. ne) then
cmam                 ic = ic + 1
cmam                 if (verbos)
cmam 1               write(LERR,*)'Writing from input trc= ',trcnum,
cmam 2               '  as trc= ',ic
cmam                 call savew2(lhed,ifmt_TrcNum,l_TrcNum,
cmam 1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn,
     1                           ln_DstSgn, idist  , TRACEHEADER)
                     distr = idist
                     if( up ) then
                         sn = -1.0
                     else
                         sn = +1.0
                     endif
                     call vmov (lhed, 1, lhed0, 1, SZLNHD)
                     if(.not. copy) then
                        call vclr (lhed0(ITHWP1),1,nsamp)
                     endif
                     do 600  k = 1, lpad
                         ic = ic + 1
                         xoff = (grp*float(lpad-k+1))
                         idist = distl + sn * xoff
                         idista    = iabs(idist)
                         call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,   ic   , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstUsg,l_DstUsg,
     1                               ln_DstUsg, idista , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                               ln_DstSgn, idist  , TRACEHEADER)
                         if (dead)
     1                   call savew2(lhed0,ifmt_StaCor,l_StaCor,
     2                               ln_StaCor, 30000  , TRACEHEADER)
                         if (verbos)
     1                   write(LERR,*)'Left padding trc= ',ic
                         call wrtape(luout, itr0, nbytes)
  600                continue

                         ic = ic + 1
                     if (verbos)
     1               write(LERR,*)'Writing from input trc= ',trcnum,
     2               '  as trc= ',ic
                     call savew2(lhed,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum,   ic   , TRACEHEADER)
                     call wrtape(luout, itr, nbytes)

                     do 601  k = 1, rpad
                         xoff = (grp*float(k))
                         idist = distr + sn * xoff
                         ic = ic + 1
                         dista     = iabs(idist)
                         call savew2(lhed0,ifmt_TrcNum,l_TrcNum,
     1                               ln_TrcNum,   ic   , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstUsg,l_DstUsg,
     1                               ln_DstUsg, idista , TRACEHEADER)
                         call savew2(lhed0,ifmt_DstSgn,l_DstSgn,
     1                               ln_DstSgn, idist  , TRACEHEADER)
                         if (dead)
     1                   call savew2(lhed0,ifmt_StaCor,l_StaCor,
     2                               ln_StaCor, 30000  , TRACEHEADER)
                         if (verbos)
     1                   write(LERR,*)'Right padding trc= ',ic
                         call wrtape(luout, itr0, nbytes)
  601                continue


                  ENDIF

 1001             continue

c--------------
c  skip to end
c  of cur rec
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)

 1000       continue
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      if(verbos) then
            write(LERR,*)'end of embed, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
       endif
      end

c-------------------------------------------------------
c  function to build group interval from digit entries
c-------------------------------------------------------
      integer function igrp ( i1, i2, i3, i4 )
      integer  i1, i2, i3, i4
      
         igrp = 1000*i1 + 100*i2 + 10*i3 + i4
 
      end

c-------------------------------------------------------
c  online help
c-------------------------------------------------------
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
       write(LER,*)
     :'execute embed by typing embed and a list of program parameters.'
       write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
       write(LER,*)
     :'a character(s) corresponding to some parameter.'
       write(LER,*)' '
       write(LER,*)
     :'users enter the following parameters, or use the default values'
       write(LER,*)
     :' -N [ntap]     (no default)        : input data file name'
       write(LER,*)
     :' -O [otap]     (no default)        : output data file name'
       write(LER,*)
     :' -ns[ns]       (default = first)   : start trace number'
       write(LER,*)
     :' -ne[ne]       (default = last)    : end trace number'
       write(LER,*)
     :' -rs[irs]      (default = first)   : start record number'
       write(LER,*)
     :' -ne[ire]      (default = last)    : end record number'
       write(LER,*)' '
       write(LER,*)
     :' -gi[group] (no default) group interval'
       write(LER,*)
     :' -L [lpad]  (default=0) pad left side of spread with zero trcs'
       write(LER,*)
     :' -R [rpad]  (default=0) pad right side of spread with zero trcs'
       write(LER,*)
     :' -C copy first or last trace of remaining gather into pads' 
       write(LER,*)
     :' -B if present, spread decreases from positive to negative'
       write(LER,*)
     :'    else spread increases from negative to positive'
       write(LER,*)
     :' -D if present flag embedded traces as dead'
       write(LER,*)
     :' -ip[ipad]  (default=0) number inside traces to pad'
       write(LER,*)
     :' -is[is]    (default=0) start inside pad after this trace #'
       write(LER,*)' '
         write(LER,*)
     :'usage:   embed -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
         write(LER,*)
     :'             -re[ire] -gi[group] -L[lpad] -R[rpad] [-U-C -D -V]'
         write(LER,*)
     :'***************************************************************'
      return

      end

      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,lpad,rpad,
     1                  ipad,is,group,verbos, dead,copy,up)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     lpad  - i*4 number leftmost zero pad on spread
c     rpad  - i*4 number rightmost zero pad on spread
c     ipad  - i*4 number of inside traces to pad
c     is    - i*4 start inside pad after this trace
c     group - r*4 group interval override
c     dead        - l   flag as dead traces
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer *4 ns, ne, irs, ire, lpad, rpad, is, ipad
      real       group
      logical    verbos, dead, copy, up
      integer    argis

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-ip',ipad ,   0  ,  0    )
            call argi4 ( '-is',is   ,   0  ,  0    )
            call argr4 ( '-gi',group,   0. ,  0.   )
            call argi4( '-L', lpad, 0, 0 )
            call argi4( '-R', rpad, 0, 0 )
            up     = ( argis( '-B' ) .gt. 0 )
            dead   = ( argis( '-D' ) .gt. 0 )
            copy   = ( argis( '-C' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )

      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, grp,
     1           copy, lpad,rpad,ipad,is,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c      grp  - R*4 group length
c     lpad  - I*4 leftmost zero pad on spread
c     rpad  - I*4 rightmost zero pad on spread
c     ipad  - i*4 number of inside traces to pad
c     is    - i*4 start inside pad after this trace
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, lpad, rpad
      real*4    grp
      character ntap*(*), otap*(*)
      logical   copy

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' group interval     =  ', grp
            write(LERR,*) ' leftmost zero pad  =  ', lpad
            write(LERR,*) ' rightmost zero pad =  ', rpad
            write(LERR,*) ' number trace of inside pad= ',ipad
            write(LERR,*) ' start inside pad after trace ',is
            if (copy)
     1      write(LERR,*) ' pad a COPY of left or rightmost trace'
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end

