C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
**********************************************************************C
C
C     PROGRAM MODULE endfire
C
C**********************************************************************C
C
C endfire reads each seismic record, sorts the trace ordering according
C to either ascending or descending order, then outputs the record
C as 2 separate single enders with the absolute near offset being the
C first trace in each
C
C SUBROUTINE CALLS: RTAPE, HLH, SAVE, SORT
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
 
      INTEGER   ITR(SZLNHD),itr0(SZLNHD)
      INTEGER   LHED( SZSPRD ),idist(SZSPRD),jndx(SZSPRD)
      INTEGER   NSAMP,NSI,NTRC,NREC,IFORM
      INTEGER   LUIN,LBYTES,NBYTES,luout
      integer   argis,jj,kk,jt,TraceCount,NegTraceCount,PosTraceCount
      integer   TotalTraces,RecordNumber,TraceNumber

      integer   itrce
      pointer   (wkitrce, itrce(1))

      CHARACTER   NAME * 7, ntap * 256, otap * 256
#include <f77/pid.h>

      logical     verbos,query,reform,rnum,even,heap

c
c TraceCount :  used with reform option to be sure records are padded out to
c               the number of traces desired if there is not enough live traces
c               comming in to file the gather.
c NegTraceCount : contains the number of traces in gather with negative trace dist
c PosTraceCount : contains the number of traces in gather with positive trace dist
c TotalTraces : contains total number of traces output to date.  This allows record`
c                advances based on modulus(totaltraces) if rnum option is chosen.
c RecordNumber : contains output record number for rnum option
c TraceNumber : contains output tracenumber for rnum option
c

c
c ----- set up some usefull hooks -----
c

      EQUIVALENCE ( ITR(  1), LHED(1) )

c
c ----- initialize data variables -----
c

      DATA NAME     /'ENDFIRE'/
      DATA LUIN / 1 /, LBYTES / 0 /, NBYTES / 0 /
      data verbos/.true./, itr0/SZLNHD*0/
      data TraceCount/0/,PosTraceCount/0/,NegTraceCount/0/
      data TotalTrace/0/,RecordNumber/1/,TraceNumber/1/

C**********************************************************************C
C     get online help if necessary
C**********************************************************************C
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt. 0)
      if( query ) then
          call help()
          stop
      endif

C**********************************************************************C
C     open printout file
C**********************************************************************C
#include <f77/open.h>

C**********************************************************************C
C     read command line parameters
C**********************************************************************C
      call cmdln(ntap,otap,reform,rnum,verbos)

C**********************************************************************C
C     get logical data units, get header values, update line header
C**********************************************************************C
      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

      CALL RTAPE(LUIN,ITR,LBYTES)
      if(lbytes.eq.0) then
         write(LERR,*)'ENDFIRE: no header read on unit ',luin
         write(LERR,*)'ntap =  ',ntap
         write(LERR,*)'FATAL'
         stop
      endif
#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(nsamp .gt. SZLNHD) nsamp=SZLNHD
      if(ntrc .gt. SZLNHD) then
         write(LERR,*)'Too many traces per record -- FATAL'
         stop
      endif

c--------------------------------
c  initialize dummy trace header DstSgn and StaCor
      call savew2(itr0,ifmt_DstSgn,l_DstSgn,
     1            ln_DstSgn, 0      , TRACEHEADER)
      call savew2(itr0,ifmt_StaCor,l_StaCor,
     1            ln_StaCor, 30000  , TRACEHEADER)
c     itr0(119) = 0
c     itr0(125) = 30000
c--------------------------------

c-----------------------------------------------------------------
c  we have to take into account the possiblility of an odd number
c  of channels in a split spread - this is unlikely, but...
c (Actually it's not all that unlikely if dead traces, rollin and
c  rolloff are considered)

c     if(reform) then
         
         if( mod(ntrc,2) .eq. 0) then
            even = .true.
         else
            even = .false.
         endif

c     endif

      if(reform) then

         ntrco = 2 * ntrc
         if(.not. even) then
c           ntrco = ntrco - 1
c           ntrcx = ntrc - 1
            ntrco = ntrco - 1
            ntrcx = ntrc
         else
            ntrcx = ntrc
         endif
         nreco = nrec/2

      else

         ntrco = ntrc/2
         if(.not. even) then
            ntrco = ntrco + 1
         endif
         ntrcx = ntrc
         nreco = 2 * nrec

      endif

      call savew( itr, 'NumTrc', ntrco , LINHED)
      call savew( itr, 'NumRec', nreco , LINHED)
      call savhlh( itr, lbytes, lbyout)

      call wrtape(luout,itr,lbyout)

      heap = .true.
      item = ntrc * (ITRWRD + nsamp) * SZSMPD
      nitems = ITRWRD + nsamp
      call galloc (wkitrce, item, ierr, iabort)
      if (ierr .ne. 0) heap = .false.
 
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item,'  bytes'
      endif

C**********************************************************************C
C     print out key header values
C**********************************************************************C
c     if(verbos) then
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Output traces/rec  =  ', ntrco
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Output recs/line   =  ', nreco
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' ntrx               =  ',ntrcx
c     endif

C**********************************************************************C
C
C     read record, sort on distances, form 2 endfires, or reform 
C     composite record,  then output
C
C**********************************************************************C
 
      DO 100 JJ = 1, NREC

         ic = 0
         DO 99 KK = 1, NTRC

            nbytes=0
            CALL RTAPE(LUIN,itr,NBYTES)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call saver2(itr,ifmt_StaCor,l_StaCor,
     1                  ln_StaCor, istat     , TRACEHEADER)

            if (istat .ne. 30000) then
               ic = ic + 1
c----------------------
c  put traces into array

               ishdr = (ic-1) * nitems
               call vmov (itr, 1, itrce(ishdr+1), 1, nitems)

c--------------------------------------------------------------------
c  put distances into array and put original trace indices into array

               call saver2(itr,ifmt_DstSgn,l_DstSgn,
     1                     ln_DstSgn, idis      , TRACEHEADER)

               idist(ic) = idis
               jndx(ic) = kk
            endif

            
 99      CONTINUE

         ntrcx = ic
c---------------------------
c sort on distance

         call sort(idist,jndx,ntrcx)

c-------------------------------------------------
c  figure out where positive part of spread starts

         do  70  j = 1, ntrcx

            if(idist(j) .gt. 0) go to 71

 70      continue

 71      jneg = j-1

c---------------------------------------------------------------
c  put traces into output vector in ascending absolute distance
c  order for negative side of the spread - renumber traces (opt)
c  and output within range of distances

         DO 198 KK = 1, jneg

            if(reform) then
               jt = kk
            else
               jt = jneg - kk + 1
            endif
            ishdr = (jndx(jt)-1) * nitems
            call vmov (itrce(ishdr+1), 1, itr, 1, nitems)

            if(rnum) then
               call savew2(itr,ifmt_RecNum,l_RecNum,
     1                     ln_RecNum,RecordNumber, TRACEHEADER)
               call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                     ln_TrcNum,TraceNumber , TRACEHEADER)
            endif

c 
c ----- put dead traces at back of output if StaCor=30000 -----
c       This allows zero offset data to be first but will prevent zero offset
c       dead traces from being placed in the first sequential traces.
c
               call saver2(itr,ifmt_DstSgn,l_DstSgn,
     1                     ln_DstSgn, idis , TRACEHEADER)
               call saver2(itr,ifmt_StaCor,l_StaCor,
     1                     ln_StaCor, istat, TRACEHEADER)

               if(istat.ne.30000)then

                  call wrtape(luout,itr,nbytes)

c
c ----- count negative offset traces output -----
c

                  NegTraceCount = NegTraceCount + 1
                  TotalTraces = TotalTraces + 1
                  TraceNumber = TraceNumber + 1

                  if(.not.reform)then

                     if(mod(TotalTraces,ntrco).eq.0)then

                        RecordNumber = RecordNumber+1
                        TraceNumber = 1

                     endif
                      

                  endif
         
               endif
               
 198     CONTINUE

         if(.not.reform)then

c
c ----- flush out record with dead traces if required -----
c
            if(NegTraceCount.lt.ntrco)then

               call savew2(itr0,ifmt_RecNum,l_RecNum,
     1                     ln_RecNum,RecordNumber,TRACEHEADER)

               do j=NegTraceCount+1,ntrco

                  call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     1                        ln_TrcNum, j    , TRACEHEADER)
                  call wrtape(luout,itr0,nbytes)
                  TotalTraces = TotalTraces + 1
                  TraceNumber = TraceNumber+1

                  if(.not.reform)then

                     if(mod(TotalTraces,ntrco).eq.0)then

                        RecordNumber = RecordNumber+1
                        TraceNumber = 1

                     endif

                  endif
 
               enddo
               
            endif

            NegTraceCount = 0

         endif

c---------------------------------------------------------------
c  put traces into output vector in ascending absolute distance
c  order for positive side of the spread - renumber traces (opt)
c  and output within range of distances


         DO 199 KK = jneg+1, ntrcx

            jt = kk
            ishdr = (jndx(jt)-1) * nitems
            call vmov (itrce(ishdr+1), 1, itr, 1, nitems)

            if(rnum) then
               call savew2(itr,ifmt_RecNum,l_RecNum,
     1                     ln_RecNum,RecordNumber, TRACEHEADER)
               call savew2(itr,ifmt_TrcNum,l_TrcNum,
     1                     ln_TrcNum,TraceNumber , TRACEHEADER)
            endif

c 
c ----- put dead traces at back of output if StaCor=30000 -----
c       (See above note)
c

               call saver2(itr,ifmt_DstSgn,l_DstSgn,
     1                     ln_DstSgn, idis , TRACEHEADER)
               call saver2(itr,ifmt_StaCor,l_StaCor,
     1                     ln_StaCor, istat, TRACEHEADER)

               if(istat.ne.30000)then

                  call wrtape(luout,itr,nbytes)
                  TotalTraces = TotalTraces + 1
                  TraceNumber = TraceNumber + 1

                  if(.not.reform)then

                     if(mod(TotalTraces,ntrco).eq.0)then

                        RecordNumber = RecordNumber+1
                        TraceNumber = 1

                     endif
 
                  endif

c
c ----- count positive offset traces output -----
c

                  PosTraceCount = PosTraceCount + 1

               endif

 199     CONTINUE

         if(.not.reform)then

c
c ----- flush out record with dead traces if required -----
c

            if(PosTraceCount.lt.ntrco)then

               call savew2(itr0,ifmt_RecNum,l_RecNum,
     1                     ln_RecNum,RecordNumber,TRACEHEADER)

               do j=PosTraceCount+1,ntrco
                  
                  call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     1                        ln_TrcNum, j    , TRACEHEADER)
                  call wrtape(luout,itr0,nbytes)
                  TotalTraces = TotalTraces + 1
                  TraceNumber = TraceNumber + 1

                  if(mod(TotalTraces,ntrco).eq.0)then

                     RecordNumber = RecordNumber+1
                     TraceNumber = 1

                  endif
                     
               enddo

            endif

            PosTraceCount = 0

         endif

c
c ----- if reforming the original split spread make sure you have -----
c       enough traces per record output
c

         if(reform)then

            if(mod(JJ,2).eq.0)then 

c
c ----- determine output trace count to date and if less than the -----
c       desired ntrco pad with dead traces (with zero offset)
c
               
               TraceCount = NegTraceCount + PosTraceCount
               if(TraceCount.lt.ntrco)then

                  call savew2(itr0,ifmt_RecNum,l_RecNum,
     1                        ln_RecNum,RecordNumber,TRACEHEADER)

                  do j=TraceCount+1,ntrco

                     call savew2(itr0,ifmt_TrcNum,l_TrcNum,
     1                           ln_TrcNum, j    , TRACEHEADER)
                     call wrtape(luout,itr0,nbytes)
                     TotalTraces = TotalTraces + 1
                     if(mod(TotalTraces,ntrco).eq.0)RecordNumber = 
     :                    RecordNumber+1
                   
                  enddo

               endif

c
c ----- reset all trace counters for next record pair -----
c

            PosTraceCount = 0
            NegTraceCount = 0
            TraceCount = 0
            TraceNumber = 1

            endif 
                  
         endif

 100  CONTINUE

 999  continue

      call lbclos(luin)
      call lbclos(luout)
      stop
      END

      subroutine sort(ix,key,no)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end

c------------------
c  online help

      subroutine help
#include <f77/iounit.h>

      
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for ENDFIRE: sort traces'
        write(LER,*)'       into single ender records or reform into'
        write(LER,*)'       split spreads'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set'
        write(LER,*)'-O[otap]   -- output data set'
        write(LER,*)'-U         -- reform into split spread'
        write(LER,*)'-R         -- rnumber output traces'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'        endfire -N[] -O[] -R -V'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,reform,rnum,verbos)
c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      rnum - L      renumber traces on output
c    reform - L      reverse order of distances
c    verbos - L      verbose output or not
c-----
      
#include <f77/iounit.h>
      integer    argis
      logical    verbos, reform, rnum
      character  ntap*(*), otap*(*)

         call argstr('-N',ntap,' ',' ') 
         call argstr('-O',otap,' ',' ') 
           rnum = (argis('-R') .gt. 0)
         reform = (argis('-U') .gt. 0)
         verbos = (argis('-V') .gt. 0)
         
      return
      end
