C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FillDead ( nlive, nsamp, ist, iend, Record_In, 
     :     Dist_In, DistBuffer, Amp_In, Amp_Out, spline_IZ,
     :     spline_ZZ, Dist_Out, Record_Out )

c declare variables passed from calling routine

      implicit none

      integer nlive, nsamp, ist, iend
      integer spline_IZ(1)

      real Record_In(nsamp,nlive), Dist_In(nlive), Record_Out(nsamp)
      real DistBuffer(nlive), Amp_In(nlive), spline_ZZ(4)
      real Amp_Out(1), Dist_Out(1)

c declare local variables

      integer spline_init, i, j

c initialize variables

      spline_init = 1

      DO i = ist, iend

         call vclr (Amp_In, 1, nlive)
         Amp_Out(1) = 0.0
         

c load up data to spline fit

         do j = 1, nlive
            Amp_In(j) = Record_In(i,j)
            DistBuffer(j) = Dist_In(j)
         enddo

c sort input distances into increasing order

         call sort2 ( nlive, DistBuffer, Amp_In )

c cubic spline interpolation, spline_init is unity for first pass to build
c intermediate tables IZ and ZZ.  subsequent calls will use these tables so
c that spline_init is then set to zero to bypass table construction.
            
         call fcuint ( DistBuffer, Amp_In, nlive, Dist_Out, Amp_Out, 
     :        1, spline_IZ, spline_ZZ, spline_init)
         spline_init = 0

         Record_Out(i) = Amp_Out(1)

      ENDDO

      return
      end
