C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine InterpData ( nlive, ntrco, nsamp, ist, iend, 
     :     Record_In, Record_Out, Dist_In, Dist_Out, DistBuffer,
     :     Amp_In, Amp_Out, spline_IZ, spline_ZZ, Type )

c declare variables passed from calling routine

      integer ntrco, nsamp, ist, iend, nlive
      integer spline_IZ(ntrco)

      real Record_In(nsamp,nlive), Record_Out(nsamp,ntrco)
      real Dist_In(nlive), Dist_Out(ntrco), DistBuffer(nlive)
      real Amp_In(nlive), Amp_Out(ntrco)
      real spline_ZZ(ntrco,4)

      character Type*6

c declare variables used in local routine

      integer i,j, spline_init

c initialize variables

      call vclr (Record_Out, 1, nsamp*ntrco)
      spline_init = 1

c interpolate output trace samples using simple linear interpolation
c ------------------------------------------------------------------      
c table of existing trace distances --> Dist_In[]
c table of desired output trace distances  --> Dist_Out[]
c build table of input amplitudes --> Amp_In[]
c interpolate output amplitudes at a given sample --> Amp_Out[]
c load to output record --> Record_Out[]
c ------------------------------------------------------------------      

      DO i = ist, iend

         call vclr (Amp_In, 1, nlive)
         call vclr (Amp_Out, 1, ntrco)
         
         do j = 1, nlive
            Amp_In(j) = Record_In(i,j)
            DistBuffer(j) = Dist_In(j)
         enddo

c sort input distances into increasing order

         call hsort2 ( nlive, DistBuffer, Amp_In )

         if ( Type .eq. 'linear' ) then

            call Linear(Amp_In, DistBuffer, Amp_Out, Dist_Out, nlive,
     :           ntrco)

         else

c cubic spline interpolation, spline_init is unity for first pass to build
c intermediate tables IZ and ZZ.  subsequent calls will use these tables so
c that spline_init is then set to zero to bypass table construction.
            
            call fcuint ( DistBuffer, Amp_In, nlive, Dist_Out, Amp_Out, 
     :           ntrco, spline_IZ, spline_ZZ, spline_init)
            spline_init = 0

         endif

         do j = 1, ntrco
            Record_Out(i,j) = Amp_Out(j)
         enddo

      ENDDO

      return
      end

      
