C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MakeMirror( nlive, ntrc_in, nsamp, Record_In, 
     :     Dist_In, DistBuffer, Header_In, ITRWRD, 
     :     ifmt_DstSgn, l_DstSgn, ln_DstSgn, num_mirror_inside, 
     :     num_mirror_outside, Xmax, Xzero )

c declare variables passed from calling routine

      integer nlive, ntrc_in, ITRWRD
      integer num_mirror_inside, num_mirror_outside
      integer ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer Header_In(ITRWRD,ntrc_in)

      real Record_In(nsamp,ntrc_in), Xmax, Xzero
      real Dist_In(ntrc_in), DistBuffer(ntrc_in)

c declare local variables

      integer total_traces, DstSgn, DstRef

c initilize variables

      total_traces = nlive

      do i = 1, nlive
         DistBuffer(i) = Dist_In(i)
      enddo

      call hsort1 (nlive, DistBuffer)

c Inside mirrored traces

      IF ( num_mirror_inside .gt. 0 ) then

         if ( abs ( DistBuffer(1) ) .lt. abs ( DistBuffer(nlive) ) ) 
     :        then

c trace 1 is near offset, find inside mirror traces and load to
c Record_In and Header_In with opposite sign on DstSgn.  Since a
c distance sort is done in the interpolation routines simply tacking
c the mirrored traces on the end is sufficient

            do 10 i = 1, num_mirror_inside

               do j = 1, nlive

                  call saver2 (Header_In(1,j), ifmt_DstSgn, l_DstSgn, 
     :                 ln_DstSgn, DstSgn, TRACEHEADER)

                  if ( DstSgn .eq. nint(DistBuffer(i)) ) then
                     call vmov ( Record_In(1,j), 1, 
     :                    Record_In(1,nlive+i), 1, nsamp )
                     call vmov ( Header_In(1,j), 1, 
     :                    Header_In(1,nlive+i), 1, ITRWRD )
                     Dist_In(nlive+i) = -1.0 * DistBuffer(i)
                     DstSgn = nint(Dist_In(nlive+i) )
                     call savew2 (Header_In(1,nlive+i), ifmt_DstSgn, 
     :                    l_DstSgn, ln_DstSgn, DstSgn, TRACEHEADER)
                     goto 10
                  endif
               enddo

 10         continue

         else

c trace 1 is far offset, find mirror traces and load to
c Record_In and Header_In with opposite sign on DstSgn

            do 20 i = nlive, nlive - num_mirror_inside, -1

               do j = 1, nlive

                  call saver2 (Header_In(1,j), ifmt_DstSgn, l_DstSgn, 
     :                 ln_DstSgn, DstSgn, TRACEHEADER)

                  if ( DstSgn .eq. nint(DistBuffer(i)) ) then
                     call vmov ( Record_In(1,j), 1, 
     :                    Record_In(1,nlive+i), 1, nsamp )
                     call vmov ( Header_In(1,j), 1, 
     :                    Header_In(1,nlive+i), 1, ITRWRD )
                     Dist_In(nlive+i) = -1.0 * DistBuffer(i)
                     DstSgn = nint(Dist_In(nlive+i) )
                     call savew2 (Header_In(1,nlive+i), ifmt_DstSgn, 
     :                    l_DstSgn, ln_DstSgn, DstSgn, TRACEHEADER)
                     goto 20
                  endif
               enddo

 20         continue

         endif

         total_traces = total_traces + num_mirror_inside

      ENDIF

c Outside mirrored traces

      IF ( num_mirror_outside .gt. 0 ) then

         if ( abs(Xmax) .gt. abs(Xzero) ) then
            DstRef = nint ( Xmax )
         else
            DstRef = nint ( Xzero )
         endif
         
         if ( abs ( DistBuffer(1) ) .lt. abs ( DistBuffer(nlive) ) ) 
     :        then

c trace 1 is near offset, find outside mirror traces and load to
c Record_In and Header_In with appropriate change in trace distance

            do 30 i = nlive, nlive - num_mirror_outside, -1

               do j = 1, nlive

                  call saver2 (Header_In(1,j), ifmt_DstSgn, l_DstSgn, 
     :                 ln_DstSgn, DstSgn, TRACEHEADER)

                  if ( DstSgn .eq. nint(DistBuffer(i)) ) then
                     call vmov ( Record_In(1,j), 1, 
     :                    Record_In(1,total_traces+nlive-i+1), 1, nsamp)
                     call vmov ( Header_In(1,j), 1, 
     :                    Header_In(1,total_traces+nlive-i+1), 1, 
     :                    ITRWRD )
                     Dist_In(total_traces+nlive-i+1) = 2* float(DstRef) 
     :                    - DistBuffer(i)
                     DstSgn = nint(Dist_In(total_traces+nlive-i+1))
                     call savew2 (Header_In(1,total_traces+nlive-i+1), 
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn, 
     :                    TRACEHEADER)
                     goto 30
                  endif
               enddo

 30         continue

         else

c trace 1 is far offset, find mirror traces and load to
c Record_In and Header_In with opposite sign on DstSgn

            do 40 i = 1, num_mirror_outside

               do j = 1, nlive

                  call saver2 (Header_In(1,j), ifmt_DstSgn, l_DstSgn, 
     :                 ln_DstSgn, DstSgn, TRACEHEADER)

                  if ( DstSgn .eq. nint(DistBuffer(i)) ) then
                     call vmov ( Record_In(1,j), 1, 
     :                    Record_In(1,total_traces+i), 1, nsamp )
                     call vmov ( Header_In(1,j), 1, 
     :                    Header_In(1,total_traces+i), 1, ITRWRD )
                     Dist_In(total_traces+i) = float(DstRef) - 
     :                    abs( float(DstRef) - DistBuffer(i))
                     DstSgn = nint(Dist_In(total_traces+i))
                     call savew2 (Header_In(1,total_traces+i), 
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn, 
     :                    TRACEHEADER)
                     goto 40
                  endif
               enddo

 40         continue

         endif

         total_traces = total_traces + num_mirror_outside

      ENDIF

      nlive = total_traces
      return
      end
         

      
      
