C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------

c     Program Changes:

c      - add -D[] option to allow record wise distance limit file to 
c        be input so that  various dist ranges can be interpolated down
c        the line.  This was required by Foinaven OBC data and likley
c        will be the norm from here on [Garossino]

c      - add -dead option to fill in dead traces only using 
c        cubic spline option April 3, 2000 [Garossino]

c      - original written: January 14, 1997 [Garossino]

c     Program Description:

c      - routine to perform spatial interpolation offering options
c        to utilize linear, spline and unequal spaced FFT engines for
c        amplitude interpolation.  Interpolation man be performed across
c        traces along lines, parabolas, hyperbolas   or arbitrary 
c        polynomials.  Optional semblance scanning may ensure interpolation
c        along most appropriate trajectory
c
c       - ends of data may be treated by mirroring, last trace continuation,
c         or zero pad

c get machine dependent parameters 

      implicit none

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     ntrco, nreco
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, ns, ne, argis

      real        UnitSc

      character   ntap*255, otap*255, name*7

      logical     verbos

c Program Specific _ dynamic memory variables

      integer Header_In, Header_Out, DeadHeader_In
      integer RecordInSize, HeaderInSize
      integer RecordOutSize, HeaderOutSize
      integer spline_IZ, DeadIndex, StartDist, EndDist, Dist_size
      integer errcd1, errcd2, errcd3, errcd4, abort
      integer errcd5, errcd6, errcd7, errcd8, errcd9
      integer errcd10, errcd11, errcd12, errcd13, errcd14, errcd15

      real    Record_In, Record_Out, Dist_In, Dist_Out
      real    Amp_In, Amp_Out, DistBuffer, spline_ZZ

      pointer (memadr_Record_In, Record_In(2))
      pointer (memadr_Record_Out, Record_Out(2))
      pointer (memadr_Header_In, Header_In(2))
      pointer (memadr_Header_Out, Header_Out(2))
      pointer (memadr_DeadHeader_In, DeadHeader_In(2))
      pointer (memadr_Dist_In, Dist_In(2))
      pointer (memadr_Dist_Out, Dist_Out(2))
      pointer (memadr_Amp_In, Amp_In(2))
      pointer (memadr_Amp_Out, Amp_Out(2))
      pointer (memadr_DistBuffer, DistBuffer(2))
      pointer (memadr_spline_IZ, spline_IZ(2))
      pointer (memadr_spline_ZZ, spline_ZZ(2))
      pointer (memadr_DeadIndex, DeadIndex(2))
      pointer (memadr_StartDist, StartDist(2))
      pointer (memadr_EndDist, EndDist(2))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_RecNum,l_RecNum,ln_RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_Dstsgn,l_Dstsgn,ln_Dstsgn, Dstsgn, DeadDstSgn
      integer ifmt_HdrWrd(SZLNHD),l_HdrWrd(SZLNHD),ln_HdrWrd(SZLNHD)

      integer hdr_index, tr_index, JJ, KK, irec
      integer ntrc_in, num_mnemonics
      integer num_mirror_outside, num_mirror_inside
      integer i, jerr, nlive, dead_hdr_index, ndead
      integer dead_index, ludist, length, lenth

      character*6 HdrWrd(SZLNHD)
      character distap*256

      real Xzero, deltaX, Xmax, r_DeadDstSgn, r_StartDist, r_EndDist

      character Type*6

      logical mirror, decrement, Policemen, dead

c Initialize variables

      data abort/0/
      data name/"EQUALDX"/
      data decrement/.false./

      do i = 1, SZLNHD
         ifmt_HdrWrd(i) = 0
         l_HdrWrd(i) = 0
         ln_HdrWrd(i) = 0
         HdrWrd(i) = ' '
      enddo

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ns, ne, ist, iend, 
     :     Xzero, deltaX, Xmax, Type, HdrWrd, num_mnemonics,
     :     mirror, num_mirror_inside, num_mirror_outside, 
     :     dead, name, distap, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open input distance limits file if attached

      if ( distap .ne. ' ' ) then

c allocate unit, allocate memory based on number of entries, 
c load distance limits

         call alloclun(ludist)
         length = lenth(distap)
	 if (length .eq. 0) go to 990
         open ( ludist, file=distap(1:length), status='old', err=990 )

         Dist_size = 0
         do while ( 1 .eq. 1 )
            Dist_size = Dist_size + 1
            read (ludist, *, end=100, err=991) r_StartDist, r_EndDist
         enddo

 100     continue

         Dist_size = Dist_size - 1

         call galloc (memadr_StartDist, Dist_size * SZSMPD, errcd14, 
     :        abort )
         call galloc (memadr_EndDist, Dist_size * SZSMPD, errcd15, 
     :        abort )

         if ( errcd14 .ne. 0 .or.
     :        errcd15 .ne. 0  ) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 2*Dist_size * SZSMPD, '  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'Unable to allocate workspace:'
            write(LER,*) 2*Dist_size * SZSMPD, '  bytes'
            write(LER,*)' '
            goto 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 2*Dist_size * SZSMPD, '  bytes'
            write(LERR,*)' '
         endif

         call vclr ( StartDist, 1, Dist_size)
         call vclr ( EndDist, 1, Dist_size)


         rewind (ludist)

         do i = 1, Dist_size

            read (ludist,*) r_StartDist, r_EndDist
            StartDist(i) = nint(r_StartDist)
            EndDist(i) = nint(r_EndDist)
         enddo

      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'EQUALDX: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 7, LERR)

c check user supplied boundary conditions and set defaults

      if (unitsc .eq. 0.0) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         unitsc = .001
         call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      nreco = ire - irs + 1

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ntrc_in = ne - ns + 1 + num_mirror_inside + num_mirror_outside

      if ( dead ) then
         ntrco = ne - ns + 1
      elseif ( distap .ne. ' ' ) then
         ntrco = nint ( abs ( float( StartDist(1) - EndDist(1) )/
     :        abs(deltaX) ) ) + 1
      else
         ntrco = nint ( abs(Xmax - Xzero)/abs(deltaX) ) + 1
      endif

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh, update and output line header

      call savew(itr, 'NumTrc', ntrco, LINHED)
      call savew(itr, 'NumRec', nreco, LINHED)

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
      call savelu ( 'DstSgn', ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER )

      do i = 1, num_mnemonics
         call savelu ( HdrWrd(i), ifmt_HdrWrd(i), l_HdrWrd(i), 
     :        ln_HdrWrd(i), TRACEHEADER )
      enddo

c check to make sure all header values to be interpolated can acutally
c be interpolated

      do i = 1, num_mnemonics

         if ( ifmt_HdrWrd(i) .ne. SAVE_FLOAT_DEF .and.
     :        ifmt_HdrWrd(i) .ne. SAVE_SHORT_DEF .and.
     :        ifmt_HdrWrd(i) .ne. SAVE_LONG_DEF ) then

            write(LERR,*)' '
            write(LERR,*)' You have asked to interpolate a header'
            write(LERR,*)' value that cannot be handled due to format '
            write(LERR,*)' restrictions,  '
            write(LERR,*)' '
            write(LERR,*)' mnemonic = ',HdrWrd(i)
         endif
      enddo

c verbose output of all pertinent information before processing begins

      call verbal ( ntap, otap, nsamp, nsi, ntrc, ntrco, nrec, nreco, 
     :     iform, ist, iend, irs, ire, ns, ne, Xzero, deltaX, Xmax, 
     :     HdrWrd, num_mnemonics, Type, mirror, num_mirror_inside,
     :     num_mirror_outside, dead, distap, verbos )

c dynamic memory allocation:  

      RecordInSize = ntrc_in * nsamp
      RecordOutSize = ntrco * nsamp
      HeaderInSize = ntrc_in * ITRWRD 
      HeaderOutSize = ntrco * ITRWRD 

      call galloc ( memadr_Record_In, RecordInSize * SZSMPD, errcd1, 
     :     abort )
      call galloc ( memadr_Record_Out, RecordOutSize * SZSMPD, errcd2, 
     :     abort )
      call galloc ( memadr_Header_In, HeaderInSize * SZSMPD, errcd3, 
     :     abort )
      call galloc ( memadr_Header_Out, HeaderOutSize * SZSMPD, errcd4, 
     :     abort )
      call galloc ( memadr_DeadHeader_In, HeaderInSize * SZSMPD, 
     :     errcd13, abort )
      call galloc ( memadr_Dist_In, ntrc_in * SZSMPD, errcd5, abort )
      call galloc ( memadr_Dist_Out, ntrco * SZSMPD, errcd6, abort )
      call galloc ( memadr_Amp_In, ntrc_in * SZSMPD, errcd7, abort )
      call galloc ( memadr_Amp_Out, ntrco * SZSMPD, errcd8, abort )
      call galloc ( memadr_DistBuffer, ntrc_in * SZSMPD, errcd9, abort )
      call galloc ( memadr_spline_IZ, ntrco * SZSMPD, errcd10, abort )
      call galloc ( memadr_spline_ZZ, ntrco * 4 * SZSMPD, errcd11, 
     :     abort )
      call galloc ( memadr_DeadIndex, ntrc_in * SZSMPD, errcd12, abort )
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 .or.
     :     errcd12 .ne. 0 .or.
     :     errcd13 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) RecordInSize* SZSMPD, '  bytes'
         write(LERR,*) RecordOutSize* SZSMPD, '  bytes'
         write(LERR,*) 2*HeaderInSize* SZSMPD, '  bytes'
         write(LERR,*) HeaderOutSize* SZSMPD, '  bytes'
         write(LERR,*) 4 * ntrc_in * SZSMPD, '  bytes'
         write(LERR,*) 7 * ntrco * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) RecordInSize* SZSMPD, '  bytes'
         write(LER,*) RecordOutSize* SZSMPD, '  bytes'
         write(LER,*) 2*HeaderInSize* SZSMPD, '  bytes'
         write(LER,*) HeaderOutSize* SZSMPD, '  bytes'
         write(LER,*) 4 * ntrc_in * SZSMPD, '  bytes'
         write(LER,*) 7 * ntrco * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) RecordInSize* SZSMPD, '  bytes'
         write(LERR,*) RecordOutSize* SZSMPD, '  bytes'
         write(LERR,*) 2*HeaderInSize* SZSMPD, '  bytes'
         write(LERR,*) HeaderOutSize* SZSMPD, '  bytes'
         write(LERR,*) 4 * ntrc_in * SZSMPD, '  bytes'
         write(LERR,*) 7 * ntrco * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record_In, 1, RecordInSize )
      call vclr ( Record_Out, 1, RecordOutSize )
      call vclr ( Dist_In, 1, ntrc_in )
      call vclr ( Dist_Out, 1, ntrco )
      call vclr ( Amp_In, 1, ntrc_in )
      call vclr ( Amp_Out, 1, ntrco )
      call vclr ( DistBuffer, 1, ntrc_in )
      call vclr ( spline_ZZ, 1, ntrco )

      do i = 1, HeaderInSize
         Header_In(i) = 0
         DeadHeader_In(i) = 0
      enddo

      do i = i, HeaderOutSize
         Header_Out(i) = 0
      enddo

      do i = 1, ntrco
         spline_IZ(i) = 0
      enddo

      do i = 1, ntrc_in
         DeadIndex(i) = 0
      enddo

      if ( .not. dead .and. distap .eq. ' ' ) then

c load output trace distance table, make sure this always increment
c as some of the interpolation codes do not like it to decrement
c if it needs to decrement, set a flag and flip the output.  If dead
c has been flagged on command line then we do not do this as the output
c distance will be in the input trace header DstSgn for the dead trace
c and we will be interpolating a single trace at a time.

         if ( Xzero .gt. Xmax ) then
            do i = 1, ntrco
               Dist_Out(i) = Xzero + float(ntrco - i) * deltaX
            enddo
            decrement = .true.
         else
            do i = 1, ntrco
               Dist_Out(i) = Xzero + float(i - 1) * deltaX
            enddo
         endif

      endif
         
c BEGIN PROCESSING 

c skip to start record

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c initialize trace and header array indices

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD
         dead_hdr_index = 1 - ITRWRD
         nlive = 0
         ndead = 0

c skip unwanted traces
         
         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

c load live data on which to base the interpolation to memory

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'sequential  rec= ',JJ
               write(LERR,*)'sequential  trace= ',KK
               go to 999
            endif

            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER )

c process only live traces and zero out dead traces unless the -dead is flagged
c in which case fill dead traces only

            if ( StaCor .ne. 30000 ) then

c advance data and header array indices for this trace

               tr_index = tr_index + nsamp
               hdr_index = hdr_index + ITRWRD
               call vmov( itr(ITHWP1), 1, Record_In(tr_index), 1, 
     :              nsamp )
               call vmov( itr, 1, Header_In(hdr_index), 1, ITRWRD )
               
               nlive = nlive + 1
               call saver2 ( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn,
     :              DstSgn, TRACEHEADER )
               Dist_In(nlive) = float(DstSgn)
               
            elseif ( StaCor .eq. 30000 .and. dead ) then

c keep buffer of dead traces to fill

               dead_hdr_index = dead_hdr_index + ITRWRD
               ndead = ndead+1

c keep trace of sequential output trace for dead trace entry

               DeadIndex(ndead) = KK
               call vmov( itr, 1, DeadHeader_In(dead_hdr_index), 1, 
     :              ITRWRD )
               
            endif

         ENDDO

c data now loaded to memory for this record

c POLICEMEN

         Policemen = .true.

         if (nlive .lt. 4) then

            if (Type .eq. 'spline') then

               Policemen = .false.

               call saver2(itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     1              irec, TRACEHEADER)
               write (LERR,*) 'For record ', irec
               write (LERR,*) 'Less than 4 live traces per record'
               write (LERR,*) 'No cubic spline interpolation done'
               write (LERR,*) 
            endif

            if ((nlive .lt. 2) .and. (Type .eq. 'linear')) then
               Policemen = .false.

               call saver2(itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     1              irec, TRACEHEADER)
               write (LERR,*) 'For record ', irec
               write (LERR,*) 'Less than 2 live traces per record'
               write (LERR,*) 'No linear interpolation done'
               write (LERR,*) 
            endif

         endif

c mirror a user defined number of trace on inside or outside or both 
c if requested by the user.  Default is to extrapolate using last inside
c or outside trace.

         if ( mirror ) 
     :        call MakeMirror ( nlive, ntrc_in, nsamp, Record_In, 
     :        Dist_In, DistBuffer, Header_In, ITRWRD, ifmt_DstSgn, 
     :        l_DstSgn, ln_DstSgn, num_mirror_inside, 
     :        num_mirror_outside, Xmax, Xzero )
         
c         if ( ray_parameter_scan )
c     :        call ScanRayParameters()

c         if ( nmo_scan ) 
c     :        call ScanNmoFunction()

         if ( distap .ne. ' ' ) then

            if ( StartDist(JJ-irs+1) .gt. EndDist(JJ-irs+1) ) then

               deltaX = ( float ( StartDist(JJ-irs+1) - 
     :              EndDist(JJ-irs+1) ) ) / float (ntrco )

               write(lerr,*)' rec ',JJ,' dx = ',deltaX

               do i = 1, ntrco
                  Dist_Out(i) = float (StartDist(JJ-irs+1)) + 
     :                 float(ntrco - i) * deltaX
               enddo
               decrement = .true.

            else

               deltaX = ( float ( EndDist(JJ-irs+1) - 
     :              StartDist(JJ-irs+1) ) ) / float (ntrco )

               write(lerr,*)' rec ',JJ,' dx = ',deltaX

               do i = 1, ntrco
                  Dist_Out(i) = float(StartDist(JJ-irs+1)) + 
     :                 float(i - 1) * deltaX
               enddo
               decrement = .false.

            endif

         endif

         IF ( .not. dead ) then

c do data interpolation

            call InterpData ( nlive, ntrco, nsamp, ist, iend, 
     :           Record_In, Record_Out, Dist_In, Dist_Out, DistBuffer, 
     :           Amp_In, Amp_Out, spline_IZ, spline_ZZ, Type ,LER)
            
c do header interpolation

            call InterpHeader ( nlive, ntrco, spline_IZ, spline_ZZ, 
     :           Type, num_mnemonics, HdrWrd, 
     :           ifmt_HdrWrd, l_HdrWrd, ln_HdrWrd, 
     :           ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           Header_In, Header_Out, 
     :           Dist_In, Dist_Out, DistBuffer, Amp_In, Amp_Out )


c OUTPUT record   complete with interpolated traces headers and
c watch out for decrementing requirement

            if ( .not. decrement ) then

c reset array load points for this trace 

               tr_index = 1 - nsamp
               hdr_index = 1 - ITRWRD

               DO KK = 1, ntrco

                  tr_index = tr_index + nsamp
                  hdr_index = hdr_index + ITRWRD

                  call vmov ( Record_Out(tr_index), 1, itr(ITHWP1), 1, 
     :                 nsamp )
                  call vmov ( Header_Out(hdr_index), 1, itr(1), 1, 
     :                 ITRWRD )
                  call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,  
     :                 JJ, TRACEHEADER )
                  call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,  
     :                 KK, TRACEHEADER )
                  call wrtape (luout, itr, obytes)
               ENDDO

            else

c reset array load points for this trace 

               tr_index = ntrco * nsamp + 1
               hdr_index = ntrco * ITRWRD + 1
               
               DO KK = ntrco, 1, -1
                  
                  tr_index = tr_index - nsamp
                  hdr_index = hdr_index - ITRWRD
                  
                  call vmov ( Record_Out(tr_index), 1, itr(ITHWP1), 1, 
     :                 nsamp )
                  call vmov ( Header_Out(hdr_index), 1, itr(1), 1, 
     :                 ITRWRD )
                  call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,  
     :                 JJ, TRACEHEADER )
                  TrcNum = ntrco - KK + 1
                  call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,  
     :                 TrcNum, TRACEHEADER )
                  call wrtape (luout, itr, obytes)
               ENDDO
            endif

         ELSE

c
c [-dead OPTION] - do dead trace fill only
c
            
            tr_index = 1 - nsamp
            hdr_index = 1 - ITRWRD
            dead_index = 1

            DO KK = ns,ne

               tr_index = tr_index + nsamp
               hdr_index = hdr_index + ITRWRD

               if ( DeadIndex(dead_index) .eq. KK ) then

                  if ( Policemen ) then

c fill in dead trace if policemen are satisfied [i.e. enough live traces to do
c a spline fit.

                     call saver2 
     :                    ( DeadHeader_In((dead_index -1)*ITRWRD + 1),
     :                    ifmt_DstSgn, l_DstSgn, ln_DstSgn, DeadDstSgn,
     :                    TRACEHEADER )
                     r_DeadDstSgn = float(DeadDstSgn)

                     call FillDead ( nlive, nsamp, ist, iend, Record_In, 
     :                    Dist_In, DistBuffer, Amp_In, Amp_Out(1), 
     :                    spline_IZ, spline_ZZ,
     :                    r_DeadDstSgn,Record_Out )

c mark dead trace live

                     call savew2 ( DeadHeader_In((dead_index-1)*ITRWRD
     :                    +1), ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :                    TRACEHEADER )
                     call vmov ( DeadHeader_In((dead_index-1)*ITRWRD +1)
     :                    , 1, itr, 1, ITRWRD )
                     call vmov ( Record_Out, 1, itr(ITHWP1), 1, 
     :                    nsamp )
                     call wrtape (luout, itr, obytes )
                     dead_index = dead_index + 1
                  else

c no fill possible using spline so just output a dead trace

                     call vmov ( DeadHeader_In((dead_index-1)*ITRWRD +1
     :                    ), 1, itr, 1, ITRWRD )
                     call vclr ( itr(ITHWP1), 1, nsamp )
                     call wrtape ( luout, itr, obytes )

                     dead_index = dead_index + 1
                  endif

               else

c echo this input trace to output

                  call vmov ( Record_In(tr_index), 1, itr(ITHWP1), 1, 
     :                 nsamp )
                  call vmov ( Header_In(hdr_index), 1,itr(1), 1, 
     :                 ITRWRD )
                  call wrtape ( luout, itr, obytes )
               
               endif

            ENDDO
            
         ENDIF
c skip to end of input record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO
         
c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'equaldx: Normal Termination'
      write(LER,*)'equaldx: Normal Termination'
      stop

 990  continue

      write(LERR,*)'Error opening limiting distance file'
      write(LERR,*) distap(1:length)
      write(LERR,*)'equaldx: ABNORMAL Termination'
      write(LER,*)'equaldx: Error opening limiting distance file'
      write(LER,*) distap(1:length)
      write(LER,*)'equaldx: ABNORMAL Termination'
      stop

 991  continue

      write(LERR,*)'Error reading limiting distance file'
      write(LERR,*) distap(1:length)
      write(LERR,*)'equaldx: ABNORMAL Termination'
      write(LER,*)'equaldx: Error reading limiting distance file'
      write(LER,*) distap(1:length)
      write(LER,*)'equaldx: ABNORMAL Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      close(ludist)
      write(LERR,*)'equaldx: ABNORMAL Termination'
      write(LER,*)'equaldx: ABNORMAL Termination'
      stop


      end
