/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <unistd.h>
#include <localsys.h>
#include <io_defs.h>
#include <cu_defs.h>
#include <size_defs.h>
#include <usp_headers.h>
#include <slice.h>

main(argc,argv)
int argc;
char **argv;
{
	int fdin,fdout;
	int i,j,k,record_num;
	int verbos;
	int first_slice,last_slice,increment,slice;
	long int skip_size,initial_skip_size,normal_skip_size,trace_size;
	float *input,*input_data;
	char *header;
	char *sample;
	long byte_count;
	char ntap[64],otap[64];
	char **trace;
	float **data;
	line_header old;
	void read_err(),write_err();
	void help();

	save_cmd_args(argc,argv);

	fprintf(stderr,"FDSLICE:\n");

	if (C_ARGIS("-?",&argc,argv) != 0) help();
	if (C_ARGIS("-h",&argc,argv) != 0) help();
	verbos = C_ARGIS("-V",&argc,argv);
	C_ARGSTR("-N",ntap,"","",&argc,argv);
	C_ARGSTR("-O",otap,"","",&argc,argv);

	if (strlen(ntap) != 0) {
	  if (verbos) fprintf(stderr,"input data set -  %s\n",ntap);
	  C_LBOPEN(&fdin,ntap,"r");
	  }
	else {
	  if (verbos) fprintf(stderr,"input data set -  stdin\n");
	  fdin = 0;
	  }

	if (strlen(otap) != 0) {
	  if (verbos) fprintf(stderr,"output data set -  %s\n",otap);
	  C_LBOPEN(&fdout,otap,"w");
	  }
	else {
	  if (verbos) fprintf(stderr,"output data set -  stdout\n");
	  fdout = 1;
	  }

	header = (char *) malloc(12000*sizeof(char));
	C_RTAPE(fdin,header,&byte_count);
	if (byte_count == 0) read_err();
/*	realloc(header,byte_count);	*/

	old.Number_of_Traces  = ((usp_line_header *) header)->NumTrc;
	old.Number_of_Records = ((usp_line_header *) header)->NumRec;
	old.Sample_Interval   = ((usp_line_header *) header)->SmpInt;
	old.Number_of_Samples = ((usp_line_header *) header)->NumSmp;
	old.Format 	      = ((usp_line_header *) header)->Format;

	if (verbos) {
	  fprintf(stderr,"\ninput:\n");
	  fprintf(stderr,"\t\tformat = %d\n",		old.Format);
	  fprintf(stderr,"\t\tno. of records = %d\n",	old.Number_of_Records);
	  fprintf(stderr,"\t\tno. of traces/record = %d\n", old.Number_of_Traces);
	  fprintf(stderr,"\t\tno. of samples = %d\n",	old.Number_of_Samples);
	  fprintf(stderr,"\t\tsample interval = %d\n",	old.Sample_Interval);
	  }

	((usp_line_header *) header)->Format = old.Format;
	((usp_line_header *) header)->NumSmp = old.Number_of_Traces;
	((usp_line_header *) header)->NumTrc = old.Number_of_Records;
	((usp_line_header *) header)->SmpInt = 1;

/*  look for sample parms first, then by time; if neither, use default */

	C_ARGI4("-ss",&first_slice,0,-1,&argc,argv);
	if (first_slice == -1) {
	  C_ARGI4("-s",&first_slice,0,0,&argc,argv);
	  first_slice = (first_slice / old.Sample_Interval) + 1;
	  }
	if (first_slice < 0) first_slice = 0;
	if (first_slice > old.Number_of_Samples)
		first_slice = old.Number_of_Samples;

	C_ARGI4("-es",&last_slice,old.Number_of_Samples,-1,&argc,argv);
	if (last_slice == -1) {
	  C_ARGI4("-e",&last_slice,-1,-1,&argc,argv);
	  if (last_slice == -1)
	    last_slice = old.Number_of_Samples;
	  else
	    last_slice = (last_slice / old.Sample_Interval) + 1;
	  }
	if (last_slice < 0) last_slice = 0;
	if (last_slice > old.Number_of_Samples)
		last_slice = old.Number_of_Samples;

	C_ARGI4("-is",&increment,1,-1,&argc,argv);
	if (increment == -1) {
	  C_ARGI4("-i",&increment,old.Sample_Interval,old.Sample_Interval,
		&argc,argv);
	  increment = (int) (increment / old.Sample_Interval);
	  }
	if (increment < 0) increment = 1;

	fprintf(stderr,"\nsampling:\n");
	fprintf(stderr,"\t\tfirst slice at sample # %d\n",first_slice);
	fprintf(stderr,"\t\tlast slice at sample # %d\n",last_slice);
	fprintf(stderr,"\t\tincrement = %d\n",	increment);

	if (increment != 0.)
	  ((usp_line_header *) header)->NumRec =
		(long) ((last_slice - first_slice) / increment) + 1;
	else {
	  if (first_slice != last_slice) {
	    fprintf(stderr,"ERROR: An increment of zero has been ");
	    fprintf(stderr,"specified although start\nand end slices differ;");
	    fprintf(stderr,"please correct and resubmit.\n");
	    exit(100);
	    }
	  ((usp_line_header *) header)->NumRec = 1;
	  increment = 1; /* this will ensure that we get out our loop! */
	  }

	if (verbos) {
	  fprintf(stderr,"\noutput:\n");
	  fprintf(stderr,"\t\tformat = %d\n",
			((usp_line_header *) header)->Format);
	  fprintf(stderr,"\t\tno. of records = %d\n",
			((usp_line_header *) header)->NumRec);
	  fprintf(stderr,"\t\tno. of traces/record = %d\n",
			((usp_line_header *) header)->NumTrc);
	  fprintf(stderr,"\t\tno. of samples = %d\n",
			((usp_line_header *) header)->NumSmp);
	  fprintf(stderr,"\t\tsample interval = %d\n",
			((usp_line_header *) header)->SmpInt);
	  }

	save_hlh(header,byte_count,&byte_count);

	C_WRTAPE(fdout,header,byte_count);
	if (byte_count == 0) write_err();

	input = (float *) malloc(SZTRHD+(old.Number_of_Samples*SZSMPD));
	input_data = (float *)((char *)input+SZTRHD);

/*	C_RTAPE(fdin,input,&byte_count);
	if (byte_count == 0) read_err(); */

	trace_size = SZTRHD + (((usp_line_header *)header)->NumSmp * SZSMPD);
	trace = (char **)
	    malloc(((usp_line_header *)header)->NumRec*sizeof(char *));

	data = (float **)
	    malloc(((usp_line_header *)header)->NumRec*sizeof(float *));

	for (i=0; i<((usp_line_header *)header)->NumRec; i++) {
		trace[i] = (char *) calloc( trace_size,sizeof(char));
		data[i] = (float *)(trace[i]+SZTRHD);
		}

	for (i=0; i<((usp_line_header *)header)->NumTrc; i++) {
	  for (j=0; j<((usp_line_header *)header)->NumSmp; j++) {
	    C_RTAPE(fdin,input,&byte_count);
	    if (byte_count == 0) read_err();
	    for (k = first_slice, record_num = 0;
		k <= last_slice; k += increment, record_num++) {
	      *(data[record_num]+j) = input_data[k-1];
	      }
	    }
	  for (j=0; j<((usp_line_header *)header)->NumRec; j++) {
	    ((usp_trace_header *)trace[j])->RecNum = j+1;
	    ((usp_trace_header *)trace[j])->TrcNum = i+1;
	    C_WRTAPE(fdout,trace[j],trace_size);
	    if (trace_size == 0) write_err();
	    }
	  }
	C_LBCLOS(fdin);
	C_LBCLOS(fdout);
	exit(0);
}
void read_err()
{
 	fprintf(stderr,
	  "ERROR: fdslice - error reading input data\n");
	exit(1);
}

void write_err()
{
 	fprintf(stderr,
	  "ERROR: fdslice - error writing output data\n");
	exit(1);
}
long get_full_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.fullword.value,source,SZDFWD);
	return(buffer.value);
}
long get_half_word(source)
char *source;
{
	buffer.value = 0;
	memcpy(buffer.halfword.value,source,SZDHWD);
	return(buffer.value);
}
void put_full_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.fullword.value,SZDFWD);
	return;
}
void put_half_word(source,value)
char *source;
long value;
{
	buffer.value = value;
	memcpy(source,buffer.halfword.value,SZDHWD);
	return;
}
void help()
{
	fprintf(stderr,"Purpose: generate data slice(s) from USP data set\n");
	fprintf(stderr,"Usage: fdslice [ -Nntap ] [ -Ootap ] ");
	fprintf(stderr,"[ -ss[start_sample] | -s[start_time] ]\n\t");
	fprintf(stderr,"[ -es[end_sample] | -e[end_time] ] ");
	fprintf(stderr,"[ -is[increment_in_samples] | \n\t");
	fprintf(stderr,"-i[increment_time] ] [ -V ] [ -? ]\n\n");
/*
	fprintf(stderr,"Usage: fdslice -N[ntap] -O[otap] -s[start_time]");
	fprintf(stderr,"\n\t\t -e[end_time] -i[time_increment] -V\n");
	fprintf(stderr,"       fdslice -N[ntap] -O[otap] -ss[begin_sample]");
	fprintf(stderr,"\n\t\t -es[end_sample] -is[increment_sample] -V\n\n");
*/
	fprintf(stderr,"Options:\n");
	fprintf(stderr,"  -s  starting time for slicing (default=0)\n");
	fprintf(stderr,"  -e  ending time for slicing ");
	fprintf(stderr,"(default=trace length)\n");
	fprintf(stderr,"  -i  time increment between slices ");
	fprintf(stderr,"(default=input sample interval)\n");
	fprintf(stderr,"  -ss  starting sample for slicing (default=0)\n");
	fprintf(stderr,"  -es  ending sample for slicing ");
	fprintf(stderr,"(default=trace length)\n");
	fprintf(stderr,"  -is  increment in samples between slices ");
	fprintf(stderr,"(default=1)\n");
	fprintf(stderr,"  -V  verbose mode\n");
	exit(0);
}
