C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c    FDTIM - Finite Difference Timing Driver
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <localsys.h>
#include <fidif.h>
 
c     external ufkill,dvkill,inkill
      integer * 2 itr ( SZLNHD )
      integer * 2 ihead ( 128, 1000 )
      integer * 4 lhed( 1500 )
      integer * 4 nsamp, nsi, ntrc, nrec, iform
      integer * 4 luin , luout, lbytes, nbytes, lbyout,lbyte
      integer * 4 irs,ire,ns,ne
#include <f77/pid.h>
      integer * 4 recnum, trcnum
      real    * 4 tri ( SZSMPM )
c-----------------------------------------------------------
c  dynamic memory allocation for big arrays
      real        zx, tx
      pointer     (wkadr1, zx(1))
      pointer     (wkadr2, tx(1))
c
c-----------------------------------------------------------
      character   ntap * 100, otap * 100, name*4
      logical     newalg, verbos, query, heap1, heap2
      integer     argis, nx ,nz
      integer errcd1,errcd2,abort1,abort2
 
      equivalence ( itr(129), tri (1) )
      equivalence ( itr(1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'FDTIM'/
      data abort1 / 0 /,abort2 / 0 /
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
      call gcmdln(ntap,otap,ns,ne,irs,ire,verbos,h,s0,zs,
     1            iapp,idmax,newalg)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape4  ( luin, itr, lbyte, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STORE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call hlhprt (itr, lbyte, name, 4, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
c--------------------------
c  note: these don't
c  have to be the same size
      item1 = ntrc * nsamp
      item2 = ntrc * nsamp
c  note also SZSMPD is the 
c  size of an item in bytes
c--------------------------
c - switch from machine-dependent to generic memory allocation
c - j.m.wade 8/20/92

      call galloc (wkadr1, item1*SZSMPD, errcd1, abort1)
      if (errcd1 .ne. 0.) heap1 = .false.
      call galloc (wkadr2, item2*SZSMPD, errcd2, abort2)
      if (errcd2 .ne. 0.) heap2 = .false.

      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item2*SZSMPD,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1*SZSMPD,'  bytes'
         write(LERR,*) item2*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbyte,lbyout)
      call wrtape ( luout, itr, lbyout                 )
c
c---------------------------------------------------
c
c     Make sure input parameters are within model limits
c
      if ( iapp .le. 0 ) iapp = ntrc
      if ( iapp .gt. ntrc ) iapp = ntrc
      if ( idmax .le. 0 ) idmax = nsamp
      if ( idmax .gt. nsamp ) idmax = nsamp
c
      if (( s0 .lt. 0.5) .or. ( int(s0) .gt. ntrc ) ) then
         write (lerr,*)
     1   'source x location not within model limits'
         stop
      endif
c
      if (( zs .lt. 0.5) .or. ( int(zs) .gt. idmax ) ) then
         write (lerr,*)
     1   'source z location not within model limits'
         stop
      endif
c
      ixbeg = int(s0 + 0.5) - iapp
      if ( ixbeg .lt. 1) ixbeg = 1
c
      ixend = int(s0 + 0.5) + iapp
      if ( ixend .gt. ntrc) ixend = ntrc
c
c---------------------------------------------------
c     output of all pertinent information before
c     processing begins
c-----
      call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,s0,zs,h,iapp,idmax)
c--------------------------------------------------
c  figure out design window times

      dt = float(nsi)/1000.

c--------------------------------------------------
c     only one record allowed
      jj = 1
c 
      do 1001 kk = 1, ntrc
          nbytes = 0
          call rtape( luin, itr, nbytes)
          if(nbytes .eq. 0) then
            write(LERR,*)'End of file on input:'
            write(LERR,*)'  rec= ',jj,'  trace= ',kk
            go to 999
          endif
c
c         put trace headers in storage array
          do 600 is = 1, 128
             ihead(is, kk) = itr(is)
600       continue
c
c         put velocity info in work array
          call rc ( tri, zx, nsamp, nsamp, ntrc, kk)
c
1001   continue
c
       izbeg = 1
       izend = idmax
       write (ler,*)
     1    'izbeg izend ixbeg ixend=', izbeg, izend, ixbeg, ixend
c
c      new fd timing code -- good to 135 degrees
c      if( newalg) then
c        call fd135 
c    1    (ntrc,nsamp,izbeg,izend,ixbeg,ixend,h,s0,zs,zx,tx)
c      else
         write (ler,*) 'right here'
         call fidif
     1    (ntrc,nsamp,izbeg-1,izend-1,ixbeg-1,ixend-1,
     2    h,s0-1.,zs-1.,zx,tx)
c      endif
c
            do 1002 kk = 1, ntrc
c              put trace header info into output array
               do 800 is = 1, 128
                  itr( is ) = ihead (is, kk)
800            continue
c              put output travel times in output array
               call wc ( tx, tri, nsamp, nsamp, ntrc, kk) 
c
               call wrtape( luout, itr, nbytes)
c              if(verbos) write(LER,*)'ri ',recnum,' trace ',trcnum 
1002        continue
c----------------------
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE STORE  --  WRITE STATICS TO HEADER'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program STORE writes a list of static values to the trace header'
      WRITE(LER,*)
     :'half words of an input data set. A constant time shift can'
      WRITE(LER,*)
     :'also be added to each header word. Statics can then be applied'
      WRITE(LER,*)
     :'with program REST. Static values are supplied to the program'
      WRITE(LER,*)
     :'through a flat file list with each line having 3 values,'
      WRITE(LER,*)
     :'an index (usually the group location, RecInd = halfword 118),'
      WRITE(LER,*)
     :'receiver static (ms), and source static (ms). Currently there'
      WRITE(LER,*)
     :'is no interpolation for static values not specified.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute STORE  by typing "store" followed by program parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output data file name'
        WRITE(LER,*)
     :' -S [sfile]     (no default) : statics file name '
        WRITE(LER,*) 
     :' -is [isb]      (8=InStUn)   : trace header half word to'
        WRITE(LER,*) 
     :'                               write initiation static value' 
        WRITE(LER,*) 
     :' -ir [isr]      (11=RcStUn)  : trace header half word to'
        WRITE(LER,*) 
     :'                               write reception static value' 
      WRITE(LER,*)
     :' -st [srcsft] (0)          : initiation static constant'
      WRITE(LER,*)
     :'                               time shift (ms)'
      WRITE(LER,*)
     :' -rt [recsft] (0)          : reception static constant'
      WRITE(LER,*)
     :'                               time shift (ms)'
      WRITE(LER,*)
     :' -V [verbos]  ( no )         : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' store -N/home/data/ntap -O/home/data/otap -Sstat.file'
        WRITE(LER,*) 
     :'       -is8 -ir11 -st20 -rt45                                '
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,verbos,h,s0,zs,
     1                  iapp,idmax,newalg)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer * 4 ns, ne, irs, ire
      real    * 4 h
      logical     verbos, newalg
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argr4 ( '-csize', h ,   1  ,  1    )
            call argr4 ( '-xloc', s0 ,   1.  ,  1.    )
            call argr4 ( '-zloc', zs ,   1.  ,  1.    )
            call argi4 ( '-app', iapp ,   0  ,  0    )
            call argi4 ( '-dmax', idmax ,   0  ,  0    )
            verbos = (argis('-V') .gt. 0)
            newalg = (argis('-fd135') .gt. 0)
c
      return
      end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,s0,zs,h,iapp,idmax)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      character ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
            write(LERR,*) ' source x location     =  ', s0
            write(LERR,*) ' source y location     =  ', zs
            write(LERR,*) ' cell width and length =  ', h
            write(LERR,*) ' apperature (cells)    =  ', iapp
            write(LERR,*) ' max depth (cells)     =  ', idmax
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
c****************************************************************
      subroutine rc ( x, y, n, nz, nx, kk) 
      real y (nx, nz), x(n)
c
c----------------------------------------------------------------    
c
c     packs a one dimensional array into a specific column
c     of a two dimensional array. The array is then transposed
c     for entry into a "C language" subroutine.
c
c----------------------------------------------------------------    
      do 10 i = 1, n
      y (kk, i) = x(i)
10    continue
      end
c
c****************************************************************
      subroutine wc ( x, y, n, nz, nx, kk) 
      real x (nx, nz), y(n)
c
c----------------------------------------------------------------    
c
c
c     unpacks a specific column from a two dimensional
c     array output from a c language subroutine. This
c     includes the transpose.
c
c----------------------------------------------------------------    
      do 10 i = 1, n
      y(i) = x(kk, i)
10    continue
      end
