C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      PROGRAM fft2da
c 
c Changes:
c         Sept, 97: fixed logic in rdgather to prevent killing traces
c                   with stacor > 30000.  Now looks specifically for
c                   traces where stacor=30000 or stacor=30001
c         Garossino
c
C
C**********************************************************************C
C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

      integer     hbegin
      integer     sheader(SZLNHD)

      integer     argis, ordfft
      integer     ns, ne, irs, ire

      character*256 ntap,otap     
      character*6 name
      character*2 domain
#include <f77/pid.h>
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      logical     verbos,query,revers,forward,smooth
      logical     eod                   
      logical     liverec               
 
      data name     /'FFT2DA'/                                 
c---------------------------------
c  get online help if necessary
c---------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
           stop
      endif

c------------------------------------
c  open printout file
c------------------------------------
#include <f77/open.h>

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE ARGUMENT STRING
C**********************************************************************C
      call cmdln (ntap,ist,iend,ns,ne,irs,ire,verbos,
     1            revers,otap,smooth)
      forward=.not. revers
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
c_______________________________________________________________________
c     forward transform
c_______________________________________________________________________
      call getln(luin,ntap,'r',0 )
      call getln(luout,otap,'w',1 )

      lbytes = 0
      call rtape(luin,sheader,lbyte)
      lbytes = lbyte
      if(lbytes .eq. 0) then
         write(lerr,*)'FFT2DA: no header read on unit ',ntap
         write(lerr,*)'FATAL'
         write(lerr,*)'Check existence of file & rerun'
         stop
      endif
      call hlhprt(sheader,lbyte,name,len(name),lerr)
c
c______________________________________________________________________
c     read off relevant arguments from line header
c______________________________________________________________________
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'NumTrc',ntrin,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader, 'UnitSc', unitsc, LINEHEADER)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(sheader, 'UnitSc', unitsc, LINEHEADER)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed
c______________________________________________________________________
c     ensure that command line values are compatible with data set
c______________________________________________________________________
      call cmdchk(ns,ne,irs,ire,ntrin,nrec)
c
c     check to see if samp int is in micro secs
c______________________________________________________________________
      dt = float(nsi) * unitsc
      if(ire .lt. 1) ire=nrec
      nrecwin=ire-irs+1 
      ist=ist/nsi
      iend=iend/nsi
      if(ns .lt. 1) ns=1
      if(ne .lt. 1) ne=ntrin
      ntrwin=ne-ns+1
      if(ist .le. 0) ist=1
c______________________________________________________________________
c     save headers:
c     store original number of traces  under keyword 'IndAdj'
c     store original number of samples under keyword 'OrNSMP'
c______________________________________________________________________
      call savew(sheader,'NumRec',nrecwin,LINEHEADER)
      if (revers) then
         ntfft = nsamp
         nxfft = ntrin
c         call saver(sheader,'OrNTRC',ntr,LINEHEADER)
c i have changed this to IndAdj to prevent  collision
c with rwindow
c Garossino - I am going to compile and release this on Friday July 8, 1994
         call saver(sheader,'IndAdj',ntr  ,LINEHEADER)
c Guto: changed from TmSlIn to OrNSMP to store orig # samps - 5/8/95
c       also see below savew
c        call saver(sheader,'TmSlIn',nsamp,LINEHEADER)
         call saver(sheader,'OrNSMP',nsamp,LINEHEADER)

         call savew(sheader,'NumTrc',ntr,LINEHEADER)
         call savew(sheader,'NumSmp',nsamp,LINEHEADER)
         domain='xt'
         call savew(sheader,'DgTrkS',domain,LINEHEADER)
         if(iend .lt. 1) iend=nsamp
         lenwin=iend-ist+1
         ntrout = ntr
         nsamporig = nsamp
      else
         nsamporig = nsamp
         if(iend .lt. 1) iend=nsamp
         lenwin=iend-ist+1
         nu = ordfft(lenwin)
         ntfft = 2 ** nu
         nu = ordfft(ntrwin)
         nxfft = 2 ** nu
         call savew( sheader,'NumRec',nrecwin,LINEHEADER)
c         call savew( sheader,'OrNTRC',ntrin,LINEHEADER)
c i have changed this to IndAdj to prevent  collision
c with rwindow
c Garossino
         call savew( sheader,'IndAdj',ntrin,LINEHEADER)
c        call savew( sheader,'TmSlIn',nsamp,LINEHEADER)
         call savew( sheader,'OrNSMP',nsamp,LINEHEADER)
         call savew( sheader,'NumSmp',ntfft,LINEHEADER)
         call savew( sheader,'NumTrc',nxfft,LINEHEADER)
         domain='fk'
         call savew(sheader,'DgTrkS',domain,LINEHEADER)
         ntrout = nxfft
      endif

      maxt=max(ntfft,iend,nsamp)
c______________________________________________________________________
c     verbos printout
c______________________________________________________________________
      write(lerr,*) 
      write(lerr,*) 'files'         
      write(lerr,*) 'ntap : ',ntap    
      write(lerr,*) 'otap : ',otap    
      write(lerr,*)
      write(lerr,*)' Values read from input data set line header'
      write(lerr,*)
      write(lerr,*) ' samples/trace      =  ', nsamp
      write(lerr,*) ' start sample       =  ', ist  
      write(lerr,*) ' end   sample       =  ', iend 
      write(lerr,*) ' samples in window  =  ', lenwin
      write(lerr,*) ' fft length in time =  ', ntfft 
      write(lerr,*) ' trace buffer length=  ', maxt  
      write(lerr,*)
      write(lerr,*) ' Sample Interval    =  ', nsi  
      write(lerr,*) ' Traces per Record  =  ', ntrin
      write(lerr,*) ' Traces in window   =  ', ntrwin
      write(lerr,*) ' fft length in space=  ', nxfft 
      write(lerr,*) ' Records per Line   =  ', nrec
      if(revers) then
         write(lerr,*) ' Output # traces    =  ', ntr
         write(lerr,*) ' start trace        =  ', ns     
         write(lerr,*) ' end   trace        =  ', ne     
         write(lerr,*) ' Output # samples   =  ', nsamp
      else
         write(lerr,*) ' Output # traces    =  ', nxfft
         write(lerr,*) ' Output # samples   =  ', ntfft
      endif
      write(lerr,*) ' Output records     =  ', nrecwin
      write(lerr,*) ' Reverse Transform? =  ', revers
      write(lerr,*) ' smooth early mutes ?         ',smooth
c______________________________________________________________________
c     adjust historical line header & write header
c______________________________________________________________________
      call savhlh(sheader,lbyte,lbyout )
      call wrtape(luout,sheader,lbyout)
c______________________________________________________________________
c     calculate memory requirements
c     keep data buffered out to fft sizes, even if we don't need them.
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenu =nxfft*(maxt+lenhed)
      lenwork=ntfft*nxfft       
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,lenu,lerr)
      call mapmem('uout',l_uout,l_free,lenu,lerr)
      call mapmem('xomega',l_xomega,l_free,lenwork,lerr)
      call mapmem('xomegatr',l_xomegatr,l_free,lenwork,lerr)
      call mapmem('live',l_live,l_free,nxfft,lerr)
      call mapmem('muteend',l_muteend,l_free,nxfft,lerr)
      call mapmem('mutesm',l_mutesm,l_free,nxfft,lerr)
c_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)
         write(lerr,*)'program FFT2DA aborted'
         stop 101
      endif
c_____________________________________________________________
c     calculate length of trace in integer*2 words.
c     calculate number of bytes in output trace
c     calculate trace header position of key variables.
c_____________________________________________________________
c     lentr2=lntrhd+maxt*i2fact
      lentr2=lenhed+maxt
      if(revers) then
         nbyptr=(nsamp+lenhed)*szsmpd
      else
         nbyptr=(ntfft+lenhed)*szsmpd
      endif
c     call savelu('StaCor',ifmt,l_stacor,length,TRACEHEADER)
c     call savelu('TrcNum',ifmt,l_trcnum,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_recnum,length,TRACEHEADER)
c     call savelu('MulSkw',ifmt,l_MulSkw,length,TRACEHEADER)
c
      if(revers) then
c________________________________________________________________
c        clear out all traces.
c        reverse transformed traces will overwrite the window 
c        window (ist:iend,ns:ne)
c________________________________________________________________
         call clrgather(s(l_uin),hbegin,maxt,ntrin)
      else
c________________________________________________________________
c        skip over records.  
c________________________________________________________________
         call recskp(1,irs-1,luin,ntrin,s(l_uin))    
      endif
      do 50000 irec=irs,ire
c________________________________________________________________
c      read in seismic gather.
c________________________________________________________________
       call rdgather(s(l_uin),s(l_uin),s(l_live),hbegin,maxt, 
     1               lentr2,ntrin,luin,lerr,eod,itr,irec,
     2               l_StaCor,l_RecNum,l_MulSkw,
     3               ifmt_StaCor,ifmt_RecNum,ifmt_MulSkw,
     4               ln_StaCor,ln_RecNum,ln_MulSkw,
     5               irecnum,forward,liverec,nsamporig)
       if(eod) then       
          write(lerr,*)'error!'  
          write(lerr,*)'read ',itr,' traces from record ',irec,
     1                 ' instead of ',ntrin  
          write(lerr,*)'file unit number = ',luin
          write(lerr,*)'file name = ',ntap   
          go to 99000
       endif
       if(verbos) write(lerr,*) 'process record ',irec,
     1                                ' liverec =',liverec

       if(forward) then
c________________________________________________________________
c         forward fft from (x,t) to (kx,omega)
c________________________________________________________________
          call xt2ap(s(l_uin),s(l_uout),s(l_xomega),
     1               s(l_xomegatr),hbegin,lenhed,lenwin,ntfft,
     2               ntrin,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)
       else
c________________________________________________________________
c         inverse fft from (kx,omega) to (x,t)
c________________________________________________________________
          call ap2xt(s(l_uin),s(l_uout),s(l_xomega),s(l_live),
     1               s(l_xomegatr),hbegin,lenhed,lenwin,ntfft,
     2               ntr,ntrwin,ns,ne,nxfft,ist,iend,maxt,liverec)
       endif 
c________________________________________________________________
c      update trace headers
c      output data
c________________________________________________________________
       if(.not. revers) then
          call hdupdat(s(l_uout),nxfft,irecnum,-nxfft/2,
     1                 l_recnum,l_trcnum,l_stacor,lentr2,
     2                 ifmt_RecNum,ifmt_TrcNum,ifmt_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_StaCor)     
          call wrgather(s(l_uout),s(l_uout),hbegin,maxt,
     1                  s(l_mutesm),s(l_muteend),forward,smooth,
     2                  ifmt_MulSkw,lentr2,nxfft,nbyptr,luout,ln_MulSkw,
     3                  l_MulSkw)
       else
          call hdupdat(s(l_uout),ntrwin,irecnum,1, 
     1                 l_recnum,l_trcnum,l_stacor,lentr2,
     2                 ifmt_RecNum,ifmt_TrcNum,ifmt_StaCor,
     3                 ln_RecNum,ln_TrcNum,ln_StaCor)     
          call wrgather(s(l_uout),s(l_uout),hbegin,maxt,
     1                  s(l_mutesm),s(l_muteend),forward,smooth,
     2                  ifmt_MulSkw,lentr2,ntr,nbyptr,luout,ln_MulSkw,
     3                  l_MulSkw)
       endif

50000 continue
99000 continue
c__________________________________________________________________
c     close files
c__________________________________________________________________
      call lbclos(luin)
      call lbclos(luout)
c
      write(lerr,*) 'normal completion of routine fft2da'
      write(LER ,*) 'normal completion of routine fft2da'
      stop
      end

c------------------------------
c  online help section
c------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for fft2da:  2-d fft'
        write(LER,*)' '
        write(LER,*)'-Delimeter[argument]........................(def)' 
        write(LER,*)' '
        write(LER,*)' '
        write(LER,*)'-N[ntap] -- input space/time (x,t) data set'
        write(LER,*)'-O[otap] -- output amplitude/phase (omega,kx)'
     1                         //' data set'
        write(ler,*)
        write(ler,*)' additional command line arguments:'           
        write(ler,*)
        write(LER,*)'-s[ist]    -- start time (ms)         (first samp)'
        write(LER,*)'-e[iend]   -- end time (ms)            (last samp)'
        write(LER,*)'-ns[ns]    -- start trace #                (first)'
        write(LER,*)'-ne[ne]    -- end trace #                   (last)'
        write(LER,*)'-rs[irs]   -- start record                 (first)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-re[ire]   -- end record                    (last)'
        write(LER,*)'-R         -- inverse transform flag     (.false.)'
        write(ler,*)'-S         -- smooth early mutes on inverse '
     1                           //'(.false.)'
        write(LER,*)'-V         -- verbose output'
        write(LER,*)'Usage:'
        write(LER,*)'        fft2da -N[]-O[] '
        write(ler,*)'               -s[] -e[] -ns[] -ne[]  '
        write(ler,*)'               -rs[] -re[] -[R,S,V]'
        write(LER,*)' '

      return
      end

      subroutine cmdln (ntap,ist,iend,ns,ne,irs,ire,verbos,
     1                  revers,otap,smooth)
#include <f77/iounit.h>
      character*(*) ntap,  otap
      integer    argis,ist,iend,irs,ire,ns,ne
      logical    verbos, revers,smooth

      call argstr('-N',ntap,' ',' ') 
      call argstr('-O',otap,' ',' ') 
      call argi4('-s',ist,1,1)
      call argi4('-e',iend,0,0)
      call argi4('-ns',ns,1,1)
      call argi4('-ne',ne,0,0)
      call argi4('-rs',irs,1,1)
      call argi4('-re',ire,0,0)
      revers=(argis('-R') .gt. 0)
      smooth=(argis('-S') .gt. 0)
      verbos=(argis('-V') .gt. 0)
c
      return
      end
