C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs high-resolution spectral analysis on 2-D data, instead of
c 2-D FFT based F-K transform
c writes the results to an output file
c
c Changes: 1/27/99 - fixed up a LOT of memory leaks.  Propagated
c                    dynamic management down through all subroutines.
c          Garossino 
c**********************************************************************c
c
c     declare variables
c
c-----
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----

c standard USP variables
 
      integer nsamp, nsi, ntrc, nrec, iform, obytes
      integer itr  ( 4*SZLNHD )

      real        tri  ( 4*SZLNHD )
 
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
 
c variables used in dynamic memory allocation

      integer abort, errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer errcd7, errcd8, itemi, item1, item2, itemt

      integer     itrhdr

      real        bigar1

      complex     bigar2, X, H, Z, cfour, XP

      pointer     (memadr_itrhdr, itrhdr(1) )
      pointer     (memadr_bigar1, bigar1(1) )
      pointer     (memadr_bigar2, bigar2(1) )
      pointer     (memadr_X, X(1) )
      pointer     (memadr_H, H(1) )
      pointer     (memadr_Z, Z(1) )
      pointer     (memadr_XP, XP(1) )
      pointer     (memadr_cfour, cfour(1) )

c program dependant static variables

      integer ordfft, argis, method, nu, nt, n2, nx, nrecc
      integer ic, istrc, ishdr, ip
      integer ifmt_StaCor, l_StaCor, ln_StaCor, StaCor
      integer ifmt_MulSkw, l_MulSkw, ln_MulSkw, MulSkw
      integer ifmt_RecNum, l_RecNum, ln_RecNum, RecNum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum

      complex     ctri ( 4 * SZLNHD )

      character   ntap * 256, otap * 256, name*5

      logical     verbos

 
c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'FFTAR'/
      data abort / 0 /
      data method / 1 /
 
c-----
c     read program parameters from command line card image file
c-----

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0)then
         call help()
         stop
      endif
 
c open printout files

#include <f77/open.h>
 
c parse command line

      call gcmdln ( ntap, otap, ns, ne, irs, ire, ip, verbos )
 
c open input and output datastreams
 
      call getln ( luin , ntap,'r', 0 )
      call getln ( luout, otap,'w', 1 )
 
c build pointers for trace header access
 
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('MulSkw',ifmt_MulSkw,l_MulSkw,ln_MulSkw,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

c read input line header

      call rtape  ( luin, itr, lbytes )
      if ( lbytes .eq. 0 ) then
         length = lenth(ntap)
         if (length .gt. 0) then
           write(LERR,*)'FFTAR: no header read on input ',ntap(1:length)
         else
           write(LERR,*)'FFTAR: no header read on input pipe'
         endif
         write(LERR,*)'FATAL'
         write(LER,*)' '
         if (length .gt. 0) then
           write(LER,*)'FFTAR: no header read on input ',ntap(1:length)
         else
           write(LER,*)'FFTAR: no header read on input pipe'
         endif
         write(LER,*)'FATAL'
         stop
      endif

c save global line header parameters

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
      call hlhprt (itr, lbytes, name, 5, LERR)
 
c check line header against command line request

      call cmdchk( ns, ne, irs, ire, ntrc, nrec )
 
c determine fft parameterization
 
      nu = ordfft (nsamp) + 1
      nt = 2 ** nu
      n2 = 2 * nt

      if ( method .eq. 1 )  then

c for now method is hardwired to be 1

         nu = ordfft (ntrc) + 1
         nx = 2 ** nu
      else
         nx = ntrc
      endif

      itemi = max0 ( ntrc, nx )
      itemi = itemi * ITRWRD

      item1 = nx * n2

      item2 = nx * nt  * 2

      itemt = ntrc * 2
 
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
 
      call galloc (memadr_itrhdr , itemi * SZSMPD, errcd1, abort )
      call galloc (memadr_bigar1 , item1 * SZSMPD, errcd2, abort )
      call galloc (memadr_bigar2 , item2 * SZSMPD, errcd3, abort )
      call galloc (memadr_X    , itemt * SZSMPD, errcd4, abort )
      call galloc (memadr_H    , itemt * SZSMPD, errcd5, abort )
      call galloc (memadr_Z    , itemt * SZSMPD, errcd6, abort )
      call galloc (memadr_XP   , itemt * SZSMPD, errcd7, abort )
      call galloc (memadr_cfour, itemt * SZSMPD, errcd8, abort )
 
      if ( errcd1 .ne. 0 .or. 
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)  5 * itemt,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LER,*)  5 * itemt,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)  5 * itemt,'  bytes'
         write(LERR,*)' '
      endif

c modify line header to reflect actual number of traces output

      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', nx   , LINHED)

      call savew(itr, 'OrNSMP',nsamp, LINHED)
c      call savew(itr, 'NumSmp', n2  , LINHED)
      call savew(itr, 'NumSmp', nt  , LINHED)
 
c number output bytes
      
c      obytes = SZTRHD + n2 * SZSMPD
      obytes = SZTRHD + nt * SZSMPD

c update HLH
 
      call savhlh(itr,lbytes,lbyout)

c write output line header
 
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----

      if ( ip .eq. 0 ) then
         ip = ntrc / 2 - 1
         write(LERR,*)'WARNING:'
         write(LERR,*)'Default prony order will be set to ',ip
      endif

      call verbal( nsamp, nsi, ntrc, nrec, iform, ip, ntap, otap )
 
c skip down to start record

      call recskp( 1, irs-1, luin, ntrc, itr )
 
      DO JJ = irs, ire
 
c skip to start trace
       
         call trcskp(JJ,1,ns-1,luin,ntrc,itr)

         ic = 0

         DO kk = ns, ne
 
            nbytes = 0

c read trace

            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature end of file on input:'
               write(LERR,*)'rec= ',JJ,'  trace= ',kk
               go to 999
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           stacor , TRACEHEADER)
            if ( kk .eq. ns ) call saver2(itr,ifmt_RecNum,l_RecNum, 
     :           ln_RecNum, RecNum , TRACEHEADER)
 
c dead trace treatment

            if ( StaCor .eq. 30000 ) then
               call vclr ( tri, 1, nsamp )
            else
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
            endif
            
c  Load input data and header arrays

            ic = ic + 1
            istrc = (ic-1) * n2
            ishdr = (ic-1) * ITRWRD

            if ( StaCor .ge. 30000 ) then

               call savew2(itr,ifmt_StaCor,l_StaCor,
     1              ln_StaCor, 30001  , TRACEHEADER)
               call detmut (tri, MulSkw, nsamp)
               call savew2(itr,ifmt_MulSkw,l_MulSkw,
     1              ln_MulSkw, MulSkw  , TRACEHEADER)
            endif

            call vmov ( tri, 1, bigar1(istrc+1), 1, nsamp )
            call vmov ( itr, 1, itrhdr(ishdr+1), 1, ITRWRD )
            
         ENDDO
 
c calculate fftar spectra
 
         call subs (ntrc, ip, nt, n2, nsamp, bigar1, bigar2, tri, ctri, 
     :        X, XP, H, Z, cfour, nx, method )
 
C write out fftar spectra
 
         DO kk = 1, nx
 
            istrc = (kk-1) * n2
            ishdr = (kk-1) * ITRWRD

            call vmov ( bigar1(istrc+1), 1, itr(ITHWP1), 1, nt )
            call vmov ( itrhdr(ishdr+1), 1, itr, 1, ITRWRD )
            call savew2 ( itr,ifmt_RecNum,l_RecNum, ln_RecNum, RecNum, 
     :           TRACEHEADER)
            call savew2 ( itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum, kk, 
     :           TRACEHEADER)
            call wrtape ( luout, itr, obytes )
 
         ENDDO
 
c  skip to end of record

         call trcskp( JJ, ne+1, ntrc, luin, ntrc, itr )
 
      ENDDO
 

c normal Termination

      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'fftar: Normal Termination'
      write(LER,*)'fftar: Normal Termination'
      stop      

 999  continue

c Abnormal Termination
 
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'fftar: Abnormal Termination'
      write(LERR,*)'       processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'fftar: Abnormal Termination'
      write(LER,*)'       processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      

      end
 
c -----
c Subroutines
c -----

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)         : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)         : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -ne[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -ip[ip]      (default = ntrc/2-1) :  prony (AR) order'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   fftar -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] -ip[ip]  [-R -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
      subroutine gcmdln ( ntap, otap, ns, ne, irs, ire, ip, verbos )
c-----
c     get command arguments
c
c     ntap  - C*256    input file name
c     otap  - C*256    output file name
c     ip    - R*4      order of prony method
c                                                   =2-->Prony)
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire
      integer     ip
      logical     verbos
      integer     argis
 
            call argi4 ( '-ip', ip, 0, 0)

            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argstr( '-N', ntap, ' ', ' ' )

            call argstr( '-O', otap, ' ', ' ' )

            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )

            verbos =   (argis('-V') .gt. 0)
 
      return
      end
 
      subroutine verbal( nsamp, nsi, ntrc, nrec, iform, ip, ntap, otap )

c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec, ip
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
             write(LERR,*) ' prony order        =  ', ip
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
