C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE fftpack
C
C**********************************************************************C
C
C fftpack READS SEISMIC TRACE DATA FROM AN INPUT FILE and 
C does a forward or inverse 1D FFT
C
C Written by D. A. Yanchak
c Ported by P.G.A. Garossino [Feb, 1994]
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <localsys.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

      integer itr( SZLNHD )
      integer luin, luout, nbytes, irs, ire, ns, ne
      integer nsamp, nsampo, nsi, ntrc, ntrco, nrec, nreco, iform
      integer argis, obytes, lbytes

      character   name * 7, ntap * 256, otap * 256

      logical verbos, query, remove

c declare variables for dynamic memory allocation

      integer abort, errcd1, itemSpace

      real work

      pointer (wkadr1, work(200000))

c program independant variables

      integer NextPowerOfTwo, ordfft

c initialize variables 

      data  nbytes / 0 /
      data  lbytes / 0 /
      data  abort / 0 /
      data remove /.false./
      data  name/'FFTPACK'/

C get help if necessary

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

C read command line parameters

      call cmdln ( ntap, otap, irs, ire, ns, ne, remove, verbos )

c open input/output files

      call getln ( luin, ntap, 'r', 0)
      call getln ( luout, otap, 'w', 1)

c preprocess input data and setup output lineheader

      lbytes=0
      call rtape  ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'FFTPACK: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence/permissions of file & rerun'
         stop
      endif

      if ( remove ) then
         call saver(itr, 'OrNSMP', nsamp, LINHED)
      else
         call saver(itr, 'NumSmp', nsamp, LINHED)
      endif

      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c handle data selection defaults 

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1
      
      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 ) ne = ntrc
      ntrco = ne - ns + 1

c  find power of 2

      NextPowerOfTwo = ordfft(nsamp)
      nsampo = 2 ** NextPowerOfTwo

      if(nsampo .gt. 8192) then
         write(LERR,*) 'FFTPACK: Trace length too long to transform'
         write(LERR,*) '         Be sure next power of 2 is less than'
         write(LERR,*) '         8192 or contact the USP guys at APR'
         write(LERR,*) '         for a program change'
         write(LERR,*) 'Fatal'  
         write(LERR,*) ' '
      
         write(LER,*) 'FFTPACK: Trace length too long to transform'
         write(LER,*) '         Be sure next power of 2 is less than'
         write(LER,*) '         8192 or contact the USP guys at APR'
         write(LER,*) '         for a program change'
         write(LER,*) 'Fatal'        
         write(LER,*) ' '
         stop
      endif

c dynamic memory allocation

      itemSpace = nsampo * SZSMPD

      call galloc (wkadr1, itemSpace, errcd1, abort)

      if ( errcd1 .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemSpace,' bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemSpace,' bytes'
         write(LERR,*)' '
      endif

c  modify header as needed

      call hlhprt ( itr , lbytes, name, 7, LERR )
  
      call savew( itr, 'NumTrc', ntrco, LINHED)
      call savew( itr, 'NumRec', nreco, LINHED)

      if ( .not. remove ) then
c the following is done so that vfilt3d can use the OrNTRC entry to
c know how many frequency slices were in the original dataset when
c vfilt3d is running inside IKP

         call savew( itr, 'OrNTRC', nsampo, LINHED)
         call savew( itr, 'NumSmp', nsampo, LINHED)

c put original number of samples/trace into OrNSMP so that when
c using fftpack -R the data will be restored with the original
c nsamp

         call savew( itr, 'OrNSMP', nsamp, LINHED)

      else
         call savew( itr, 'OrNTRC', 0, LINHED)
         call savew( itr, 'OrNSMP', 0, LINHED)
         call savew( itr, 'NumSmp', nsamp, LINHED)
      endif      

c add the command line to the HLH

      call savhlh(itr, lbytes, lbyout)

C write out modified line header

      call wrtape ( luout, itr, lbyout )

c calculate number of output bytes

      if (remove) then
         obytes = SZTRHD + SZSMPD * nsamp
      else
         obytes = SZTRHD + SZSMPD * nsampo
      endif

c verbose output

      call verbal(ntap, nsamp, nsi, ntrc, nrec, iform, otap, nsampo, 
     :     ntrco, nreco, remove)

C input data and do fft

      DO jj = irs, ire

         do kk = ns, ne

c initialize workspace

            call vclr( work, 1, nsampo )

            nbytes = 0
            call rtape(luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

c if reverse fft then read in power of 2 stuff otherwise read
c in just the data

            if ( remove ) then
               call vmov ( itr(ITHWP1), 1, work, 1, nsampo )
            else
               call vmov ( itr(ITHWP1), 1, work, 1, nsamp )
            endif

c do forward or reverse fft 

            if ( .not. remove) then

               call rfft(work,nsampo,1)
c scale appropriately on forward transform 
               call rfftsc ( work, nsampo, 0, 1 )

c load and output transformed trace

               call vmov(work, 1, itr(ITHWP1), 1, nsampo )
               call wrtape ( luout, itr, obytes )

            else

               call rfft(work,nsampo,-1)

c load and output reverse transformed trace

               call vmov(work, 1, itr(ITHWP1), 1, nsamp )
               call wrtape ( luout, itr, obytes )

            endif

         enddo

      ENDDO

c close all attached files and terminate normally

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' Normal Termination'
      write(LER,*)'FFTPACK: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)' Abnormal Termination'
      write(LER,*)'FFTPACK: Abnormal Termination'

      stop
      end

c online help screen

      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'Run this program by typing: fftpack and the following arguments'
         write(LER,*)
     :' -N [ntap]    (stdin)              : Input data file name '
        write(LER,*)
     :' -O [otap]    (stdout)             : Output data file name'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start record number'
        write(LER,*)
     :' -re[ire]     (default = last)     : end record number'
        write(LER,*)
     :' -ns[ns]      (default = first)    : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)     : end trace number'
        write(LER,*)
     :' -R                                : apply inverse FFT'
        write(LER,*)
     :' -V verbose printout'
       write(LER,*)
     :'Usage: '
       write(LER,*)
     :' fftpack -N[ntap] -O[otap]  -rs[] -re[] -ns[] -ne[] [-R -V]'
       write(LER,*)
     :'***************************************************************'

      return
      end

C**********************************************************************C
C     get command line parameters
C**********************************************************************C
      subroutine cmdln ( ntap, otap, irs, ire, ns, ne, remove, verbose )

      integer     irs, ire, ns, ne, argis

      character   ntap*(*), otap*(*)

      logical     verbos, remove

      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argstr ( '-N', ntap, ' ', ' ' )
      call argstr ( '-O', otap, ' ', ' ' )
      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )
      remove = ( argis ('-R') .gt. 0 )
      verbos = ( argis ('-V') .gt. 0 )

      return
      end

c verbal subroutine

      subroutine verbal ( ntap, nsamp, nsi, ntrc, nrec, iform, otap,  
     :     nsampo, ntrco, nreco, remove) 

#include <f77/iounit.h>
      integer nsamp, nsi, ntrc, nrec, iform, nsampo, ntrco, nreco
      integer lentap, leotap

      character ntap*(*), otap*(*)

      logical remove

      write(LERR,*)' '
      write(LERR,*)' Input Data Parameters'
      write(LERR,*)' '
      lentap = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name =  ', ntap(1:lentap)
      else
        write(LERR,*) ' input data set      =  stdin'
      endif
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrc
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform
      write(LERR,*)' '
      write(LERR,*)' Output Data Parameters'
      leotap = lenth(otap)
      write(LERR,*)' '
      if (leotap .gt. 0) then
        write(LERR,*) ' output data set name=  ', otap(1:leotap)
      else
        write(LERR,*) ' output data set     =  stdout'
      endif
      write(LERR,*)' '
      write(LERR,*) ' # of samples/trace =  ', nsampo
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  ', ntrco
      write(LERR,*) ' records per line   =  ', nreco

      if ( .not. remove) then
         write(LERR,*)' '
         write(LERR,*)' Performing Forward FFT '
      else
         write(LERR,*)' '
         write(LERR,*)' Performing Inverse FFT '
      endif

      write(LERR,*)' '

      return
      end
     
