C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fft2ree (rdata,nsamp,ntrc,nt,ntt,nx,
     1                    lenitabt,lenrtabt,rtabt,rtabx,itabt,
     2                    itabx,ipwrt,ipwrx,cdata,initt,initx,
     3                    lenitabx,lenrtabx)

c  routine to do 2-d fft

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c     revers  -  reverse transform

c output

c      cdata  -  matrix of complex transformed values
#include <f77/iounit.h>
#include <f77/lhdrsz.h>


      	integer	 nt, nx, nsamp, ntrc, ntt

      	real 	 rdata(ntt, nx)
        complex  cdata(nt , nx)
        real     rtabt (lenrtabt), rtabx (lenrtabx)
        integer  itabt (lenitabt), itabx (lenitabx)
        integer  ipwrt (4), ipwrx (4)
        complex  workc(2*SZLNHD)


        ntmid = nt / 2
        nxmid = nx / 2

c------------
c       .. unpack amp & phase into real & imag

       DO  kx = 1, nx
          
          if (kx .gt. nxmid) then
             kxout = kx - nxmid
          else

c if nx/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nx and reacts accordingly.

             if ( mod(nx,2) .gt. 0 ) then
                kxout = nxmid + kx + 1
             else
                kxout = nxmid + kx
             endif
          endif
          ix = kxout

          DO  kt = 1, nt

c if nt/2 is non-integer the mapping needs to change slightly.  The following
c checks the modulus 2 of nt and reacts accordingly.

             if (kt .gt. ntmid) then
                if ( mod(nt,2) .gt. 0 ) then
                   ktout = kt - ntmid - 1
                else
                   ktout = kt - ntmid
                endif                     
             else
                ktout = ntmid + kt
             endif
             
             if ( mod(nt,2) .gt. 0 ) then
                iamp   = nt  - ktout
                iphase = ntt - ktout 
             else
                iamp   = nt  - ktout + 1
                iphase = ntt - ktout + 1
             endif
             
             cdata(kt,kx) =  rdata(iamp  , ix)    *
     1            cexp ( cmplx(0.,rdata(iphase, ix)) )
          ENDDO
       ENDDO

       do  i = 1, nt
          workc (i) = cmplx (0.0, 0.0)
       enddo

c------------
c  	.. Fourier transform:  (ky,kx) --> (y,x)

       DO  i = 1, nt

          do  j = 1, nx
             workc(j) = cdata(i,j)
          enddo

c----
c   power of 2 Math Adv call used on old version of fftxy
c              call cfft   (workc, nx, -1)
c----
c   equivalent
c   mixed radix call
c   in dimension X
c   (init must = 1 first time through to build sine & cos tables)
c----
          call cfftm  (workc, 2, nx, -1, initx, itabx, rtabx, ierr)
          initx = 0

          do  j = 1, nx
             cdata (i, j) = workc (j)
          enddo
       ENDDO

       DO j = 1, ntrc

          do i = 1, nt
             workc(i) = cdata(i,j)
          enddo

c----
c   power of 2 Math Adv calls
c              call cfft   (workc, nt, -1)
c----
c   equivalent
c   mixed radix call
c   in dimension T
c   (init must = 1 first time through to build sine & cos tables)
c----
          call cfftm  (workc, 2, nt, -1, initt, itabt, rtabt, ierr)
          initt = 0
          
          do  i = 1, nsamp
             rdata (i,j) = real (workc(i))
          enddo
       ENDDO

      return
      end
