C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE FILT
C
C**********************************************************************C
C
C FILT READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C APPLIES A USER-SPECIFIED BUTTERWORTH FILTER, AND
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE, butt, filco
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include     <save_defs.h>
#include     <f77/iounit.h>
#include     <f77/lhdrsz.h>
#include     <f77/sisdef.h>

      INTEGER     ITR ( 2 * SZLNHD)
      INTEGER     LHED( 2 * SZLNHD), LUIN, LUOUT, NBYTES, LBYTES
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM, msamp,deci,obytes
      REAL        Fl, Fh, SAMP, coefs(2,64), wrk1(3), wrk2(384)
      REAL        TRI  ( 2 * SZLNHD ), phz ( 2 * SZLNHD )
      REAL        phi  ( 2 * SZLNHD ), G ( 2 * SZLNHD )
      REAL        fwt  ( 2 * SZLNHD ), amp ( 2 * SZLNHD )
      REAL        work ( 2 * SZLNHD ), sf  ( 2 * SZLNHD )
      CHARACTER   NAME * 4
      character   ntap * 512, otap * 512
#include     <f77/pid.h>
      logical     verbos,zerop,mute,orms,bias,butt,bess,conv
      real        tmul
      integer     argis, imtop, imbottom, init, lfmax
 
      EQUIVALENCE ( ITR(  1), LHED(1) )
      data name/'FILT'/
      data lfmax/501/
      DATA     NBYTES , LBYTES  /
     :           0    ,   0     /

c-------------------------------------
c  get online help if necessary
      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
         call help()
         stop
      endif
c-------------------------------------

c-------------------------------
c  open printout file
#include  <f77/open.h>
c-------------------------------

C**********************************************************************C
C     READ PROGRAM PARAMETERS FROM COMMAND LINE
C**********************************************************************C
      call cmdln (ntap,otap,tmul,fl,fh,ns,ne,orms,fll,flh,fhl,fhh,
     &                irs,ire,norder,deci,zerop,verbos,mute,bias,
     &                bess,butt,aint,ex,lsf,pow,conv,db,band,wt,prew)

C**********************************************************************C
C     ABORT IF ANY UNUSED ARGUMENTS WERE PRESENT
C**********************************************************************C
      call xtrarg(name,ler,.FALSE.,.FALSE.)
      call xtrarg(name,lerr,.FALSE.,.TRUE.)

C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln ( luin, ntap, 'r', 0 )
      call getln (luout, otap, 'w', 1 )

      lbytes = 0
      CALL RTAPE ( LUIN, ITR, LBYTES )
      if(lbytes .eq. 0) then
         write(LERR,*)'FILT: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      CALL HLHprt( ITR , LBYTES, NAME, 4, LERR)

#include  <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

      msamp = nsamp

      samp = real (nsi) * unitsc
      if(deci .ne. 1) then
        if(fh .gt. 5./(samp*deci)) fh = 4.5/(samp*deci)
      endif
c
c - possible loss of samples from trace end - j.m.w. - 12/15/94
c
c     msamp = nsamp/deci
      msamp = (nsamp+deci-1)/deci

      SAMP = SAMP * tmul
      dt   = SAMP

c------------------------------
c  check defaults
      call cmdchk (ns,ne,irs,ire,ntrc,nrec)
c------------------------------
       nrecc = ire - irs + 1
       jtr   = ne - ns + 1
       obytes = SZTRHD + SZSMPD * msamp

c---------------------------------------------------
c  adjust line header & write header
       call savew( itr, 'NumTrc', jtr    , LINHED)
       call savew( itr, 'NumRec', nrecc  , LINHED)
       call savew( itr, 'NumSmp', msamp  , LINHED)
       call savew( itr, 'SmpInt',nsi*deci, LINHED)

       call savhlh ( itr, lbytes, lbyout )
       CALL WRTAPE ( LUOUT, ITR, LBYOUT )
c---------------------------------------------------

c----------------------------
c   printout
       write(LERR,*) ' Values read from command line '
       write(LERR,*) 'Input data set =  ',ntap
       write(LERR,*) 'Output data set = ',otap
       if (orms) then
       write(LERR,*) ' F1 =  ', fll, '  Hz.'
       write(LERR,*) ' F2 =  ', flh, '  Hz.'
       write(LERR,*) ' F3 =  ', fhl, '  Hz.'
       write(LERR,*) ' F4 =  ', fhh, '  Hz.'
       write(LERR,*) ' Filter exponent = ', pow
       if (conv) then
       write(LERR,*) ' Convolutional filter used'
       if (.not.zerop) then
       write(LERR,*) ' Minimum delay filter used'
       write(LERR,*) ' Prewitening     =  ',prew,' (%)'
       endif
       else
       write(LERR,*) ' Frequency domain used'
       endif
       elseif (butt) then
       write(LERR,*) ' FL =  ', fl, '  Hz.'
       write(LERR,*) ' FH =  ', fh, '  Hz.'
       write(LERR,*) ' BWF order = ', norder
       if (zerop)
     1 write(LERR,*) ' Causal filter used'
       elseif (bess) then
       write(LERR,*) ' Bessel intercept=  ',aint
       write(LERR,*) ' Filter length   =  ',lsf
       write(LERR,*) ' Ross weight     =  ',ex
       elseif (bias) then
       write(LERR,*) ' Remove DC bias only from data'
       endif
       write(LERR,*) ' tmul = ',tmul
       write(LERR,*) ' Decimation = ',deci
       write(LERR,*) ' Output samples = ',msamp
       write(LERR,*) ' Traces per record = ',ntrc
       write(LERR,*) ' Records per line =',nrec
       write(LERR,*)' '
       write(LERR,*) 'Values read from input data set line header'
       write(LERR,*) ' # of Samples/Trace =  ', nsamp
       write(LERR,*) ' Sample Interval    =  ', nsi,' (input)'
       write(LERR,*) ' Traces per Record  =  ', ntrc
       write(LERR,*) ' Records per Line   =  ', nrec
       write(LERR,*) ' Format of Data     =  ', iform
       write(LERR,*) ' Unit Scale of Data =  ', unitsc
       write(LERR,*) ' Do not restore early mute =  ', mute

       prew = prew / 100

c-----------------------------------
c  skip to start record
      call recskp(1,irs-1,luin,ntrc,itr)
c-----------------------------------

C**********************************************************************C
C
C     COMPUTE DESIRED FILTER
C
C**********************************************************************C

      if (orms) then

         call fweight (nsamp, nt, nf, dt, df, fll, flh, fhl,
     1                 fhh, fwt, work, tri, phi, G, zerop, verbos,
     2                 samp,LG,conv,db,band,wt,lfmax,lag,prew)

      elseif (butt) then

         call bwcoef ( fl, fh, dt, coefs, xnorm, norder, ift)

      elseif (bess) then

         call vnwt(ex, aint, lsf, sf)
         write(LERR,*)'Filter Weights are'
         write(LERR,111) (sf(i),i=1,lsf)
111      format(5e12.4)
         lag = lsf/2 + 1

      endif

C**********************************************************************C
C
C     READ TRACE, FILTER, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      DO 5001 JJ = IRS, IRE

c-------------------------------------------------
c  skip to start trace of this record
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c-------------------------------------------------

           DO 5002 KK = NS, NE

               nbytes = 0
               CALL RTAPE  ( LUIN, ITR, NBYTES           )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',jj,'  trace= ',kk
                  go to 999
               endif

               call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
               call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istatic, TRACEHEADER)
               call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                     irec   , TRACEHEADER)

               IF(istatic .ne. 30000) THEN

c detect mute zones top and bottom ala angle stack data unless not wanted

                  if (.not. mute) then
                     call bd_detmut ( tri, imtop, nsamp,0)
                     call bd_detmut ( tri, imbottom, nsamp,1)
c
c - possible loss of samples from trace end - j.m.w. - 12/15/94
c
c                    imtop = imtop / deci
c                    imbottom = imbottom / deci
                     imtop = (imtop+deci-1) / deci
                     imbottom = (imbottom+deci-1) / deci
                  endif

                  if (orms .AND. conv) then

                      call fold (LG, G, nsamp, tri, LY, work)
                      do  ii = 1, nsamp
                          tri (ii) = dt * work (ii+lag)
                      enddo

                  elseif (orms .AND. .not.conv) then

                      call trapf (nsamp, nt, nf, dt, df, tri, fwt,
     1                            work, amp, phz, phi, zerop, pow)

                  elseif (butt) then
                     
c set initialization of bworth filter on for each trace.  This is required
c for pathological datasets like mud weights and interval velocity and doesn't
c hurt regular seismic data - pgg

                     init = 1

                     call bwfilt ( tri, amp, wrk1, wrk2, coefs,
     1                            xnorm, norder, nsamp, init, 0)

                     init = 0
                     if(zerop)then
                        call vrvrs (amp,  1, nsamp)
                        call bwfilt ( amp, tri, wrk1, wrk2, coefs,
     1                       xnorm, norder, nsamp, init, 0)
                        call vrvrs (tri,  1, nsamp)
                     else
                        call vmov  (amp(1), 1, tri, 1, nsamp)
                     endif

c apply bessel filter

                  elseif (bess) then

                     call fold (lsf, sf, nsamp, tri, nfold, work)
                     call vmov (work(lag), 1, tri, 1, nsamp)

c remove DC bias only

                  elseif (bias) then

                     sum = 0.
                     do  i = 1, nsamp
                         sum = sum + tri (i)
                     enddo
                     sum = sum / float (nsamp)
                     do  i = 1, nsamp
                         tri (i) = tri (i) - sum
                     enddo

                  endif

                  call decim(tri, nsamp, deci)

c reapply mute zones top and bottom unless otherwise requested

                  if (.not. mute)then
                     call bd_resmut (tri, imtop, msamp, 0)
                     call bd_resmut (tri, imbottom, msamp, 1)
                  endif

               ENDIF

               call vmov (tri, 1, lhed(ITHWP1), 1, nsamp)
               CALL WRTAPE ( LUOUT, ITR, OBYTES          )
 5002      CONTINUE

c-------------------------------------------------
c  skip to end trace of this record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c-------------------------------------------------
           if( verbos ) write(LERR,*)'Filtered record ',irec

 5001 CONTINUE

  999 continue
      call lbclos ( luin )
      call lbclos ( luout)
      END
c---------------------
c-----
      subroutine decim(x,n,ndec)
      real      x(*)
      integer   n,ndec
c-----
c      decimate original time series
c      outputing only each ndec'th point
c-----
      j=0
      do 100  i = 1, n, ndec
             j=j+1
             x (j) = x (i)
100   continue

      return
      end

c---------------------------------
c  online help section
c---------------------------------
      subroutine  help
#include  <f77/iounit.h>

      write(LER,*)
     :'**************************************************************'
      write(LER,*)
     :'Run this program by typing filt and the following arguments'
      write(LER,*)
     :' -N[ntap]     (default stdin)         : Input data file'
      write(LER,*)
     :' -O[otap]     (default stdout)        : Output data file'
      write(LER,*)
     :' -ns[ns]      (default = first)       : start trace number'
      write(LER,*)
     :' -ne[ne]      (default = last)        : end trace number'
      write(LER,*)
     :' -rs[irs]     (default = first)       : start record number'
      write(LER,*)
     :' -re[ire]     (default = last)        : end record number'
      write(LER,*)' '
      write(LER,*)
     :'                 Input Filter Frequencies'
      write(LER,*)
     :'Butterworth:'
      write(LER,*)
     :' -fl[flow]    (default =10 Hz)        : Lowcut corner'
      write(LER,*)
     :' -fh[fhigh]   (default =40Hz)         : Highcut corner'
      write(LER,*)
     :' -nor[norder] (default = 2)           : Filter order'
      write(LER,*)
     :'Ormsby:'
      write(LER,*)
     :' -ormsby      Do trapezoidal (4-corner) filter'
      write(LER,*)
     :' -f1[flolo]  (default = 0 Hz)          : Low Lowcut corner'
      write(LER,*)
     :' -f2[flohi]  (default = 0 Hz)          : High Lowcut corner'
      write(LER,*)
     :' -f3[fhilo]  (default = Nyquist Hz)    : Low Highcut corner'
      write(LER,*)
     :' -f4[fhihi]  (default = Nyquist Hz)    : High Highcut corner'
      write(LER,*)
     :' -pow[pow]   (default = 1)             : filter exponent'
      write(LER,*)
     :' -conv       Use convolutional ormsby filter'
      write(LER,*)
     :' -db[db]     (default = 40)            : db reject'
      write(LER,*)
     :' -wt[wt]     (default = 1)             : bessel weight'
      write(LER,*)
     :' -pw[pw]     (default = 1)             : % prewitening (-conv)'
      write(LER,*)
     :'Bessel Filter:'
      write(LER,*)
     :' -i[aint]    (default = .05)           : intercept (notch width)'
      write(LER,*)
     :' -w[ex]    (default = 0)               : ross weight'
      write(LER,*)
     :' -l[lsf]    (default = 31)             : filter length'
      write(LER,*)' '
      write(LER,*)
     :' -C           For minimum phase output, else zero phase output'
      write(LER,*)
     :' '
      write(LER,*)
     :' -bias        Remove DC Bias Only'
      write(LER,*)
     :' -tmul[tmul]  (default = 1)           : time multiplier'
      write(LER,*)
     :' -d[idec]     (default = 1)           : Decimation factor'
      write(LER,*)
     :' -M                     Do not restore early mute'
      write(LER,*)' '
      write(LER,*)
     :'Usage:'
      write(LER,*)
     :' filt -N[] -O[] -ns[] -ne[] -rs[] -re[] -tmul[] [-C -M -V]'
      write(LER,*)
     :'      [ -d[] -fl[] -fh[] -nor[] ]'
      write(LER,*)
     :'      [ -f1[] -f2[] -f3[] -f4[] -ormsby -conv -db[] -wt[] -pw[]]'
      write(LER,*)
     :'      [ -i[] -l[] -w[] -bess ]'
      write(LER,*)
     :'      [ -bias ]'

      return
      end

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c    tmul   - R      time multiplier
c    fl,h   - R      corner frqs
c     ns    - I      start trace
c     ne    - I      stop end trace
c    irs    - I      start record
c    ire    - I      stop end record
c  norder   - I      butterworth order
c    deci   - I      decimation factor
c   zerop   - L      causal/acausal
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap,otap,tmul,fl,fh,ns,ne,orms,fll,flh,fhl,fhh,
     &                irs,ire,norder,deci,zerop,verbos,mute,bias,
     &                bess,butt,aint,ex,lsf,pow,conv,db,band,wt,prew)
#include    <f77/iounit.h>
      character  ntap*(*), otap*(*)
      integer    argis,ns,ne,irs,ire,norder,deci
      real       fl,fh,tmul,prew,fll,flh,fhl,fhh,db,band,wt
      logical    zerop, verbos, mute, orms, bias, butt, bess, conv

          call argstr( '-N', ntap, ' ', ' ' )
          call argstr( '-O', otap, ' ', ' ' )
          call argr4( '-tmul',tmul,1.0,1.0)

          bias   = ( argis( '-bias' ) .gt. 0   )
          orms   = ( argis( '-ormsby' ) .gt. 0   )
          conv   = ( argis( '-conv' ) .gt. 0   )
          mute   = ( argis( '-M' ) .gt. 0   )
          bess   = ( argis( '-B' ) .gt. 0   )
          verbos = ( argis( '-V' ) .gt. 0   )

          if (.not. bias .AND. .not. orms .AND. .not. bess) then
              butt = .true.
          else
              butt = .false.
          endif
c
c We need to consume all arguments so xtrarg won't choke under IKP - j.m.wade
c
c         if (orms) then
             call argr4 ( '-f1', fll , 0.0 , 0.0  )
             call argr4 ( '-f2', flh , 0.0 , 0.0  )
             call argr4 ( '-f3', fhl , 0.0 , 0.0  )
             call argr4 ( '-f4', fhh , 0.0 , 0.0  )
             call argr4 ( '-db', db , 40.0 , 40.0  )
             call argr4 ( '-r', band , 10.0 , 10.0  )
             call argr4 ( '-wt', wt , 1.0 , 1.0  )
             call argr4 ( '-pw', prew , 5.0 , 5.0  )
c         else
             call argr4 ( '-fl', fl , 10.0 , 10.0  )
             call argr4 ( '-fh', fh , 40.0 , 40.0  )
c         endif
             call argr4( '-i', aint, .05, .05 )
             call argi4( '-l', lsf, 3, 3 )
             call argr4( '-w', ex, 0., 0. )

          
          call argi4 ( '-ns', ns ,   0  ,  0    )
          call argi4 ( '-ne', ne ,   0  ,  0    )
          call argi4 ( '-rs', irs ,   0  ,  0    )
          call argi4 ( '-re', ire ,   0  ,  0    )
          call argi4 ( '-nor', norder, 2 , 2 )
          call argr4 ( '-pow', pow, 1.0, 1.0)
          call argi4( '-d',deci,1,1)

          if (bias .and. (deci.ne.1)) then
             write(LERR,*)' '
             write(LERR,*)'WARNING:'
             write(LERR,*)'Cannot decimate data and remove DC bias. You'
             write(LERR,*)'must specify bandpass filter stops for this'
             write(LERR,*)'option (either butterworth or ormsby).'
             write(LERR,*)' '
          endif
          if (butt .AND. mod(norder,2) .ne. 0) then
             write(LERR,*)'WARNING:'
             write(LERR,*)'Butterworth order must be a factor of 2'
             norder = norder + 1
             write(LERR,*)'Resetting to ',norder
          endif
          if (butt .AND. norder .gt. 16) then
             write(LERR,*)'WARNING:'
             write(LERR,*)'Butterworth order must be < 16'
             norder = 16
          endif

          if (bias) mute = .true.

          if(argis('-C').gt.0)then
                zerop = .false.
          else
                zerop = .true.
          endif


      return
      end
