C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mphase (nsamp, ampl, SZSMPD)

#include <f77/iounit.h>

      complex  temp
      pointer  (wktemp, temp(1))
      real     ampl(*)
      real     work1, work2
      pointer  (wkwork1, work1(1))
      pointer  (wkwork2, work2(1))
      integer  ordfft, nsamp, nt, nf, SZSMPD

      do  i = 1, nsamp
          a = ampl(i)
          if (a .ne. 0.0) then
             sgn = a / abs(a)
             go to 1
          endif
      enddo
1     continue

         nu = ordfft (2*nsamp+1)
         nt = 2 ** nu
         nf = nt/2 + 1
         pi = 3.14159265
         nl = nf/2 - 1

      ierr = 0
      iabort = 0
      iget = nt * SZSMPD
      call galloc (wkwork1, iget, ier, iabort)
      ierr = ierr + ier
      call galloc (wkwork2, iget, ier, iabort)
      ierr = ierr + ier
      iget = 2 * nt * SZSMPD
      call galloc (wktemp , iget, ier, iabort)
      ierr = ierr + ier
      if (ierr .ne. 0) then
       write(LER,*)'FILT:  memory failure!!!'
       call ccexit (666)
      endif
C +----------------------------------------------------+
C | get amplitude spectrum                             |
C +----------------------------------------------------+
         do  i = 1, nt
             temp (i) = cmplx (0.,0.)
         enddo
      do i=1,nsamp
      write(10,*)i,ampl(i)
      enddo
         call rfftf  (ampl, temp, nt)
         call rfftsc (temp, nt, 3, 1)
         call cvabs  (temp, 2, ampl, 1, nf)
C +----------------------------------------------------+
C | take log of amp non-zero amp spectrum              |
C | then compute hilbert xform of log amp to get phase |
C | this will be the min delay phase                   |
C +----------------------------------------------------+
         jj = 0
         do  i = 1, nf
             a = ampl (i)
             if (a .ne. 0.0) then
                 jj = jj + 1
                 work1 (i) = alog ( a )
             else
                 work1 (i) = 0
                 go to 2
             endif
         enddo
2        continue

         call vclr (work2, 1, nf)
         call hilbertx (work1, jj, work2, ierr, SZSMPD)

         if (ierr .ne. 0) then
            write(LERR,*)'FATAL ERROR in hilbert transform:'
            write(LERR,*)'unable to allocate memory'
            write(LER ,*)'FATAL ERROR in hilbert transform:'
            write(LER ,*)'unable to allocate memory'
            call ccexit (666)
         endif

         do  i = 1, nt
             temp (i) = cmplx (0.,0.)
         enddo
C +----------------------------------------------------+
C | insert min delay phasse & inverse fft              |
C +----------------------------------------------------+
         call cvmexp (work2, 1, ampl, 1, temp, 2, nf)
         call vclr (ampl, 1, nsamp)
         call rfftsc (temp, nt, -3, 0)
         call rffti  (temp, ampl, nt)
      do i=1,nsamp
      write(11,*)i,ampl(i)
      enddo
c        do  i = 1, nsamp
c            ampl (i) = -ampl (i)
c        enddo

       call gfree (wkwork1)
       call gfree (wkwork2)
       call gfree (wktemp )

      return
      end
