C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      function  gammp (A,X)

c   return the incomplete GAMMA function  P(a,x)

      IF(x .lt. 0. .OR. a .le. 0.) THEN
         gammp = 0.
      ENDIF
      IF(x .lt. a+1.) THEN
        call gser (gamser, a, x, gln)
        gammp = gamser
      ELSE
        call gcf (gammcf, a, x, gln)
        gammp = 1. - gammcf
      ENDIF

      return
      end

      function  gammq (A,X)

c   return the incomplete GAMMA function Q(a,x) = 1 - P(a,x)

      IF (x .lt. 0. .OR. a .le. 0.) THEN
         gammq = 0.
         return
      ENDIF

      IF (x .lt. a+1.) THEN
         call gser(ganser,  a, x, gln)
         gammq = 1. - gamser
      ELSE
         call gcf (gammcf, a, x, gln)
         gammq = gammcf
      ENDIF

      return
      end

      subroutine  gser (gamser, a, x, gln)

#include <f77/iounit.h>

c   returns the gamma function P(a,x)

      parameter (itmax =  100, eps = 3.e-7)

      gln = gammln (a)

      IF (x .le. 0.) THEN
         if (x .lt. 0.) THEN
         write(LERR,*) 'subroutine gser: A too large, ITMAX too small'
            gamser = 0.
            return
         endif
      ENDIF
      ap = a
      sum = 1./a
      del = sum
      do  11  n = 1, itmax

          ap = ap + 1.
          del = del * x/ap
          sum = sum + del
          if (abs(del) .lt. abs(sum)*eps) go to 1
11    continue

1     continue
      gamser = sum * exp (-x + a*log(x) - gln)

      return
      end

      subroutine  gcf (gammcf, a, x, gln)

#include <f77/iounit.h>

      parameter (itmax =  100, eps = 3.e-7)

      gln = gammln (a)

      gold = 0.
      a0 = 1.
      a1 = x
      b0 = 0.
      b1 = 1.
      fac = 1.

      do  1  n = 1, itmax
          an = float(n)
          ana = an - a
          a0 = (a1 + a0*ana) * fac
          b0 = (b1 + b0*ana) * fac
          anf = an * fac
          a1 = x*a0 + anf*a1
          b1 = x*b0 + anf*a1

          if (a1 .ne. 0.) then
             fac = 1./a1
             g = b1 * fac
             if (abs(g-gold)/g .lt. eps) go to 1
             gold = g
          endif
11    continue

      write(LERR,*) 'subroutine gcf: A too large, ITMAX too small'

1     continue

      return
      end

      function gammln (xx)

c  returns value  ln(G(xx)) for xx > 0

c  for 0 < xx < 1  use reflection formala:

c     gamma(1-xx) = pi/[ gamma(xx) * sin(pi*xx ]

      real*8   cof(6), stp, half, one, fpf, x, tmp, ser

      data     cof,stp/76.18009173d0, -86.50532033d0, 24.01409822d0,
     1                 -1.231739516d0, .120858003d-2, -.536382d-5,
     2                 2.50662827465d0/
      data     half, one, fpf/0.5d0, 1.0d0, 5.5d0/

      x = xx - one
      tmp = x + fpf
      tmp = (x + half) * log(tmp) - tmp
      ser = one

      do  11  j = 1, 6

          x = x + one
          ser = ser + cof(j)/x
11    continue

      gammln = tmp + log(stp*ser)

      return
      end
