C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine lfit (Xi, Yi, SIG, ndata, A, ma, lista, mfit, covar,
     1                 ncvm, chisq, xmin, xmax, itype)

#include <f77/iounit.h>

c  give ndata data points X(i), Y(i) with std devs SIG(i) use chi**2 min
c  to determine MFIT of  MA coefficients A of a function that de[ends linearly
c  on A [ y = sum{ Ai * AFUNCi(x) } ]
c  array  LISTA renumbers the parameters so that the first MFIT elements
c  correspond to the parameters actually being determined; the remaining 
c  MA - MFIT elements are held fixed at their input values.
c  lfit 
c  returns values for the MA fit parameters A, the chi**2, and the covariance
c  matrix COVAR(ncvm, ncvm) - ncvm is the dimension of COVAR in the calling
c  prgm.
c  user supplies a subroutine FUNCS(A, AFUNC, MA) that returns the MA basis
c  functions evaluated aat x = X in the array AFUNC

c  xmin & xmax are the min & max limits of Xi
c  itype is the type of function to fit

      parameter (mmax = 2500)

      real      Xi(ndata), Yi(ndata), SIG(ndata), A(mmax)
      integer   lista(mmax)
      real      covar(ncvm,ncvm)
      real      beta(mmax), afunc(mmax)
      real      xmin, xmax

      kk = mfit + 1

      do  12  j = 1, ma
          ihit = 0
          do  11  k = 1, mfit
              if (lista(k) .eq. j) ihit = ihit + 1
11        continue

          if (ihit .eq. 0) then
             lista(kk) = j
             kk = kk + 1
          elseif(ihit .gt. 1) then
             write(LERR,*)'subroutine lfit: improper set in LISTA'
             return
          endif

12        continue

          if (kk .ne. (ma+1)) then
             write(LERR,*)'subroutine lfit: improper set in LISTA'
             return
          endif

          do  14  j = 1, mfit

              do  13  k =  1, mfit
                  covar(j,k) = 0.
13            continue

              beta(j) = 0.

14        continue

          do  18  i  =  1, ndata

              ym = yi(i)
              xm = xi(i)
              call funcs (xm, afunc, ma, xmin, xmax, itype)
              if (mfit .lt. ma) then
                 do  15  j = mfit+1, ma
                     ym = ym - a(lista(j)) * afunc(lista(j))
15               continue
              endif

              sig2i = 1./sig(i) **2

              do  17  j  = 1, mfit
                  wt =  afunc(lista(j)) * sig2i
                  do  16  k = 1, j
                      covar(j,k) = covar(j,k) + wt * afunc(lista(k))
16                continue

                  beta(J) = beta(j) + ym*wt
17            continue
18        continue

          if (mfit .gt. 1) then
             do  21  j = 2, mfit
                 do  19  k = 1, j-1
                     covar(k,j) = covar(j,k)
19               continue
21           continue
          endif

          do 999 j = 1, mfit
999       continue

          call gaussj (covar, mfit, ncvm, beta, 1, 1)

          do  22  j = 1, mfit
              a(lista(j)) = beta(j)
22        continue

          chisq = 0.

          do  24  i = 1, ndata
              xm = xi(i)
              call funcs(xm, afunc, ma, xmin, xmax, itype)
              sum = 0.
              do  23  j =  1, ma
                  sum = sum + a(j) * afunc(j)
23            continue
              chisq = chisq + ((Yi(i) - sum)/SIG(i)) **2
              Yi(i) = sum
24        continue

          call covsrt (covar, ncvm, ma, lista, mfit)


      return
      end



