C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ap2xt(uin,uout,ibuffer,ufx,
     1                 hbegin,lenhed,lenwin,ntfft,lentr2,
     2                 ntr,nxfft,ist,iend,maxt,
     3                 ufk,f,delf,live,
     4                 kmin,kmax,xwgt,dk,dist,l_MulSkw)


      integer hbegin

      real    uout(hbegin:maxt,ntr)       
      real    uin(hbegin:maxt,kmin:kmax)               
      integer*2 ibuffer(lentr2,ntr)

c
      complex  ufx(ntfft/2,nxfft)
c
      complex    ufk(ntfft/2,kmin:kmax)
      complex    f(kmin:kmax,ntr)
      complex    delf(ntr)
      real       dist(ntr)
      real       xwgt(ntr)
      logical    live(ntr)
c__________________________________________________________________
c     copy trace headers from input data to output data.
c__________________________________________________________________
      jtrin=kmin-1         
      do 5000 jtr=1,ntr 
       jtrin=jtrin+1
       call vmov(uin(hbegin,jtrin),1,uout(hbegin,jtr),1,lenhed)
5000  continue
c___________________________________________________________________
c     flip data from omega up to omega down.                       
c     unpack amplitude and phase components.
c___________________________________________________________________
      do 30000 k=kmin,kmax                 
       iamp=ntfft/2+1
       iphase=ntfft+1
       do 20000 jf=1,ntfft/2
        iamp=iamp-1           
        iphase=iphase-1       
        ufk(jf,k)=uin(iamp,k)*
     1     cmplx(cos(uin(iphase,k)),sin(uin(iphase,k)))
20000  continue
30000 continue
c___________________________________________________________________
c     calculate x-k transform Fourier coefficient matrjtr.
c___________________________________________________________________
      call getf(f,delf,live,kmin,kmax,xwgt,dk,dist,ntr,-1)  
c___________________________________________________________________
c     transform from x --> k.
c___________________________________________________________________
      call vclr(ufx,1,ntr*ntfft)
      do 50000 k=kmin,kmax
       do 45000 jtr=1,ntr
        if(live(jtr)) then
           do 43000 jf=1,ntfft/2
            ufx(jf,jtr)=ufx(jf,jtr)
     1                        +f(k,jtr)*ufk(jf,k)    
43000      continue
        endif 
45000  continue
50000 continue
c___________________________________________________________________
c     transform from omega --> t (out of place)       
c___________________________________________________________________
      do 70000 jtr=1,ntr    
       call rfftb(ufx(1,jtr),uout(1,jtr),ntfft,-1)
70000 continue
c___________________________________________________________________
c     move data back to its proper position before windowing.                
c___________________________________________________________________
      do 90000 jtr=1,ntr    
       do 80000 jsamp=iend,ist,-1
        uout(jsamp,jtr)=uout(jsamp+1-ist,jtr)
80000  continue
       do 82000 jsamp=1,ist-1
        uout(jsamp,jtr)=0.
82000  continue
       do 83000 jsamp=iend+1,ntfft
        uout(jsamp,jtr)=0.
83000  continue
90000 continue
c
      return
      end
