C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getf(f,delf,live,kmin,kmax,xwgt,dk,dist,ntr,idir)
c
      complex    f(kmin:kmax,ntr)
      complex    delf(ntr)     
      real       dist(ntr)
      real       xwgt(ntr)
      logical    live(ntr)
c______________________________________________________________________
c     subroutine to calculate the forward spatial fourier transform mx.
c______________________________________________________________________
      akmin=kmin*dk
c
      do 10000 jtr=1,ntr
       if(live(jtr)) then
          x=dist(jtr) 
          arg=-idir*akmin*dist(jtr)
          darg=-idir*dk*dist(jtr)
          f(kmin,jtr)=xwgt(jtr)*cmplx(cos(arg),sin(arg))
          delf(jtr)=cmplx(cos(darg),sin(darg))
       else
          f(kmin,jtr)=(0.,0.)
          delf(jtr)=(0.,0.)
       endif

10000 continue
c______________________________________________________________________
c     calculate the f matrix.
c     exploit the fact that
c
c         exp(i*(n+1)*dk*x)=exp(i*n*dk*x)*exp(i*dk*x)
c
c______________________________________________________________________
      do 30000 k=kmin+1,kmax
       do 20000 jtr=1,ntr
        f(k,jtr)=f(k-1,jtr)*delf(jtr)
20000  continue
30000 continue

c
      return
      end
