C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine toeplitz(n,a,urhs,uout,s,ifl,ifh,
     1                    v,r,e,ec,temp,rc)             
C
c      title: mclev - multi frequency Wiener Levinson algorithm to solve 
C                     complex hermetian system of equations.
c                     matrix a is toeplitz.
C
C      the system of equations this routine will solve is of the form:
C
C      |       a(1)     a(2)   ...   a(N)   | |uout(1)|     |urhs(1)|
C      |  CONJG(a(2))   a(1)   ...   a(N-1) | |  . |     |      .  |
C      |         .                          | |  . |  =  |      .  |
C      |         .                          | |  . |     |      .  |
C      |         .                          | |    |     |         |
C      |  CONJG(a(N))          ...     a(1) | |uout(N)|     |urhs(N)|
C
C
C      note that the main diagonal "a(1)" must be real.
C
C      NOTE THaT THE SYSTEM IS SCaLED BY 1./a(1) BEFORE IT IS SOLVED.
C      (THIS WILL BE NOTICED ON OUTPUT)
C
C
C      INPUT
C
c      n       =  order of system of equations
C
C      INPUT/OUTPUT
C
C      a       =  (n) first row/column of Toeplitz matrix.
C      urhs  =  (n) rhs of system to solve
C
C      OUTPUT
C
C      uout    =  (n) solution vector
C      s       =  (n) solution vector for spike rhs
C
c_______________________________________________________________
      integer  iand
c_______________________________________________________________
c     input matrix
c_______________________________________________________________
      complex    a(n)
c_______________________________________________________________
c     rhs
c_______________________________________________________________
      complex    urhs(ifl:ifh,n)
c_______________________________________________________________
c     soln for unit rhs
c_______________________________________________________________
      complex    s(ifl:ifh,n)
c_______________________________________________________________
c     soln for full rhs
c_______________________________________________________________
      complex    uout(ifl:ifh,n)
c_______________________________________________________________
c     temporary work arrays for vectorization across solutions.
c_______________________________________________________________
      real       rnorm
      complex    v(ifl:ifh),r(ifl:ifh)
      complex    e(ifl:ifh),ec(ifl:ifh)
      complex    temp(ifl:ifh),rc(ifl:ifh)
c_______________________________________________________________
c     normalize matrix and rhs, zero other vectors
c     since [a] is Hermitian, a(1) and hence rnorm are real.
c_______________________________________________________________
      rnorm=1./real(a(1))
      write(0,*) 'a(1),rnorm,ifl,ifh ',a(1),rnorm,ifl,ifh
      do 1020 i=1,n
       a(i)=a(i)*rnorm
       do 11000 ifreq=ifl,ifh
        urhs(ifreq,i)=urhs(ifreq,i)*rnorm
        s(ifreq,i)=(0.,0.)
        uout(ifreq,i)=(0.,0.)
11000  continue
1020  continue
c_______________________________________________________________
c     initialize recursion
c_______________________________________________________________
      do 20000 ifreq=ifl,ifh
       v(ifreq)=(1.,0.)
       s(ifreq,1)=(1.,0.)
       uout(ifreq,1)=urhs(ifreq,1)
20000 continue
c_______________________________________________________________
c     main recursion loop
c_______________________________________________________________
      do 99000 j=2,n
c_______________________________________________________________
c      error term for spike rhs
c_______________________________________________________________
       do 30000 ifreq=ifl,ifh
        e(ifreq)=(0.,0.)
30000  continue
       do 2020 i=2,j
        do 31000 ifreq=ifl,ifh
         e(ifreq)=e(ifreq)+conjg(a(i))*s(ifreq,j-i+1)
31000   continue
2020   continue
c_______________________________________________________________
c      scale factor and new spike value
c_______________________________________________________________
       do 40000 ifreq=ifl,ifh
        r(ifreq)=e(ifreq)/conjg(v(ifreq))
40000  continue
       do 50000 ifreq=ifl,ifh
        v(ifreq)=v(ifreq)-r(ifreq)*conjg(e(ifreq))
50000  continue
c_______________________________________________________________
c      new solution vector for spike
c_______________________________________________________________
       do 2040 i=1,j/2
        do 60000 ifreq=ifl,ifh
         temp(ifreq)=s(ifreq,i)
         s(ifreq,i)=s(ifreq,i)-r(ifreq)*conjg(s(ifreq,j-i+1))
60000   continue
        do 70000 ifreq=ifl,ifh
         s(ifreq,j-i+1)=s(ifreq,j-i+1)-r(ifreq)*conjg(temp(ifreq))
70000   continue
2040   continue
       if(iand(j,1).ne.0) then
          do 80000 ifreq=ifl,ifh
           s(ifreq,j/2+1)=
     1         s(ifreq,j/2+1)-r(ifreq)*conjg(s(ifreq,j/2+1))
80000     continue
       endif
c_______________________________________________________________
c      error term for full rhs
c_______________________________________________________________
       do 81000 ifreq=ifl,ifh
        ec(ifreq)=(0.,0.)
81000  continue
       do 2120 i=2,j
        do 82000 ifreq=ifl,ifh
         ec(ifreq)=ec(ifreq)+conjg(a(i))*uout(ifreq,j-i+1)
82000   continue
2120   continue
c_______________________________________________________________
C      scale factor
c_______________________________________________________________
       do 83000 ifreq=ifl,ifh
        rc(ifreq)=(ec(ifreq)-urhs(ifreq,j))/conjg(v(ifreq))
83000  continue
c_______________________________________________________________
c      new solution vector for spike
c_______________________________________________________________
       do 2140 i=1,j
        do 84000 ifreq=ifl,ifh
         uout(ifreq,i)=uout(ifreq,i)-rc(ifreq)*conjg(s(ifreq,j-i+1))
84000   continue
2140   continue
C
99000 continue
C
       return
       end
