C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine SumRadialFreq(InputFftxy, ntrc, nsampAmp, RadialSum, 
     :     RadialLiveSamples, ntrco ,dKX, dKY, dKR )

c declare variables passed from calling routine

      integer ntrc, nsampAmp, ntrco

      real InputFftxy(nsampAmp,ntrc), RadialSum(ntrco)
      real RadialLiveSamples(ntrco), dKX, dKY, dKR

c declare local variables

      integer Xcenter, Ycenter

      real  Kr_min, Kr_max, Kr, Kx, Ky

c initialize variables

c determine 2d sample location of Kx = Ky = 0 position

      if ( mod(ntrc,2) .eq. 0 ) then
         Xcenter  = ( ntrc / 2 ) + 1
      else
         Xcenter = ( ntrc / 2 )
      endif

      if ( mod(nsampAmp,2) .gt. 0 ) then
         Ycenter = nsampAmp / 2 + 1
      else
         Ycenter = nsampAmp / 2 
      endif

c perform summation over entire spectra once.  The outer loop is x 
c the inner loop is y. The innermost loop is radial frequency. 

      do ix =  1, ntrc

         Kx = float(ix - Xcenter) * dKX
 
         do iy = 1, nsampAmp

            Ky = float(iy - Ycenter) * dKY
            
            Kr = ( Kx**2 + Ky**2 )**0.5
            
            do i = 1, ntrco

               Kr_max = float(i) * dKR
               Kr_min = float(i) * dKR - dKR
               
c sum only the samples that fall within the current bin, keep trace of the
c number of samples summed in RadialLiveSamples()

               if ( Kr .ge. Kr_min .and. Kr .lt. Kr_max ) then
                  RadialSum(i) = RadialSum(i) + InputFftxy(iy,ix)
                  RadialLiveSamples(i) = RadialLiveSamples(i) + 1.
                  goto 10
               endif

            enddo
 10         continue
         enddo
      enddo

      return
      end

               




         


