C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine BuildAmpMask ( Segment, Index, Trace, Sample, 
     :     itemPick, NumSegs, AmpMask, nsamp, ntrc, nbins, nsampAmp, 
     :     dKX, dKY, dKR )

#include <f77/lhdrsz.h>

c variables passed into subroutine

      integer Segment, NumSegs, nsampAmp, ntrc, nbins, itemPick
      integer nsamp, Index(NumSegs,2)

      real Trace(itemPick), Sample(itemPick) 
      real AmpMask(nsampAmp,ntrc), dKX, dKY, dKR

c local variables

      integer Pindex, ix, iy
      integer Xcenter, Ycenter

      real Kx, Ky, Kr, InterpSamp, binAmp(SZLNHD)
      real Kr_max, Kr_min

c determine index of pick file elements for this filter
         

      if ( Segment .eq. 1 ) then
         Pindex = 0
      else
         Pindex = 0
         do LL = 1, Segment - 1
            Pindex = Pindex + Index(LL,1)
         enddo
      endif
      

c fill binAmp based on pick file information

      DO 10 i = 1, nbins

         IF ( i .lt. nint( Trace(Pindex+1) ) ) then

c this bin is before first bin in pickfile

            binAmp(i) = 0.0

         ELSEIF ( i .gt. nint( Trace( Pindex + Index(Segment,1) ) ) ) 
     :           then

c bin after last pick

            binAmp(i) = 0.0

         ELSE

c interpolate a fractional value for the amplitude multiplier for this
c bin from within segment.  Value will end up >0.0 and <= 1.0  .

            do j = Pindex + 2, Pindex + Index(Segment,1) 
            
               if ( i .le. nint(Trace(j)) ) then

                  InterpSamp = Sample(j-1) + 
     :                 ((Sample(j)-Sample(j-1)) / (Trace(j)-Trace(j-1))) 
     :                 * abs(float(i) - Trace(j-1))
                  binAmp(i) = (float(nbins)-InterpSamp)/float(nbins)
                  binAmp(i) = (exp(binAmp(i))- 1.0)/(exp(1.0) - 1.0)
                  goto 10
               endif

            enddo
               
         ENDIF
 10   CONTINUE


c form Amplitude Mask based on weighting in binAmp array and the postion on
c the input fftxy display.  The logic here must parallel that in fkrad from
c which the picks where made.  Basically determine the Kr of a sample location
c and apply the appropriate weighting.

c determine 2d sample location of Kx = Ky = 0 position

      if ( mod(ntrc,2) .eq. 0 ) then
         Xcenter  = ( ntrc / 2 ) + 1
      else
         Xcenter = ( ntrc / 2 )
      endif

      if ( mod(nsampAmp,2) .gt. 0 ) then
         Ycenter = nsampAmp / 2 + 1
      else
         Ycenter = nsampAmp / 2 
      endif

      do ix =  1, ntrc

         Kx = float(ix - Xcenter) * dKX
 
         do iy = 1, nsampAmp

            Ky = float(iy - Ycenter) * dKY
            
            Kr = ( Kx**2 + Ky**2 )**0.5
            
            do LL = 1, nbins
               
               Kr_max = float(LL) * dKR
               Kr_min = float(LL) * dKR - dKR
               
               if ( Kr .ge. Kr_min .and. Kr .lt. Kr_max ) then
                  
                  if ( binAmp(LL) .gt. 0. ) then
                     AmpMask(iy,ix) = binAmp(LL)
                  else
                     AmpMask(iy,ix) = 0.0
                  endif
                  goto 100
                  
               endif
            enddo
            
c if execution gets to here then the radius is greater than the last active bin
c if this is so then AmpMask for this value must be set to zero

            AmpMask(iy,ix) = 0.0
            
 100        CONTINUE
            
         enddo

      enddo

      return
      end

