C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ShapeSpectrum ( ntrc, nsamp, InputFftxy, OutputFftxy, 
     :     nsampAmp, AmpMask, Difference )

      integer ntrc, nsamp, nsampAmp

      real InputFftxy(nsamp,ntrc), OutputFftxy(nsamp,ntrc)
      real AmpMask(nsampAmp,ntrc)

      logical Difference 
      
      DO i = 1, ntrc
         do j = 1, nsampAmp

            OutputFftxy(j,i) = InputFftxy(j,i) * AmpMask(j,i) 

c If difference was requested supply output = input - filtered 

            if ( Difference ) OutputFftxy(j,i) = 
     :           InputFftxy(j,i) - OutputFftxy(j,i)

         enddo
      ENDDO

c load phase spectrum back for output

      do i = 1, ntrc
         do j = nsampAmp+1, nsamp

            OutputFftxy(j,i) = InputFftxy(j,i)

         enddo
      enddo
            
      return
      end

