C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( irs, ire, nsamp, ntrc, nsi, nrec, ntap, otap,   
     :     ptap, iform, dX, dY, NumSegs, nbins, start, end, Exponent, 
     :     Bin1, Bin2, Bin3, Bin4, verbos) 

c     verbose output of processing parameters

#include <f77/iounit.h>
 
      integer  irs, ire, nsamp, nsi, ntrc, iform
      integer  nbins, NumSegs, start, end, Bin1, Bin2, Bin3, Bin4

      real     dX, dY, Exponent 

      character   ntap*(*), otap*(*), ptap*(*)

      logical verbos
 
      write(LERR,*)' '
      write(LERR,*)' Input line header values '
      write(LERR,*)' '
      write(LERR,*) ' # of samples/trace   =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec
      write(LERR,*) ' format of data       =  ', iform
      write(LERR,*) ' input data set name  =  ', ntap
      write(LERR,*)' '
      write(LERR,*)' Output line header values '
      write(LERR,*)' '
      write(LERR,*) ' # of samples/trace   =  ', nsamp
      write(LERR,*) ' sample interval      =  ', nsi
      write(LERR,*) ' traces per record    =  ', ntrc
      write(LERR,*) ' records per line     =  ', nrec*NumSegs
      write(LERR,*) ' format of data       =  ', iform
      write(LERR,*) ' output data set name =  ', otap
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters'
      write(LERR,*)' '
      write(LERR,*) ' X co-ordinate sample interval = ',dX
      write(LERR,*) ' Y co-ordinate sample interval = ',dY
      write(LERR,*) ' Start Record to Pass = ', irs
      write(LERR,*) ' Start Record to Process = ', start
      write(LERR,*) ' End Record to Pass = ', ire
      write(LERR,*) ' End Record to Process = ', end
      if ( ptap .ne. ' ' ) then
         write(LERR,*) ' Input xsd pick file name = ',ptap
         write(LERR,*) ' Number of input filters = ',NumSegs
         write(LERR,*) ' Number of frequency bins = ', nbins
      else
         write(LERR,*) ' Powering Exponent = ', Exponent
         write(LERR,*) ' Low Radial Cutoff Bin  = ', Bin1
         write(LERR,*) ' Low Radial 100 % Bin = ', Bin2
         write(LERR,*) ' High Radial 100 % Bin = ', Bin3
         write(LERR,*) ' High Radial Cutoff Bin  = ', Bin4
      endif

      if ( verbos ) write(LERR,*)' Verbos printout requested'
      return
      end
