C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickCount ( lupick, NumEntries, NumSegs, RecUnits, 
     :     TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset, 
     :     FormatIn, Pick_ntrc, Pick_nrec, Pick_nsamp )

#include <f77/iounit.h>

c variables passed from calling routine

      integer lupick, NumEntries, NumSegs, Pick_ntrc, Pick_nrec
      integer Pick_nsamp

      real RecUnits, TrcUnits, SmpUnits, RecOffset, TrcOffset 
      real SmpOffset

      character FormatIn*20

c declare local variables

      real value

      character key*10

c read pick file header information to determine memory acquisition requirements
c in main 
 
      IF ( FormatIn .eq. 'xsd' ) then

c read pick file header assuming new XSD format.

         read ( lupick, 10, err = 900 , end = 901 ) RecUnits, 
     :        TrcUnits, SmpUnits, Pick_nrec, Pick_ntrc, Pick_nsamp, 
     :        RecOffset, TrcOffset, SmpOffset, NumSegs, 
     :        NumEntries
 10      format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, 
     :        i5, 7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )

         return
       
      ELSEIF ( FormatIn .eq. 'xsdheader' ) then

c read file header

         do while ( 1 .eq. 1 )
            read ( lupick, '(a10,1x,f17.6)', err=900, end=901 ) 
     :           key, value

            if (key.EQ.'No_Seg') NumSegs = nint(value)
            if (key.EQ.'Max_Pick') NumEntries = nint(value)
            if (key.EQ.'UnitRec') RecUnits = value
            if (key.EQ.'UnitTrc') TrcUnits = value
            if (key.EQ.'UnitSmp') SmpUnits = value
            if (key.EQ.'OffsetRec') RecOffset = value
            if (key.EQ.'OffsetTrc') TrcOffset = value
            if (key.EQ.'OffsetSmp') SmpOffset = value
            if (key.EQ.'NumRec') Pick_nrec = nint(value)
            if (key.EQ.'NumTrc') Pick_ntrc = nint(value)
            if (key.EQ.'NumSmp') Pick_nsamp = nint(value)
            if (key.EQ.'NumSmp') return
         enddo

      ENDIF

c error messages

 900  continue
      write(LERR,*)'FLATTEN: error reading xsd pick file'
      write(LERR,*)'FATAL'
      write(LER,*)' '
      write(LER,*)'FLATTEN: error reading xsd pick file'
      write(LER,*)'FATAL'
      write(LER,*)' '
      stop

 901  continue
      write(LERR,*)' FLATTEN: empty input xsd pick file'
      write(LERR,*)' FATAL '
      write(LER,*)' '
      write(LER,*)' FLATTEN: empty input xsd pick file'
      write(LER,*)' FATAL '
      write(LER,*)' '
      stop

      end
