C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c
c
c     Program Description:
C**********************************************************************C
C
C flatten READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C reads picks from an xsd pick file,  computes a static
C which will flatten that event, and puts this static into
C a user specified trace header word,
C AND witeS UPDATED LINE HEADER AND REQUIRED RECORDS
C OR TRACES
c
c Changes
c -------
c
c Jun 14, 1999 - fixed bug in routine after irregular interpolation where
c          timeout instead of Tim_int(j) was loaded to output.  In this
c          case Tim_int was loaded by the interpolation subroutine but
c          code from above using timeout had been cut and paste to supply
c          the free format header load and timeout was never changed to
c          Tim_int(j).   
c Garossino
c
c     Indexing bug detected and fixed 4 November 1996 J. M. Gridley
c     somebody nint'ed all the int`s and caused another problem which
c     was fixed at the same time. JMG
C**********************************************************************C
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 


      integer     itr ( SZLNHD )
      integer     Nstart(SZLNHD), Nend(SZLNHD)

      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis

      real        tri ( SZLNHD )
    
   
      character   ntap*255, otap*255, name*7

      logical     verbos

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2
      integer errcd4, errcd3, errcd5, errcd6, errcd7, abort
      integer Headers,icount,m
      integer NumPicks(SZLNHD)
      integer iRecord_Picks, iTrace_Picks, iTime_Picks

      Real    Record, Space, Record_Picks, Trace_Picks
      Real    Time_Picks, ttmp, ra, rb, rc
      Real    Record_temp, Trace_temp, Time_temp


      pointer (memadr_Record, Record(200000))
      pointer (memadr_Space, Space(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_Record_Picks, Record_Picks(200000))
      pointer (memadr_Trace_Picks, Trace_Picks(200000))
      pointer (memadr_Time_Picks, Time_Picks(200000))
      pointer (memadr_ttmp, ttmp(200000))
      pointer (memadr_iRecord_Picks, iRecord_Picks(200000))
      pointer (memadr_iTrace_Picks, iTrace_Picks(200000))
      pointer (memadr_iTime_Picks, iTime_Picks(200000))
      pointer (memadr_ra, ra(200000))
      pointer (memadr_rb, rb(200000))
      pointer (memadr_rc, rc(200000))
      pointer (memadr_Record_temp, Record_temp(200000))
      pointer (memadr_Trace_temp, Trace_temp(200000))
      pointer (memadr_Time_temp, Time_temp(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer hdr_index, tr_index, JJ, KK, irec_current
      integer irwd,itwd,iseg,nord, NumSegs, NumEntries
      integer Pick_ntrc, Pick_nrec, Pick_nsamp
      integer nullval,imax, ival
      integer length, lupick, npick1, npick2

      real Trc_int(SZLNHD), Tim_int(SZLNHD)
      real tflat, scl, si
      real RecUnits, TrcUnits, SmpUnits, RecOffset, TrcOffset
      real SmpOffset

      character   hdrwrd * 6, recwrd * 6, trcwrd * 6
      character   ptap*255,FormatIn*20

      logical     all, rec, trace, onepik, stat

c Initialize variables

      data abort/0/
      data name/"FLATTEN"/
      data nullval/0/
      data irec_current/0/
      data irs/0/
      data ire/0/
      data ist/0/
      data iend/0/
      data irwd/0/, itwd/0/, iswd/0/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln(ntap,otap,ptap,si,onepik,iseg,irwd,
     1 itwd,iswd,nord,tflat,verbos,stat,scl,hdrwrd,recwrd,
     2 trcwrd,all,rec,trace)

      if ( irwd .lt. 0 ) onepik = .true.

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c open pickfile

      call alloclun (lupick)
      length = lenth(ptap)
      if (length .eq. 0) go to 990
      open ( lupick, file = ptap(1:length), status = 'old', err=990 )

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'PRGM: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
c--------------------------
c     save key header values
c--------------------------
#include <f77/saveh.h>
      
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
      
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1		TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,
     1		TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,
     1		TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,
     1		TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,
     1		TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     1		TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,
     1		TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     1		TRACEHEADER)
      
      call savelu( recwrd ,ifmt_recwrd,l_recwrd,ln_recwrd,
     1		TRACEHEADER)
      call savelu( trcwrd ,ifmt_trcwrd,l_trcwrd,ln_trcwrd,
     1		TRACEHEADER)
      call savelu( hdrwrd ,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,
     1		TRACEHEADER)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
c===================================================================
c Check the header word situation and emplace overrides if
c neccessary

      if (irwd .ne. 0) then
         l_recwrd = iabs(irwd)
      endif
      if (itwd .ne. 0) then
         l_trcwrd = iabs(itwd)
      endif
      if (iswd .ne. 0) then
         l_hdrwrd = iswd
      endif
c===================================================================

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
   
      FormatIn='xsd'
      iseg = 1

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, ptap,
     :     iend, irs, ire, verbos, si, onepik,iseg,irwd,
     :     tflat,stat,scl,hdrwrd,recwrd,trcwrd,all,rec,trace,
     :     ifmt_hdrwrd )

c===================================================================
        call PickCount (  lupick, NumEntries, NumSegs, RecUnits,
     :       TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset,
     :       FormatIn, Pick_ntrc, Pick_nrec, Pick_nsamp )
        
        if ( Pick_ntrc .ne. ntrc .or.
     :       Pick_nrec .ne. nrec .or.
     :       Pick_nsamp .ne. nsamp ) then
           write(LERR,*)' '
           write(LERR,*)' WARNING:'
           write(LERR,*)' your pick file was not created using '
           write(LERR,*)' your input dataset.  This may or may'
           write(LERR,*)' not be a problem depending on the flatten'
           write(LERR,*)' option your are using.  Here are the '
           write(LERR,*)' global parameters of each:'
           write(LERR,*)' '
           write(LERR,*)'        Dataset                   Pickfile'
           write(LERR,*)'        -------                   --------'
           write(LERR,*)' '
           write(LERR,*)' nrec:  ',nrec,'                   ',Pick_nrec
           write(LERR,*)' ntrc:  ',ntrc,'                   ',Pick_ntrc
           write(LERR,*)' nsamp: ',nsamp,'                ',Pick_nsamp 
           write(LERR,*)' '
        endif
 
c===================================================================
c Policeman to check the sample values
 
        if (SmpUnits .ne. nsi) then
           
           write(LERR,*)'xsd pick file  and data file does not
     :          have the same sample rate'
           write(LER,*)'xsd pick file  and data file does not
     :          have the same sample rate'

           if(si .le. 0.) then
              write(LERR,*)'No Sample override was found. Please
     :             enter a sample override on command line [-si]'
              write(LER,*)'No Sample override was found. Please
     :             enter a sample override on command line [-si]'
              
              go to 999
           endif

           nsi = nint (si)
           SmpUnits = si
        endif

c allocate memory for picks

        call galloc ( memadr_Record_Picks, NumEntries*NumSegs* SZSMPD, 
     :       errcd1, abort)
        call galloc ( memadr_Trace_Picks, NumEntries*NumSegs* SZSMPD,
     :       errcd2, abort)
        call galloc ( memadr_Time_Picks, NumEntries*NumSegs* SZSMPD,
     :       errcd3, abort)
        call galloc ( memadr_ttmp, NumEntries*NumSegs* SZSMPD, errcd4, 
     :       abort )
        call galloc ( memadr_ra, NumEntries * SZSMPD, errcd5, abort )
        call galloc ( memadr_rb, NumEntries * SZSMPD, errcd6, abort )
        call galloc ( memadr_rc, NumEntries * SZSMPD, errcd7, abort )
        call galloc ( memadr_Record_temp, NumEntries * SZSMPD, 
     :       errcd7, abort )
        call galloc ( memadr_Trace_temp, NumEntries * SZSMPD, 
     :       errcd8, abort )
        call galloc ( memadr_Time_temp, NumEntries * SZSMPD, 
     :       errcd9, abort )

        if ( errcd1 .ne. 0 .or.
     :       errcd2 .ne. 0 .or.
     :       errcd3 .ne. 0 .or.
     :       errcd4 .ne. 0 .or.
     :       errcd5 .ne. 0 .or.
     :       errcd6 .ne. 0 .or.
     :       errcd8 .ne. 0 .or.
     :       errcd9 .ne. 0 .or.
     :       errcd7 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 4*NumEntries*NumSegs * SZSMPD, '  bytes'
         write(LERR,*) 3*NumEntries * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*)' '
         write(LER,*) 4*NumEntries*NumSegs * SZSMPD, '  bytes'
         write(LER,*) 3*NumEntries * SZSMPD, '  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) nsamp * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( Record_Picks, 1, NumEntries*NumSegs )
      call vclr ( Trace_Picks, 1, NumEntries*NumSegs )
      call vclr ( Time_Picks, 1, NumEntries*NumSegs )
      call vclr ( ttmp, 1, NumEntries*NumSegs )
      call vclr ( ra, 1, NumEntries )
      call vclr ( rb, 1, NumEntries )
      call vclr ( rc, 1, NumEntries )
      call vclr ( Record_temp, 1, NumEntries )
      call vclr ( Trace_temp, 1, NumEntries )
      call vclr ( Time_temp, 1, NumEntries )
c=================================================================== 
c     
c     N = Number of entries (Numentries)
c     iseg = segment number in file


      call PickReader (lupick,1,NumPicks,NumSegs, 
     :     Record_Picks, Trace_Picks, Time_Picks, NumEntries,
     :     RecUnits, ra, rb, rc,
     :     TrcUnits, SmpUnits, RecOffset, TrcOffset, SmpOffset,
     :     icount )

      jcount=0
      do j = 1, NumSegs
c	write(6,*)NumSegs,NumPicks(j)
         do i = 1,NumPicks(j)
            jcount=jcount+1
c         write(6,*)  Record_Picks(jcount), Trace_Picks(jcount)
         enddo
      enddo
c===================================================================
c     set up a pick counter to keep track of first and last picks for
c     each segment
      
      Nstart(1) = 1
      Nend(1)= NumPicks(1)
      
      do i = 2, NumSegs
         Nstart(i) = Nend(i-1) + 1
         Nend(i) = Nend(i-1) + NumPicks(i)
      enddo
      
c     Sort Picks
c     added to code after release
      
      if(.not. rec .and. .not. trace) then
c     sort for prestack data    
         call hsort3 (jcount,Record_Picks,
     :        Trace_Picks,Time_Picks)
         
         do i = 1, NumSegs
            do j = Nstart(i), Nend(i)
               Trace_temp(j-Nstart(i)+1)=Trace_Picks(j)
               Record_temp(j-Nstart(i)+1)=Record_Picks(j)
               Time_temp(j-Nstart(i)+1)=Time_Picks(j)
               
            enddo
            
c     sort on traces
            
            call hsort3 (Nend(i)-Nstart(i)+1,
     :           Trace_temp,Record_temp,Time_temp)
            
            do j=1,Nend(i)-Nstart(i)+1
               Trace_Picks(j+Nstart(i)-1)=Trace_temp(j)
               Record_Picks(j+Nstart(i)-1)=Record_temp(j)
               Time_Picks(j+Nstart(i)-1)=Time_temp(j)
               
            enddo
            
         enddo
         
      endif
      
c     sort if record stack
      if (Rec) then
         call hsort3 (jcount,Record_Picks,
     :        Trace_Picks,Time_Picks)
      endif
c     c sort if trace stack
      if (Trace) then
         call hsort3 (jcount,Trace_Picks,
     :        Record_Picks,Time_Picks)
      endif
      
c debug
c      do j = 1, NumSegs
c         do i = Nstart(j),Nend(j)
c            write(6,*)  Record_Picks(i), Trace_Picks(i),
c     :	Time_Picks(i)
c         enddo
c      enddo

c===================================================================
c     get statistics from all the picks
c     stat is the option to only write to header
      
      call maxv(Time_Picks,1,tmax,loc1,icount)
      call minv(Time_Picks,1,tmin,loc2,icount)

      if (stat) then
         tzmax = 0.
      else
         if (tflat .eq. -99999. ) then
            tzmax = .5 * (tmax+tmin)
         else
            tzmax = tflat
         endif
      endif
      
      call vsadd (Time_Picks, 1, -tzmax, ttmp, 1, icount)

      if (.not. stat) 
     :     call vsmul (ttmp, 1, -1.0, Time_Picks, 1, icount)
      
      call vsmul (ttmp, 1, scl, Time_Picks, 1, icount)

c===================================================================
      call galloc ( memadr_iRecord_Picks, NumEntries*NumSegs* SZSMPD, 
     :     errcd1, abort)
      call galloc ( memadr_iTrace_Picks, NumEntries*NumSegs * SZSMPD,
     :     errcd2, abort)
      call galloc ( memadr_iTime_Picks, NumEntries*NumSegs * SZSMPD,
     :     errcd3, abort)
      
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)  NumEntries*NumSegs* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) NumEntries*NumSegs * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) NumEntries*NumSegs * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( iRecord_Picks, 1, NumEntries*NumSegs )
      call vclr ( iTrace_Picks, 1, NumEntries*NumSegs )
      call vclr ( iTime_Picks, 1, NumEntries*NumSegs )

c load integer arrays

      do i = 1, NumSegs * NumEntries  
         iTrace_Picks(i)=nint(Trace_Picks(i))
         iRecord_Picks(i)=nint(Record_Picks(i))
         iTime_Picks(i)=nint(Time_Picks(i))
      enddo

c=================================================================== 
        
c     dynamic memory allocation: 
 
      ival = max (ntrc,nrec)
    

      RecordSize = ival * nsamp 
      HeaderSize = ival * ITRWRD 

      call galloc ( memadr_Record, RecordSize * SZSMPD, errcd1,
     :     abort)
      call galloc ( memadr_Space, RecordSize * SZSMPD, errcd2,
     :     abort)
      call galloc ( memadr_Headers, HeaderSize * SZSMPD, errcd3,
     :     abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Space, 1, RecordSize )
      call vclr ( Headers, 1, HeaderSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

         DO 800 KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

            call saver2 ( itr, ifmt_RecWrd, l_RecWrd,
     :           ln_RecWrd, irec, 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_TrcWrd, l_TrcWrd,
     :           ln_TrcWrd, itrc, 
     :           TRACEHEADER )

            call saver2 ( itr, ifmt_StaCor, l_StaCor, 
     :           ln_StaCor, StaCor, TRACEHEADER )

            IF ( StaCor .eq. 30000 ) then
               nullval = 30000
               if (hdrwrd .eq. 'StaCor') then
                  call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                 ln_HdrWrd,nullval, TRACEHEADER)

                  if(verbos)
     :                   write(LERR,*)'Record = ',irec,
     :                 ' Trace = ',itrc, ' dead trace '
               else

cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,0.0, TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,0, TRACEHEADER)
                  endif

cmam              call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                 ln_HdrWrd,0, TRACEHEADER)
                  if(verbos)
     :                   write(LERR,*)'Record = ',irec,
     :                 ' Trace = ',itrc, ' dead trace'
               endif
               
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               call vclr ( tri, 1, nsamp )
               call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )

c Pass the data along and process 

            ELSE

c load trace header to array Headers[]

c=================================================================== 
c The Meat
c             
c===================================================================
c     Case of   1-Trace, Multiple-Records

               if (ntrc .le. 1 .and. nrec .gt. 1 .or. rec) then  
                
                  do 69 i = 1, icount

                     if (irec .lt. nint(Record_Picks(1)) .or.
     :                    irec .gt.
     :                    nint(Record_Picks(icount)))
     :                    then
                        go to 55
                       
                     endif 

                     if (irec .eq. nint(Record_Picks(i))
     :                    .or. irec .eq. nint(Record_Picks(1))
     :                    .or. irec .eq. 
     :                    nint(Record_Picks(icount)))
     :                    then
                        
                        if (irec .eq. nint(Record_Picks(icount)))
     :                       then
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,Time_Picks(icount), TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(Time_Picks(icount)),
     :                   TRACEHEADER)
                  endif

cmam                       call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                          ln_HdrWrd,int(Time_Picks(icount)), 
cmam :                          TRACEHEADER)
                        else
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,Time_Picks(i), TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(Time_Picks(i)), TRACEHEADER)
                  endif

cmam                       call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                          ln_HdrWrd,int(Time_Picks(i)), 
cmam :                          TRACEHEADER)
                        endif
                        if(verbos)
     :                       write(LERR,*)'Record = ',irec,
     :                       'Trace = ',itrc, 'Pick = ',
     :                       nint(timeout)
                        go to 55
                     endif
                     
                     if (irec .gt. nint(Record_Picks(i)) .and.
     :                    irec .lt. nint(Record_Picks(i+1)))then
                        
                        call Pick_Interpolation(Record_Picks(i),
     :                       Record_Picks(i+1),Time_Picks(i),
     :                       Time_Picks(i+1),
     :                       float(irec),timeout)
                        
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,timeout, TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(timeout), TRACEHEADER)
                  endif

cmam                    call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                       ln_HdrWrd,int(timeout), 
cmam :                       TRACEHEADER)
                        
                        if(verbos) 
     :                       write(LERR,*)'Record = ',irec,
     :                       'Trace = ',itrc, 'Pick = ',
     :                       nint(timeout)                 
                        
                     endif
 69               enddo
               endif

c===================================================================
c     Case of 2  1-Record Multiple Traces 

               if (nrec .le. 1 .and. ntrc .gt. 1 .or. trace ) then  
              
                  do 44 i = 1,icount-1
                     
                     if (itrc .lt. nint(Trace_Picks(1)) .or.
     :                    itrc .gt.
     :                    nint(Trace_Picks(icount)))
     :                    then
                        
                        go to 55
                        
                     elseif (itrc .ge. nint(Trace_Picks(i)) .and.
     :                       itrc .le. nint(Trace_Picks(i+1)))then
                        
                        call Pick_Interpolation(Trace_Picks(i),
     :                       Trace_Picks(i+1),Time_Picks(i),
     :                       Time_Picks(i+1),
     :                       float(itrc),timeout)
                        
                        itime = nint(timeout)
                        
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,timeout, TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(timeout), TRACEHEADER)
                  endif

cmam                    call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                       ln_HdrWrd,int(timeout), 
cmam :                       TRACEHEADER)                      
                        
                        if (verbos)
     :                       write(LERR,*)'Record = ',irec,
     :                       'Trace = ',itrc, 'Pick = ',
     :                       itime
                        
			go to 55   
                     endif
 44               enddo
               endif
c===================================================================
c Case 3 (-A)
c Apply a single record pick to all records assuming a single 
c segment pick event

               if (all) then
                 
                  do 45 i = 1,icount-1
                     
                     if (itrc .lt. nint(Trace_Picks(1)) .or.
     :                    itrc .gt.
     :                    nint(Trace_Picks(icount)))
     :                    then
                        
                        go to 55
                        
                     elseif (itrc .ge. nint(Trace_Picks(i)) .and.
     :                       itrc .le. nint(Trace_Picks(i+1)))then
                        
                        call Pick_Interpolation(Trace_Picks(i),
     :                       Trace_Picks(i+1),Time_Picks(i),
     :                       Time_Picks(i+1),
     :                       float(itrc),timeout)
                        
                        itime = nint(timeout)
                        
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,timeout, TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(timeout), TRACEHEADER)
                  endif

cmam                    call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
cmam :                       ln_HdrWrd,int(timeout), 
cmam :                       TRACEHEADER)                      
                        
                        if(verbos)
     :                       write(LERR,*)'Record = ',irec,
     :                       'Trace = ',itrc, 'Pick = ',
     :                       nint(timeout)
                        
			go to 55   
                     endif
 45               enddo
c     
c     endif for all option
               endif
c===================================================================
c     Case 4  Where there are different picked events for each
c     record
c     in this case the traces will be interpolated for each record.
c===================================================================

               if (.not. all .and. .not. rec .and. .not.
     :              trace ) then
c===================================================================
c     first check to see if the record has its own pick
c===================================================================
c     Situation #1
c     get out if data beyond picks                  
                  if (irec .lt. nint(Record_Picks(1)) .or.
     :                 irec .gt.
     :                 nint(Record_Picks(icount)))
     :                 then
                     
                     go to 55
                     
                  endif
c-------------------------------------------------------------------
c     Situation #  ??

                  do 777 i = 1, NumSegs
                   
c     Check to see if the Input Record has its own pick
                     
                     if (irec .eq. nint(Record_Picks(Nstart(i))))
     :                    then
                   

c     Find the correct location of trace position
                        
                        do m = int(Nstart(i)),int(Nend(i))

c     Policeman

                           if (itrc .lt. Trace_Picks(Nstart(i))
     :                          .or. itrc .gt. Trace_Picks(Nend(i)))
     :                          then
                              go to 55
                           endif
                              
c     case where rec/trace has to be interpolated    
                         
                           if (irec .ge. nint(Record_Picks(m))
     :                          .and. irec .le.
     :                          nint(Record_Picks(m+1))) then

c========================================================================
                           
                            
                              if(itrc .ge. nint(Trace_Picks(m))
     :                             .and. itrc
     :                             .le. nint(Trace_Picks(m+1)))
     :                             then 

                                 call Pick_Interpolation(
     :                                Trace_Picks(m),
     :                                Trace_Picks(m+1),
     :                                Time_Picks(m),
     :                                Time_Picks(m+1),
     :                                float(itrc),timeout) 

                                 

cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,timeout, TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(timeout), TRACEHEADER)
                  endif

cmam                             call savew2(itr,ifmt_hdrwrd,
cmam :                                l_HdrWrd,
cmam :                                ln_HdrWrd,
cmam :                                nint(timeout),
cmam :                                TRACEHEADER)
                                  
                                 if(verbos)
     :                                write(LERR,*)'Record = ',irec,
     :                                'Trace = ',itrc, 'Pick = ',
     :                                nint(timeout)
                               
                                 go to 55
                              endif
                           endif
                               
                        enddo
                            
                     endif

c-------------------------------------------------------------------
c Since data does not have its own record picks we must interpolate
c but first find out where this rec/trace lies w/rt picked events
                         
c first check the counter

                     if (irec .gt. nint(Record_Picks(Nstart(i)))
     :                    .and. irec .lt.
     :                    nint(Record_Picks(Nstart(i+1))))
     :                    then

c     Now do the irregular grid  interpolation since we have found the
c     correct position

                        npick1 = Nend(i) - Nstart(i) + 1 
                        npick2 = Nend(i+1) - Nstart(i+1) +1 
                        imax = max0( npick1, npick2 )
                     
                        call Irregular_Grid_Interpolation(
     :                       irec,imax,
     :                       Nstart(i),Nstart(i+1),
     :                       Nend(i),Nend(i+1),
     :                       Record_Picks,Trace_Picks,
     :                       Time_Picks,
     :                       Trc_int, Tim_int, ntraces)
                        
                        do j = 1, ntraces
                           
                           if (itrc .eq. nint(Trc_int(j)))then
                              
cmam....determine if output header word if integer or float
                  if ((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :                (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
cmam........float or fake float word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,Tim_int(j), TRACEHEADER)
                  else
cmam........integer word
                     call savew2(itr,ifmt_hdrwrd,l_HdrWrd,
     :                   ln_HdrWrd,int(Tim_int(j)), TRACEHEADER)
                  endif

cmam                          call savew2(itr,ifmt_hdrwrd,
cmam :                             l_HdrWrd,
cmam :                             ln_HdrWrd,int(Tim_int(j)), 
cmam :                             TRACEHEADER)
                              
                              if(verbos) 
     :                             write(LERR,*)'Record = ',irec,
     :                             'Trace = ',itrc, 'Pick = ',
     :                             nint(Tim_int(j))
                              
                              go to 55
                           endif
                           
                        enddo
                        
                     endif
                     
 777              enddo
                  
c===================================================================
c     endif for .not. all

               endif

c===================================================================
c     write output data
c     StaCor endif

            ENDIF
            
 55         call wrtape (luout, itr, obytes)
c=================================================================== 
         
 800     ENDDO
      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'flatten: Normal Completion'
      write(LER,*)'flatten: Normal Completion'
      stop

c error messages

 990  continue

      write(lerr,*)' '
      write(lerr,*)' unable to open pickfile ',ptap(1:length)
      write(lerr,*)' check existence/spelling/permissions '
      write(lerr,*)' and try again'
      write(lerr,*)'FATAL '
      write(ler,*)' '
      write(ler,*)'FLATTEN:'
      write(ler,*)' unable to open pickfile ',ptap(1:length)
      write(ler,*)' check existence/spelling/permissions '
      write(ler,*)' and try again'
      write(ler,*)'FATAL '
      stop

999   continue
      
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'flatten: ABNORMAL Termination'
      write(LER,*)'flatten: ABNORMAL Termination'
      
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)'  '
      write(LER,*)'===================================================='
      write(LER,*)'  '
      write(LER,*)' Command Line Arguments for USP Program FLATTEN'
      write(LER,*)'  '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)'  '
      write(LER,*)'Input  ......................................  (def)'
      write(LER,*)'  '
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'I/O Options:'
      write(LER,*)'-N[]      -- input data set                  (stdin)'
      write(LER,*)'-O[]      -- output data set                (stdout)'
      write(LER,*)'-P[]      -- XSD pick file                    (none)'
      write(LER,*)'----------------------------------------------------'
      write(LER,*)'Program Options:'
      write(LER,*)'-si[si]   -- sample interval override (for xsd time '
cmam  write(LER,*)'-ps[iseg] -- single segment option: segment to use  '
cmam  write(LER,*)'                                 (def=1 units = 1.0)'
cmam  write(LER,*)'-S[nord]  -- length of smoother applied to picks (0)'
      write(LER,*)'-t[tflat] -- absolute flattening time for all events'
      write(LER,*)'             (floating datum)                    (0)'
      write(LER,*)'-sf[scl]  -- pick scale factor               ( 1.0 )'
      write(LER,*)'-Tw[trcwrd] or -tw[trcwrd]'
cmam  write(LER,*)'-Tw[itwd] or -tw[itwd]'
      write(LER,*)'     -- trace header mnemonic referenced    (TrcNum)'
      write(LER,*)'-Rw[recwrd] or -rw[recwrd]'
cmam  write(LER,*)'-Rw[irwd] or -rw[irwd]'
      write(LER,*)'     -- record header mnemonic referenced   (RecNum)'
      write(LER,*)'-Hw[hdrwrd] or -hw[hdrwrd]'
cmam  write(LER,*)'-Hw[ihwd] or -hw[ihwd]'
      write(LER,*)'     -- static header mnemonic referenced   (StaCor)'
      write(LER,*)'  '
      write(LER,*)'-stat     -- put picks into static words only'
      write(LER,*)'-A        -- apply designated pick segment to all'
      write(LER,*)'             records in the line.'
      write(LER,*)'-I        -- use single segment to apply to all the'
      write(LER,*)'             records in the line.'
      write(LER,*)'-rec      -- Data and picks are 1 Trace Multiple'
      write(LER,*)'                                   Records (Stack)'
      write(LER,*)'-trace    -- Data and picks are 1 Record Multiple'
      write(LER,*)'                                    Traces (Stack)'
      write(LER,*)'-V        -- verbose printout'
      write(LER,*)'  '
      write(LER,*)'===================================================='
      write(LER,*)'Usage:'
      write(LER,*)'  flatten -N[ntap] -O[otap] -P[picks] -si[]'
      write(LER,*)'            -Tw[] -Rw[] -Hw[] -t[] -sf[]'
cmam  write(LER,*)'           -ps[] -Tw[] -Rw[] -Hw[] -S[] -t[] -sf[]'
      write(LER,*)'            [-stat -A -I -rec -trace -V]'
      write(LER,*)'  '
      write(LER,*)'===================================================='
      write(LER,*)'  '
      return
       end

c -----------------  Subroutine -----------------------

c pick up command line arguments 
C**********************************************************************C
C     get command line parameters
C**********************************************************************C
  
      subroutine cmdln(ntap,otap,ptap,si,onepik,iseg,irwd,
     1 itwd,iswd,nord,tflat,verbos,stat,scl,hdrwrd,recwrd,
     2 trcwrd,all,rec,trace)
c----
c     get command arguments
c
c     ntap  - input file name
c     otap  - output file name
c    ptap   - name of xsd pick file
c      si   - sample interval override
c  onepik   - one segment flat
c    iseg   - for onepik: read this segment
c    irwd   - header word to use as record number
c    itwd   - header word to use as trace number
c    iswd   - static header word
c    nord   - nord-point smoother
c     scl   - static value scale factor
c   tflat   - optional time to flatten
c    put    - dump pick values into static word only
c    verbos - verbose output or not
c-----
#include <f77/iounit.h>

      integer     irwd,itwd,iseg,nord, argis
      real        tflat, scl,si
      character   ntap*(*),otap*(*),ptap*(*)
      character   recwrd*(*), trcwrd*(*), hdrwrd*(*)
      logical     verbos, onepik, stat, all
      logical     rec,trace
	iseg=1

      all    = ( argis ('-A') .gt. 0 )

      call argstr ('-Hw', hdrwrd , 'StaCor', 'StaCor' )
      call argstr('-hw', hdrwrd , hdrwrd, hdrwrd )
      call argstr('-HW', hdrwrd , hdrwrd, hdrwrd )

      call argstr ('-N', ntap, ' ', ' ' )
      call argstr ('-O', otap, ' ', ' ' )

      onepik = ( argis ('-I') .gt. 0 )
      if (all) onepik = .true.
	if(all .and. onepik) iseg=1

      call argstr ('-P', ptap, ' ', ' ' )

      if(ptap .eq. ' ') then
         write(LER,*)'You must enter an xsd pick filename'
         write(LER,*)'Put this in the command line -P[] entry'
         write(LER,*)'and rerun'
         stop
      endif

      rec   = ( argis ('-rec') .gt. 0 )
      call argstr ('-Rw', recwrd , 'RecNum', 'RecNum' )
      call argstr('-rw', recwrd , recwrd, recwrd )


      stat   = ( argis ('-stat') .gt. 0 )
      call argr4  ('-si',si,0.,0.)
      call argr4  ('-sf', scl,1.,1.)
      call argi4  ('-S',nord,0,0)



      trace   = ( argis ('-trace') .gt. 0 )
      call argstr ('-Tw', trcwrd , 'TrcNum', 'TrcNum' )
      call argstr('-tw', trcwrd , trcwrd, trcwrd )
      call argstr('-TW', trcwrd , trcwrd, trcwrd )
      call argr4  ('-t', tflat,-99999.,-99999.)


      if(ptap .eq. ' ') then
         write(LER,*)'You must enter an xsd pick filename'
         write(LER,*)'Put this in the command line -P[] entry'
         write(LER,*)'and rerun'
         stop
      endif

      verbos = ( argis ('-V') .gt. 0 )

      return
      end


c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


c===================================================================     
      subroutine verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform,
     :     ist, ptap, iend, irs, ire, verbos, si, onepik,iseg,irwd,
     :     tflat,stat,scl,hdrwrd,recwrd,trcwrd,all,rec,trace,
     :     ifmt_hdrwrd )
#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi
      integer    iseg

      character  ntap*(*), otap*(*), ptap*(*)
      character   hdrwrd * 6, recwrd * 6, trcwrd * 6


      logical    verbos,onepik,stat,all,rec,trace
      real       si,scl

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' input XSD pick file   =  ', ptap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*) ' Sample override         = ',si
      write(LERR,*) ' Scale Factor            = ',scl
      if (trace) then
         write(LERR,*) ' 1 Record Multiple Traces (stack)'
      endif
      if(rec) then
         write(LERR,*) ' 1 Trace Multiple Records (stack)'
      endif
      if (all) then
         write(LERR,*)' Apply one record pick to all records'
      endif
      if(onepik) then
         write(LERR,*)' One pick segment will be applied 
     :        to whole line'       
         write(LERR,*)' Pick segment to use      =  ',iseg
         endif
         if (stat) then
            write(LERR,*)'Put pick values into static word 
     :           only (no tflat)'
         endif


      write(LERR,*)' Record Word mnemonic in Header       =  ',recwrd
      write(LERR,*)' Trace  Word mnemonic in Header       =  ',trcwrd
      write(LERR,*)' Static Word mnemonic in Header       =  ',hdrwrd
         if((ifmt_hdrwrd .eq. SAVE_FLOAT_DEF) .or.
     :      (ifmt_hdrwrd .eq. SAVE_FKFLT_DEF)) then
            write(LERR,*)'    [',hdrwrd,' is stored as float]'
         else
            write(LERR,*)'    [',hdrwrd,' is stored as integer]'
         endif
      write(LERR,*)' ' 
      write(LERR,*)'========================================== '
      write(LERR,*)' '
         
      return
      end
