      subroutine spbl1(ns,ta,n2,sum,weight,iopt,ierr)
C ******************************************************************** C
C *                                                                  * C
C *   PROGRAM  - SPBL1                                               * C
C *   LANGUAGE - FORTRAN IV                                          * C
C *   AUTHOR   - RICHARD CRIDER                                      * C
C *   DATE WRITTEN - AUGUST,1982                                     * C
C *                                                                  * C
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C *                                                                  * C
C *   ABSTRACT -                                                     * C
C *      This routine computes the forward Fourier transform, the    * C
C *      amplitude spectrum, and does the running sum.               * C
C *                                                                  * C
C *   USAGE -                                                        * C
C *   call SPBL1(ns,ta,n2,sum,iopt,work arrays)                      * C
C *                                                                  * C
C *      ns - NUMBER OF POINTS TO BE TRANSFORMED.                    * C
C *      ta - DATA TO BE TRANSFORMED.                                * C
C *      n2 - LENGTH OF THE TRANSFORM.                               * C
C *     sum - SUMMING ARRAY.                                         * C
C *    iopt - AVERAGING FLAG:                                        * C
C *           0 = GEOMETRIC  1 = ARITHMETIC                          * C
C *    ierr - error flag (non-zero = fatal error)                    * C
C *                                                                  * C
C ******************************************************************** C
      real ta(*),sum(*)
#include <localsys.h>
#include <f77/lhdrsz.h>
      real work1(1), work2(1)
      POINTER (p1,work1),(p2,work2)
 
      n3=n2/2+1
      n4=n2+2
c +================================================+
c | Do forward transform and summing on input data |
c +================================================+
      ierr = 0
      iget =n4*ISZBYT
      call galloc(p1,iget,ierr,0)
      call galloc(p2,iget,ierr,0)
      if(ierr.ne.0)return
c +====================================+
c | Do the transform and scale by 1/2N |
c +====================================+
      do i=ns,n4
       work1(i)=0.
      end do
      do i=1,ns
       work1(i)=ta(i)
      end do
      call rfft(work1,n2,1)
      call rfftsc(work1,n2,3,1)
c +================================================+
c | Compute and sum the spectrum according to iopt |
c +================================================+
      call cvabs(work1,2,work2,1,n3)
      weight=0.
      do i=1,n3
       weight=weight+work2(i)
      end do
      weight = weight/float(n3)
	  if(iopt.ne.1)then
		call vlogz(work2,1,0.0,work1,1,n3)
		call vadd(work1,1,sum,1,sum,1,n3)
	  else
        call VADD(work2,1,sum,1,sum,1,n3)
	  endif
      call gfree(p1)
      call gfree(p2)
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       SPBL2                                                *
C  ROUTINE TYPE:  Subroutine                                           *
C  PURPOSE:  Compute the operator from the averaged sprectrum          *
C  ENTRY POINTS:                                                       *
C      SPBL2  (n2,sum,iopt,xn,opratr,work1,work2,work3)                *
C  ARGUMENTS:                                                          *
C      n2      integer  INPUT          - transform length              *
C      sum     real     INPUT   (1)    - summing buffer                *
C      iopt    integer  INPUT          - geometric or arithmetic       *
C                                        mean option (0 or 1)          *
C      xn      real     INPUT*         - scaler for sum = 1/ntraces.   *
C      opratr  real     OUTPUT*        - computed balancing operator   *
C      ierr    integer  OUTPUT*        - non-zero = fatal error        *
C  ROUTINES callED:                                                    *
C      vsmul  -                                                        *
C      vexp   -                                                        *
C      rfftsc -                                                        *
C      rffti  -                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
      subroutine spbl2(n2,sum,iopt,xn,opratr,ierr)
      real sum(*),opratr(*)
#include <localsys.h>
#include <f77/lhdrsz.h>
      real work1(1), work2(1), work3(1)
      POINTER (p1,work1),(p2,work2),(p3,work3)
C
      if (xn .eq. 0.) then
         call vclr (opratr, 1, n2)
         return
      endif

      n3=n2/2+1
      n4=n2+2
      ierr = 0
      xxn = 1./xn
      iget=n4*ISZBYT
      call galloc(p1,iget,ierr,0)
      call galloc(p2,iget,ierr,0)
      call galloc(p3,iget,ierr,0)
      if(ierr.ne.0)return
c +==============================================================+
c |   Clear the space used for data storage and transform, apply |
c |   the normalization.                                         |
c |   Inverse transform to get the balancing operator            |
c +==============================================================+
      do i=1,n4
       work1(i)=0.
      end do
      k=1
      do i=1,n3
       work1(k)=sum(i)*xxn
       k=k+2
      end do
      call vsmul(sum,1,xxn,work1,2,n3)
      if(iopt.ne.1)call vexp(work1,2,work1,2,n3)
c +=====================================================+
c | Pack the data for inverse transform with no scaling |
c +=====================================================+
      call rfftsc(work1,n2,-3,0)
c +===============================+
c | Inverse transform into opratr |
c +===============================+
      call rffti(work1,opratr,n2)

      call gfree(p1)
      call gfree(p2)
      call gfree(p3)
      return
      end
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       spbl3                                                *
C  ROUTINE TYPE:  Subroutine                                           *
C  PURPOSE:  Perform the balancing operation.                          *
C  ENTRY POINTS:                                                       *
C      SPBL3  (ns,ta,n2,opratr,work1,work2,work3)                      *
C  ARGUMENTS:                                                          *
C      ns      integer  input          - Trace length (samples)        *
C      ta      real     input   (1)    - Input data (windowed)         *
C                       output           Balanced data                 *
C      n2      integer  input          - Transform length              *
C      opratr  real     input   (1)    - Balancing operator.           *
C      ierr    integer  output         - non-zero = fatal error        *
C  ROUTINES callED:                                                    *
C      vmov   -                                                        *
C      rfftf  -                                                        *
C      rfftsc -                                                        *
C      cvabs  -                                                        *
C      vdivz  -                                                        *
C      cvmul  -                                                        *
C      rffti  -                                                        *
C***********************************************************************
      subroutine spbl3(ns,ta,n2,opratr,weight,scale,ierr)
      real ta(*),opratr(*)
      real weight,sinker
      logical scale
      real work1(1), work2(1),work3(1),work4(1)
      POINTER (p1,work1),(p2,work2),(p3,work3),(p4,work4)
#include <localsys.h>
#include <f77/lhdrsz.h>
C
      n3=n2/2+1
      n4=n2+2
c +=========================================+
c | Work with double length transforms to   |
c | prevent convolutional wrap, which could |
c | be disastrous                           |
c +=========================================+
      n2d = n2 * 2
      n3d = n2d/2+1
      n4d = n2d + 2
      n2h = n2 / 2
c +======================================+
c | Compute the scalar for the transform |
c | the scalar is 1/2N.                  |
c +======================================+
      scalr = 1./(2.*float(n2d))
c +======================================+
c | Clear area to transform the operator |
c +======================================+
      ierr=0
      iget=n4d*ISZBYT
      call galloc(p1,iget,ierr,0)
      call galloc(p2,iget,ierr,0)
      call galloc(p3,iget,ierr,0)
      call galloc(p4,iget,ierr,0)
      if(ierr.ne.0)return
      do i=n3,n2d
       work1(i)=0.
      end do
c +================================================+
c | Separate the operator in the 2X trasnform area |
c +================================================+
      do i=1,n3
       work1(i)=opratr(i)
      end do
      call vmov(opratr(n2),-1,work1(n2d),-1,n2h)
c +================================================+
c | Transform the operator, unpack with no scaling |
c | and compute amplitude spectrum                 |
c +================================================+
      call rfftf(work1,work2,n2d)
      call rfftsc(work2,n2d,3,0)
	  call cvabs(work2,2,work4,1,n3d)
c +====================================================+
c | Transform the data trace, unpack with 1/4N scaling |
c | and compute amplitude spectrum                     |
c +====================================================+
      do i=ns,n2d
       work1(i)=0.
      end do
      do i=1,ns
       work1(i)=ta(i)
      end do
      call rfftf(work1,work3,n2d)
      call rfftsc(work3,n2d,3,0)
      call cvabs(work3,2,work1,1,n3d)
c +========================================================+
c |    work2 now contains the transform of the operator    |
c |    work4 now contains the amp spectrum of the operator |
c |    work3 contains the transform of the data            |
c |    work1 contains the amplitude spectrum of the data   |
c +========================================================+
c +===================================================================+
c |    Do the balancing act:                                          |
c |  -Divide the trace transform by the trace amplitude spectrum      |
c |    to remove the input spectrum                                   |
c |  -Multiply the operator and trace transforms (zero-phase convolve)|
c |  -Multiply by the equalizing scalar (for extra xform length)      |
c +===================================================================+
      call vdivz(work3(1),2,work1,1,0.0,work3(1),2,n3d)
      call vdivz(work3(2),2,work1,1,0.0,work3(2),2,n3d)
      call cvmul(work3,2,work2,2,work3,2,n3d,1)
      call vmul(work3,1,scalr,0,work3,1,n4d)
      if(scale)then
       j=1
       k=2
       sinker=0.
       do i=1,n4d,2
        a = work3(j)
        b = work3(k)
        j=j+2
        k=k+2
        ss=sqrt(a*a+b*b)
        sinker = sinker+ss
       end do
       sinker=sinker/float(n3d)
       weight = 0.5*weight/sinker
       call vmul(work3,1,weight,0,work3,1,n4d)
      endif
      call rfftsc(work3,n2d,-3,0)
      call rffti(work3,work1,n2d)
c +=======================================+
c | Put the balanced data into the output |
c +=======================================+
      do i=1,ns
       ta(i)=work1(i)
      end do

      call gfree(p1)
      call gfree(p2)
      call gfree(p3)
      call gfree(p4)
      return
      end
