C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln ( ntap, otap, qctap, cardin, verbos,lucrd,
     *qflag)
c     FORTRAN by M. A. Miller   4-14-89
c     Modified by R. L. Crider 4-27-90
c     further hacked by Gutowski 8-6-90
c
c     this routine processes the command line arguments for use in
c     program FXDC on SUN.
c
#include <f77/localsys.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer lucrd
      integer argis
 
      character ntap*(*), otap*(*), cardin*(*), qctap*(*)

      logical     verbos, qflag, there
 
      verbos = .false.
 
      verbos = (argis('-V') .gt. 0)

      call argstr ('-N',ntap,' ',' ')
      if(verbos) write(LERR,*)' ntap as read=',ntap

      call argstr ('-O',otap,' ',' ')
      if(verbos) write(LERR,*)' otap as read=',otap

      qflag = .false.
      qctap = ' '
      call argstr('-Q', qctap,' ',' ')
      if(qctap(1:1).ne.' ')qflag = .true.
      if(verbos.and.qflag) then
         write(LERR,*)' QC output requested'
         write(LERR,*)' Output file is ',qctap
      endif

      call argstr ('-D',cardin,' ',' ')
      if(verbos) write(LERR,*)' cardin as read=',cardin

      call noblnk(cardin,lc)
      if(cardin(1:1) .ne. ' ') then
         inquire(file = cardin, exist = there)
         if(.not.there)then
            write(LERR, '(3a)')'   File ',cardin,' not found.'
            call ccexit (100)
         endif
         if(verbos) write(LERR,*)' open(unit=LUCRD, file=cardin) '
         open(unit=lucrd, file=cardin, status='old',
     *        form='formatted',access='sequential')
         rewind (lucrd)
      else
         write(LERR,*)' '
         write(LERR,*)' Using command line input'
         write(LERR,*)' '
      endif

      return
      end
      subroutine fptoi (i2,r4,ns,itt)
#include <f77/iounit.h>
      INTEGER*2 i2(*)
      integer ns, itt, i
      real r4(*)
      do 10 i = 1,ns
      i2(i) = ifix(r4(i))
   10 continue
      return
      end
      subroutine itofp (i2,r4,ns)
#include <f77/iounit.h>
      INTEGER*2 i2(*)
      integer ns, i, ival
      real r4(*)
      do 10 i = 1,ns
      ival = i2(i)
      r4(i) = float(ival)
   10 continue
      return
      end
      subroutine power2(nsmp,n,nn,lup,ier)
      n = 64
  100 n = n + n
      if (n.lt.nsmp)go to 100
	  nn = n/2+1
	  return
	  end
 
 
      subroutine cmdln1(ldsign,loper,lsovlp,lwndw,
     1             ltovlp,if1,if2,pcnt,pw,imute,mode)
c-----
c     get command arguments
c
c    ldsign - I         length in traces of design window
c     loper - I         length in traces of operator
c    lsovlp - I         % spatial overlap
c     lwndw - I         length in ms of time wind (pwr of 2)
c    ltovlp - I         % temporal window overlap
c  if1, if2 - I         low & hi pass freqs
c       pw  - R         % prewhitening
c    imute  - I         preserve early mute:  0=yes; 1=no
c     mode  - I         processing mode flag
c                       0=line sequential; 1=record sequential
c     pcnt  - R         % original data to add back to output
c-----
#include <f77/iounit.h>
 
      integer   ldsign,loper,lsovlp,lwndw,ltovlp,if1,if2
      integer   imute,mode
      real      pw,pcnt
 
      call argi4('-d',ldsign,0,0)
      call argi4('-o',loper,0,0)
      call argi4('-sp',lsovlp,50,50)
      call argi4('-w',lwndw,0,0)
      call argi4('-tp',ltovlp,50,50)
      call argi4('-fl',if1,0,0)
      call argi4('-fh',if2,0,0)
      call argr4('-pw',pw,0.,0.)
      call argi4('-im',imute,1,1)
      
      call argi4('-md',mode,0,0)
      call argr4('-pc',pcnt,0.,0.)
      
 
      return
      end
 
      subroutine help
#include <f77/iounit.h>
 
         write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'execute fxdecon by typing fxdecon and list of program parameters'
      write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     1'a character(s) corresponding to some parameter.'
       write(LER,*)' '
        write(LER,*)
     1'users enter the following parameters, or use the default values'
        write(LER,*)
     1' -N [ntap]    (default = stdin)    : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout )  : output data file name'
        write(LER,*)
     1' -Q [qctap]   (no file)            : QC data file name'
        write(LER,*)
     1' -D [cardin]  (default = cmd line  : optional card file'
       write(LER,*)' '
        write(LER,*)
     1' -d [ldsign]  (def = 15)      : length in traces of design window
     2'
        write(LER,*)
     1' -o [loper]   (def = ldsign/2): length in traces of operator'
        write(LER,*)
     1' -sp [lsovlp] (def = 50)      :  % spatial partition overlap'
        write(LER,*)
     1' -w [lwndw]   (def = trace)   : length (ms) of temporal window'
        write(LER,*)
     1' -tp [ltovlp] (def = 50)      :  % temporal window overlap'
        write(LER,*)
     1' -pw [pw]     (def = 0)       : % prewhitening (max = 50 %)'
        write(LER,*)
     1' -im [imute]  (def = 1)       : preserve early mute 0=yes, 1=no'
        write(LER,*)
     1' -md [mode]   (def = 0)       : 0=line sequential; 1=record seque
     2ntial'
        write(LER,*)
     1' -pc [pcnt]   (default = 0)   : % original data to add back to ou
     2tput'
        write(LER,*)
     1' -fl [if1] -fh [if2] (defs= 0, nyquist): lo & hi cut frequencies'
       write(LER,*)
     1' -V          verbose printout flag'
       write(LER,*)' '
       write(LER,*)
     1'usage:   fxdecon -N[ntap] -O[otap] -Q[qctap] -D[cardin] -V'
       write(LER,*)
     1'                 -d[] -o[] -sp[] -w[] -tp[] -fl[] -fh[] -pw[]'
       write(LER,*)
     1'                 -im[] -md[] -pc[]'
         write(LER,*)
     1'***************************************************************'
 
      return
      end
c 
      subroutine riprt(ir, lu)
      integer ir, lu,ris(20)
      integer cnt
      data cnt/0/
      SAVE cnt, ris
      cnt = cnt + 1
      write(lu,*)'ri= ',ir
      if(cnt.le.20)then
       ris(cnt) = ir
       if(cnt.eq.20)then
        write(lu,100)(ris(k),k=1,cnt)
  100   format(' RIs PROCESSED', 20i5)
        cnt = 0
       endif
      endif
      return
      entry ripclr(lu)
      if(cnt.gt.0) write(lu,100)(ris(k),k=1,cnt)
      return
      end
