C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE GASP
C
C**********************************************************************C
c
c Changes:
c
c Sept/97:  added -hw option to allow storage of gasp scalar tracewise
c           which allows later removal...requested by Joel Greer [GUPCO]
c Garossino
c
c
c July/95   fixed average record constant scaling option to account for
c           dead traces
c Garossino
c
c
C
C GASP READS SEISMIC TRACE DATA FROM AN INPUT FILE;
C APPLIES JOB, record OR TRACE CONSTANT SCALING BASED
C ON AVERAGE ABSOLUTE AMPLITUDES WITH MEAN SCALING,
C OR ON MAXIMUM ABSOLUTE AMPLITUDES; AND
C WRITES THE RESULTS TO AN OUTPUT FILE

c - if record constant scaling the scaling coefficient is recorded 
c   in an attached coefficients file for later removal/reapplication

c - window start and end time for scaler derivation may be supplied 
c   on the command line or come with the data in user defined trace
c   header locations
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h> 
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr ( SZLNHD )
      integer     irs, ire, nrec, nreco, ntrc, nsamp, nsi, iform
      integer     luin, luout, argis, JJ, KK, LL
      integer     lbytes, lbyout, nbytes

      real        tri( SZLNHD )

      character   name*4, ntap*255, otap*255

      logical     verbos

c declare variables used with dynamic memory allocation
      
      integer     CoefRecord, errcdCR, errcdCS, errcod, abort
      integer     item, itemi, items, itemr, itrhd

      real        sum, recmax, wrk
      real        recs, CoefScalar

      pointer     (wkitrhd, itrhd(1))
      pointer     (wkwrk, wrk(1))
      pointer     (wksum, sum(1))
      pointer     (wkrec, recmax(1))
      pointer     (wkaddr, recs(1))
      pointer     (wkaddCR, CoefRecord(100000))
      pointer     (wkaddCS, CoefScalar(100000))

      logical     heap, heaps

c declare program dependant variables

      integer  msi, window, index, lucoef, NumLiveTraces, nwnd, ismp
      integer  startw, stopw, method, type, ii
      integer  istrc, ishdr
      integer  RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer  TrcNum, l_TrcNum, ln_TrcNum, ifmt_TrcNum
      integer  StaCor, l_StaCor, ln_StaCor, ifmt_StaCor
      integer  DstSgn, l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer  Wrd1, l_Wrd1, ln_Wrd1, ifmt_Wrd1
      integer  Wrd2, l_Wrd2, ln_Wrd2, ifmt_Wrd2
      integer  l_WrdScl, ln_WrdScl, ifmt_WrdScl

      real  t0, atest, sum1, wndw, percnt
      real  maxval, scalar, amax, samp, fac, fact, recscl

      character  coeftap*255, c_Wrd1*6, c_Wrd2*6, c_WrdScl*6

      logical  meth, type1, type2, max, med, dead, remove, coef

c initialize variables

      data name / 'GASP' /
      data amax/2047.0/
      data e/ 1.0e-30 /
      data dead/.false./
      data remove/.false./
      data coef/.false./
      data type2/.false./
      data abort /1/

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 )then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c read command line parameters

      call cmdln ( ntap, otap, percnt, startw, stopw, irs, ire, type1, 
     :     type2, meth, verbos, med, ivel, coeftap, remove, coef,  
     :     c_Wrd1, c_Wrd2, c_WrdScl )

C Type scaling (0=TRACE,1=JOB,2=RECORD)

        type = 0
c if using application from coefficients file then force gasp to run in
c record constant mode

        if ( coef ) type2 = .true.

        if ( type1 )  then
           type = 1
        elseif( type2 ) then 
           type = 2
        endif


        if ( meth ) then
           method = 0
        elseif ( med ) then
           method = 2
        else
           method = 1
        endif

c---------------------------
c  bomb off for job
c  constant scale with pipes
c---------------------------
        if (ntap(1:1) .eq. ' ' .and. type1) then
           write(LERR,*)'Cannot pipe into gasp using job constant'
           write(LERR,*)'option (you can with rec or trc const).'
           write(LERR,*)'Write data to a disk file and use -N[]'
           write(LERR,*)'command line entry for input data set name'
           write(LER,*)'Cannot pipe into gasp using job constant'
           write(LER,*)'option (you can with rec or trc const).'
           write(LER,*)'Write data to a disk file and use -N[]'
           write(LER,*)'command line entry for input data set name'
           goto 999
        endif

c echo parameters to printout file

        write(LERR,*) ' '
        write(LERR,*) 'Command Line Parameters'
        write(LERR,*) '-----------------------'
        write(LERR,*) 'Input data = ', ntap
        write(LERR,*) 'Scale %                          =  ',percnt
        write(LERR,*) 'Start time of window             =  ',startw
        write(LERR,*) 'Stop time of window              =  ',stopw
        write(LERR,*) 'Scaling type (0=Max,1=Avg,2=Med) =  ',method
        write(LERR,*) 'Type scaling (0=TR,1=JOB,2=REC)  =  ',type
        if ( coef ) 
     :       write(LERR,*) 'Applying gain from coefficients file'
        if ( c_Wrd1 .ne. ' ' ) then
           write(LERR,*)'Window start time from header entry ',
     :          c_Wrd1
        endif
        if ( c_Wrd2 .ne. ' ' ) then
           write(LERR,*)'Window end time from header entry ',
     :          c_Wrd2
        endif
        if ( c_WrdScl .ne. ' ' ) then
           write(LERR,*)'Trace Scalar associated with header entry ',
     :          c_WrdScl
        endif

c open input and output datasets

      call getln( luin, ntap, 'r', 0)
      call getln(luout, otap, 'w', 1)

c create pointers for required trace header variables

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)

      if ( c_Wrd1 .ne. ' ' )
     :     call savelu(c_Wrd1,ifmt_Wrd1,l_Wrd1,ln_Wrd1,TRACEHEADER)
      if ( c_Wrd2 .ne. ' ' )
     :     call savelu(c_Wrd2,ifmt_Wrd2,l_Wrd2,ln_Wrd2,TRACEHEADER)
      if ( c_WrdScl .ne. ' ' ) then
         call savelu(c_WrdScl,ifmt_WrdScl,l_WrdScl,ln_WrdScl,
     :        TRACEHEADER)
         if ( ifmt_WrdScl .ne. SAVE_FKFLT_DEF ) then
            write(LERR,*)' '
            write(LERR,*)' You have asked to store your scalar '
            write(LERR,*)' in a header value that is not '
            write(LERR,*)' appropriate.  Use a floating'
            write(LERR,*)' point assignment such as Horz01 or '
            write(LERR,*)' you may not be able to remove or reapply '
            write(LERR,*)' this scaling '
            write(LERR,*)'WARNING'
            write(LER,*)' '
            write(LER,*)'GASP: '
            write(LER,*)' You have asked to store your scalar '
            write(LER,*)' in a header value that is not '
            write(LER,*)' appropriate.  Use a floating'
            write(LER,*)' point assignment such as Horz01 or '
            write(LER,*)' you may not be able to remove or reapply '
            write(LER,*)' this scaling '
            write(LER,*)'WARNING'
            write(LER,*)' '
         endif
      endif

c open coefficients file if record constant option is requested

      if(type2)then
         call alloclun(lucoef)
         lecoeftap = lenth(coeftap)
	 if (lecoeftap .eq. 0) go to 990
         
         if ( remove .and. ( c_WrdScl .eq. ' ')  ) then
            open(unit=lucoef,file=coeftap(1:lecoeftap),status='old',
     :           err=990)
         else
            open(unit=lucoef,file=coeftap(1:lecoeftap),status='unknown',
     :           err=990)
         endif
      endif

c read input line header

      lbytes = 0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)' '
         write(LERR,*)'GASP: no line header on input file ',ntap
         write(LERR,*)'FATAL'
         write(LER,*)' '
         write(LER,*)'GASP: no line header on input file ',ntap
         write(LER,*)'FATAL'
         goto 999
      endif

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'              Historical Line Header '
      write(LERR,*)'              ---------------------- '
      write(LERR,*)' '

c print historical line header to printout file

      call hlhprt( itr , lbytes, name, 4, LERR )

c get global parameters from line header      

      call saver( itr, 'NumSmp', nsamp , LINHED)
      call saver( itr, 'SmpInt', nsi   , LINHED)
      call saver( itr, 'NumTrc', ntrc  , LINHED)
      call saver( itr, 'NumRec', nrec  , LINHED)
      call saver( itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c echo to printout file

      write(LERR,*)
      write(LERR,*)'Values from Lineheader'
      write(LERR,*) 'No. of Records         =  ',nrec
      write(LERR,*) 'No. of Traces per Record =',ntrc
      write(LERR,*) 'No. of Samples per Trace =',nsamp
      write(LERR,*) 'Sample interval          =',nsi
      write(LERR,*) 'Format                   =',iform


c-------------------------------------
c  if we choose rec const scaling
c  we can handle pipes but that 
c  requires reading recs into an array
c  if so:
c  malloc only space we're going to use
c-------------------------------------

      IF (type2) THEN
         
         heap  = .true.
         item  = ntrc * nsamp
         itemt = nsamp
         itemi = ntrc * ITRWRD
         
c if record too large don't malloc if we're piping

         if (item .gt. 4000000 .and. luin .eq. 0) then
            write(LERR,*)' '
            write(LERR,*)'GASP: number traces/rec x number samps/trc= ',
     :           item,' > limit of 4000000'
            write(LERR,*)'      You cannot use pipes. Write data to '
            write(LERR,*)'      disk before using gasp'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'GASP: number traces/rec x number samps/trc= ',
     :           item,' > limit of 4000000'
            write(LER,*)'      You cannot use pipes. Write data to '
            write(LER,*)'      disk before using gasp'
            write(LER,*)'FATAL'
            goto 999
         endif
         
         if (item .le. 4000000) then
            call galloc (wkitrhd, itemi*SZSMPD, errcod, abort)
            if (errcod .ne. 0) heap = .false.
            call galloc (wkaddr, item*SZSMPD, errcod, abort)
            if (errcod .ne. 0) heap = .false.
         else
            write(LERR,*)'number traces/rec x number samps/trc= ',
     1           item,' > limit of 4000000'
            write(LERR,*)'number traces/rec x number samps/trc= ',
     1           item,' > limit of 4000000'
            write(LERR,*)'Bypassing memory allocation step. Will'
            write(LERR,*)'rewind data set instead to apply scaling'
            heap = .false.
            go to 11
         endif
         
         if (.not. heap) then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate memory:'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'GASP: Unable to allocate memory:'
            write(LER,*) item*SZSMPD,'  bytes'
            write(LER,*)' '
            go to 999
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating memory'
            write(LERR,*) item*SZSMPD,'  bytes'
            write(LERR,*)' '
         endif
      ENDIF

 11   continue

c-------------
c  malloc vectors for storing scale factors
c  size will depend on if we have piping or
c  not, or if we do trc, rec, or job const
c-------------

      if (type .eq. 0) then
         items = 1
         itemr = 1
      elseif (type .eq. 1) then
         items = ntrc * nrec
         itemr = 1
      elseif (type .eq. 2) then
         items = ntrc
         itemr = nrec
      else
         write(LERR,*)'GASP: No scaling type given'
         write(LERR,*)'      Check command line arguments'
         write(LERR,*)'FATAL'
         goto 999
      endif

      heaps = .true.

      call galloc (wkwrk, itemt * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
      call galloc (wksum, items * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.
      call galloc (wkrec, itemr * SZSMPD, errcod, abort)
      if (errcod .ne. 0) heaps = .false.

      if (.not. heaps) then
         write(LERR,*)' '
         write(LERR,*)'Gasp: Unable to allocate memory'
         write(LERR,*) itemt*SZSMPD,'  bytes'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Gasp: Unable to allocate memory'
         write(LER,*) itemt*SZSMPD,'  bytes'
         write(LER,*) items*SZSMPD,'  bytes'
         write(LER,*) itemr*SZSMPD,'  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Gasp: Allocating memory'
         write(LERR,*) items*SZSMPD,'  bytes'
         write(LERR,*) itemr*SZSMPD,'  bytes'
         write(LERR,*)' '
      endif

c determine windowing parameters

      t0 = startw
      msi = nsi

         samp = float(nsi) * unitsc
         startw = startw / nsi + 1 
         stopw = stopw/nsi + 1
         if ( stopw .le. 1 .or. stopw .gt. nsamp ) stopw = nsamp

      window = stopw -  startw +  1
      fac = amax *  percnt / 100.

      if ( ire .eq. 0 ) ire = nrec
      if ( irs .eq. 0 ) irs = 1
      if ( irs .gt. ire) then
         write(LERR,*)' '
         write(LERR,*)'GASP: Start record ', irs,' is greater than'
         write(LERR,*)'      end record ',ire
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'GASP: Start record ', irs,' is greater than'
         write(LER,*)'      end record ',ire
         write(LER,*)'FATAL'
         write(LER,*)' '
         goto 999
      endif

c update and output line header 

      nreco = ire -irs + 1
      call savew( itr, 'NumRec', nreco , LINHED)
      call savhlh( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c skip to start record

      call recskp( 1, irs-1, luin, ntrc, itr )

      IF ( remove .or. coef ) then

c Scaling using Coefficients File or from header entry if WrdScl .ne. ' '
c read and sort data from coefficients file and apply or remove 
c scaling as requested

         if ( c_WrdScl .eq. ' ' ) then

            

            call CoefCount ( lucoef, Ncoef )

c allocate dynamic memory for coefficients data

            call galloc ( wkaddCR, Ncoef * SZSMPD, errcdCR, abort)
            call galloc ( wkaddCS, Ncoef * SZSMPD, errcdCS, abort)

            if ( errcdCR .ne. 0 .or. errcdCS .ne. 0 ) then
               write(LERR,*)' '
               write(LERR,*)'Unable to allocate data record space:'
               write(LERR,*) item*SZSMPD,'  bytes'
               write(LERR,*)' '
               write(LER,*)' '
               write(LER,*)'Unable to allocate data record space:'
               write(LER,*) item*SZSMPD,'  bytes'
               write(LER,*)' '
               go to 999
            else
               write(LERR,*)' '
               write(LERR,*)'Allocating data record space:'
               write(LERR,*) item*SZSMPD,'  bytes'
               write(LERR,*)' '
            endif
          
            call ReadCoef ( lucoef, Ncoef, CoefRecord, CoefScalar )
            if ( Ncoef .gt. 1 ) call hsrti2 ( Ncoef, CoefRecord, 
     :           CoefScalar )

         endif

         DO JJ = 1, nreco
            DO KK = 1,ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  go to 999
               endif

               call vmov (ITR(ITHWP1), 1, tri, 1, nsamp)

               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )

               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
               else

c get scalar from coefficients file or header as required

                  if ( c_WrdScl .eq. ' ' ) then
                     call GetScalar ( RecNum, Ncoef, CoefRecord, 
     :                    CoefScalar, scalar )
                  else
                     call saver2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                    ln_WrdScl, scalar, TRACEHEADER )
                  endif

c scale data as required

                  if ( remove ) then 
                     do LL = 1,nsamp
                        tri(LL) = tri(LL)/scalar
                     enddo
                  else
                     do LL = 1,nsamp
                        tri(LL) = tri(LL) * scalar
                     enddo
                  endif
               endif
               
               call vmov (tri, 1, itr(ITHWP1), 1, nsamp)

c load scalar to trace header if requested

               if ( c_WrdScl .ne. ' ' )  
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, scalar, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
               
            ENDDO
         ENDDO

         call lbclos ( luin )
         call lbclos ( luout)
         if(type2) close(lucoef)
         write(LERR,*)'GASP: Normal Termination'
         write(LER,*)'GASP: Normal Termination'
         stop
         
      ENDIF

c Trace Constant Scaling

      IF ( type .eq. 0 ) then

         DO JJ = 1, nreco
            DO KK = 1, ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  go to 9100
               endif

               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
                  dead = .true.
               else
                  dead = .false.
               endif

               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               DstSgn = iabs (DstSgn)
               if (ivel .ne. 99999) then
                  startw = 1 + tmute(int(t0),ivel,DstSgn,msi,unitsc)
               endif

c pick up window start and/or  end for this trace from the trace header
c if requested

               if ( c_Wrd1 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1, 
     :                 TRACEHEADER )
                  startw = nint ( float(Wrd1) / float(nsi) ) + 1
               endif
               if ( c_Wrd2 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2, 
     :                 TRACEHEADER )
                  stopw = nint ( float(Wrd2) / float(nsi) ) + 1
                  if ( stopw .le. 1 .or. stopw .gt. nsamp )stopw = nsamp
               endif

               if (startw .gt. nsamp) startw = nsamp
               window = stopw - startw + 1

               IF ( method .eq. 1 ) then

C Average Absolute Amplitude with mean scaling

                  call svemg (tri(startw), 1, maxval, window )
                  if ( abs (maxval) .lt. e ) maxval = 1.0
                  atest = alive(tri(startw),window,1.0e-20)
                  fact = fac * atest / ( maxval + e )
                  call vsmul (tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )
                  
               ELSEIF ( METHOD .EQ. 0 )  THEN

C Maximum Absolute Amplitude scaling
                      
                  call maxmgv (tri(startw), 1, maxval, index, window)
                  if (  maxval .lt. e ) maxval  = 1.0
                  fact= fac / ( maxval + e )
                  call vsmul  (tri, 1, fact, itr(ITHWP1), 1, nsamp )
c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )

               ELSEIF ( METHOD .eq. 2  )  THEN

C Maximum Absolute Amplitude scaling on nonzero samples (zprg03)

                  ii = 0
                  do  i = startw, stopw
                      trii = tri(i)
                      if (trii .ne. 0.0) then
                         ii = ii + 1
                         wrk(ii) = trii
                      endif
                  enddo
                  maxval = 0.
                  if (ii .gt. 2) then
                     call medmad (wrk, ii, maxval)
                     maxval = abs(maxval)
                  endif
                  if (  maxval .lt. e ) maxval  = 1.0
                  fact= fac / ( maxval + e )
                  call vsmul  (tri, 1, fact, itr(ITHWP1), 1, nsamp )
c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' )
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl,
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape ( luout, itr, nbytes )

                  
               ENDIF

               if(verbos) then
                  write(LERR,*)'Record= ',RecNum,'  Trace= ',
     1                 TrcNum,'  Scale factor= ',fact
               endif

            ENDDO
         ENDDO

 9100    continue

C**********************************************************************C
C
C     READ TRACES, COMPUTE JOB AND RECORD CONSTANT SCALE FACTORS
C     type = 1   --  job
C     type = 2   --  rec:  in this case if we're piping or if records
C                          are not too large we can deal with them
C                          without rewinding the disk file
C
C**********************************************************************C

      ELSEIF ( TYPE .GE. 1 )  THEN

         NumLiveTraces = 0
         recscl = 0.
         nwnd = 0

         DO 200 JJ = 1, nreco

            if (type .eq. 2) then
               NumLiveTraces = 0
               recscl = 0.
               nwnd = 0
            endif

            DO 210 KK = 1, ntrc

               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature End of file on input'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  go to 9200
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )
               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )

               if (StaCor .eq. 30000) then
                  call vclr (tri, 1, nsamp)
                  dead = .true.
               else
                  dead = .false.
                  NumLiveTraces = NumLiveTraces + 1
               endif

               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )
               DstSgn = iabs (DstSgn)
               if (ivel .ne. 99999) then
                  startw = 1 + tmute(int(t0),ivel,DstSgn,msi,unitsc)
               endif

c pick up window start and/or  end for this trace from the trace header
c if requested

               if ( c_Wrd1 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd1, l_Wrd1, ln_Wrd1, Wrd1, 
     :                 TRACEHEADER )
                  startw = nint ( float(Wrd1) / float(nsi) ) + 1
               endif
               if ( c_Wrd2 .ne. ' ' ) then
                  call saver2 ( itr, ifmt_Wrd2, l_Wrd2, ln_Wrd2, Wrd2, 
     :                 TRACEHEADER )
                  stopw = nint ( float(Wrd2) / float(nsi) ) + 1
                  if ( stopw .le. 1 .or. stopw .gt. nsamp )stopw = nsamp
               endif

               if (startw .gt. nsamp) startw = nsamp
               window = stopw - startw + 1
               
               if (TYPE .eq. 2 .AND. heap) then
                  ishdr = (kk-1) * ITRWRD
                  call vmov (itr, 1, itrhd(ishdr+1), 1, ITRWRD)
                  istrc = (kk-1) * nsamp
                  call vmov (tri, 1, recs(istrc+1), 1, nsamp)
               endif

c find # live samps in window

               ismp = 0

               do ii = 1, window
                  if ( abs(tri(startw+ii-1) ).gt. 1.e-32 ) then
                     ismp = ismp + 1
                  endif
               enddo

               nwnd = nwnd + ismp

               IF ( method .eq. 1 ) then

C Average Absolute Amplitude with mean scaling

                  call svemg   ( tri(startw), 1, sum1, window )
                  if (ismp .ne. 0) recscl = recscl + sum1 / float(ismp)

               ELSEIF ( method .eq. 2 .and. .not. dead ) then

C Median Amplitude scaling

                  call svemg   ( tri(startw), 1, maxval, window )

                  if ( ismp .ne. 0 ) then
                     sum(NumLiveTraces) = maxval / float(ismp)
                  else
                     write(LERR,*)'GASP: Unflagged dead trace found '
                     write(LERR,*)'      at record ',RecNum,' trace '
     :                    ,kk
                     write(LERR,*)'WARNING'
                     sum(NumLiveTraces) = 0.0
                  endif

               ELSEIF ( METHOD .EQ. 0   )  THEN

C Maximum Absolute Amplitude scaling

                  call maxmgv (tri(startw), 1, maxval, index, window)
                  recscl = MAX (recscl, maxval)
               ENDIF
 210        CONTINUE

c-----
c    for rec or trace constant scaling we've now read in a whole
c    record (trace). If it's all dead just output the dead object
c    and then skip to the end of the read record loop
c-----
            if ((NumLiveTraces .eq. 0) .AND. type .gt. 1 ) then

c write out dead record

               DO KK = 1, ntrc
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (recs(istrc+1),1,itr(ITHWP1),1,nsamp)
                  call vmov (itrhd(ishdr+1), 1, itr, 1, ITRWRD)
                  call wrtape (luout, itr, nbytes)
               ENDDO

c if we do last record we're finished

               if (JJ .eq. nreco) then
                  write(LERR,*)'GASP: processed ',nreco,' records'
                  call lbclos ( luin )
                  call lbclos ( luout)
                  if(type2) close(lucoef)
                  write(LERR,*)'GASP: Normal Termination'
                  write(LER,*)'GASP: Normal Termination'
                  stop
               endif

               goto 200

            endif
C**********************************************************************C
C
C For record constant (type = 2) scaling compute scaling factors
c method
c      0 = maximum
c      1 = average 
c      2 = median
C
C**********************************************************************C

            IF (type .eq. 2) THEN
               
               if ( method .eq. 0 ) then
                  fact = fac / ( recscl + e )
               elseif (method .eq. 1) then
                  fact = fac * float(NumLiveTraces) / ( recscl + e)
               elseif ( method .eq. 2 ) then
                  call medmad ( sum, NumLiveTraces, recscl )
                  fact = fac / ( recscl + e )
               endif
               
               recmax(JJ) = fact

            ENDIF

c-------------
c  if we can store each record in memory
c  we can apply current scale factor &
c  write out data
c-------------

            IF (type .eq. 2 .and. heap) then

               if ( verbos ) then
                  if ( method .eq. 0 ) then
                     write(LERR,*)'Record= ',RecNum,' maa scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  elseif ( method .eq. 1 ) then
                     write(LERR,*)'Record= ',RecNum,' aaa scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  elseif ( method .eq. 2 ) then
                     write(LERR,*)'Record= ',RecNum,' med scaler= ',
     :                    fact,' live trcs= ',NumLiveTraces
                  endif
               endif

c write out scale factor for record

               write(lucoef,*) float(RecNum), fact

c scale record

               call vsmul (recs, 1, fact, recs, 1, nsamp*ntrc)

c write out scaled record

               DO KK = 1, ntrc
                  istrc = (kk-1) * nsamp
                  ishdr = (kk-1) * ITRWRD
                  call vmov (recs(istrc+1),1,itr(ITHWP1),1,nsamp)
                  call vmov (itrhd(ishdr+1), 1, itr, 1, ITRWRD)

c if user has requested, place scalar in trace header for later use

                  if ( c_WrdScl .ne. ' ' ) 
     :                 call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :                 ln_WrdScl, fact, TRACEHEADER )

                  call wrtape (luout, itr, nbytes)
               ENDDO

c if we do last record we're finished

               if (JJ .eq. nreco) then
                  write(LERR,*)'GASP: processed ',nreco,' records'
                  call lbclos ( luin )
                  call lbclos ( luout)
                  if(type2) close(lucoef)
                  write(LERR,*)'GASP: Normal Termination'
                  write(LER,*)'GASP: Normal Termination'
                  stop
               endif
            ENDIF

 200     continue
 9200    continue

      ENDIF

C Job Constant scaling

      IF ( type .eq. 1 )  then

         write(LERR,*)'Total live samples= ',nwnd,
     1        ' Total live trcs=- ',NumLiveTraces,' recscl= ',recscl
         wndw = float(nwnd) / float(NumLiveTraces)

         if ( method .eq. 0 ) then
            fact = fac / ( recscl + e )
            write(LERR,*)'Job constant maa scaler=  ',fact
         elseif ( method .eq. 1 ) then

c shouldn't this account for number of live traces instead of ntrc*nreco
            fact = fac * float( NumLiveTraces ) / ( recscl + e )

            write(LERR,*)'Job constant aaa scaler=  ',fact
         elseif ( method .eq. 2 ) then
            call medmad (sum, NumLiveTraces, recscl)
            fact = fac / ( recscl + e )
            write(LERR,*)'Job constant med scaler=  ',fact
         endif
        
c rewind dataset for application of scalar
 
         call rwd (luin)

         nbytes = 0
         call rtape  ( luin, itr, nbytes )
         if(nbytes .eq. 0) then
            write(LERR,*)'GASP: Premature EOF on input', ntap
            go to 999
         endif

         DO JJ = 1, nreco
            DO KK = 1, NTRC
               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input:'
                  write(LERR,*)'Sequential rec= ',jj,' trace= ',kk
                  go to 9300
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call vsmul  ( tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

               if ( c_WrdScl .ne. ' ' ) 
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, fact, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
            ENDDO
         ENDDO
 9300    continue

C**********************************************************************C
C
C APPLY RECORD CONSTANT SCALING BASED ON above schemes
C TO TRACES, WRITE TO OUTPUT DISK
C
C**********************************************************************C

      ELSEIF ( type .eq. 2 .and. .not.heap )  then

         call rwd (luin)
         nbytes = 0
         call rtape  ( luin, itr, nbytes )
         if(nbytes .eq. 0) then
            write(LERR,*)'GASP: Premature EOF on input', ntap
            go to 999
         endif


         DO JJ = 1, nreco

            fact = recmax(JJ)
            if(verbos) then
               if     (method .eq. 0) then
                  write(LERR,*)'Record= ',RecNum,'  maa scaler= ',fact
               elseif (method .eq. 1) then
                  write(LERR,*)'Record= ',RecNum,'  aaa scaler= ',fact
               elseif (method .eq. 2) then
                  write(LERR,*)'Record= ',RecNum,'  med scaler= ',fact
               endif
            endif
c write out scale factor for record
            
            write(lucoef,*)float(RecNum),fact
            
            DO KK = 1, ntrc
               nbytes = 0
               call rtape  ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'GASP: Premature EOF on input ', ntap
                  write(LERR,*)'  rec= ',RecNum,'  trace= ',kk
                  go to 9500
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

               call vsmul  ( tri, 1, fact, itr(ITHWP1), 1, nsamp )

c if user has requested, place scalar in trace header for later use

               if ( c_WrdScl .ne. ' ' ) 
     :              call savew2 ( itr, ifmt_WrdScl, l_WrdScl, 
     :              ln_WrdScl, fact, TRACEHEADER )

               call wrtape ( luout, itr, nbytes )
            ENDDO
         ENDDO
 9500    continue

      ENDIF

      call lbclos ( luin )
      call lbclos ( luout)
      if(type2) close(lucoef)
      write(LERR,*)'GASP: Normal Termination'
      write(LER,*)'GASP: Normal Termination'
      stop
      
 990  continue
       
      write(LERR,*)'LASTGASP: cannot open coefficents file',coeftap
      write(LERR,*)'          Check existance and/or permissions'
      write(LERR,*)' '
      write(LERR,*)'FATAL'
      stop
      
 999  continue
      call lbclos ( luin )
      call lbclos ( luout)
      if(type2) close(lucoef)
      write(LERR,*)'GASP: Abnormal Termination'
      write(LER,*)'GASP: Abnormal Termination'
      stop
      end

c-------------------------------------------
c  online help section
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for gasp:  '
      write(LER,*)'                         General Amp Scaling Program'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-C[]   -- Coefficient file                (GaspCoef)'
      write(LER,*)'-coef  enter on command line if coef file to be used'
      write(LER,*)'       on application.  Not required on removal'
      write(LER,*)' '
      write(LER,*)'-rs[]  -- 1st record to process                  (1)'
      write(LER,*)'-re[]  -- Last record to process       (last record)'
      write(LER,*)'-s[]   -- percent scalar (% of 2047)            (15)'
      write(LER,*)'-t0[]  -- Window start time in units of data     (0)'
      write(LER,*)'-tmax[]-- Window stop time in units of data    (end)'
      write(LER,*)'-v[]   -- mute velocity in ft(m)/s         (999999) '
      write(LER,*)'-hw1[] -- header mnemonic for window start  (unused)'
      write(LER,*)'-hw2[] -- header mnemonic for window end    (unused)'
      write(LER,*)' '
      write(LER,*)'-hws[] -- header mnemonic for scalar        (unused)'
      write(LER,*)'          if used must be a floating point header   '
      write(LER,*)'          entry (i.e. Horz08) '
      write(LER,*)' '
      write(LER,*)'-rec   enter on command line to perform  Record '
      write(LER,*)'       constant scaling'
      write(LER,*)'-job   enter on command line to perform Job constant'
      write(LER,*)'       scaling'
      write(LER,*)' '
      write(LER,*)'NOTE: trace constant scaling is the default'
      write(LER,*)' '
      write(LER,*)'-max  enter on command line to Scale based on '
      write(LER,*)'      maximum absolute amplitude.'
      write(LER,*)'-med  enter on command line to Scale based on '
      write(LER,*)'      median amplitude (only for -rec, -job)'
      write(LER,*)' '
      write(LER,*)'NOTE: scaling base on the average absolute amplitude'
      write(LER,*)'      is the default '
      write(LER,*)' '
      write(LER,*)'-R    enter on the command line to remove previous'
      write(LER,*)'      scaling.  If you have stored the scaling in '
      write(LER,*)'      a trace header slot [see -hws above] then you'
      write(LER,*)'      may use this option independant of the type'
      write(LER,*)'      of scalar used [i.e. -job, -rec].  If you have'
      write(LER,*)'      stored your scalars in an attached coef file'
      write(LER,*)'      you may only use this option in -rec mode'
      write(LER,*)' '
      write(LER,*)'-V    enter on the command line for verbose printout'
      write(LER,*)' '
      write(LER,*)'Usage:   gasp -N[ntap] -O[otap] -C[ctap] -s100 -t0[]'
      write(LER,*)'              -tmax[] [-rec, -job, -max, -med, -R, '
      write(LER,*)'              -hw1[] -hw2[] -hws[] -V]'
      write(LER,*)' '
      write(LER,*)'===================================================='

      return
      end

      subroutine cmdln ( ntap, otap, percnt, startw, stopw, irs, ire, 
     :     type1, type2, meth, verbos, med, ivel, coeftap, remove, coef,
     :     c_Wrd1, c_Wrd2, c_WrdScl )

#include <f77/iounit.h>
      integer     argis, startw, stopw, irs, ire
      real        percnt

      character   ntap*(*), otap*(*), coeftap*(*) 
      character   c_Wrd1*6, c_Wrd2*6, c_WrdScl*6

      logical     type1, type2, meth, verbos, med, remove, coef

         coef = ( argis ( '-coef' ) .gt. 0 )
         call argstr ( '-C', coeftap, 'GaspCoef', 'GaspCoef' )

         call argstr ( '-hw1', c_Wrd1, ' ', ' ' )
         call argstr ( '-hw2', c_Wrd2, ' ', ' ' )
         call argstr ( '-hws', c_WrdScl, ' ', ' ' )

         type1 =  ( argis ( '-job' ) .gt. 0 )

         med    = ( argis ( '-med' ) .gt. 0 )
         meth = ( argis ( '-max' ) .gt. 0 )

         call argstr ( '-N', ntap, ' ', ' ' )

         call argstr ( '-O', otap, ' ', ' ' )

         remove   = ( argis ( '-R' ) .gt. 0 )
         type2  = ( argis ( '-rec' ) .gt. 0 )
         call argi4  ( '-rs', irs  , 1 , 1 )
         call argi4  ( '-re', ire  , 0 , 0 )

         call argr4  ( '-s', percnt, 15. , 15. )

         call argi4  ( '-tmax', stopw, 0 , 0 )
         call argi4  ( '-t0',startw, 0  ,  0 )

         call argi4  ( '-v', ivel, 99999, 99999 )
         verbos = ( argis ( '-V' ) .gt. 0 )

         if (med .and. meth) then
            write(LERR,*)'FATAL - cannot use both -med & -max'
            write(LERR,*)'Use one or the other & rerun'
            stop
         endif

      return
      end

	real function tmute(t0,vmute,DstSgn,nsi,unitsc)
	integer t0, vmute, DstSgn, nsi
        real    unitsc
c	if(nsi .le. 32) then
		tzero = ( float(t0)/float(nsi) ) 
		time  = float(DstSgn)/float(vmute) / unitsc
		tmute = tzero  + time/(float(nsi))
c	else
c		tzero = 1000.0 * ( float(t0)/float(nsi) ) 
c		time  = 1000.0*float(DstSgn)/float(vmute)
c		tmute = tzero + 1000.0 * time/(float(nsi))
c	endif
	return
	end
	real    function alive(x,nx,tol)
	real x(*),tol
	integer nx
	if(nx .lt. 1) then
		alive = 1.0
		return
	end if
	ilive = 0
	do 10 i = 1, nx
           if (abs(x(i) ) .gt. tol) ilive = ilive+1
10 	continue
	alive = ilive
	return 
	end
