C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C*********************************************************************
C*********************************************************************
C
C	THIS SUBROUTINE COMPUTES THE MEDIAN
C	INPUT DATA
C	VECTOR.
C	
C	THE PROCESSING SEQUENCE IS AS FOLLOWS;
C	1)	THE INPUT VECTOR IS SORTED
C	2)	IF THE NUMBER OF ELEMENTS IN THE INPUT VECTOR IS
C		ODD THE MEDIAN IS TAKEN AS THE MIDDLE ELEMENT OF THE
C		SORTED VECTOR. IF THERE ARE AN EVEN NUMBER OF ELEMENTS
C		THE MEDIAN IS TAKEN AS THE ARITHMATIC MEAN OF THE
C		TWO MIDDLE ELEMENTS.
C	THE SORTING IS DONE USING THE SORT SUBROUTINE SHELL.
C
C
	SUBROUTINE MEDMAD(INDAT,N,MEDOUT)
C
C	THE FORMAL PARAMETERS OF THE SUBROUTINE ARE DEFINED.
C
C	INDAT-THE INPUT DATA VECTOR OF FLOATING POINT NUMBERS OF
C		LENGTH N.
C	N-THE NUMBER OF ELEMENTS IN THE INPUT ARRAY.
C	MEDOUT-THE VALUE OF THE MEDIAN OF THE INPUT ARRAY.
C
C
	REAL*4 INDAT(1)
	REAL*4 MEDOUT
	INTEGER*4 N
C
C	THE INTERNAL VARIABLES OF THE SUBROUTINE ARE DECLARED.
C
C	INDX-IS THE INDEX OF THE MIDDLE VALUE OF THE SORTED ARRAYS
C
	INTEGER*4 INDX
C
C	THE WORK ARRAY IS SORTED
C
	CALL SHELL(N,INDAT)
C
C	NOW THE MEDIAN VALUE IS FOUND.
C
	IF(MOD(N,2).EQ.1) THEN
C
C	THE NUMBER OF ELEMENTS IS ODD.
C
	  INDX=N/2+1
	  MEDOUT=INDAT(INDX)
	ELSE
C
C	THE NUMBER OF ELEMENTS IS EVEN.
C
	 INDX=N/2
	 MEDOUT=(INDAT(INDX)+INDAT(INDX+1))/2.0
	ENDIF
	RETURN
	END
C
C	THIS SUBROUTINE SORTS THE INPUT ARRAY INTO ASSCENDING
C	NUMERICAL ORDER. THE ROUTINE USED SHELL'S METHOD
C	OF SORTING. THIS METHOD IS USEFULL IF THE NUMBER
C	OF ELEMENTS BEING SORTED IS GREATER THAN 50 BUT LESS
C	THAN A FEW THOUSAND.
C
C
	SUBROUTINE SHELL(N,IN)
	REAL*4 IN(1)
	INTEGER*4 N
	REAL*4 ALN2I,TINY
	REAL*4 T
	INTEGER*4 NN,K,I,J,L,M,LOGNB2
	PARAMETER(ALN2I=1.0/0.69314718, TINY=1.0E-6)
C
	LOGNB2=INT(ALOG(FLOAT(N))*ALN2I+TINY)
	M=N
	DO 10 NN=1,LOGNB2
	  M=M/2
	  K=N-M
	  DO 20 J=1,K
	    I=J
  30	    CONTINUE
	    L=I+M
	    IF(IN(L).LT.IN(I)) THEN
	      T=IN(I)
	      IN(I)=IN(L)
	      IN(L)=T
	      I=I-M
	      IF(I.GE.1) GO TO 30
	    ENDIF
  20	  CONTINUE
  10	CONTINUE
	RETURN
	END


