C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine frtmau(ls,a,b,x,r1,lerr,mode)
c-----
c In sis genf this was FRTIMA
c-----
      real    x(*),a(*),b(*),r1(*)
      complex rc1(1024)
      integer n1, n3, mode
      data    n1/1/,n3/3/

      n = 2 * ( ls - 1 )
      pi = 4.0*atan(1.0)
      fac = pi/180.0
c-----
c  same as    fac=1./57.29577
c-----
      if (mode .eq. 2) then
          b0 = 0.
      else
          b0 = 0.
      endif

      rad=fac*b(1)

      do  i = 1, ls
          r1(i) = 0.
          x (i) = 0.
          rc1(i) = cmplx(0.,0.)
      enddo
 
      do 1 i=1,ls
        rad = fac  * (b(i) + b0)
        xr  = a(i) * cos(rad)
        xi  = a(i) * sin(rad)
        if (i .eq. ls) then
           xi = 0.
        endif
        rc1(i) = cmplx (xr, xi)
1     continue

c-----
c     write(lerr,*)'frtmau -  n = ',n
c     write(22,1212)(r1(juk),juk = 1,1025)
c1212  format('INPUT TO FFT'/(1x,10f6.2))
c-----
c     for grins - 
c     call compl1(n,mm)
c     mmm = 2**mm
c     write(lerr,*)'ls,n,mm,mmm = ',ls,   n, mm, mmm
c                                   257  512  9  512

c     call cfft(r1,n,n1)
c     call cfftsc(r1,n)
      call rfftsc (rc1, n, -3, 0)
      call rfft   (rc1, n, -1)
      lw = ls/2
      
      do  i = 1, ls
          r1i = real (rc1(i))
          if (i .ge. lw) then
             wt = .5 * (1 + cos( pi*(i-lw)/lw ))
          else
             wt = 1.
          endif
          r1 (i) = wt * r1i
          write(lerr,*)i,r1(i)
      enddo
      do  i = ls+1, n
          r1 (i) = 0.
      enddo

c-----
c the output is the same if harmgr is used - instead of cfft etc.
c-----

      j = 1
      do 6 i=1,n
        x(i)=r1(j)
c       j = j + 2
        j = j + 1
6     continue
      
      return
      end
