C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c genfu reads input impulse (filter amplitudes) response from ascii
c file (log.unit = LUCARD), seismic traces data from input seismic
c file (log.unit = c LUIN) and convolves impulse response with each
c trace in frequency c domain and writes inverse transform of result
c to output seismic file (log.unit = LUOUT).
c
c (usp version of SIS GENF - basically it is just the MODE=0,
c  1 and 2 parts of the SIS program.)
c
c Initial development date: December 14, 1990    Herb Wright
c Modified:                 July 30, 1992          "    "
c Modified:                 Aug   5, 1992          "    "
c Modified:                 Aug  17, 1992          "    "
c  
c**********************************************************************c
c-----
c    get machine dependent parameters
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/gnfftbuf.h>
#include <f77/genfgr.h>
c-----

      integer    maxamp, fftfrd, fftinv, ientry
c
c - ientry is modified, set its value below in a data statement - j.m.wade
c
c     parameter (maxamp = 1024, fftfrd=1, fftinv=-1, ientry=0)
      parameter (maxamp = 1024, fftfrd=1, fftinv=-1)


      integer      itr  ( SZLNHD )
      integer      lhed ( SZLNHD )
      real         head ( SZLNHD )


      integer
     : argis, ifflg, ifor, imut, iper,
     : iph, isi, isym, iwe, iws, lag, lagc, lagr, lbyout, lbytes,
     : lngfl, luin, luout, mode, nbytes, noscl, npt, nrc,  nsamp,
     : ntbyt, ntrr, numf, obytes, recnum, static, trcnum,
     : irs,ire,ns,ne,itrout,ircout,gfpw2,lugri,lugra,lugrp

      real
     : tri ( SZLNHD ), tro ( SZLNHD ),  filtr( SZLNHD ),
     : work1( 2*SZLNHD ), work2( 2*SZLNHD ), ampl(SZLNHD), r2(SZLNHD),
     : weit, alag, shape (3*SZLNHD), amps( SZLNHD ), phz( SZLNHD ),
     :  amps1( SZLNHD ), phz1( SZLNHD ),amps2( SZLNHD ), phz2( SZLNHD ),
     :  work( SZLNHD )

      complex
     : filtrc (SZLNHD), tempc (SZLNHD), trnc (SZLNHD)

      character
     : ntap  * 256, otap * 256, fname * 256, name * 5, jobnot * 8,
     : apfile * 256

      character*4 
     : title(12)

      logical
     : verbos, query, dispgr, zeros, inverse, phzo, mindel, wweight,
     : shp, scalout

      external
     : gfpw2

      equivalence
     : (itr(1), lhed(1), head(1))

      data 
     : lbytes / 0 /,  name/'GENFU'/,
     :  title /'***','IMPU','LSE','RESP','ONSE',' OF ','FILT',
     :           'ER  ','    ','    ','    ',' ***'/

      data ientry / 0 /

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
c-----
c     open printout files
c     this consists of a "nnnnn" identifier, the parent process id 
c     number:
c       XXXXXX.nnnnn   (where XXXXXX = program name.)
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>

      do  i = 1, SZLNHD
          filtrc(i) = cmplx (0.,0.)
          tempc (i) = cmplx (0.,0.)
          trnc  (i) = cmplx (0.,0.)
      enddo

C parms used:  see comments in subroutine gcmdln.
C
c numf   -  No. of impulse response values read
c           (not an input parm, determined when reading data)
C
C
      call gcmdln(lerr,ntap,otap,fname,verbos,dispgr,inverse,
     1            mode,ns,ne,irs,ire,lagc,imut,iper,iws,
     2            iwe,ifflg,weit,delf1,f1,cinv,isym,iph,npt,
     3            apfile,phzo,prew,mindel,wweight,shp,scalout)
 
      if (apfile .eq. ' ' .AND. fname .eq. ' ') then
         write(LERR,*)' **** error ****'
         write(LERR,*)' **** impulse response file not on command line'
         write(LERR,*)' **** rerun using either -f[] or -AP[]'
         write(LER ,*)' **** error ****'
         write(LER ,*)' **** impulse response file not on command line'
         write(LER ,*)' **** rerun using either -f[] or -AP[]'
         stop
      endif
c
c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)' **** error ****'
         write(LERR,*)' **** no header read from unit ',luin
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      istop = 0
      call saver(itr, 'JobNum', jobnot, LINHED)
      call saver(itr, 'NumSmp', nsamp,  LINHED)
      call saver(itr, 'SmpInt', isi  ,  LINHED)
      call saver(itr, 'NumTrc', ntrr ,  LINHED)
      call saver(itr, 'NumRec', nrc ,   LINHED)
      call saver(itr, 'Format', ifor,   LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
         dt = real (isi) * unitsc
         si = dt

      call hlhprt (itr, lbytes, name, 5, LERR)

      if(SZSMPD.gt.4) then
         if(ifor.ne.3) then
           write(lerr,*)' '
           write(lerr,*)' Only Format 3 allowed on Cray'
           write(lerr,*)' '
           call lbclos ( luin )
           call lbclos ( luout )
           stop
         endif
      else
         if(ifor.ne.1.and.ifor.ne.3) then
           write(lerr,*)' '
           write(lerr,*)' Only Format 1 or 3 allowed'
           write(lerr,*)' '
           call lbclos ( luin )
           call lbclos ( luout )
           stop
         endif
      endif

      if ( nsamp .le. 0 ) then
        write(lerr,*)' ' 
        write(lerr,*)' No. samples/trace = ',nsamp
        write(lerr,*)' Problem with No. samples'
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif
        
      if ( ifor .eq. 1 ) then
        write(lerr,*)' ' 
        write(lerr,*)' No. format 1 data allowed - only fmt 3'
        write(ler,*)' No. format 1 data allowed - only fmt 3'
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif

      if ( ifor .eq. 3 .and. nsamp .gt. SZLNHD ) then
        write(lerr,*)' ' 
        write(lerr,*)' No. samples/trace = ',nsamp
        write(lerr,*)' No. format 3 samples/trace exceeds ' 
        write(lerr,*)' programed allowable buffer space ' 
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif
c-----
c trace length in byte units:
      ntbyt = SZTRHD + SZSMPD*nsamp
c-----
c were graphs requested ?
c-----
      if ( dispgr ) then

        lugri = LUDISK
        call getfng(lerr,WHICHS,lugri,lugra,lugrp)
          
      endif

c   read in filter data  - ASCII card image file. (each record
c   expected to be 80 bytes)
c   if iphze is zero on return from reading, then data is for
c   mode=0 processing.  if iphze is not zero, then the data is
c   for mode 1 or 2 processing.
c
      iphze = 0
      numf = 0
c----
      if( verbos .and. mode .ne. 0) then
         write(lerr,*)' '
         write(lerr,*)'Input from'
         write(lerr,*)fname
         write(lerr,*)apfile
      endif

      call rdfltc (lucard,lutemp,lerr,mode,fname,maxamp,ampl,
     1             numf,iphze,verbos,apfile)
      if (mode .eq. 0) then
         do i = 1, numf
            if(ampl(i) .ne. 0.0) then
               is = i
               go to 111
            endif
         enddo
111      continue
         do i = numf, 1, -1
                        if(ampl(i) .ne. 0.0) then
               ie = i
               go to 112
            endif
         enddo
112      continue
         write(LERR,*)'is,ie,numf= ',is,ie,numf
         numf = ie - is + 1
         ii = 0
         do i = is, ie
            ii = ii + 1
            work1(ii) = ampl(i)
         enddo
         do i = 1, numf
            ampl(i) = work1(i)
         enddo
      endif
 
      if (iphze .ne. 0 .and. mode .eq. 0) then
        write (lerr,33)
33      format(' **** error ****'/
     :         ' **** kind of data read and mode do not agree')
        stop
      endif

      if (iphze .eq. 0 .and. mode .ne. 0) then
        write (lerr,34)
34      format(' **** error ****'/
     :         ' **** kind of data read and mode do not agree')
        stop
      endif
 
      if( numf .eq. 0 ) then
        write(LERR,*)' **** error ****'
        write(LERR,*)' **** - Problem with filter file'
        write(LERR,*)' **** - No values retrieved from file.'
        goto 999
      endif
c
c check input parms and compute needed lag parms from lagc
c
      if(mode.eq.0)npt = numf

      call parchk(lerr,
     1            alag, lagc, lag, lagr, lngfl,
     2            cinv,delf1,f1,ifflg,ifor,imut,iper,iph,isi,
     3            isym,iwe,iws,mode,noscl,npt,nrc,nsamp,ntrr,numf,
     4            recnum,trcnum,weit,iphze,ns,ne,irs,ire,itrout,
     5            ircout)
c
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
c  get length for fft 
      n2 =  gfpw2 (nsamp+lngfl)
      n2 = 2 * n2
c----------------------
c     modify line header to reflect actual number of traces to output
c--------
      itrout = ne - ns + 1
      ircout = ire - irs + 1
      call savew(itr, 'NumRec', nrc   , LINHED)
      call savew(itr, 'NumTrc', ntrr  , LINHED)
      call savew(itr, 'Format',   3   , LINHED)

      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      call verbal(ntap,otap,fname,lerr,verbos,inverse,
     1            mode,imut,lagc,ifflg,iper,iws,iwe,
     2            noscl,weit,npt,delf1,f1,cinv,isym,
     3            iph,irs,ire,ns,ne,itrout,ircout,nsamp,
     4            isi,ntrr,nrc,ifor,phzo,prew,mindel,wweight,shp,
     5            scalout)
c-----

      prew = .01 * prew

c     BEGIN PROCESSING

c*************************************************************************

c        filter computation (done one time only)

c             mode = 0    :   we are given time domain response
c             mode = 1,2  :   we are given ampl/phase

c*****
c      If mode is 1 or 2, will need to first compute the filter.
c*****
       IF (mode .gt. 0) then

         if( verbos ) then 
           numpts = iphze - 1
           write(lerr,5)numpts,(ampl(i),i=1,numpts)
5          format(' filter read: '//' amplitude data - number = ',i5/
     :     (5(1x,e13.6)))
           write(lerr,6)numpts,(ampl(i),i=iphze,numf)
6          format(//' phase data - number = ',i5/(5(1x,e13.6)))
         endif

         call gnfltu (lerr,lugri,SZSMPD,dispgr,mode,
     1               alag, lagc, lag, lagr, lngfl, ampl, r2,
     2               cinv, delf1, f1, ifflg, ifor, imut, iper,
     3               iph, isi, isym,noscl, npt, nrc, nsamp,numf,
     4               weit, iphze)

         if( verbos ) then
           write(lerr,1717)(ampl(i),i=1,npt)
1717       format(/' Filter Generated'/(5(1x,e13.6)))
         endif
c*****
c      If mode is 0
c*****

       ELSE

c-----
c        ross weighting, no graph of filter response
c-----
         if(weit .ne. 0.0)then

           icen = (lngfl + 1) / 2
           fac = 1.0 / (icen * icen)
           icen1 = icen - 1
c
           do 201 i = 1,icen1
             xi = 1 + icen - i
             fac1 = (1.0 - xi * xi * fac) ** weit
             j = 1 + lngfl - i
             ampl(i) = fac1 * ampl(i)
             ampl(j) = fac1 * ampl(j)
201        continue

        else 
c-----
c        If graph requested and if no ross weighting. graph 
c        non-scaled filter response  
c-----
          if ( dispgr )
     :      call grap7u(ampl,1,4,1.0,1.0,title,npt,dummy,lugri,
     :       SZSMPD)
        endif

         if( verbos ) then
           write(lerr,7)numf,(ampl(i),i=1,numf)
7          format(' filter read: '//' filter amplitudes - number = ',i5/
     :     (1x,6e13.6))
         endif

      ENDIF
c*************************************************************************

      if (dispgr) call graphu (isi,lerr,lugra,lugrp,SZSMPD)
c
c-----
c prepare minimum delay version of input filter "ampl"

      IF (mindel) THEN

         if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'Min Delay Option:'
            write(LERR,*)' '
            write(LERR,*)'Input wavelet'
            do  i = 1, lngfl
                write(LERR,*)i, ampl(i)
            enddo
            write(LERR,*)' '
         endif

         call mphase (lngfl,ampl,work1,work2,tempc,se1,se2,shape,prew,
     1                shp,SZSMPD)

         if (verbos) then
            write(LERR,*)' '
            write(LERR,*)'Minimum delay wavelet'
            do  i = 1, lngfl
                write(LERR,*)i, ampl(i)
            enddo
            write(LERR,*)' '
         endif
      ENDIF
c-----
c     BEGIN PROCESSING
c-----
c     skip unwanted records
c-----
c     call recskp(1,irs-1,luin,ntrr,itr)
      nbytes = obytes
      call recrw (1,irs-1,luin,ntrr,itr,luout, nbytes)
      if (nbytes  .eq. 0) go to 999

c-----
c        process desired trace records
c-----
      ircc = 0
c---
      DO  1001  JJ = irs, ire
          ircc = ircc + 1
        
c----------------------
c  skip to start trace
c         call trcskp(jj,1,ns-1,luin,ntrr,itr)
          nbytes = obytes
          call trcrw (JJ, 1, ns-1, luin, ntrr, itr, luout, nbytes)
          if (nbytes  .eq. 0) go to 999
c----------------------
          jdo = 0
          itcc = 0

          do 1000  jtr = ns, ne

             itcc = itcc + 1
             nbytes = 0
             call rtape( luin, itr, nbytes)
             if(nbytes .eq. 0) then
               write(LERR,*)' **** End of file on input:'
               write(LERR,*)' **** rec= ',jj,'  trace= ',jtr
               go to 999
             endif
             call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

             call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   static, TRACEHEADER)
             call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   recnum, TRACEHEADER)
             call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                   trcnum, TRACEHEADER)

             if (static .eq. 30000) then
                call vclr (tri,1,nsamp)
                go to 500
             endif
c-----------------------
c  here's rest of the meat...
c-----
             call cvnfre (lerr,itr,lhed,tri,tro,filtr,work1,work2,
     1                    n2,filtrc,tempc,trnc,nsamp,lngfl,iper,ampl,
     2                    isi,fftfrd,fftinv,ictr,ientry,noscl,mode,
     3                    rmplen,factor,xramp,icount,datlen,inverse,
     4                    rmpflg,zerofg,zeros,ramp,kop,iws,iwe,imut,
     5                    static,recnum,trcnum,ifflg,phzo,ifh,
     6                    amps,phz,amps1,phz1,amps2,phz2,si,work,
     7                    prew,SZLNHD,SZTRHD,SZFFTB,SZSMPD,ITHWP1,
     8                    wweight,scalout)

             call vmov ( tro, 1, tri, 1, nsamp )

500          continue

c            call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
c    1                   ircc  , TRACEHEADER)
c            call savew2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
c    1                   itcc  , TRACEHEADER)

             call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
             call wrtape (luout, itr, obytes)

1000      continue

c------------------------
c  pass remainder of rec
             nbytes = obytes
             call trcrw (JJ, ne+1, ntrr, luin, ntrr, itr, luout, nbytes)
1001  CONTINUE
c

c------------------------
c  pass remainder of recs
      nbytes = obytes
      call recrw (ire+1, nrc, luin, ntrr, itr, luout, nbytes)
      if (nbytes .eq. 0) go to 999

  
      if (noscl .ne. 1) then
        write(lerr,*) ' '
        write(lerr,*) ' '
        call riclr (lerr)
      else
        write (lerr,154) ircc
  154   format(//,2x,i5,'records processed',/)
      endif

c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )
      if (dispgr) then
        close(lugri) 
        close(lugra) 
        close(lugrp) 
      endif

      stop
      end
