C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getfng(lerr,WHICHS,lugri,lugra,lugrp)
c----
c  routine for getting print file filename and opening graph
c  files with proper id appended - ".I", ".A", ".P"
c  input logical unit variable, lugri provides the starting lu
c  for the first graph file - ".I".
c    lugri           .I   - impulse response of filter
c    lugra = lugri+1 .A   - amplitude spectra of filter
c    lugrp = lugri+2 .P   - phase spectra of filter
c----

      character 
     : fngi * 80, fnga * 80, fngp * 80, curname * 80, tempf * 15, 
     : usrtxt1 * 37, usrtxt2 * 49, fngtx * 89, prtcmd * 29

      integer
     : lerr, lugri, lugra, lugrp, ios, WHICHS

      data 
     : ios/0/, tempf/'xtemp.zzzz.1234'/,
     : usrtxt1/'(to print on local laser printer use:'/,
     : usrtxt2/'(ftp to sun. to print on local laser printer use:'/,
     : prtcmd/' enscript -r -fCourier-Bold8 '/

c------
c provide additional lu variables
c------
      lugra = lugri+1
      lugrp = lugra+1

c-----
c get list of GENFU.* files.  With the ls -t, the current file,
c just opened, will be first.
c-----
c     call system ('ls -t GENFU.* > '//tempf)

      open (unit=lugri, iostat=ios, file=tempf, err=9015,
     :      status='old',form='formatted')
      curname = ' '
      read(lugri,88)curname
88    format(a80)
      call charct(curname,80,lenc)
      close(lugri) 
c----
c remove tempf
c     call system('rm -f '//tempf)
c----
      write(lerr,*)'graphs generated:'
c----
c build graph filename for filter impulse response graph
c----

      fngi = curname(:lenc)//'.I'
      call charct(fngi,80,lenn)
      write(lerr,*)' impulse response of filter  - ',fngi(:lenn) 
      
c-----
c open the graph file
c-----
      ios = 0
      open (unit=lugri, iostat=ios, file=fngi(:lenn), err=9015,
     :      status='new',form='formatted')
      write(lugri,*)'impulse response graph for job ',
     : curname(:lenc)
      fngtx = prtcmd//fngi(:lenn)//')'
      call charct(fngtx,89,lenx)
      if ( WHICHS .eq. 1 )
     : write(lugri,*)usrtxt1,fngtx(:lenx)
      if ( WHICHS .eq. 2 )
     : write(lugri,*)usrtxt2,fngtx(:lenx)
      write(lugri,*)' '

c----
c build graph filename for filter amplitude spectra graph
c----

      fnga = curname(:lenc)//'.A'
      call charct(fnga,80,lenn)
      write(lerr,*)' amplitude spectra of filter - ',fnga(:lenn) 
c-----
c open the graph file
c-----
      ios = 0
      open (unit=lugra, iostat=ios, file=fnga(:lenn), err=9015,
     :      status='new',form='formatted')
      write(lugra,*)'amplitude spectra graph for job ',curname(:lenc)
      fngtx = prtcmd//fnga(:lenn)//')'
      call charct(fngtx,89,lenx)
      if ( WHICHS .eq. 1 )
     : write(lugra,*)usrtxt1,fngtx(:lenx)
      if ( WHICHS .eq. 2 )
     : write(lugra,*)usrtxt2,fngtx(:lenx)
      write(lugra,*)' '

c----
c build graph filename for filter phase spectra graph
c----

      fngp = curname(:lenc)//'.P'
      call charct(fngp,80,lenn)
      write(lerr,*)' amplitude spectra of filter - ',fngp(:lenn) 
c-----
c open the graph file
c-----
      ios = 0
      open (unit=lugrp, iostat=ios, file=fngp(:lenn), err=9015,
     :      status='new',form='formatted')
      write(lugrp,*)'phase spectra graph for job ',curname(:lenc)
      fngtx = prtcmd//fngp(:lenn)//')'
      call charct(fngtx,89,lenx)
      if ( WHICHS .eq. 1 )
     : write(lugrp,*)usrtxt1,fngtx(:lenx)
      if ( WHICHS .eq. 2 )
     : write(lugrp,*)usrtxt2,fngtx(:lenx)
      write(lugrp,*)' '
      return

9015  write(lerr,*)' '
      write(lerr,*)'NOTE ***********************************'
      write(lerr,*)'error occurred in getting printer file,'
      write(lerr,*)'filename and/or opening graph files.  graphs'
      write(lerr,*)'are in this file.  you can edit out the'
      write(lerr,*)'non-graph text and create a new file which'
      write(lerr,*)'can be printed on local laser printer with: '
      write(lerr,*)' '
      write(lerr,*)'   enscript -r -fCourier-Bold8 <filename>'
      write(lerr,*)'****************************************'
      write(lerr,*)' '
      lugri = lerr
      lugra = lerr
      lugrp = lerr
      return

      end
