C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine parchk(lot,
     1                 alag, lagc, lag, lagr, lngfl,
     2                 cinv,delf1,f1,ifflg,ifor,imut,iper,iph,isi,
     3                 isym,iwe,iws,mode,noscl,npt,nrc,nsamp,ntrr,numf,
     4                 recnum,trcnum,weit,iphze,ns,ne,irs,ire,itrout,
     5                 ircout)

 
c  check input parms and compute lag parms
 
      integer
     :ifflg, ifor, imut, iper, iph, isi, isym, iwe, iws, lag,
     :lagc, lagr, lngfl, mode, noscl, npt, nrc, nsamp, ntrr, recnum,
     :trcnum,iphze,ns,ne,irs,ire
 
      real
     :alag, cinv, delf1, f1, weit
 
 
      ierr = 0
      if (ns .eq. 0) ns = 1
      if (ne .eq. 0) ne = ntrr
      if (irs .eq. 0) irs = 1
      if (ire .eq. 0) ire = nrc
      if (ns .gt. ne) ierr = 1
      if (irs .gt. ire) ierr = 1
      if (ns .lt. 1 .or. ns .gt. ntrr) ierr = 1
      if (ne .lt. 1 .or. ne .gt. ntrr) ierr = 1
      if (irs .lt. 1 .or. irs .gt. nrc) ierr = 1
      if (ire .lt. 1 .or. ire .gt. nrc) ierr = 1

      if (ierr .ne. 0) then
      write(lot,*)'Problem with command line starting and ending trace'
      write(lot,*)'or record parameters.'
      write(lot,*)'Check -ns, -ne, -rs and -re parameters.'
      write(lot,*)'Also, verify against line header print out.'
      stop
      endif

      if(mode .lt. 0 .or. mode .gt. 2) goto 40

      if(nsamp .gt. 8192) go to 60

      noscl = 0

      if(iwe .gt. 0)noscl = 1
      if(iper .le. 0)iper = 15
      if(iper .gt. 100)iper = 100
      if(iwe .gt. iws)go to 15
      if(noscl .eq. 1)go to 50

   15 if(iwe .gt. nsamp * isi)iwe = nsamp * isi

      if(imut .ne. 1)imut = 0
      if(ifor .ne. 3 )go to 70
      if(ifflg .ne. 1 .and. ifflg .ne. 2)ifflg = 0
 
      lagr = lagc / isi
      lag = npt - lagc / isi - 1

      if (mode.gt.0 .and. delf1 .le. 0.0) goto 80
      if (mode.gt.0 .and. f1 .lt. 0.0) f1 = 0.0  
      if (mode.eq.2 .and. cinv .eq. 0.0)cinv = 5.
      if (npt .eq. 0) npt = 500/isi

      lngfl = npt
      alag = 0.0

      if (isym .gt. 0) then
        i = npt/2 * 2
        if(i .eq. npt) npt = npt - 1
        lag = lag + (npt-1)/2
        alag = (npt-1)/2 * 0.001 * isi
      endif

      if ( lagc .gt. 500*isi ) goto 90
 
      return
 
40    write (lot,45)
45    format(' **** error ****'/
     :        4x,' **** only modes 0,1 and 2 allowed *****')
      stop
50    write (lot,55)
55    format(' **** error ****'/
     :        4x,' **** scale window incorrectly specified *****')
      stop
60    write (lot,65)
65    format(' **** error ****'/
     :       ' **** max. of 6000 input samples')
      stop
70    write(lot,75)
75    format(' **** error ****'/
     :       ' **** only SIS formats 3 allowed.')
      stop
80    write(lot,85)
85    format(' **** error ****'/
     :       ' **** The frequency interval for filter was not specified'
     :)
      stop
90    write (lot,95)
95    format(' **** error ****'/
     :       ' **** lag exceeds filter length')
      stop
      end
