C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdfltc (lu10,lutmp,lerr,mode,fname,max,datout,
     1                   npt,iphze,verbos,apfile)
c
      character*81 card, tard
      character*(*) fname
      character*(*) apfile
      character*5 genf2, genf3, bgblk, gwh
      character*4 dtype
      character*1 blnk
c
      real
     :datout(*), datin(40)
c
      integer 
     :lerr,npt,nu,j,ifound,ict,lu10,mode,have2,ifirst,
     :ierr
c
      logical l,verbos
c
      data 
     :blnk/' '/,genf2/'2GENF'/,genf3/'3GENF'/,ifirst/0/,
     :namps/0/,nphze/0/,
     :bgblk/'     '/,have2/0/
c
c  test filename for existence
c     if no, then return with error flag set
c
      if (fname .eq. ' ') then

      call charct(apfile,100,lenf)
      dtype = 'OLD'
      inquire(file=apfile,exist=l)
      if(.not.l)then
        write (lerr,5)
        stop
      endif
      ios = 0
      open (unit=lu10, iostat=ios, file=apfile,
     :      status='OLD',form='FORMATTED')

      else

      call charct(fname,100,lenf)
      dtype = 'OLD'
      inquire(file=fname,exist=l)
      if(.not.l)then
        write (lerr,5)
        stop
      endif
      ios = 0
      open (unit=lu10, iostat=ios, file=fname,
     :      status='OLD',form='FORMATTED')

      endif

5       format(' **** error ****'/
     :         ' **** filter file does not exist')
c-----
c because the cray fortran compiler does not allow 
c free form internal read with a list.  it was necessary
c to work around that restriction by using a scratch 
c file.  this is better than having to rewrite the 
c routine and possibly having to force the user to have
c to adhere to some fixed format.
c-----
c     open(unit=lutmp,status='scratch',form='formatted')
c     open(unit=lutmp,status='unknown',form='formatted')

      ic2 = 0
      ic3 = 0
      istop = 0
      nu = 0
10    continue
      read(lu10,20,end=60)card(1:80)
20    format(a80)   

c-------------------------------------------------------------
c  mode = 1 or 2

      if(mode.ne.0) then

        IF (fname .ne. ' ') THEN

        if( verbos )write (lerr,1213)card(1:80)
1213    format(a80)
        gwh = card(1:5)
        if (gwh.eq.genf2) then
          if(have2.ne.0) then
            write(lerr,*)' '
            write(lerr,*)'problem with order of 2GENF and',
     :       '3GENF cards'
            stop
          endif
          ic2 = ic2 + 1
          if ( ic2 .gt. 22 ) then
            write(lerr,*)'only 22 "2GENF" cards allowed'
            stop
          endif

c          write(lutmp,12)card(6:80)
c12        format(a75)
c          rewind lutmp

          ii = 0
          do  i = 6, 80
              ii = ii + 1
              tard(ii:ii) = card(i:i)
          enddo
          ict = 0
          j = 1
          do 16 k = 1,12
            j = j + 5
            jend = j + 4
            if(card(j:jend).eq.bgblk) go to 17
            ict = ict + 1
16        continue
c
17        if (ict.eq.0) then
            write(lerr,*)'error in reading ',fname(:lenf)
            write(lerr,*)card(1:5),'card exists without data'
            stop
          endif
c
c          read(lutmp,18)(datin(j),j=1,ict)
c18        format(12f5.0)
c          rewind lutmp
           call rdcard (ict, tard, datin, LER, LERR)
           do  i = 1, 80
               card(i:i) = ' '
               tard(i:i) = ' '
           enddo
          go to 45
        endif
c
c
        if (gwh.eq.genf3) then
          ic3 = ic3 + 1
          if ( ic3 .gt. 22 ) then
            write(lerr,*)'only 22 "3GENF" cards allowed'
            stop
          endif
c         write(lutmp,12)card(6:80)
c         rewind lutmp
          ii = 0
          do  i = 6, 80
              ii = ii + 1
              tard(ii:ii) = card(i:i)
          enddo
          have2 = 1
          if(ifirst.eq.0) then
            ifirst = 1
            namps = nu
            iphze = nu + 1
          endif
c
          ict = 0
          j = 1
          do 22 k = 1,12
            j = j + 5
            jend = j + 4
            if(card(j:jend).eq.bgblk) go to 23 
            ict = ict + 1
22        continue
c
23        if (ict.eq.0) then
            write(lerr,*)'error in reading ',fname(:lenf)
            write(lerr,*)card(1:5),'card exists without data'
            stop
          endif

           call rdcard (ict, tard, datin, LER, LERR)
           do  i = 1, 80
               card(i:i) = ' '
               tard(i:i) = ' '
           enddo
c         read(lutmp,18)(datin(j),j=1,ict)
c         do  j = 1, ict
c             datin(j) = +datin(j)
c         enddo
c         rewind lutmp

          go to 45
        endif
c
        ierr = 1
        write(lerr,*)'error in reading ',fname(:lenf)
        write(lerr,*)'data not in proper format for mode = ',
     :  mode
        write(lerr,*)' or'
        write(lerr,*)'2GENF exists as 2genf'
        write(lerr,*)' or' 
        write(lerr,*)'3GENF exists as 3genf' 
        if (ierr.ne.0)stop

        ELSE

            rewind lu10
            nc = 0
            do  while (1.eq.1)

                read(lu10,'(a80)',end=999,err=998) card
                nc = nc + 1
            enddo
            go to 999
998         write(lerr,*)'genfu: FATAL ERROR reading amp-phz file'
            write(lerr,*)'check contents of file ',apfile
            write(ler ,*)'genfu: FATAL ERROR reading amp-phz file'
            write(ler ,*)'check contents of file ',apfile
            stop
999         continue

            rewind lu10
            do  j = 1, nc
 
                read(lu10,'(a80)') card
                call fsscnf (card,'%f %f',datout(j),datout(nc+j))
            enddo
            iphze = nc + 1
            nphze = nc
            namps = nc
            nu = 2 * nc
            go to 60


        ENDIF

c--------------
c  mode = 0
      else 
c--------------

        if(card(1:2) .eq. '2G' .or. card(1:2) .eq. '2g') then
          write(lerr,*)'error in reading ',fname(:lenf)
          write(lerr,*)'not correct data for mode = ',mode
          stop
        endif
        if(card(1:2) .eq. '3G' .or. card(1:2) .eq. '3g') then
          write(lerr,*)'error in reading ',fname(:lenf)
          write(lerr,*)'not correct data for mode = ',mode
          stop   
        endif
c 
        ifound = 1
        ict = 1
        if( card(1:1) .eq. blnk) then
          ifound = 0
          ict = 0
        endif
c
        do 30 j = 1,80
          if( ifound .ne. 0 ) then
            if( card(j:j) .ne. blnk) goto 30
            ifound = 0
            go to 30
          endif
c
          if( card(j:j) .eq. blnk) goto 30
          ifound = 1
          ict = ict + 1
30      continue

c       write(lutmp,12)card
c       rewind lutmp
c       read( lutmp,* ) (datin(j),j=1,ict)
c       rewind lutmp

        call rdcard (ict, card, datin, LER,LERR)
        do  i = 1, 80
            card(i:i) = ' '
            tard(i:i) = ' '
        enddo

      endif
c--------------------------------------------------------------
c
45    do 50 j = 1,ict
        nu = nu + 1
        if( nu .gt. max)then
          write(lerr,*)'buffer full!'
          write(lerr,*)'reading filter file:'
          write(lerr,*)'file = ',fname(:lenf)   
          write(lerr,*)' '   
          write(lerr,*)'if mode = 0 '
          write(lerr,*)'   max filter values allowed = 500'
          write(lerr,*)'if mode = 1 or 2 '
          write(lerr,*)'   max amp values allowed = 256'
          write(lerr,*)'   max phase values allowed = 256'
          stop
        endif
        datout(nu) = datin(j)
50    continue
c
      goto 10
c
60    if (iphze .ne. 0 ) then
        nphze = nu - iphze + 1
        if (nphze .ne. namps) then
          write (lerr,70)fname(:lenf),nphze, namps
70        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** the number of values for amp and'/
     :       ' **** phase are not the same.'//
     :       ' **** number of phase values     = ',i5/
     :       ' **** number of amp values = ',i5)
          istop = 1
        endif
        if ( nphze .gt. 256 .or. namps .gt. 256 ) then
          write (lerr,80)fname(:lenf),nphze, namps
80        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** number of phase values     = ',i5/
     :       ' **** number of amplitude values = ',i5)
          write(lerr,*)'      (max amp values allowed is 256)'
          write(lerr,*)'      (max phase values allowed is 256)'
          stop
        endif
        if (istop .ne. 0) stop
      else
        if ( nu .gt. 500 ) then
          write (lerr,90)fname(:lenf),nu
90        format('error in reading filter file '/
     :       ' **** file = ',a50/
     :       ' **** number of filter values    = ',i5)
          write(lerr,*)'      (max filter values allowed is 500)'
          stop
        endif     
      endif
      npt = nu
      return
      end
