C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal(ntap,otap,fname,lerr,verbos,inverse,
     1                 mode,imut,lagc,ifflg,iper,iws,iwe,
     2                 noscl,weit,npt,delf1,f1,cinv,isym,
     3                 iph,irs,ire,ns,ne,itrout,ircout,nsamp,
     4                 isi,ntrr,nrc,ifor,phzo,prew,mindel,wweight,
     5                 shp,scalout)

c-----
c     genf verbose output of processing parameters
c     mode    I*4     genfu mode 0,1 or 2
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c     fname - C*100   input ascii file name - impulse response
c     ifor  - I*4     format of data
c     ns    - I*4     starting trace index
c     ne    - I*4     ending trace index
c     irs   - I*4     starting record index
c     ire   - I*4     ending record index
c     itrout- I*4     traces/record to output
c     ircout- I*4     number of records to output
c     nsamp - I*4     number of samples in trace
c     isi   - I*4     sample interval in ms
c     nrc   - I*4     number of records per line
c     ntrr  - I*4     traces per record
c     imut  - I*4     flag - restore early mute
c     ifflg - I*4     flag - integrate/differentiate
c     iper  - I*4     percent of 2047
c     iws   - I*4     start time (ms)
c     iwe   - I*4     end time
c     weit  - R*4     ross-weighting exponent
c  The following are only pertinent to mode = 1 or 2 execution:
c     delf1 - R*4     freq int of amp & phase arrays
c     f1      R*4       "   "   "  "      "   1st sample
c     cinv    R*4     threshhold ratio in % of max ampl value
c     isym    I*4     filter symetrical ?  0-no, 1-yes
c     iph     I*4     phase type ? 0 - values are phase spec
c                                  1 -   "     "    "   lag
c
c-----
c#include <f77/iounit.h>
 
      character
     : ntap*(*), otap*(*), fname*(*)
 
      real
     : cinv, delf1, f1, weit
 
      integer
     : ifflg, ifor, imut, iper, iph, isi, isym, iwe, iws, lagc, mode,
     : noscl, npt, nrc, nsamp, ntrr, numf, recnum, trcnum, ns, ne,
     : irs, ire, itrout, ircout
      
      logical
     : verbos,phzo,mindel,inverse,wweight,shp,scalout

 
      write(LERR,*)' '
      write(LERR,*) 'command line parmeters/defaults:    '
      write(LERR,*) 'genfu mode                        = ',mode
      call charct(ntap,100,lenn) 
      write(LERR,*) 'seismic input file                = ',ntap(:lenn)
      call charct(otap,100,lenn) 
      write(LERR,*) 'seismic output file               = ',otap(:lenn)
      call charct(fname,100,lenn) 
      write(LERR,*) 'input filter file                 = ',fname(:lenn)
      write(LERR,*) 'restore early mute (1-no,0-yes)   = ',imut
      write(LERR,*) 'positive or negative lag (ms)     = ',lagc
      write(LERR,*) 'integrate/differentiate flag      = ',ifflg
      write(LERR,*) '    0 = no (normal)'
      write(LERR,*) '    1 = integrate output'
      write(LERR,*) '    2 = differentiate output'
      write(LERR,*) 'scaling - percent of 2047         = ',iper
      write(LERR,*) 'scaling - start time (ms)         = ',iws
      write(LERR,*) 'scaling - end time (ms)           = ',iwe
      if ( noscl .eq. 0 ) then
        write(LERR,*) ' (end scaling time = 0 - no scaling!)'
      endif
      write(LERR,*) 'ross-weighting exponent           = ',weit
      if ( weit .eq. 0.0 ) then
        write(LERR,*) ' (no ross-weighting!) '
      endif
      if(mode .ne.0)then
        write(LERR,*) 'Input amplitude and phase'
        write(LERR,*) 'desired number of points in filter= ',npt
        write(LERR,*) 'freq interval of amp & phase i/p  = ',delf1
        write(LERR,*) 'start freq/1st amp & phase value  = ',f1
        if(mode .eq.2)then
        write(LERR,*) 'inversion pecent                  = ',cinv
        endif
        write(LERR,*) 'filter symetrical (0-no,1-yes)    = ',isym
        write(LERR,*) 'phase type (0-phase spec,1-ph.lag)= ',iph
      else
        write(LERR,*) 'Input wavelet time response'
      endif
      if (scalout) then
        write(LERR,*) 'Do not normalize convolving wavelet'
      else
        write(LERR,*) 'Normalize convolving wavelet'
      endif
      if (wweight) then
      write(LERR,*) 'Apply cosine bell weight to wavelet'
      endif
      if (inverse) then
      write(LERR,*) 'prewhitening (%)                  = ',prew
      endif
      write(LERR,*) 'starting record index to filter   = ',irs
      write(LERR,*) 'ending record index to filter     = ',ire
      write(LERR,*) 'starting trace index to filter    = ',ns
      write(LERR,*) 'ending trace index to filter      = ',ne
      write(LERR,*) 'traces/record out                 = ',itrout
      write(LERR,*) 'number of records out             = ',ircout
      write(LERR,*)' '
      if(mindel) then
       write(LERR,*) 'Convolve with minimum delay version of input'
       write(LERR,*) 'filter. Good only for mode=0'
       if (shp) then
        write(LERR,*) 'Min delay using time domain algorithm'
       else
        write(LERR,*) 'Min delay using hilbert freq domain algorithm'
       endif
      endif
      if(phzo)
     1write(LERR,*) 'Apply phase only filter to input data'
      if(verbos) then 
        write(LERR,*) 'from line header: '
        write(LERR,*) '# of samples/trace                = ',nsamp
        write(LERR,*) 'sample interval                   = ',isi
        write(LERR,*) 'traces per record                 = ',ntrr
        write(LERR,*) 'records per line                  = ',nrc
        write(LERR,*) 'format of data                    = ',ifor
        write(LERR,*)' '
      endif
 
      return
      end
