C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fftint (X, Y, work, ns, nt, nt2, nto, nto2,
     1                   nmax, coarse, ideci)

      real     X (ns), Y (nto)
      complex  work (nmax)
      logical  coarse


      IF (coarse) THEN

         j = 0
         do  i = 1, ns, ideci
             j = j + 1
             Y (j) = X (i)
         enddo

      ELSE

         do  i = 1, nt2
             work (i) = cmplx (0.,0.)
         enddo

         call rfftf  (X, work, nt)
         call rfftsc (work, nt, 2, 1)

         do  i = nt2+1, nto2
             work (i) = cmplx (0.,0.)
         enddo

         call rfftsc (work, nto, -2, 0)
         call rffti  (work, Y, nto)

         do  i = 1, nt
             X (i) = 0.
         enddo

      ENDIF

      return
      end
