C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine PickSort(index, traces, times, TraceBuffer, TimeBuffer,
     :      count, nseg ,ntrc, mtype )

c routine to sort picks into increasing record/trace order to ease
c interpolations required during mute application.  This also allows 
c the user to have picked the mutes in any order.

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer index(2*SZSMPM,2), count, nseg, ntrc, pointer, outpointer
      integer RecNumBuffer(SZLNHD), npickBuffer(SZLNHD)

      real traces(count), times(count) 
      real TraceBuffer(count), TimeBuffer(count)

      character mtype*(*)

      logical stack

c initialize data

      call vclr(TraceBuffer,1,count)
      call vclr(TimeBuffer,1,count)
      do i = 1,SZLNHD
         RecNumBuffer(i) = 0
         npickBuffer(i) = 0
      enddo

c determine if working with single or multi trace records

      stack = .false.
      if ( ntrc .eq. 1 .or. nseg .eq. 1 ) stack = .true.

      IF ( stack .or. mtype .eq. 'nearon' .or. mtype .eq. 'nearoff' ) 
     :     then

c sort based on traces and return

         call hsort2 ( count, traces, times )
         return

      ELSE

c sort based on record number and return

         do i = 1, nseg
            RecNumBuffer(i) = index(i,2)
            npickBuffer(i) = index(i,1)
         enddo
         
         call isort2 (nseg,RecNumBuffer,npickBuffer)

         outpointer = 1

         do 10 i = 1, nseg

            pointer = 1

            do j = 1, nseg

c find next segment to output in incrementing order

               if ( index(j,2) .eq. RecNumBuffer(i) ) then

c output the segment to the buffer

                  do k = 1, index(j,1)
                     Tracebuffer(outpointer+ k - 1) = 
     :                    traces(pointer + k - 1)
                     Timebuffer(outpointer+ k - 1) = 
     :                    times(pointer + k - 1)
                  enddo

                  outpointer = outpointer + index(j,1)
                  goto 10

               endif

               pointer = pointer + index(j,1)

            enddo

 10      continue

c move the buffers to the original arrays and return         

         call vmov ( Tracebuffer, 1, traces, 1, count )
         call vmov ( Timebuffer, 1, times, 1, count )
         do i = 1,nseg
            index(i,1) = npickBuffer(i)
            index(i,2) = RecNumBuffer(i)
         enddo

         return

      ENDIF

      end
        

     
         



            
