C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- declare variables -----
c
c Getamp  August 1995  James M. Gridley
c
c ----- get machine dependent parameters -----
c
#include <save_defs.h> 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c
c ----- dimension standard USP variables -----

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco,  obytes
      integer     luin, luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis, itime, iword1

      real        tri ( SZSMPM ), cept, y(SZSMPM)
      real        amp

      character   ntap*255, ptap*255, otap*255, hdrwd*6, name*6, mtype*2
      character   trcwrd*6

      logical     verbos, nb, track, pos, negi, maa, head, graph, exact

c dimension program specific variables

      integer     index(2*SZSMPM,2), count, nseg, NumPicks
      integer     RecNum, l_RecNum, ln_RecNum, ifmt_RecNum
      integer     l_DstSgn, ln_DstSgn, ifmt_DstSgn
      integer     static, l_StaCor, ln_StaCor, ifmt_StaCor
      integer     length, SeisSize, PickSize, length2
      integer     lupick, abort, errcd1, errcd2, errcd3, errcd4, errcd5
      integer     errcd6, errcd7, trcnum

      real        dt_units
      real	  mute_output, mute_coefs
      real        TraceBuffer, TimeBuffer

      pointer     (wkadr1, mute_output(200000))
      pointer     (wkadr2, mute_coefs(200000))
      pointer     (wkadr3, traces(200000))
      pointer     (wkadr4, times(200000))
      pointer     (wkadr5, records(200000))
      pointer     (wkadr6, TraceBuffer(200000))
      pointer     (wkadr7, TimeBuffer(200000))

      character   ONword*6, OFFword*6,  mnemonic*6

      logical     NoExtrap


c Variable Definitions
c
c ----- Integer -----
c
c     index() : contains segment information (seq.rec,npicks) 
c     count : counter for traces() and times() arrays
c     nseg : number of segments in the pick file
c     mul : pick file time units override
c     spinit : initial shot point override
c     spincr : shot point increment override
c     ramp : length of mute ramp in ms
c
c ----- Real -----
c
c     traces() : pick file entries
c     times() : pick file entries 
c     dist : trace distance 
c
c ----- Character -----
c
c     ptap : pick file name
c     mtype : type of mute requested
c

c Initialize variables

      data lbytes/0/
      data nbytes/0/
      data name/'GETAMP'/
      data abort/0/
      data luout/6/
      data ONword/'VPick1'/
      data OFFword/'VPick2'/
      data NoExtrap/.false./
      data pos/.false./
      data negi/.false./
      data maa/.false./
      data head/.false./
      data graph/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln (ntap,ptap,otap,ns,ne,irs,ire,nb,hdrwd,head,
     : graph,iwin,itm,track,pos,negi,maa,itwd,verbos,mnemonic,exact,
     : trcwrd)

c open input and output datasets

      
      
         length = 6
      if ( otap(1:length) .ne. '-99999' ) then
         length = lenth(otap)
         open(luout, file=otap(1:length), status='unknown')
c         open(luout, file=otap(1:length), status='unknown', err=990 )
      endif

      call getln(luin , ntap,'r', 0)

c  read line header of input save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LERR,*)'GETAMP: no header read from unit ',luin
         write(LERR,*)'FATAL'
         write(LER,*)'GETAMP: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      call savelu(hdrwd,ifmt_hdrwd,l_hdrwd,ln_hdrwd,TRACEHEADER)

      if (itwd .gt. 0) then
         l_hdrwd = itwd
      endif

      call savelu(trcwrd,ifmt_trcwrd,l_trcwrd,ln_trcwrd,TRACEHEADER)

      call hlhprt (itr, lbyte, name, 6, LERR)

c assign floating point delta T variable used in mute application.  This will
c be in units of milliseconds for millisecond data and microseconds for 
c microsecond data.  It is assumed [and required] that the pick file conform
c to the same convention.  If muting microsecond data then the pick file must
c contain microsecond picks.

      dt_units = float(nsi)

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c modify line header to reflect actual number of traces output

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)

c number output bytes

      obytes = SZTRHD + nsamp * SZSMPD

c save out hlh and line header

      call savhlh(itr,lbytes,lbyout)

c verbose output of all pertinent information before processing begins

      call verbal (nsamp,dt_units,ntrc,nrec, ntap, ns, ne, 
     : ire,irs,otap, ptap,nb,hdrwd,iwin,itm,track,pos,negi,maa,itwd,
     :     mnemonic,graph,exact,trcwrd)

c open pick file
      length2 = lenth(ptap)
      IF (ptap(1:length2) .ne. '-99999') THEN

         lupick = 27
         open ( lupick, file=ptap(1:length2), status='old',
     :  err=990 )
c Determine Size Requirements and allocate memory

         call PickCount ( lupick, NumPicks )
	
         SeisSize = nsamp * SZSMPD
         PickSize = NumPicks * SZSMPD

         call galloc (wkadr1, SeisSize, errcd1, abort)
         call galloc (wkadr2, SeisSize, errcd2, abort)
         call galloc (wkadr3, PickSize, errcd3, abort)
         call galloc (wkadr4, PickSize, errcd4, abort)
         call galloc (wkadr5, PickSize, errcd5, abort)
         call galloc (wkadr6, PickSize, errcd6, abort)
         call galloc (wkadr7, PickSize, errcd7, abort)

         if ( errcd1 .ne. 0 .or. 
     :        errcd2 .ne. 0 .or. 
     :        errcd3 .ne. 0 .or. 
     :        errcd4 .ne. 0 .or.
     :        errcd5 .ne. 0 .or.
     :        errcd6 .ne. 0 .or.
     :        errcd7 .ne. 0 )then
            write(LERR,*)' '
            write(LERR,*)'Unable to allocate workspace:'
            write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
            write(LERR,*)' '
         else
            write(LERR,*)' '
            write(LERR,*)'Allocating workspace:'
            write(LERR,*) 1*SeisSize+5*PickSize,'  bytes'
            write(LERR,*)' '
         endif
         
c read and qc pick file
         mtype='on'

         call ReadPick (lupick,index,records,traces,times,count, 
     :        nseg,-9999,-9999,-9999,mtype,hdrwd,nsi,verbos )

c sort the picks based on increasing record [or trace if appropriate] index

         call PickSort ( index, traces, times, TraceBuffer, TimeBuffer, 
     :        count, nseg, ntrc, mtype )

c linear interpolation of picks

         do i=1,count-1
            slope= (times(i+1)-times(i))/(traces(i+1)-traces(i))
            cept=times(i+1)-slope*traces(i+1)
            if (i .eq. 1) then 
               traces(1)=1 
            endif
            do j=traces(i),traces(i+1)
               y(j)=slope*j + cept
            enddo
         enddo

c ending loop with pickfile option
      ENDIF
c============================================================
c BEGIN PROCESSING
c skip to start record

      call recskp(1,irs-1,luin,ntrc,itr)

c============================================================

      DO 1000 JJ = irs, ire
 
c skip to start trace

         call trcskp(JJ,1,ns-1,luin,ntrc,itr)

         do 1001 kk=ns,ne
            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
            
            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1           recnum , TRACEHEADER)
            call saver2(itr,ifmt_trcwrd,l_trcwrd, ln_trcwrd,
     1           trcnum , TRACEHEADER)
            
            if (hdrwd .ne. 'RecNum') then
               call saver2(itr,ifmt_hdrwd,l_hdrwd, ln_hdrwd,
     1              iword1 , TRACEHEADER)
            endif

            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1           static , TRACEHEADER)


            if (static .eq. 30000) then
               go to 1001
            endif
c======================================================================
c  figure out sample corresponding to time
               if (head) then
                  itm=iword1
               endif

               it = itm/nsi + 1
               iwin2 = int((iwin/nsi + 1)/2)
               iwins=iwin/nsi
c============================================================
c  get amplitude for:
c  fixed time, no window, no pick file
c counter to keep track of exact time values
c jmg 4 Jan 1996
c request of Sugianto	


            IF (iwins .eq. 0 .and. ptap(1:length2) .eq. '-99999') THEN
               amp = tri(it)
               itime = (it-1)*nsi

            ELSEIF (iwins .ne. 0 .and. ptap(1:length2)
     :              .eq. '-99999')THEN
               amp=tri(it-iwin2-1)
               itime = (it-1)*nsi
               do ii=it-iwin2,it+iwin2+1	
                  if (pos) then
			if (tri(ii) .gt. amp) then	
				amp=tri(ii)
				itc=ii
			endif
c                     amp=max(amp,tri(ii))
                  elseif (negi) then
			if (tri(ii) .lt. amp) then	
				amp=tri(ii)
				itc=ii
			endif
c                     amp=min(amp,tri(ii))	

                  elseif (maa) then

			if(abs(tri(ii)) .gt. amp .and.
     : tri(ii) .lt. amp)  then
                     amp=tri(ii)
				itc=ii
			else
				if(abs(tri(ii)) .gt. abs(amp)) then
				amp=tri(ii)
				itc=ii
				endif
c                     amp=max(abs(amp),abs(tri(ii)))
	 		endif
                  endif

               enddo
c
c Now Deal with XSD picks

            ELSEIF (iwins .eq. 0 .and. ptap(1:length2)
     :              .ne. '-99999')THEN
               itime=int(y(kk))
               itmp=itime/nsi
               amp=tri(itmp)
               
            ELSEIF (iwins .ne. 0 .and. ptap(1:length2)
     :              .ne. '-99999')THEN
               itime=int(y(kk))
               itmp=itime/nsi
               amp=tri(itmp-iwin2-1)
               
               do ii=itmp-iwin2,itmp+iwin2 + 1	
                  if (pos) then
			if (tri(ii) .gt. amp) then	
				amp=tri(ii)
				itc=ii
			endif
c                     amp=max(amp,tri(ii))
                  elseif (negi) then
			if (tri(ii) .lt. amp) then	
				amp=tri(ii)
				itc=ii
			endif
c                     amp=min(amp,tri(ii))	
                  elseif (maa) then
			if(abs(tri(ii)) .gt. amp .and.
     : tri(ii) .lt. amp)  then
                     amp=tri(ii)
				itc=ii
			else
				if(abs(tri(ii)) .gt. abs(amp)) then
				amp=tri(ii)
				itc=ii
				endif
c                     amp=max(abs(amp),abs(tri(ii)))
	 		endif
                  endif
               enddo
            ENDIF
c======================================================================
c  write output data

	if (graph) then
            if(head) then 	
		if(exact) then
               write(luout,103)itc*nsi ,amp
		else	
               write(luout,103) iword1,amp
		endif
            elseif (.not. head) then
		if(exact) then
               write(luout,103)itc*nsi ,amp
		else
                write(luout,103) trcnum,amp
		endif
		endif
	endif		

	if (.not. graph) then
            if(head) then 	
			if (exact) then
               write(luout,102) recnum, trcnum, amp, itc*nsi, iword1
			else	
               write(luout,102) recnum, trcnum, amp, itime, iword1
			endif
            elseif (.not. head .and. iword1 .eq. RecNum) then
			if (exact) then
                write(luout,100) recnum, trcnum, amp, itc*nsi
			else	
                write(luout,100) recnum, trcnum, amp, itime
			endif
            elseif (.not. head .and. iword1 .ne. RecNum) then
			if (exact) then
                write(luout,102) recnum, trcnum, amp, itc*nsi,iword1
			else	
                write(luout,102) recnum, trcnum, amp, itime,iword1
			endif
		endif
	endif		
	

 100        format(i6,4x,i6,9x,e15.5,5x,i5)
 102        format(i6,4x,i6,9x,e15.5,5x,i5,5x,i5)
 103        format(i6,4x,e15.5)
 
 
            if(verbos)write(LERR,*)'ri ',recnum,' trace ',trcnum
 1001    continue
 
 1002    continue
c---------------------
c  between records put
c  null line
         if (JJ .ne. ire .AND. ntrc .gt. 1 .AND. .not. nb) then
            write(luout,101)
 101        format()
            write(LERR,*)'Inserting null line at JJ/KK= ',jj,
     1           kk
         endif
 
c----------------------
c  skip to end of record
         call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
 1000    CONTINUE
c-----
c     close data files
c-----
 999     continue
 
      write(LERR,*)'end of getamp, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
 
      call lbclos ( luin )
      close (luout)

      write(LER,*) 'GETAMP: Normal Completion'
      write(LERR,*) 'GETAMP: Normal Completion'
	goto 44
 
990   write(LERR,*) ' '
      write(LERR,*) 'GETAMP: error opening pick file'
      write(LERR,*) '        check spelling/existence'
      write(LERR,*) 'FATAL'
      write(LER,*) ' '
      write(LER,*) 'GETAMP: error opening pick file'
      write(LER,*) '        check spelling/existence'
      write(LER,*) 'FATAL'

44    end
c=====================================================================
      subroutine cmdln (ntap,ptap,otap,ns,ne,irs,ire,nb,hdrwd,head,
     : graph,iwin,itm,track,pos,negi,maa,itwd,verbos,mnemonic,exact,
     : trcwrd)

#include <f77/iounit.h>

      integer     ns, ne, irs, ire,itm
      integer     argis,iwin


      character   ntap*(*), ptap*(*), mnemonic*(*), hdrwd*(*), otap*(*)
      character   trcwrd*(*)

      logical     verbos, track, pos, nb, negi, maa,head, graph, exact

      exact=(argis('-E') .gt. 0)
      head=(argis('-head') .gt. 0)
      maa=(argis('-maa') .gt. 0)
      pos=(argis('-max') .gt. 0)
      negi=(argis('-min') .gt. 0)
      call argstr( '-hw', hdrwd, 'RecNum', 'RecNum' )
      call argstr( '-tw', trcwrd, 'TrcNum', 'TrcNum' )
      nb =   (argis('-nb') .gt. 0)
      call argi4 ( '-ne', ne ,   0  ,  0    )
      call argi4 ( '-ns', ns ,   0  ,  0    )
      call argi4 ( '-re', ire ,   0  ,  0    )
      call argi4 ( '-rs', irs ,   0  ,  0    )
      call argstr( '-N', ntap, ' ', ' ' )
      call argstr( '-O', otap, '-99999', '-99999' )
      call argstr( '-P', ptap, '-99999', '-99999' )
      call argi4 ( '-t', itm,   0  ,  0    )
      verbos =   (argis('-V') .gt. 0)
      call argi4 ( '-w',iwin, 0, 0 )
      graph =   (argis('-x') .gt. 0)

	if (iwin .eq. 0) then
		track=.false.
		else
		track=.true.
	endif
      return
      end
c=====================================================================
      subroutine verbal (nsamp,dt_units,ntrc,nrec, ntap, ns, ne, 
     : ire,irs,otap, ptap,nb,hdrwd,iwin,itm,track,pos,negi,maa,itwd,
     :     mnemonic,graph,exact,trcwrd)

#include <f77/iounit.h>
 
      integer     nsamp, ntrc, nrec, iwin, itm, ns, ne, irs, ire

      real        dt_units

      character   ntap*(*),  ptap*(*), otap*(*)
      character   mnemonic*(*), trcwrd*6

      logical     nb, track, pos, negi, maa, graph,exact
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ',ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*) ' samples/trace         =  ', nsamp
      write(LERR,*) ' sample interval       =  ', dt_units
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' records per line      =  ', nrec
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
	if (exact) then
      write(LERR,*)' '
      write(LERR,*)' Extracting Exact Time Values '
	endif
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' Input data set name  =  ', ntap(1:length)
      else
        write(LERR,*) ' Input data set       =  stdin'
      endif
      if ( otap(1:6) .ne. '-99999' ) then
         length = lenth(otap)
         write(LERR,*) ' Output data set name  =  ', otap(1:length)
      else
         write(LERR,*)' Output directed to stdout'
      endif
      length = lenth(ptap)
      IF (ptap(1:length) .ne. '-99999')
     : write(LERR,*) ' XSD pick file name    =  ', ptap(1:length)
      write(LERR,*) 'time of amplitude      =  ', itm
      write(LERR,*) ' Trace header word     =  ', trcwrd
      write(LERR,*) ' Trace header mnemonic =  ', mnemonic
      if (track) then
                write(LERR,*) ' Length of tracking window= ',iwin
      endif
      if (pos) then
                write(LERR,*) ' Tracking positive amplitudes'
      else
                write(LERR,*) ' Tracking negative amplitudes'
      endif
      write(LERR,*) ' Start/End traces   =  ', ns,ne
      write(LERR,*) ' Start/End records  =  ', irs,ire
      write(LERR,*)' '
      write(LERR,*)' '
	if (graph) then
      write(LERR,*) ' '
      write(LERR,*) ' Output in xgraph format'
      write(LERR,*)' '
	endif
 
      return
      end
c---------------------------------------
c  online help section
c---------------------------------------
      subroutine help
#include <f77/iounit.h>
 
        write(LER,*)' '
        write(LER,*)'      COMMAND LINE ARGUMENTS FOR getamp'
        write(LER,*)' '
        write(LER,*)'_Input___________Description___________(default)__'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'I/O Options: '
        write(LER,*)'-N[ntap]   -- input data set name      (stdin)'
        write(LER,*)'-O[otap]   -- output data set name     (stdout)'
        write(LER,*)'-P[ptap]   -- XSD Picks data set name  (optional)'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Design window: (if -P[ptap] is not used)'
        write(LER,*)'-t[itm] -- time of amplitude retrieval      (none)'
        write(LER,*)'             (if -P[ptap] is not used)'
        write(LER,*)'-w[iwn] -- length of tracking window           (0)'
        write(LER,*)'           (if itw=0 retrieve values at itm)      '
        write(LER,*)'           (can hang wind on time by using -hw[]'
        write(LER,*)'            and -head flag)'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Output Format:'
        write(LER,*)'-hw[hdrwrd] -- Trace header word output (RecNum)'
        write(LER,*)'-tw[trcwrd] -- Trace number header word (TrcNum)'
        write(LER,*)'------------------------------------------------- '
        write(LER,*)'Trace/record limitation:'
        write(LER,*)'-ns[nst]   -- start process trc #       (first tr)'
        write(LER,*)'-ne[ned]   -- end process trc #          (last tr)'
        write(LER,*)'-rs[nrst]  -- start process rec #      (first rec)'
        write(LER,*)'-re[nred]  -- end process rec  #        (last rec)'
        write(LER,*)'--------------------------------------------------'
        write(LER,*)'Program Amplitude Tracking Options:'
        write(LER,*)'-max Retrieve Maximum positive amplitudes         '
        write(LER,*)'-min Retrieve Minimum negative amplitudes         '
        write(LER,*)'-maa Retrieve Maximum absolute amplitudes         '
        write(LER,*)' '
        write(LER,*)'-head   use values in -hwxxxxx as retrieval time '
        write(LER,*)'        (-t[])  must use this option with -hwxxxxx'
        write(LER,*)' '
        write(LER,*)'-nb  No separation of output records'
        write(LER,*)' '
        write(LER,*)'-x   Output data in xgraph format'
        write(LER,*)' '
        write(LER,*)'-E   Output Exact Time Values of Amplitudes (must'
        write(LER,*)'     be present to do amp tracking within window)'
        write(LER,*)' '
        write(LER,*)'-V   verbos printout'
        write(LER,*)' '
        write(LER,*)'=================================================='
        write(LER,*)'Usage:'
        write(LER,*)'getamp -N[] -O[] -P[] -ns[] -ne[] -rs[] -re[] -t[]'
        write(LER,*)'       -w[] -hw[] -tw[] [-max, -min, -maa, -nb, '
        write(LER,*)'       -head -x, -E, -V ]'
        write(LER,*)'=================================================='
        write(LER,*)' '
        write(LER,*)' '
 
      return
      end
