/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <localsys.h>
#include <usp_headers.h>
#include <save.h>
#include <save_defs.h>
#include <io_defs.h>
#include <cu_defs.h>
#include <string.h>

void main(argc,argv)
int argc;
char **argv;
{
/*
c**********************************************************************c
c
c     program module getval
c
c**********************************************************************c
c
c getval reads seismic trace data from an input file,
c extracts a value from the line or trace header (one of)
c and writes the output to stdout
c
c**********************************************************************c
c
c - modified the code to pull floating point or character variables 
c   from the headers. Previously, everything was assumed to be integers.
c						- Joe M. Wade 4/14/95
c
c**********************************************************************c
c
c     declare variables
c
*/
	char	*itr,*lhed;
	int	nsamp, nsi, ntrc, nrec, iform;
	int	luin , nbytes;
	FILE	*luout;
	int	irs,ire,ns,ne;
	char	ntap[256], otap[256];
	char 	**lnkey, **trkey;
	int	*ifmt_lnkey,*l_lnkey,*ln_lnkey;
	int	*ifmt_trkey,*l_trkey,*ln_trkey;
	int	query,verbose;
	int	C_ARGIS();
	int	lnkeyknt,trkeyknt;
	short	shortval;
	int	longval;
	float	rval;
	char	*chdata;
	int	i,j,jj,kk,trcknt,ierr;
	void	gcmdln(),help();

	nbytes = 0;

/* -----
c     read program parameters from command line card image file
----- */

	if ( C_ARGIS("-?",&argc,argv) > 0 ) {
	  help();
	  exit(0);
	  }

	lnkeyknt = sizeof(lhdr) / sizeof(struct hdr);
	lnkey =  (char **) malloc( lnkeyknt*sizeof(char *));
	if (lnkey == NULL) {
	  fprintf(stderr,"GETVAL: memory allocation failed for lnkeys\n");
	  exit(1);
	  }

	trkeyknt = sizeof(thdr) / sizeof(struct hdr);
	trkey = (char **) malloc( trkeyknt*sizeof(char *) );
	if (lnkey == NULL) {
	  fprintf(stderr,"GETVAL: memory allocation failed for trkeys\n");
	  exit(1);
	  }

	gcmdln(ntap,otap,&ns,&ne,&irs,&ire,lnkey,trkey,&lnkeyknt,&trkeyknt,
           &verbose,&argc,argv);

/*-----
c     get logical unit numbers for input and output
-----*/
	if (strlen(ntap) != 0)
	  C_LBOPEN(&luin , ntap, "r");
	else
	  luin = 0;

	if (strlen(otap) != 0) {
	  luout = fopen(otap, "w");
	  if (luout == NULL) {
	    fprintf(stderr,"ERROR opening file %s for output; check permissions\n",otap);
	    exit(1);
	    }
	  }
	else {
	  luout = stdout;
	  }
/*-----
c     read line header of input
c     save certain parameters
-----*/
	lhed = (char *)malloc(500000);
	C_RTAPE( luin, lhed, &nbytes);
	if (nbytes == 0) {
	  fprintf(stderr,"GETVAL: no header read from unit %d\nFATAL\n",luin );
	  exit(1);
	  }
	lhed = (char *) realloc(lhed, nbytes);

	nsamp = ((usp_line_header *)lhed)->NumSmp;
	nsi = ((usp_line_header *)lhed)->SmpInt;
	ntrc = ((usp_line_header *)lhed)->NumTrc;
	nrec = ((usp_line_header *)lhed)->NumRec;
	iform = ((usp_line_header *)lhed)->Format;

	if (ne == 0) ne = ntrc;
	if (ire == 0) ire= nrec;

	if (lnkeyknt != 0) {
	  ifmt_lnkey = (int *) malloc(lnkeyknt*sizeof(int));
	  l_lnkey    = (int *) malloc(lnkeyknt*sizeof(int));
	  ln_lnkey   = (int *) malloc(lnkeyknt*sizeof(int));

	  if ( ifmt_lnkey == NULL | l_lnkey == NULL | ln_lnkey == NULL ) {
	    fprintf(stderr,"GETVAL: memory allocation failed\n");
	    exit(1);
	    }

	  for (i=0; i<lnkeyknt; i++) {
	    ierr = C_SAVELU(lnkey[i],&ifmt_lnkey[i],&l_lnkey[i],&ln_lnkey[i],
		LINEHEADER);
	    if (ierr == 0) {
	      fprintf(stderr,"Line header key %s is invalid - FATAL\n",
			lnkey[i]);
	      exit(1);
	      }
	    }

/*-----
c     ensure that command line values are compatible with data set
-----*/
/*
	cmdchk(ns,ne,irs,ire,ntrc,nrec,lnkeyknt,trkeyknt)
*/

/*-----
c     GO GET LINE HEADER VALUE
-----*/
	if ( verbose != 0) {
	  for (i=0; i<lnkeyknt; i++) {
     	    if (ifmt_lnkey[i] == SAVE_CHAR_DEF) {
		fprintf(luout,"  %*s  ",ln_lnkey[i],lnkey[i]);
		} 
	    else {
		fprintf(luout,"  %s  ",lnkey[i]);
	    	}
	    }
	  fprintf(luout,"\n");
	  }

	for ( j=0; j<lnkeyknt; j++) {
	  if (ifmt_lnkey[j] == SAVE_SHORT_DEF) {
	      ierr = get_indexed_hw_val(lhed,ifmt_lnkey[j],l_lnkey[j],
			ln_lnkey[j],LINEHEADER,&shortval);
	      if (ierr != 0 ) {
	        fprintf(luout,"  %6d  ",shortval);
	        }
	      }
	   else if  (ifmt_lnkey[j] == SAVE_LONG_DEF) {
	      ierr = get_indexed_hw_val(lhed,ifmt_lnkey[j],l_lnkey[j],
			ln_lnkey[j],LINEHEADER,&longval);
	      if (ierr != 0 ) {
	        fprintf(luout,"%8d  ",longval);
	        }
	      }
	   else if (ifmt_lnkey[j] == SAVE_CHAR_DEF) {
	      chdata = (char *)malloc((ln_lnkey[j]+1)*sizeof(char));
	      if (chdata == NULL ) {
	        fprintf(stderr,"GETVAL: error getting memory for character ");
		fprintf(stderr,"header value %s\n",lnkey[j]);
		exit(1);
	        }
	      ierr = get_indexed_hw_val(lhed,ifmt_lnkey[j],l_lnkey[j],
			ln_lnkey[j],LINEHEADER,chdata);
	      if (ierr != 0 ) {
	        fprintf(luout,"  %s  ",chdata);
	        }
	      free(chdata);
	      }
	   else if ((ifmt_lnkey[j] == SAVE_FLOAT_DEF) ||
	     (ifmt_lnkey[j] == SAVE_FKFLT_DEF)) {
	      ierr = get_indexed_hw_val(lhed, ifmt_lnkey[j], l_lnkey[j],
				ln_lnkey[j], LINEHEADER, &rval);
	      if (ierr != 0 ) {
	        fprintf(luout,"%8.6g  ",rval);
	        }
	      }
	    free(lnkey[j]);

   	    if (ierr == 0) {
	      fprintf(stderr,"Unable to find line header key\n");
	      fprintf(stderr,"Check command line\n");
	      exit(1);
	      }
	    }

	fprintf(luout,"\n");
	if (verbose != 0) fprintf(luout,"\n");

	free(lnkey);
	free(ifmt_lnkey);
	free(l_lnkey);
	free(ln_lnkey);
	  }
	free(lhed);

	if (trkeyknt != 0) {

	  ifmt_trkey = (int *) malloc(trkeyknt*sizeof(int));
	  l_trkey    = (int *) malloc(trkeyknt*sizeof(int));
	  ln_trkey   = (int *) malloc(trkeyknt*sizeof(int));
	  if ( ifmt_trkey == NULL | l_trkey == NULL | ln_trkey == NULL) {
	    fprintf(stderr,"GETVAL: memory allocation failed\n");
	    exit(1);
	    }

	  for (i=0; i<trkeyknt; i++) {
	    ierr = C_SAVELU(trkey[i],&ifmt_trkey[i],&l_trkey[i],&ln_trkey[i],
		TRACEHEADER);
	    if (ierr == 0) {
	      fprintf(stderr,"Trace header key %s is invalid - FATAL\n",
			trkey[i]);
	      exit(1);
	      }
	    }
/*-----
c     skip unwanted records
-----*/
/*
	  call recskp(1,irs-1,luin,ntrc,itr)
*/
	  trcknt = ((irs-1) * ntrc);
	  if (trcknt != 0) C_SKIPT(luin, trcknt);

/*-----
c     GO GET TRACE HEADER VALUE
-----*/

	  if ( verbose != 0) {
	    for (i=0; i<trkeyknt; i++) {
     	      if (ifmt_trkey[i] == SAVE_CHAR_DEF) {
		fprintf(luout,"  %*s  ",l_trkey[i],trkey[i]);
		} 
	      else {
		fprintf(luout,"  %s  ",trkey[i]);
	    	}
	      }
	    fprintf(luout,"\n");
	    }

	  itr = (char *)malloc(sizeof(usp_trace_header)+(nsamp*sizeof(float)));

	  for (jj = irs; jj <= ire; jj++) {

/*----------------
c  skip to start
c  of record
----------------*/
/*
	    call trcskp(jj,1,ns-1,luin,ntrc,itr)
*/
	    trcknt = ns-1;
	    if (trcknt != 0) C_SKIPT(luin, trcknt);

	    for (kk = ns; kk <= ne; kk++) {

	      nbytes = 0;
	      C_RTAPE ( luin, itr, &nbytes);
	      if(nbytes == 0) {
	        fprintf(stderr,"End of file on input:");
	        fprintf(stderr,"  rec= %d, trace= %d\n",jj,kk);
	        exit(1);
	        }

	      for ( j=0; j<trkeyknt; j++) {
	        if (ifmt_trkey[j] == SAVE_SHORT_DEF) {
	          ierr = get_indexed_hw_val(itr,ifmt_trkey[j],l_trkey[j],
			ln_trkey[j],LINEHEADER,&shortval);
	          if (ierr != 0 ) {
	            fprintf(luout,"  %6d  ",shortval);
	            }
	          }
	        else if (ifmt_trkey[j] == SAVE_LONG_DEF) {
	          ierr = get_indexed_hw_val(itr,ifmt_trkey[j],l_trkey[j],
			ln_trkey[j],LINEHEADER,&longval);
	          if (ierr != 0 ) {
	            fprintf(luout,"%8d  ",longval);
	            }
	          }
	        else if (ifmt_trkey[j] == SAVE_CHAR_DEF) {
	          chdata = (char *)malloc((ln_trkey[j]+1)*sizeof(char));
	          if (chdata == NULL ) {
	            fprintf(stderr,"GETVAL: error getting memory for character ");
		    fprintf(stderr,"header value %s\n",trkey[j]);
		    exit(1);
	            }
	          ierr = get_indexed_hw_val(itr,ifmt_trkey[j],l_trkey[j],
			ln_trkey[j],LINEHEADER,chdata);
	          if (ierr != 0 ) {
	            fprintf(luout,"  %s  ",chdata);
	            }
	          free(chdata);
	          }
	        else if ((ifmt_trkey[j] == SAVE_FLOAT_DEF) ||
	               (ifmt_trkey[j] == SAVE_FKFLT_DEF)) {
	          ierr = get_indexed_hw_val(itr, ifmt_trkey[j], l_trkey[j],
				ln_trkey[j], LINEHEADER, &rval);
	          if (ierr != 0 ) {
	            fprintf(luout,"%8.6g  ",rval);
	            }
	          }

   	        if (ierr == 0) {
	          fprintf(stderr,"Unable to find trace header key\n");
	          fprintf(stderr,"Check command line\n");
	          exit(1);
	          }
	        }
	        fprintf(luout,"\n");
	      }

/*----------------
c  skip to end of
c  current record
----------------*/

	      trcknt = ntrc-ne;
	      if (trcknt != 0) C_SKIPT(luin, trcknt);
	      }
	    }
/*-----
c     close data files
-----*/
	C_LBCLOS ( luin );
	exit(0);
}

void help()
{
	fprintf(stderr,
	  "***************************************************************\n");
	fprintf(stderr,
	  "execute getval by typing getval and a list of program parameters\n");
	fprintf(stderr,
	  "note that each parameter is proceeded by -x where x is \n");
	fprintf(stderr,
	  "a character(s) corresponding to some parameter.\n");
	fprintf(stderr,
	  "users enter the following parameters, or use the default values\n\n");
	fprintf(stderr,
	  " -N [ntap]    (no default)       : input data file name\n");
	fprintf(stderr,
	  " -O [otap]    (no default)       : ascii output file name\n");
	fprintf(stderr,
	  " -L[lnkey]    (one of    )       : line header key\n");
	fprintf(stderr,
	  " -T[lnkey]    (or,       )       : trace header key\n");
	fprintf(stderr,
	  " -ns[ns]      (default = first)  : start trace number\n");
	fprintf(stderr,
	  " -ne[ne]      (default = last)   : end trace number\n");
	fprintf(stderr,
	  " -rs[irs]      (default = first) : start record number\n");
	fprintf(stderr,
	  " -ne[ire]      (default = last)  : end record number\n");
	fprintf(stderr,
	  "usage:   getval -N[ntap] -O[otap] -L[] -T[]\n");
	fprintf(stderr,
	  " -ns[ns] -ne[ne] -rs[irs] -re[ire] -V\n");
	fprintf(stderr,
	  "***************************************************************\n");
}

void gcmdln(ntap,otap,ns,ne,irs,ire,lnkey,trkey,lnkeyknt,trkeyknt,
	verbose,argc,argv)
/*-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     scal1 - i*4 trace amplitude is held near scal1 % of 2047
c     nwind - i*4 agc window in ms
c     agc         - L   output agc curves only
c     verbose     - L   verbose output or not
-----*/
char	*ntap, *otap, **lnkey, **trkey;
int	*ns, *ne, *irs, *ire;
int	*lnkeyknt, *trkeyknt;
int     *verbose;
int	*argc;
char	**argv;
{
#include <cu_defs.h>
	int	C_ARGIS();
	int	i;

	*verbose = C_ARGIS("-V",argc,argv);
	C_ARGSTR("-N", ntap, "", "",argc,argv);
	C_ARGSTR("-O", otap, "", "",argc,argv);

	for (i=0; i < *lnkeyknt; i++) {
	  lnkey[i] = (char *)malloc(7*sizeof(char));
	  C_ARGSTR( "-L", lnkey[i], "", "", argc, argv );
	  if (strlen(lnkey[i]) == 0) break;
	  }

	free(lnkey[i]);
 	*lnkeyknt = i;

	for (i=0; i < *trkeyknt; i++) {
	  trkey[i] = (char *)malloc(7*sizeof(char));
	  C_ARGSTR( "-T", trkey[i], "", "", argc, argv );
	  if (strlen(trkey[i]) == 0) break;
	  }

	free(trkey[i]);
 	*trkeyknt = i;

	C_ARGI4 ( "-ns", ns, 1, 1, argc, argv);
	C_ARGI4 ( "-ne", ne, 0, 0, argc, argv);
	C_ARGI4 ( "-rs", irs, 1, 1, argc, argv);
	C_ARGI4 ( "-re", ire, 0, 0, argc, argv);

	if (lnkeyknt == 0 && trkeyknt == 0) {
	  fprintf(stderr,"No keys given -- FATAL\n");
	  exit(1);
	  }

	return;
}


