C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C*****  FILRM1                                                          REF38850
C
      SUBROUTINE FILRM1(ARRAY,BEG,END)                                  REF15600
C                                                                       REF15620
      IMPLICIT INTEGER (A-Z)                                            REF15630
      INTEGER*2 ARRAY(*)                                                REF15640
      REAL INC                                                          REF15650
C                                                                       REF15660
      TEMP=ARRAY(BEG)                                                   REF15670
      INC=(ARRAY(END)-TEMP)/FLOAT(END-BEG)                              REF15680
C                                                                       REF15690
      DO 10 I=1,END-BEG-1                                               REF15700
         ARRAY(BEG+I)=TEMP+I*INC                                        REF15710
  10  CONTINUE                                                          REF15720
C                                                                       REF15730
C                                                                       REF15740
      RETURN                                                            REF15750
      END                                                               REF15760
C
C*****  FILL                                                            REF38850
C
      SUBROUTINE FILL(ARRAY,NSAMP)                                      REF15770
      DIMENSION ARRAY(*)                                                REF15780
      INTEGER * 2 IARRAY(10000)                                         REF15790
      CALL MOVE (0,IARRAY,0,6000)                                       REF15800
      CALL MAXABS ( NSAMP, ARRAY, AMAX, INDEX )                         REF15810
      IF ( AMAX .EQ. 0.0 ) THEN                                         REF15820
         CALL MOVE ( 0, ARRAY, 0, NSAMP * 4 )                           REF15830
         RETURN                                                         REF15840
      END IF                                                            REF15850
      CALL SCALE  ( 30000.0/AMAX, NSAMP, ARRAY)                         REF15860
      DO 10 I = 1, NSAMP                                                REF15870
        IARRAY(I) = ARRAY(I)                                            REF15880
10    CONTINUE                                                          REF15890
      CALL ELRAMP(IARRAY,NSAMP)                                         REF15900
      DO 20 I = 1, NSAMP                                                REF15910
      ARRAY(I) = IARRAY(I)                                              REF15920
20    ARRAY(I) = ARRAY(I) * AMAX/30000.0                                REF15930
      RETURN                                                            REF15940
      END                                                               REF15950
C
C*****  ELRAMP                                                          REF38850
C
      SUBROUTINE ELRAMP(ARRAY,N)                                        REF15960
C                                                                       REF15980
      IMPLICIT INTEGER(A-Z)                                             REF15990
      INTEGER*2 ARRAY(*)                                                REF16000
C                                                                       REF16010
C                                                                       REF16020
      DO 10 I=1,N                                                       REF16030
         IF(ARRAY(I).NE.0) THEN                                         REF16040
            FIRST=I                                                     REF16050
            TEMP=ARRAY(I)                                               REF16060
            DO 5 J=1,I                                                  REF16070
               ARRAY(J)=TEMP                                            REF16080
   5        CONTINUE                                                    REF16090
            GOTO 20                                                     REF16100
         ENDIF                                                          REF16110
  10  CONTINUE                                                          REF16120
C                                                                       REF16130
  20  DO 30 I=N,1,-1                                                    REF16140
         IF(ARRAY(I).NE.0) THEN                                         REF16150
            LAST=I                                                      REF16160
            TEMP=ARRAY(I)                                               REF16170
            DO 25 J=N,I,-1                                              REF16180
               ARRAY(J)=TEMP                                            REF16190
  25        CONTINUE                                                    REF16200
            GOTO 40                                                     REF16210
         ENDIF                                                          REF16220
  30  CONTINUE                                                          REF16230
C                                                                       REF16240
C                                                                       REF16250
  40  BEG=FIRST                                                         REF16260
      DO 50 I=FIRST+1,LAST                                              REF16270
         IF(ARRAY(I).NE.0) THEN                                         REF16280
            END=I                                                       REF16290
            CALL FILRM1(ARRAY,BEG,END)                                  REF16300
            BEG=END                                                     REF16310
         ENDIF                                                          REF16320
  50  CONTINUE                                                          REF16330
C                                                                       REF16340
C                                                                       REF16350
      RETURN                                                            REF16360
      END
      SUBROUTINE SCALE(S,LX,X)                                          REF22350
      DIMENSION X(1)                                                    REF22360
C     THIS SUBROUTINE SCALES A VECTOR X BY MULTIPLYING EACH ELEMENT BY  REF22370
C     A SCALE FACTOR S                                                  REF22380
C                                                                       REF22390
C     INPUTS ARE                                                        REF22400
C        LX=LENGTH OF VECTOR X    INTEGER*4                             REF22410
C        X=THE VECTOR X, X(1),X(2),...,X(L)     REAL*4                  REF22420
C        S=SCALE FACTOR        REAL*4                                   REF22430
C     OUTPUTS ARE                                                       REF22440
C        X=THE SCALED VECTOR X, WHERE---                                REF22450
C          X(1)=S*X(1),X(2)=S*X(2),...,X(L)=S*X(L)                      REF22460
C              REAL*4                                                   REF22470
C                                                                       REF22480
C      THIS SUBROUTINE IS MAINTAINED BY DON WAGNER                      REF22490
C                                                                       REF22500
      DO 10 I=1,LX                                                      REF22510
   10 X(I)=S*X(I)                                                       REF22520
      RETURN                                                            REF22530
      END                                                               REF22540
C
C*****  MAXABS                                                          REF38850
C
      SUBROUTINE MAXABS(LX,X,XMAX,INDEX)                                REF22550
C                                                                       REF22560
C     THIS SUBROUTINE FINDS THE MAXIMUM ABSOLUTE VALUE OF A VECTOR X    REF22570
C     INPUTS ARE                                                        REF22580
C       LX=LENGTH OF VECTOR X (INTEGER*4)                               REF22590
C        X=THE VECTOR X, X(1),X(2),...,X(LX) (REAL*4)                   REF22600
C     OUTPUTS ARE                                                       REF22610
C        XMAX=THE MAXIMUM-VALUED ELEMENT OF X (REAL*4)                  REF22620
C        INDEX=THE VECTOR INDEX AT WHICH THIS MAXIMUM-VALUED ELEMENT    REF22630
C              OCCURS (INTEGER*4)                                       REF22640
C     EXAMPLE---                                                        REF22650
C       GIVEN X=2.5,-9.0,-3.0,4.5   THE SUBROUTINE OUTPUTS---           REF22660
C          XMAX=9                                                       REF22670
C          INDEX=2                                                      REF22680
C     IF TWO OR MORE ELEMENTS OF X HAVE IDENTICAL MAXIMUM VALUES, THE   REF22690
C     INDEX FOUND BY THIS SUBROUTINE WILL BE THE ONE CORRESPONDING  TO  REF22700
C     THE LOWEST INDEX AT WHICH THIS MAXIMUM VALUE OCCURS.              REF22710
C                                                                       REF22720
C     MAINTAINED BY DON WAGNER                                          REF22730
C                                                                       REF22740
      DIMENSION X(2)                                                    REF22750
      XM=ABS(X(1))                                                      REF22760
      DO 10 J=1,LX                                                      REF22770
   10 XM=AMAX1(XM,ABS(X(J)))                                            REF22780
      XMAX=XM                                                           REF22790
      DO 20 J=1,LX                                                      REF22800
      INDEX=J                                                           REF22810
      IF(ABS(X(J))-XMAX) 20,30,20                                       REF22820
   20 CONTINUE                                                          REF22830
   30 RETURN                                                            REF22840
      END                                                               REF22850
