C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ------------------------  gridr  ----------------------------------- 
c  Next time in add header gridding as well so that output headers are
c  reasonably correct......May31/95 
c
c     Program Changes:
c
c      - original written: January, 1995 [Garossino]
c
c     Program Description:
c
c
c     create an interpolated 3D volume of data using standard 
c     grid reduction algorithm from a sparse set of 2D lines 
c     [with x,y info in header]

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, argis

      real        tri( SZLNHD ), UnitSC

      character   ntap*255, otap*255, name*5

      logical     verbos

c Program Specific _ dynamic memory variables

      integer DataSize, HeaderSize, GeomSize, abort
      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6, errcd7
      integer errcd8, errcd9, errcd10, errcd11, errcd12, errcd13
      integer errcd14
      integer Records, Traces, Headers, Headers_WorkSpace
      integer RecList, TrcList

      real    Data, Data_WorkSpace
      real    Xcoords, Ycoords, Xlist, Ylist, Radii, Angles 

      pointer (wkadrData, Data(200000))
      pointer (wkadrSpace, Data_WorkSpace(200000))
      pointer (wkadrHeaders, Headers(200000))
      pointer (wkadrHdrSpace, Headers_WorkSpace(200000))
      pointer (wkadrXcoords, Xcoords(200000))
      pointer (wkadrYcoords, Ycoords(200000))
      pointer (wkadrRecords, Records(200000))
      pointer (wkadrTraces, Traces(200000))
      pointer (wkadrReclist, RecList(200000))
      pointer (wkadrTrcList, TrcList(200000))
      pointer (wkadrXlist, Xlist(200000))
      pointer (wkadrYlist, Ylist(200000))
      pointer (wkadrRadii, Radii(200000))
      pointer (wkadrAngles, Angles(200000))

c Program Specific _ static memory variables

      integer ifmt_LinInd,l_LinInd,ln_LinInd
      integer ifmt_DphInd,l_DphInd,ln_DphInd
      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX, CDPBCX
      integer ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY, CDPBCY
      integer ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC, SrPtXC
      integer ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC, SrPtYC
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_Wrd,l_Wrd,ln_Wrd
      integer index, JJ, KK, next_X_index

      real Xmin, Xmax, DeltaX, X, next_X
      real Ymin, Ymax, DeltaY, Y
      real Limit_NumAdjZeroSegs, Limit_nsegs
      real Limit_radius, Limit_MinNumElems, Limit_Amp
      real pi

      character  Limit_weighting*10, Wrd*6

      logical ThreeD, next_X_Search_Flag

c Initialize variables

      data abort/1/
      data name/"GRIDR"/
      pi =  4. * atan(1.0)

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ist, iend, name,  
c output dataset limits
     :     Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY, 
c grid reduction operator limits
     :     Limit_weighting, 
     :     Limit_NumAdjZeroSegs, 
     :     Limit_nsegs, 
     :     Limit_radius, 
     :     Limit_MinNumElems,
     :     Limit_Amp, 
c header word to grid reduce
     :     Wrd,
c flags
     :     Threed, verbos )

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'GRIDR: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', UnitSC, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', UnitSC, LINHED)
      endif

c setup pointers for later trace header calls

      call savelu ( 'LinInd', ifmt_LinInd, l_LinInd, ln_LinInd, 
     :     TRACEHEADER)
      call savelu ( 'DphInd', ifmt_DphInd, l_DphInd, ln_DphInd, 
     :     TRACEHEADER)
      call savelu ( 'RecNum', ifmt_RecNum, l_RecNum, ln_RecNum, 
     :     TRACEHEADER)
      call savelu ( 'TrcNum', ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER)
      call savelu ( 'SrPtXC', ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, 
     :     TRACEHEADER)
      call savelu ( 'SrPtYC', ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, 
     :     TRACEHEADER)
      call savelu ( 'CDPBCX', ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :     TRACEHEADER)
      call savelu ( 'CDPBCY', ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, 
     :     TRACEHEADER)
      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER)
      if ( Wrd .ne. ' ' ) call savelu ( Wrd , ifmt_Wrd, l_Wrd, ln_Wrd, 
     :     TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 5, LERR)

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

c determine output parameters

      nreco = nint ( ( Xmax - Xmin ) / DeltaX ) + 1
      ntrco = nint ( ( Ymax - Ymin ) / DeltaY ) + 1

      nsampo = iend - ist + 1
      obytes = SZTRHD + SZSMPD * nsampo 

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco, LINHED)
      call savew(itr, 'NumSmp', nsampo, LINHED)

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, ist, iend, name,  
c output dataset limits
     :     ntrco, nreco, nsampo, nsi,
     :     Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY, 
c grid reduction operator limits
     :     Limit_weighting, 
     :     Limit_NumAdjZeroSegs, 
     :     Limit_nsegs, 
     :     Limit_radius, 
     :     Limit_MinNumElems,
     :     Limit_Amp, 
c header word to grid reduce
     :     Wrd,
c flags
     :     ThreeD, verbos )

c dynamic memory allocation:  

      DataSize = (4 * ntrc * nsamp + 2 ) * SZSMPD
      HeaderSize = ( 4 * ntrc * ITRWRD + 2 ) * SZSMPD
      GeomSize = ( ntrc * nrec + 2 )  * SZSMPD

      call galloc (wkadrData, DataSize, errcd1, abort)
      call galloc (wkadrSpace, DataSize, errcd2, abort)
      call galloc (wkadrHeaders, HeaderSize, errcd3, abort)
      call galloc (wkadrHdrSpace, HeaderSize, errcd4, abort)
      call galloc (wkadrXcoords, GeomSize, errcd5, abort)
      call galloc (wkadrYcoords, GeomSize, errcd6, abort)
      call galloc (wkadrRecords, GeomSize, errcd7, abort)
      call galloc (wkadrTraces, GeomSize, errcd8, abort)
      call galloc (wkadrRecList, GeomSize, errcd9, abort)
      call galloc (wkadrTrcList, GeomSize, errcd10, abort)
      call galloc (wkadrXlist, GeomSize, errcd11, abort)
      call galloc (wkadrYlist, GeomSize, errcd12, abort)
      call galloc (wkadrRadii, GeomSize, errcd13, abort)
      call galloc (wkadrAngles, GeomSize, errcd14, abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 .or.
     :     errcd12 .ne. 0 .or.
     :     errcd13 .ne. 0 .or.
     :     errcd14 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*DataSize+2*HeaderSize, '  bytes'
         write(LERR,*)10 * GeomSize , ' bytes '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*DataSize+2*HeaderSize, '  bytes'
         write(LER,*)10 * GeomSize , ' bytes '
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*DataSize+2*HeaderSize, '  bytes'
         write(LERR,*) 10 * GeomSize , ' bytes '
         write(LERR,*)' '
      endif

c initialize memory
         
      DataSize = 2 * ntrc * nsamp
      HeaderSize = ntrc * ITRWRD
      GeomSize = nrec * ntrc
      call vclr (Data, 1, DataSize )
      call vclr ( Data_WorkSpace, 1, DataSize ) 
      call vclr ( Xcoords, 1, GeomSize )
      call vclr ( Ycoords, 1, GeomSize )
      call vclr ( XList, 1, GeomSize )
      call vclr ( Ylist, 1, GeomSize )
      call vclr ( Radii, 1, GeomSize )
      call vclr ( Angles, 1, GeomSize )

      do i = 1, HeaderSize
         Headers(i) = 0
         Headers_WorkSpace(i) = 0
      enddo
      
      do i = 1, GeomSize
         Records(i) = 0
         Traces(i) = 0
         RecList(i) = 0
         TrcList(i) = 0
      enddo

C Prior to grid reduction I must first read through the data and build a disk
c map in memory for the [x,y,sequential rec,sequential trc] of the input.  This 
c will allow the ready identification of which traces are required in the grid 
c operator for any given output trace.

c BEGIN PROCESSING X,Y MEMORY MAP

c skip unwanted input records

      call recskp ( 1, 0, luin, ntrc, itr )

      index = 0

      DO JJ = 1, nrec
         DO KK = 1, ntrc 

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call saver2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum, RecNum,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC,
     :           TRACEHEADER)
            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor,
     :           TRACEHEADER)

            if ( StaCor .ne. 30000 ) then

c load only live data from inside the area described by user.  Allow a 
c fringe equal to the radius of investigation so that grid reduction
c right up to the boundary is possible

               if (ThreeD) then

c base coordinate limitation on CDP bin centers for 3D stacked data input
c this allows one to reinterpolate 3D data as well as 2D data with 
c this routine

                  if ( CDPBCX .ge. nint(Xmin - Limit_radius) .and. 
     :                 CDPBCX .le. nint(Xmax + Limit_radius) .and. 
     :                 CDPBCY .ge. nint(Ymin - Limit_radius) .and. 
     :                 CDPBCY .le. nint(Ymax + Limit_radius) ) then
                     index = index + 1
                     Xcoords(index) = float(CDPBCX)
                     Ycoords(index) = float(CDPBCY)
                     Records(index) = JJ
                     Traces(index) = KK
                  endif
               else

c it is assumed that the SrPtXC reflects the position of the CDP post
c stack.  If this is not the case then I may have to allow a cmdln
c entry [hwx,hwy] to allow the user to define which header words contain
c this information

                  if ( SrPtXC .ge. nint(Xmin - Limit_radius) .and. 
     :                 SrPtXC .le. nint(Xmax + Limit_radius) .and. 
     :                 SrPtYC .ge. nint(Ymin - Limit_radius) .and. 
     :                 SrPtYC .le. nint(Ymax + Limit_radius) ) then
                     index = index + 1
                     Xcoords(index) = float(SrPtXC)
                     Ycoords(index) = float(SrPtYC)
                     Records(index) = JJ
                     Traces(index) = KK
                  endif
               endif
            endif
         ENDDO
      ENDDO
            
c sort the gleaned input data locations on X 

      if ( index .gt. 1 ) then
        call isort4 ( index, Xcoords, Ycoords, Records, Traces )
      else
        write(lerr,*)'GRIDR: '
        write(LERR,*)' not enough data found inside limits'
        write(LERR,*)' to be able to grid reduce area'
        write(lerr,*)'FATAL '
        write(ler,*)'GRIDR: '
        write(LER,*)' not enough data found inside limits'
        write(LER,*)' to be able to grid reduce area'
        write(ler,*)'FATAL '
        stop
      endif

c begin GRID REDUCTION processing 

      SrPtXC = nint(Xmin) - nint(DeltaX)
      X = Xmin - DeltaX
      next_X_index = 1

      DO JJ = 1, nreco

c assign output trace header stuff

         SrPtXC = SrPtXC + nint( DeltaX )
         SrPtYC = nint(Ymin) - nint(DeltaY)

c assign [x] coordinate of output location for grid reduction calculation

         X = X + DeltaX
         next_X = X + DeltaX
         next_X_Search_Flag = .true.
         Y = Ymin - DeltaY
         Grid_lowX = X - Limit_radius
         Grid_highX = X + Limit_radius

         DO KK = 1, ntrco

c clear output header 

            do i = 1, ITHWP1
               itr(i) = 0
            enddo

c clear trace 

            call vclr ( tri, 1, nsampo )

c assign rest of trace header stuff

            SrPtYC = SrPtYC + nint( DeltaY )
 
c assign [x] coordinate of output location for grid reduction calculation

            Y = Y + DeltaY
            Grid_lowY = Y - Limit_radius
            Grid_highY = Y + Limit_radius

c SEARCH MEMORY MAP and serve up input data required to 
c calculate this grid point.

            call GetData ( 
c x,y coordinates of required output trace 
     :           X, Y, 
c X and Y limits reached by grid operator
     :           Grid_lowX, Grid_highX, Grid_lowY, Grid_highY,
c input data geometry information
     :           Xcoords, Ycoords, Records, Traces, index,
c list of input data falling within grid operator
     :           Xlist, Ylist, RecList, TrcList, NumTraces,
c input data from above list
     :           ist, iend, itr, ifmt_StaCor, l_StaCor, ln_Stacor,
     :           luin, nsamp, ntrc, Data, Headers,
c radius limiting and angle calculation
     :           Limit_radius, Limit_nsegs,Radii, Angles, pi,
c search efficiency variables
     :           next_X, next_X_index, next_X_Search_Flag,
     :           current_X_index )

c PERFORM selected trace header GRID REDUCTION for this output trace
c for now only a single header entry is being reduced for Greg Schurter
c to be able to remove the flattening required prior to grid reduction
c on his data. 

            IF ( Wrd .ne. ' ' .and. NumTraces .gt. 0 ) then

               call GridHeader( 
c x,y coordinates of required output trace
     :              X, Y, pi,
c list of input data within limits of grid operator
     :              Xlist, Ylist, RecList, TrcList, NumTraces,
c vector position information for traces
     :              Radii, Angles,
c input data and workspace
     :              ntrc, Headers, Headers_WorkSpace, 
     :              ifmt_wrd, l_wrd, ln_wrd,
c grid reduction limits
     :              Limit_nsegs, Limit_NumAdjZeroSegs, 
     :              Limit_MinNumElems, Limit_Amp, 
     :              Limit_radius, Limit_weighting, 
c output grid reduced data at this location
     :              itr, verbos)

            ENDIF

c PERFORM time series GRID REDUCTION for this output trace  

c test the header griding only by turning off data griding if header
c to grid is supplied

            IF ( Wrd .eq. ' ' ) then

               call GridData ( 
c     x,y coordinates of required output trace
     :              X, Y, pi,
c list of input data within limits of grid operator
     :              Xlist, Ylist, RecList, TrcList, NumTraces,
c vector position information for traces
     :              Radii, Angles,
c input data and workspace
     :              nsamp, ntrc, Data, Data_WorkSpace,  
c grid reduction limits
     :              Limit_nsegs, Limit_NumAdjZeroSegs, 
     :              Limit_MinNumElems, Limit_Amp, 
     :              Limit_radius, Limit_weighting, 
c output grid reduced data at this location
     :              tri, ist, iend, 
     :              verbos ) 
c OUTPUT TRACE STATUS live or dead

               call dotpr ( tri, 1, tri, 1, vdot, nsampo )
               if ( abs(vdot) .lt. 1.e-30) then
                  call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :                 30000, TRACEHEADER )
               endif

            ENDIF

c WRITE OUTPUT TRACE

            call savew2( itr, ifmt_LinInd, l_LinInd, ln_LinInd, JJ,
     :           TRACEHEADER)
            call savew2( itr, ifmt_DphInd, l_DphInd, ln_DphInd, KK,
     :           TRACEHEADER)
            if ( ThreeD ) then
               call savew2( itr, ifmt_CDPBCX, l_CDPBCX, ln_CDPBCX, 
     :              SrPtXC, TRACEHEADER)
               call savew2( itr, ifmt_CDPBCY, l_CDPBCY, ln_CDPBCY,
     :              SrPtYC, TRACEHEADER)
            else
               call savew2( itr, ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, 
     :              SrPtYC, TRACEHEADER)
               call savew2( itr, ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC,
     :              SrPtXC, TRACEHEADER)
            endif
            call savew2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, KK,
     :           TRACEHEADER)
            call savew2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, JJ,
     :        TRACEHEADER)
            call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
            call wrtape ( luout, itr, obytes )

         ENDDO
      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'gridr: Normal Termination'
      write(LER,*)'gridr: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'gridr: ABNORMAL Termination'
      write(LER,*)'gridr: ABNORMAL Termination'
      stop
      end
