C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal (ntap, otap, ist, iend, name,  
c output dataset limits
     :     ntrco, nreco, nsampo, nsi,
     :     Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY, 
c grid reduction operator limits
     :     Limit_weighting, 
     :     Limit_NumAdjZeroSegs, 
     :     Limit_nsegs, 
     :     Limit_radius, 
     :     Limit_MinNumElems,
     :     Limit_Amp, 
c header word to grid reduce
     :     Wrd,
c flags
     :     ThreeD, verbos  )

#include <f77/iounit.h>

      integer    nsampo, ntrco, ist, iend, nsi

      real Xmin, Xmax, DeltaX, Ymin, Ymax, DeltaY

      real Limit_NumAdjZeroSegs, Limit_nsegs 
      real Limit_radius, Limit_MinNumElems, Limit_Amp

      character  ntap*(*), otap*(*), Limit_weighting, Wrd*6

      logical    ThreeD, verbos

c local variables

      integer length

      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Input Dataset '
      write(LERR,*)' '
      length = lenth(ntap)
      if (length .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:length)
      else
        write(LERR,*) ' input data set        =  stdin'
      endif
      write(LERR,*)' '
      write(LERR,*)' Output Dataset Parameters '
      write(LERR,*)' '
      length = lenth(otap)
      if (length .gt. 0) then
        write(LERR,*) ' output data set name   =  ', otap(1:length)
      else
        write(LERR,*) ' output data set        =  stdout'
      endif
      write(LERR,*) ' samples per trace      =  ', nsampo
      write(LERR,*) ' traces per record      =  ', ntrco
      write(LERR,*) ' number of records      =  ', nreco
      write(LERR,*) ' sample interval[ms]    =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' Output Dataset Limits '
      write(LERR,*)' '
      write(LERR,*) ' minimum X coordinate    =  ', Xmin
      write(LERR,*) ' maximum X coordinate    =  ', Xmax
      write(LERR,*) ' minimum Y coordinate    =  ', Ymin
      write(LERR,*) ' maximum Y coordinate    =  ', Ymax
      write(LERR,*)' '
      write(LERR,*) ' X increment    =  ', DeltaX
      write(LERR,*) ' Y increment    =  ', DeltaY
      write(LERR,*)' '
      write(LERR,*)' Grid Reduction Parameters '
      write(LERR,*)' '
      write(LERR,*) ' Number of Adjacent Empty Segments =  ', 
     :     Limit_NumAdjZeroSegs
      write(LERR,*) ' Number of Segments =  ', Limit_nsegs
      write(LERR,*) ' Radius of Investigation =  ', Limit_radius
      write(LERR,*) ' Minimum Number of Elements =  ', 
     :     Limit_MinNumElems
      write(LERR,*) ' Maximum Sample Amplitude =  ', Limit_Amp
      write(LERR,*) ' Type of Distance Weighting Applies = ', 
     :     Limit_weighting
      if ( ThreeD ) then
         write(LERR,*) ' Xcoord from CDPBCX, Ycoord from CDPBCY'
      else
         write(LERR,*) ' Xcoord from SrPtXC, Ycoord from SrPtYC'
      endif
      write(LERR,*) ' Header Mnemonic to grid reduce = ',Wrd
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
